/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import org.apache.curator.framework.state.ConnectionState;
import org.apache.druid.curator.DruidConnectionStateListener;
import org.apache.druid.java.util.emitter.service.AlertEvent;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidConnectionStateListenerTest {
    private StubServiceEmitter emitter;
    private DruidConnectionStateListener listener;

    @Before
    public void setUp() {
        this.emitter = new StubServiceEmitter("DruidConnectionStateListenerTest", "localhost");
        this.listener = new DruidConnectionStateListener((ServiceEmitter)this.emitter);
    }

    @Test
    public void test_isConnected() {
        Assert.assertFalse((boolean)this.listener.isConnected());
        this.listener.stateChanged(null, ConnectionState.CONNECTED);
        Assert.assertTrue((boolean)this.listener.isConnected());
        this.listener.stateChanged(null, ConnectionState.SUSPENDED);
        Assert.assertFalse((boolean)this.listener.isConnected());
        this.listener.stateChanged(null, ConnectionState.RECONNECTED);
        Assert.assertTrue((boolean)this.listener.isConnected());
        this.listener.stateChanged(null, ConnectionState.LOST);
        Assert.assertFalse((boolean)this.listener.isConnected());
    }

    @Test
    public void test_doMonitor_init() {
        this.listener.doMonitor((ServiceEmitter)this.emitter);
        Assert.assertEquals((long)1L, (long)this.emitter.getNumEmittedEvents());
        this.emitter.verifyValue("zk/connected", (Number)0);
    }

    @Test
    public void test_doMonitor_connected() {
        this.listener.stateChanged(null, ConnectionState.CONNECTED);
        this.listener.doMonitor((ServiceEmitter)this.emitter);
        Assert.assertEquals((long)1L, (long)this.emitter.getNumEmittedEvents());
        this.emitter.verifyValue("zk/connected", (Number)1);
    }

    @Test
    public void test_doMonitor_notConnected() {
        this.listener.stateChanged(null, ConnectionState.SUSPENDED);
        this.listener.doMonitor((ServiceEmitter)this.emitter);
        Assert.assertEquals((long)2L, (long)this.emitter.getNumEmittedEvents());
        this.emitter.verifyValue("zk/connected", (Number)0);
    }

    @Test
    public void test_suspendedAlert() {
        this.listener.stateChanged(null, ConnectionState.SUSPENDED);
        Assert.assertEquals((long)1L, (long)this.emitter.getNumEmittedEvents());
        AlertEvent alert = (AlertEvent)this.emitter.getAlerts().get(0);
        Assert.assertEquals((Object)"alerts", (Object)alert.getFeed());
        Assert.assertEquals((Object)"ZooKeeper connection[SUSPENDED]", (Object)alert.getDescription());
    }

    @Test
    public void test_reconnectedMetric() {
        this.listener.stateChanged(null, ConnectionState.SUSPENDED);
        Assert.assertEquals((long)1L, (long)this.emitter.getNumEmittedEvents());
        this.listener.stateChanged(null, ConnectionState.RECONNECTED);
        Assert.assertEquals((long)2L, (long)this.emitter.getNumEmittedEvents());
        long observedReconnectTime = this.emitter.getValue("zk/reconnect/time", null).longValue();
        Assert.assertTrue((observedReconnectTime >= 0L ? 1 : 0) != 0);
    }
}

