/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.ProvisionException;
import org.apache.druid.guice.DruidProcessingModule;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.utils.JvmUtils;
import org.junit.Assume;
import org.junit.Test;

public class DruidProcessingModuleTest {
    @Test(expected=ProvisionException.class)
    public void testMemoryCheckThrowsException() {
        try {
            JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
        }
        catch (UnsupportedOperationException e) {
            Assume.assumeNoException((Throwable)e);
        }
        DruidProcessingModule module = new DruidProcessingModule();
        module.getIntermediateResultsPool(new DruidProcessingConfig(){

            public String getFormatString() {
                return "test";
            }

            public int intermediateComputeSizeBytes() {
                return Integer.MAX_VALUE;
            }
        }, JvmUtils.getRuntimeInfo());
    }

    @Test
    public void testMemoryCheckIsChillByDefaultIfNothingSet() {
        DruidProcessingConfig config = new DruidProcessingConfig(){

            public String getFormatString() {
                return "processing-test-%s";
            }
        };
        DruidProcessingModule module = new DruidProcessingModule();
        config.getNumInitalBuffersForIntermediatePool();
        module.getIntermediateResultsPool(config, JvmUtils.getRuntimeInfo());
    }
}

