/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice.security;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import java.util.List;
import java.util.Properties;
import org.apache.druid.guice.ConfigModule;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.security.PolicyModule;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.policy.NoRestrictionPolicy;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.policy.RestrictAllTablesPolicyEnforcer;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.junit.Assert;
import org.junit.Test;

public class PolicyModuleTest {
    @Test
    public void testDefaultConfigNoopPolicyEnforcer() {
        Properties properties = new Properties();
        PolicyEnforcer policyEnforcer = (PolicyEnforcer)Guice.createInjector((Module[])new Module[]{binder -> binder.bind(Properties.class).toInstance((Object)properties), new DruidGuiceExtensions(), new ConfigModule(), new PolicyModule()}).getInstance(Key.get(PolicyEnforcer.class));
        Assert.assertNotNull((Object)policyEnforcer);
        Assert.assertTrue((boolean)(policyEnforcer instanceof NoopPolicyEnforcer));
    }

    @Test
    public void testConfigThrowForUnrecognizedType() {
        Properties properties = new Properties();
        properties.setProperty("druid.policy.enforcer.type", "unrecognizedType");
        Injector injector = Guice.createInjector((Module[])new Module[]{binder -> binder.bind(Properties.class).toInstance((Object)properties), new DruidGuiceExtensions(), new ConfigModule(), new PolicyModule()});
        ProvisionException e = (ProvisionException)Assert.assertThrows(ProvisionException.class, () -> injector.getInstance(Key.get(PolicyEnforcer.class)));
        Assert.assertTrue((boolean)e.getCause().getMessage().contains("Could not resolve type id 'unrecognizedType' as a subtype of `org.apache.druid.query.policy.PolicyEnforcer`"));
    }

    @Test
    public void testConfigRestrictAllTablesPolicyEnforcer() {
        Properties properties = new Properties();
        properties.setProperty("druid.policy.enforcer.type", "restrictAllTables");
        PolicyEnforcer policyEnforcer = (PolicyEnforcer)Guice.createInjector((Module[])new Module[]{binder -> binder.bind(Properties.class).toInstance((Object)properties), new DruidGuiceExtensions(), new ConfigModule(), new JacksonModule(), new PolicyModule()}).getInstance(Key.get(PolicyEnforcer.class));
        Assert.assertNotNull((Object)policyEnforcer);
        Assert.assertEquals((Object)new RestrictAllTablesPolicyEnforcer(null), (Object)policyEnforcer);
    }

    @Test
    public void testConfigRestrictAllTablesPolicyEnforcerWithAllowedPolicies() {
        Properties properties = new Properties();
        properties.setProperty("druid.policy.enforcer.type", "restrictAllTables");
        properties.setProperty("druid.policy.enforcer.allowedPolicies", "[\"some-policy-class\", \"org.apache.druid.query.policy.NoRestrictionPolicy\"]");
        PolicyEnforcer policyEnforcer = (PolicyEnforcer)Guice.createInjector((Module[])new Module[]{binder -> binder.bind(Properties.class).toInstance((Object)properties), new DruidGuiceExtensions(), new ConfigModule(), new JacksonModule(), new PolicyModule()}).getInstance(Key.get(PolicyEnforcer.class));
        Assert.assertNotNull((Object)policyEnforcer);
        Assert.assertEquals((Object)new RestrictAllTablesPolicyEnforcer((List)ImmutableList.of((Object)"some-policy-class", (Object)"org.apache.druid.query.policy.NoRestrictionPolicy")), (Object)policyEnforcer);
        Assert.assertTrue((boolean)policyEnforcer.validate((Policy)NoRestrictionPolicy.instance()));
        Assert.assertFalse((boolean)policyEnforcer.validate((Policy)RowFilterPolicy.from((DimFilter)new NullFilter("some-col", null))));
    }
}

