/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.messages.MessageBatch;
import org.apache.druid.messages.client.MessageRelayClient;
import org.apache.druid.messages.client.MessageRelayClientImpl;
import org.apache.druid.rpc.MockServiceClient;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessageRelayClientImplTest {
    private ObjectMapper smileMapper;
    private MockServiceClient serviceClient;
    private MessageRelayClient<String> messageRelayClient;

    @Before
    public void setup() {
        this.smileMapper = new DefaultObjectMapper((JsonFactory)new SmileFactory(), null);
        this.serviceClient = new MockServiceClient();
        this.messageRelayClient = new MessageRelayClientImpl((ServiceClient)this.serviceClient, this.smileMapper, String.class);
    }

    @After
    public void tearDown() {
        this.serviceClient.verify();
    }

    @Test
    public void test_getMessages_ok() throws Exception {
        MessageBatch batch = new MessageBatch((List)ImmutableList.of((Object)"foo", (Object)"bar"), 123L, 0L);
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/outbox/me/messages?epoch=-1&watermark=0"), HttpResponseStatus.OK, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/x-jackson-smile"), this.smileMapper.writeValueAsBytes((Object)batch));
        ListenableFuture result = this.messageRelayClient.getMessages("me", -1L, 0L);
        Assert.assertEquals((Object)batch, (Object)result.get());
    }

    @Test
    public void test_getMessages_noContent() throws Exception {
        this.serviceClient.expectAndRespond(new RequestBuilder(HttpMethod.GET, "/outbox/me/messages?epoch=-1&watermark=0"), HttpResponseStatus.NO_CONTENT, (Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/x-jackson-smile"), ByteArrays.EMPTY_ARRAY);
        ListenableFuture result = this.messageRelayClient.getMessages("me", -1L, 0L);
        Assert.assertEquals((Object)new MessageBatch(Collections.emptyList(), -1L, 0L), (Object)result.get());
    }
}

