/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.IndexerSqlMetadataStorageCoordinatorTestBase;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.segment.SegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.cache.NoopSegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.simulate.TestDruidLeaderSelector;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableDuration;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class IndexerSQLMetadataStorageCoordinatorMarkUsedTest
extends IndexerSqlMetadataStorageCoordinatorTestBase {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private IndexerMetadataStorageCoordinator storageCoordinator;
    private final DataSegment wikiSegment1 = CreateDataSegments.ofDatasource("wiki").startingAt("2012-03-15").eachOfSizeInMb(500L).get(0);
    private final DataSegment wikiSegment2 = CreateDataSegments.ofDatasource("wiki").startingAt("2012-01-05").eachOfSizeInMb(500L).get(0);

    @Before
    public void setup() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlSegmentMetadataTransactionFactory transactionFactory = new SqlSegmentMetadataTransactionFactory(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, new TestDruidLeaderSelector(), (SegmentMetadataCache)NoopSegmentMetadataCache.instance(), NoopServiceEmitter.instance()){

            public int getMaxRetries() {
                return 2;
            }
        };
        this.storageCoordinator = new IndexerSQLMetadataStorageCoordinator((SegmentMetadataTransactionFactory)transactionFactory, this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, null, CentralizedDatasourceSchemaConfig.create());
        this.derbyConnector.createSegmentTable();
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed1() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        Set<SegmentId> segmentIds = Set.of(koalaSegment1.getId(), koalaSegment2.getId(), koalaSegment3.getId());
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals((long)2L, (long)this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", segmentIds));
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals(Set.of(koalaSegment1, koalaSegment2), this.retrieveAllUsedSegments("koala"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed_inEternityIntervalWithVersions() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals((long)2L, (long)this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", Intervals.ETERNITY, (List)ImmutableList.of((Object)"2017-10-15T20:19:12.565Z", (Object)"2017-10-16T20:19:12.565Z")));
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals(Set.of(koalaSegment1, koalaSegment2), this.retrieveAllUsedSegments("koala"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed_withEmptyVersions() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals((long)0L, (long)this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", Intervals.of((String)"2017/2018"), (List)ImmutableList.of()));
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed_inEternityIntervalWithEmptyVersions() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals((long)0L, (long)this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", Intervals.ETERNITY, (List)ImmutableList.of()));
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed_inFiniteIntervalWithVersions() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals((long)2L, (long)this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", Intervals.of((String)"2017-10-15/2017-10-18"), (List)ImmutableList.of((Object)"2017-10-15T20:19:12.565Z", (Object)"2017-10-16T20:19:12.565Z")));
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals(Set.of(koalaSegment1, koalaSegment2), this.retrieveAllUsedSegments("koala"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed_withNonExistentVersions() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3);
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals((long)0L, (long)this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", Intervals.ETERNITY, (List)ImmutableList.of((Object)"foo", (Object)"bar")));
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed_invalidDataSource() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createNewSegment2("koala");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2);
        Set<SegmentId> segmentIds = Set.of(koalaSegment1.getId(), koalaSegment2.getId());
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        MatcherAssert.assertThat((Object)((DruidException)Assert.assertThrows(DruidException.class, () -> this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("wrongDataSource", segmentIds))), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Could not find segment IDs"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed_withInvalidSegmentIds() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createNewSegment2("koala");
        Set<SegmentId> segmentIds = Set.of(koalaSegment1.getId(), koalaSegment2.getId());
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        MatcherAssert.assertThat((Object)((DruidException)Assert.assertThrows(DruidException.class, () -> this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", segmentIds))), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageContains("Could not find segment IDs"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment4 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createNewSegment2("koala");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3, koalaSegment4);
        Interval theInterval = Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-18T00:00:00.000");
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals((long)2L, (long)this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", theInterval, null));
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals(Set.of(koalaSegment1, koalaSegment2), this.retrieveAllUsedSegments("koala"));
    }

    @Test
    public void test_markNonOvershadowedSegmentsAsUsed_withOverlappingInterval() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z");
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-19T00:00:00.000/2017-10-22T00:00:00.000", "2017-10-15T20:19:12.565Z");
        DataSegment koalaSegment4 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createNewSegment2("koala");
        this.publishUnusedSegments(koalaSegment1, koalaSegment2, koalaSegment3, koalaSegment4);
        Interval theInterval = Intervals.of((String)"2017-10-16T00:00:00.000/2017-10-20T00:00:00.000");
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals((long)1L, (long)this.storageCoordinator.markNonOvershadowedSegmentsAsUsed("koala", theInterval, null));
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments("wiki"));
        Assert.assertEquals(Set.of(koalaSegment2), this.retrieveAllUsedSegments("koala"));
    }

    @Test
    public void test_getUnusedSegmentIntervals() {
        this.publishSegments(this.wikiSegment1, this.wikiSegment2);
        int numChangedSegments = this.storageCoordinator.markSegmentsAsUnused("wiki", Set.of(this.wikiSegment1.getId(), this.wikiSegment2.getId()));
        Assert.assertEquals((long)2L, (long)numChangedSegments);
        DataSegment koalaSegment1 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment1);
        this.derbyConnectorRule.segments().updateUsedStatusLastUpdated(koalaSegment1.getId().toString(), DateTimes.nowUtc().minus((ReadableDuration)Duration.standardHours((long)2L)));
        DataSegment koalaSegment2 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-16T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment2);
        this.derbyConnectorRule.segments().updateUsedStatusLastUpdated(koalaSegment2.getId().toString(), DateTimes.nowUtc().minus((ReadableDuration)Duration.standardDays((long)2L)));
        DataSegment koalaSegment3 = IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment3);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.wikiSegment2.getInterval()), (Object)this.storageCoordinator.getUnusedSegmentIntervals("wiki", DateTimes.of((String)"2000"), DateTimes.of((String)"3000"), 1, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.wikiSegment2.getInterval()), (Object)this.storageCoordinator.getUnusedSegmentIntervals("wiki", DateTimes.of((String)"2000"), DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), 1, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.wikiSegment1.getInterval()), (Object)this.storageCoordinator.getUnusedSegmentIntervals("wiki", DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), DateTimes.of((int)2012, (int)4, (int)7, (int)0, (int)0), 1, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.storageCoordinator.getUnusedSegmentIntervals("wiki", DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), DateTimes.of((int)2012, (int)1, (int)7, (int)0, (int)0), 1, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.wikiSegment2.getInterval(), (Object)this.wikiSegment1.getInterval()), (Object)this.storageCoordinator.getUnusedSegmentIntervals("wiki", DateTimes.of((String)"2000"), DateTimes.of((String)"3000"), 5, DateTimes.COMPARE_DATE_AS_STRING_MAX));
        Assert.assertEquals((Object)ImmutableList.of(), (Object)this.storageCoordinator.getUnusedSegmentIntervals("wiki", DateTimes.COMPARE_DATE_AS_STRING_MIN, DateTimes.of((String)"3000"), 5, DateTimes.nowUtc().minus((ReadableDuration)Duration.parse((String)"PT86400S"))));
        Assert.assertEquals((Object)ImmutableList.of((Object)koalaSegment2.getInterval()), (Object)this.storageCoordinator.getUnusedSegmentIntervals("koala", DateTimes.COMPARE_DATE_AS_STRING_MIN, DateTimes.of((String)"3000"), 5, DateTimes.nowUtc().minus((ReadableDuration)Duration.parse((String)"PT86400S"))));
    }

    private Set<DataSegment> retrieveAllUsedSegments(String dataSource) {
        return this.storageCoordinator.retrieveAllUsedSegments(dataSource, Segments.INCLUDING_OVERSHADOWED);
    }

    private void publishUnusedSegments(DataSegment ... segments) {
        this.publishSegments(segments);
        for (DataSegment segment : segments) {
            this.storageCoordinator.markSegmentAsUnused(segment.getId());
        }
    }

    private void publishSegments(DataSegment ... segments) {
        this.storageCoordinator.commitSegments(Set.of(segments), null);
    }

    private static DataSegment createSegment(String dataSource, String interval, String version) {
        return new DataSegment(dataSource, Intervals.of((String)interval), version, Map.of(), List.of(), List.of(), (ShardSpec)new LinearShardSpec(Integer.valueOf(1)), Integer.valueOf(9), 1234L);
    }

    private static DataSegment createNewSegment1(String datasource) {
        return IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment(datasource, "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z");
    }

    private static DataSegment createNewSegment2(String datasource) {
        return IndexerSQLMetadataStorageCoordinatorMarkUsedTest.createSegment(datasource, "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
    }
}

