/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.IndexerMetadataStorageCoordinator;
import org.apache.druid.indexing.overlord.ObjectMetadata;
import org.apache.druid.indexing.overlord.SegmentCreateRequest;
import org.apache.druid.indexing.overlord.Segments;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.IndexerSQLMetadataStorageCoordinator;
import org.apache.druid.metadata.IndexerSqlMetadataStorageCoordinatorTestBase;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.segment.SegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataReadOnlyTransactionFactory;
import org.apache.druid.metadata.segment.SqlSegmentMetadataTransactionFactory;
import org.apache.druid.metadata.segment.cache.HeapMemorySegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.NoopSegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.server.coordinator.simulate.BlockingExecutorService;
import org.apache.druid.server.coordinator.simulate.TestDruidLeaderSelector;
import org.apache.druid.server.coordinator.simulate.WrappingScheduledExecutorService;
import org.apache.druid.timeline.partition.NumberedPartialShardSpec;
import org.apache.druid.timeline.partition.PartialShardSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IndexerSQLMetadataStorageCoordinatorReadOnlyTest
extends IndexerSqlMetadataStorageCoordinatorTestBase {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private IndexerMetadataStorageCoordinator readOnlyStorage;
    private IndexerMetadataStorageCoordinator readWriteStorage;
    private TestDruidLeaderSelector leaderSelector;
    private SegmentMetadataCache segmentMetadataCache;
    private StubServiceEmitter emitter;
    private BlockingExecutorService cachePollExecutor;
    private final SegmentMetadataCache.UsageMode cacheMode;

    @Parameterized.Parameters(name="cacheMode = {0}")
    public static Object[][] testParameters() {
        return new Object[][]{{SegmentMetadataCache.UsageMode.ALWAYS}, {SegmentMetadataCache.UsageMode.NEVER}, {SegmentMetadataCache.UsageMode.IF_SYNCED}};
    }

    public IndexerSQLMetadataStorageCoordinatorReadOnlyTest(SegmentMetadataCache.UsageMode cacheMode) {
        this.cacheMode = cacheMode;
    }

    @Before
    public void setup() {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        this.leaderSelector = new TestDruidLeaderSelector();
        this.emitter = new StubServiceEmitter();
        this.cachePollExecutor = new BlockingExecutorService("test-cache-poll-exec");
        this.segmentMetadataCache = new HeapMemorySegmentMetadataCache(this.mapper, () -> new SegmentsMetadataManagerConfig(null, this.cacheMode, null), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SegmentSchemaCache)new NoopSegmentSchemaCache(), (SQLMetadataConnector)this.derbyConnector, (corePoolSize, nameFormat) -> new WrappingScheduledExecutorService(nameFormat, this.cachePollExecutor, false), (ServiceEmitter)this.emitter);
        this.readOnlyStorage = this.createStorageCoordinator(NodeRole.COORDINATOR);
        this.readWriteStorage = this.createStorageCoordinator(NodeRole.OVERLORD);
        this.derbyConnector.createSegmentTable();
        this.derbyConnector.createPendingSegmentsTable();
        this.leaderSelector.becomeLeader();
        if (this.isCacheEnabled()) {
            this.segmentMetadataCache.start();
            this.segmentMetadataCache.becomeLeader();
            this.syncCache();
            this.syncCache();
        }
    }

    @After
    public void tearDown() {
        this.segmentMetadataCache.stopBeingLeader();
        this.segmentMetadataCache.stop();
        this.leaderSelector.stopBeingLeader();
    }

    private void syncCache() {
        if (this.isCacheEnabled()) {
            this.cachePollExecutor.finishNextPendingTasks(2);
        }
    }

    private boolean isCacheEnabled() {
        return this.cacheMode != SegmentMetadataCache.UsageMode.NEVER;
    }

    private IndexerSQLMetadataStorageCoordinator createStorageCoordinator(NodeRole nodeRole) {
        Object transactionFactory = nodeRole.equals((Object)NodeRole.COORDINATOR) ? new SqlSegmentMetadataReadOnlyTransactionFactory(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector) : new SqlSegmentMetadataTransactionFactory(this.mapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, (DruidLeaderSelector)this.leaderSelector, this.segmentMetadataCache, (ServiceEmitter)this.emitter);
        return new IndexerSQLMetadataStorageCoordinator((SegmentMetadataTransactionFactory)transactionFactory, TestHelper.JSON_MAPPER, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)this.derbyConnector, null, CentralizedDatasourceSchemaConfig.enabled((boolean)false));
    }

    @Test
    public void test_markSegmentsAsUnused_throwsException() {
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.markSegmentAsUnused(this.defaultSegment.getId()));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.markAllSegmentsAsUnused("wiki"));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.markSegmentsAsUnused("wiki", Set.of(this.defaultSegment.getId())));
    }

    @Test
    public void test_commitSegments_throwsException() {
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.commitSegments(Set.of(this.defaultSegment), null));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.commitSegmentsAndMetadata(Set.of(this.defaultSegment), null, null, null, null));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.commitAppendSegments(Set.of(this.defaultSegment), Map.of(), "allocator", null));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.commitAppendSegmentsAndMetadata(Set.of(this.defaultSegment), Map.of(), null, null, null, "allocator", null));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.commitReplaceSegments(Set.of(this.defaultSegment), Set.of(), null));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.commitMetadataOnly("wiki", "wiki", (DataSourceMetadata)new ObjectMetadata((Object)"A"), (DataSourceMetadata)new ObjectMetadata((Object)"B")));
    }

    @Test
    public void test_deleteSegments_throwsException() {
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.deleteSegments(Set.of(this.defaultSegment)));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.deletePendingSegments("wiki"));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.deletePendingSegmentsCreatedInInterval("wiki", Intervals.ETERNITY));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.deletePendingSegmentsForTaskAllocatorId("wiki", "allocator"));
    }

    @Test
    public void test_allocatePendingSegment_throwsException() {
        SegmentCreateRequest createRequest = new SegmentCreateRequest("seq1", null, "v1", (PartialShardSpec)NumberedPartialShardSpec.instance(), "allocator1");
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.allocatePendingSegment("wiki", Intervals.ETERNITY, true, createRequest));
        IndexerSQLMetadataStorageCoordinatorReadOnlyTest.verifyThrowsDefensiveException(() -> this.readOnlyStorage.allocatePendingSegments("wiki", Intervals.ETERNITY, false, List.of(createRequest), true));
    }

    @Test
    public void test_retrieveSegmentForId_returnsSegment_ifPresent() {
        Assert.assertNull((Object)this.readOnlyStorage.retrieveSegmentForId(this.defaultSegment.getId()));
        this.readWriteStorage.commitSegments(Set.of(this.defaultSegment), null);
        Assert.assertEquals((Object)this.defaultSegment, (Object)this.readOnlyStorage.retrieveSegmentForId(this.defaultSegment.getId()));
    }

    @Test
    public void test_retrieveUsedSegmentForId_returnsSegment_ifPresent() {
        Assert.assertNull((Object)this.readOnlyStorage.retrieveUsedSegmentForId(this.defaultSegment.getId()));
        this.readWriteStorage.commitSegments(Set.of(this.defaultSegment), null);
        Assert.assertEquals((Object)this.defaultSegment, (Object)this.readOnlyStorage.retrieveUsedSegmentForId(this.defaultSegment.getId()));
    }

    @Test
    public void test_retrieveAllUsedSegments_returnsSegments_ifPresent() {
        Assert.assertEquals(Set.of(), (Object)this.readOnlyStorage.retrieveAllUsedSegments(this.defaultSegment.getDataSource(), Segments.INCLUDING_OVERSHADOWED));
        this.readWriteStorage.commitSegments(Set.of(this.defaultSegment), null);
        Assert.assertEquals(Set.of(this.defaultSegment), (Object)this.readOnlyStorage.retrieveAllUsedSegments(this.defaultSegment.getDataSource(), Segments.INCLUDING_OVERSHADOWED));
    }

    private static void verifyThrowsDefensiveException(ThrowingRunnable runnable) {
        MatcherAssert.assertThat((Object)((DruidException)Assert.assertThrows(DruidException.class, (ThrowingRunnable)runnable)), (Matcher)DruidExceptionMatcher.defensive().expectMessageIs("Only Overlord can perform write transactions on segment metadata."));
    }
}

