/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientConnectionException;
import java.sql.SQLTransientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.RetryTransactionException;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.UnableToExecuteStatementException;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public class SQLMetadataConnectorTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
    }

    @Test
    public void testCreateTables() {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(this.tablesConfig.getConfigTable());
        tables.add(this.tablesConfig.getSegmentsTable());
        tables.add(this.tablesConfig.getRulesTable());
        tables.add(this.tablesConfig.getTaskLockTable());
        tables.add(this.tablesConfig.getTasksTable());
        tables.add(this.tablesConfig.getAuditTable());
        tables.add(this.tablesConfig.getSupervisorTable());
        this.connector.createSegmentTable();
        this.connector.createConfigTable();
        this.connector.createRulesTable();
        this.connector.createTaskTables();
        this.connector.createAuditTable();
        this.connector.createSupervisorsTable();
        this.connector.getDBI().withHandle(handle -> {
            for (String table : tables) {
                Assert.assertTrue((String)StringUtils.format((String)"table %s was not created!", (Object[])new Object[]{table}), (boolean)this.connector.tableExists(handle, table));
            }
            String taskTable = this.tablesConfig.getTasksTable();
            for (String column : Arrays.asList("type", "group_id")) {
                Assert.assertTrue((String)StringUtils.format((String)"Tasks table column %s was not created!", (Object[])new Object[]{column}), (boolean)this.connector.tableHasColumn(taskTable, column));
            }
            return null;
        });
        for (String table : tables) {
            this.dropTable(table);
        }
    }

    @Test
    public void testIndexCreationOnTaskTable() {
        String entryTableName = this.tablesConfig.getTasksTable();
        this.connector.createTaskTables();
        Set createdIndexSet = this.connector.getIndexOnTable(entryTableName);
        Set expectedIndexSet = Sets.newHashSet((Object[])new String[]{StringUtils.format((String)"idx_%1$s_active_created_date", (Object[])new Object[]{entryTableName}), StringUtils.format((String)"idx_%1$s_datasource_active", (Object[])new Object[]{entryTableName})}).stream().map(StringUtils::toUpperCase).collect(Collectors.toSet());
        for (String expectedIndex : expectedIndexSet) {
            Assert.assertTrue((String)StringUtils.format((String)"Failed to find the expected Index %s on entry table", (Object[])new Object[]{expectedIndex}), (boolean)createdIndexSet.contains(expectedIndex));
        }
        this.connector.createTaskTables();
        this.dropTable(entryTableName);
    }

    @Test
    public void testCreateIndexOnNoTable() {
        String tableName = "noTable";
        try {
            this.connector.createIndex(tableName, "some_string", Lists.newArrayList((Object[])new String[]{"a", "b"}));
        }
        catch (Exception e) {
            Assert.fail((String)"Index creation should never throw an exception");
        }
    }

    @Test
    public void testGeIndexOnNoTable() {
        String tableName = "noTable";
        try {
            Set res = this.connector.getIndexOnTable(tableName);
            Assert.assertEquals((long)0L, (long)res.size());
        }
        catch (Exception e) {
            Assert.fail((String)"getIndexOnTable should never throw an exception");
        }
    }

    @Test
    public void testAlterSegmentTableAddLastUsed() {
        this.connector.createSegmentTable();
        this.derbyConnectorRule.segments().update("ALTER TABLE %1$s DROP COLUMN USED_STATUS_LAST_UPDATED", new Object[0]);
        this.connector.alterSegmentTable();
        Assert.assertTrue((boolean)this.connector.tableHasColumn(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "USED_STATUS_LAST_UPDATED"));
        Assert.assertFalse((boolean)this.connector.tableHasColumn(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "SCHEMA_FINGERPRINT"));
        Assert.assertFalse((boolean)this.connector.tableHasColumn(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getSegmentsTable(), "NUM_ROWS"));
    }

    @Test
    public void testInsertOrUpdate() {
        String tableName = "test";
        this.connector.createConfigTable("test");
        Assert.assertNull((Object)this.connector.lookup("test", "name", "payload", "emperor"));
        this.connector.insertOrUpdate("test", "name", "payload", "emperor", StringUtils.toUtf8((String)"penguin"));
        Assert.assertArrayEquals((byte[])StringUtils.toUtf8((String)"penguin"), (byte[])this.connector.lookup("test", "name", "payload", "emperor"));
        this.connector.insertOrUpdate("test", "name", "payload", "emperor", StringUtils.toUtf8((String)"penguin chick"));
        Assert.assertArrayEquals((byte[])StringUtils.toUtf8((String)"penguin chick"), (byte[])this.connector.lookup("test", "name", "payload", "emperor"));
        this.dropTable("test");
    }

    private void dropTable(String tableName) {
        this.connector.getDBI().withHandle(handle -> handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute());
    }

    @Test
    public void testBasicDataSourceCreation() {
        ImmutableMap props = ImmutableMap.of((Object)"maxConnLifetimeMillis", (Object)"1200000", (Object)"defaultQueryTimeout", (Object)"30000");
        MetadataStorageConnectorConfig config = MetadataStorageConnectorConfig.create((String)"connectURI", (String)"user", (String)"password", (Map)props);
        TestSQLMetadataConnector testSQLMetadataConnector = new TestSQLMetadataConnector((Supplier<MetadataStorageConnectorConfig>)Suppliers.ofInstance((Object)config), (Supplier<MetadataStorageTablesConfig>)Suppliers.ofInstance((Object)this.tablesConfig), CentralizedDatasourceSchemaConfig.create());
        BasicDataSource dataSource = testSQLMetadataConnector.getDatasource();
        Assert.assertEquals((long)dataSource.getMaxConnLifetimeMillis(), (long)1200000L);
        Assert.assertEquals((long)dataSource.getDefaultQueryTimeout().intValue(), (long)30000L);
    }

    @Test
    public void testIsTransientException() {
        MetadataStorageConnectorConfig config = MetadataStorageConnectorConfig.create((String)"connectURI", (String)"user", (String)"password", Collections.emptyMap());
        TestSQLMetadataConnector metadataConnector = new TestSQLMetadataConnector((Supplier<MetadataStorageConnectorConfig>)Suppliers.ofInstance((Object)config), (Supplier<MetadataStorageTablesConfig>)Suppliers.ofInstance((Object)this.tablesConfig), CentralizedDatasourceSchemaConfig.create());
        Assert.assertTrue((boolean)metadataConnector.isTransientException((Throwable)new RetryTransactionException("")));
        Assert.assertTrue((boolean)metadataConnector.isTransientException(new SQLRecoverableException()));
        Assert.assertTrue((boolean)metadataConnector.isTransientException(new SQLTransientException()));
        Assert.assertTrue((boolean)metadataConnector.isTransientException(new SQLTransientConnectionException()));
        Assert.assertFalse((boolean)metadataConnector.isTransientException(null));
        Assert.assertFalse((boolean)metadataConnector.isTransientException(new SQLException()));
        Assert.assertFalse((boolean)metadataConnector.isTransientException((Throwable)new UnableToExecuteStatementException("")));
        Assert.assertTrue((boolean)metadataConnector.isTransientException((Throwable)new CallbackFailedException((Throwable)new SQLTransientException())));
        Assert.assertTrue((boolean)metadataConnector.isTransientException((Throwable)new UnableToObtainConnectionException((Throwable)new SQLException())));
        Assert.assertTrue((boolean)metadataConnector.isTransientException((Throwable)new UnableToExecuteStatementException((Exception)new SQLTransientException())));
        Assert.assertFalse((boolean)metadataConnector.isTransientException((Throwable)new CallbackFailedException((Throwable)new SQLException())));
        Assert.assertFalse((boolean)metadataConnector.isTransientException((Throwable)new UnableToExecuteStatementException((Exception)new SQLException())));
    }

    @Test
    public void test_useShortIndexNames_true_tableIndices_areNotAdded_ifExist() {
        this.tablesConfig = new MetadataStorageTablesConfig("druidTest", null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true));
        this.connector = new TestDerbyConnector(new MetadataStorageConnectorConfig(), this.tablesConfig);
        String segmentsTable = this.tablesConfig.getSegmentsTable();
        this.connector.createSegmentTable(segmentsTable);
        this.connector.alterSegmentTable();
        this.connector.getDBI().withHandle(handle -> {
            handle.execute("DROP INDEX IDX_8FE3D20EC8C9CA932EA3FF6AC497D1A9E75ADDA0", new Object[0]);
            handle.execute("CREATE INDEX IDX_DRUIDTEST_SEGMENTS_USED ON druidTest_segments(used)", new Object[0]);
            return null;
        });
        this.connector.createSegmentTable(segmentsTable);
        this.connector.alterSegmentTable();
        HashSet expectedIndices = Sets.newHashSet((Object[])new String[]{"IDX_DRUIDTEST_SEGMENTS_USED", "IDX_D011BD6ED76268701273CE512704C5AFA060D672", "IDX_6381EF2DB4824C35C0E72EF9E166626ADB2B21A3"});
        this.assertIndicesPresentOnTable(segmentsTable, expectedIndices);
        this.dropTable(segmentsTable);
        this.connector.tearDown();
    }

    @Test
    public void test_useShortIndexNames_false_tableIndices_areNotAdded_ifExist() {
        this.tablesConfig = new MetadataStorageTablesConfig("druidTest", null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false));
        this.connector = new TestDerbyConnector(new MetadataStorageConnectorConfig(), this.tablesConfig);
        String segmentsTable = this.tablesConfig.getSegmentsTable();
        this.connector.createSegmentTable(segmentsTable);
        this.connector.alterSegmentTable();
        this.connector.getDBI().withHandle(handle -> {
            handle.execute("DROP INDEX IDX_DRUIDTEST_SEGMENTS_USED", new Object[0]);
            handle.execute("CREATE INDEX IDX_8FE3D20EC8C9CA932EA3FF6AC497D1A9E75ADDA0 ON druidTest_segments(used)", new Object[0]);
            return null;
        });
        this.connector.createSegmentTable(segmentsTable);
        this.connector.alterSegmentTable();
        HashSet expectedIndices = Sets.newHashSet((Object[])new String[]{"IDX_8FE3D20EC8C9CA932EA3FF6AC497D1A9E75ADDA0", "IDX_DRUIDTEST_SEGMENTS_DATASOURCE_USED_END_START", "IDX_DRUIDTEST_SEGMENTS_DATASOURCE_UPGRADED_FROM_SEGMENT_ID"});
        this.assertIndicesPresentOnTable(segmentsTable, expectedIndices);
        this.dropTable(segmentsTable);
        this.connector.tearDown();
    }

    @Test
    public void test_useShortIndexNames_true_tableIndices_areAdded_IfNotExist() {
        this.tablesConfig = new MetadataStorageTablesConfig("druidTest", null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(true));
        this.connector = new TestDerbyConnector(new MetadataStorageConnectorConfig(), this.tablesConfig);
        String segmentsTable = this.tablesConfig.getSegmentsTable();
        HashSet expectedIndices = Sets.newHashSet((Object[])new String[]{"IDX_8FE3D20EC8C9CA932EA3FF6AC497D1A9E75ADDA0", "IDX_D011BD6ED76268701273CE512704C5AFA060D672", "IDX_6381EF2DB4824C35C0E72EF9E166626ADB2B21A3"});
        this.connector.createSegmentTable(segmentsTable);
        this.connector.alterSegmentTable();
        this.assertIndicesPresentOnTable(segmentsTable, expectedIndices);
        this.dropTable(segmentsTable);
        this.connector.tearDown();
    }

    @Test
    public void test_useShortIndexNames_false_tableIndices_areAdded_IfNotExist() {
        this.tablesConfig = new MetadataStorageTablesConfig("druidTest", null, null, null, null, null, null, null, null, null, null, null, Boolean.valueOf(false));
        this.connector = new TestDerbyConnector(new MetadataStorageConnectorConfig(), this.tablesConfig);
        String segmentsTable = this.tablesConfig.getSegmentsTable();
        HashSet expectedIndices = Sets.newHashSet((Object[])new String[]{"IDX_DRUIDTEST_SEGMENTS_USED", "IDX_DRUIDTEST_SEGMENTS_DATASOURCE_USED_END_START", "IDX_DRUIDTEST_SEGMENTS_DATASOURCE_UPGRADED_FROM_SEGMENT_ID"});
        this.connector.createSegmentTable(segmentsTable);
        this.connector.alterSegmentTable();
        this.assertIndicesPresentOnTable(segmentsTable, expectedIndices);
        this.dropTable(segmentsTable);
        this.connector.tearDown();
    }

    private void assertIndicesPresentOnTable(String tableName, Set<String> expectedIndices) {
        Set actualIndices = this.connector.getIndexOnTable(tableName).stream().filter(name -> !name.startsWith("SQL")).collect(Collectors.toSet());
        Assert.assertEquals((String)StringUtils.format((String)"Received unexpected table index set for table[%s]. Got [%s], expected [%s].", (Object[])new Object[]{tableName, actualIndices, expectedIndices}), actualIndices, expectedIndices);
    }

    static class TestSQLMetadataConnector
    extends SQLMetadataConnector {
        public TestSQLMetadataConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> tablesConfigSupplier, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
            super(config, tablesConfigSupplier, centralizedDatasourceSchemaConfig);
        }

        public String getSerialType() {
            return null;
        }

        public int getStreamingFetchSize() {
            return 0;
        }

        public String limitClause(int limit) {
            return "";
        }

        public String getQuoteString() {
            return null;
        }

        public boolean tableExists(Handle handle, String tableName) {
            return false;
        }

        public DBI getDBI() {
            return null;
        }

        protected BasicDataSource getDatasource() {
            return super.getDatasource();
        }
    }
}

