/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.metadata.SqlSegmentsMetadataManagerTestBase;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.assertj.core.util.Sets;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SqlSegmentsMetadataManagerTest
extends SqlSegmentsMetadataManagerTestBase {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final DataSegment wikiSegment1 = CreateDataSegments.ofDatasource("wiki").startingAt("2012-03-15").eachOfSizeInMb(500L).get(0);
    private final DataSegment wikiSegment2 = CreateDataSegments.ofDatasource("wiki").startingAt("2012-01-05").eachOfSizeInMb(500L).get(0);

    private static DataSegment createSegment(String dataSource, String interval, String version) {
        return new DataSegment(dataSource, Intervals.of((String)interval), version, (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 1234L);
    }

    private void publishUnusedSegments(DataSegment ... segments) {
        for (DataSegment segment : segments) {
            this.publishSegment(segment);
            this.markSegmentsAsUnused(segment.getId());
        }
    }

    private void publishWikiSegments() {
        this.publishSegment(this.wikiSegment1);
        this.publishSegment(this.wikiSegment2);
    }

    @Before
    public void setUp() throws Exception {
        this.setUp(this.derbyConnectorRule);
    }

    @After
    public void tearDown() {
        this.teardownManager();
    }

    @Test
    public void testPollEmpty() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.getRecentDataSourcesSnapshot().getDataSourcesWithAllUsedSegments().isEmpty());
    }

    @Test
    public void testPollPeriodically() {
        this.publishWikiSegments();
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay();
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Collection)dataSourcesSnapshot.getDataSource("wiki").getSegments()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), this.retrieveAllUsedSegments());
    }

    @Test
    public void testPollOnDemand() {
        this.publishWikiSegments();
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay());
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.forceOrWaitOngoingDatabasePoll();
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.OnDemandDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), (Object)ImmutableSet.copyOf((Collection)dataSourcesSnapshot.getDataSource("wiki").getSegments()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2), this.retrieveAllUsedSegments());
    }

    @Test(timeout=60000L)
    public void testPollPeriodicallyAndOnDemandInterleave() throws Exception {
        this.publishWikiSegments();
        DataSourcesSnapshot dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot();
        Assert.assertNull((Object)dataSourcesSnapshot);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        this.sqlSegmentsMetadataManager.useLatestSnapshotIfWithinDelay();
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        this.publishSegment(SqlSegmentsMetadataManagerTest.createNewSegment1("koala"));
        this.sqlSegmentsMetadataManager.forceOrWaitOngoingDatabasePoll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.OnDemandDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableList.of((Object)"koala", (Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        String newDataSource3 = "wikipedia3";
        this.publishSegment(SqlSegmentsMetadataManagerTest.createNewSegment1("wikipedia3"));
        while (this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot().getDataSource("wikipedia3") == null) {
            Thread.sleep(1000L);
        }
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertTrue((boolean)(this.sqlSegmentsMetadataManager.getLatestDatabasePoll() instanceof SqlSegmentsMetadataManager.PeriodicDatabasePoll));
        dataSourcesSnapshot = this.sqlSegmentsMetadataManager.getLatestDataSourcesSnapshot();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"koala", (Object)"wikipedia3", (Object)"wiki"), dataSourcesSnapshot.getDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toSet()));
    }

    @Test
    public void testPrepareImmutableDataSourceWithUsedSegmentsAwaitsPollOnRestart() {
        this.publishWikiSegments();
        DataSegment koalaSegment = this.pollThenStopThenPublishKoalaSegment();
        Assert.assertEquals(Set.of(koalaSegment), Set.copyOf(this.sqlSegmentsMetadataManager.getRecentDataSourcesSnapshot().getDataSource("koala").getSegments()));
    }

    @Test
    public void testGetDataSourceWithUsedSegmentsAwaitsPollOnRestart() {
        this.publishWikiSegments();
        DataSegment koalaSegment = this.pollThenStopThenPublishKoalaSegment();
        Assert.assertEquals(Set.of(koalaSegment), Set.copyOf(this.sqlSegmentsMetadataManager.getRecentDataSourcesSnapshot().getDataSource("koala").getSegments()));
    }

    @Test
    public void testPrepareImmutableDataSourcesWithAllUsedSegmentsAwaitsPollOnRestart() {
        this.publishWikiSegments();
        DataSegment koalaSegment = this.pollThenStopThenPublishKoalaSegment();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment), (Object)ImmutableSet.copyOf(this.sqlSegmentsMetadataManager.getRecentDataSourcesSnapshot().getDataSourcesWithAllUsedSegments().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator()));
    }

    @Test
    public void testIterateAllUsedSegmentsAwaitsPollOnRestart() {
        this.publishWikiSegments();
        DataSegment koalaSegment = this.pollThenStopThenPublishKoalaSegment();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.wikiSegment1, (Object)this.wikiSegment2, (Object)koalaSegment), this.retrieveAllUsedSegments());
    }

    private DataSegment pollThenStopThenPublishKoalaSegment() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        Assert.assertFalse((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSegment koalaSegment = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        this.publishSegment(koalaSegment);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        return koalaSegment;
    }

    @Test
    public void testPollWithCorruptedSegment() {
        this.publishWikiSegments();
        DataSegment corruptSegment = DataSegment.builder((DataSegment)this.wikiSegment1).dataSource("corrupt-datasource").build();
        this.publishSegment(corruptSegment);
        this.updateSegmentPayload(corruptSegment, StringUtils.toUtf8((String)"corrupt-payload"));
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        DataSourcesSnapshot snapshot = this.sqlSegmentsMetadataManager.getRecentDataSourcesSnapshot();
        Assert.assertEquals((Object)"wiki", (Object)((ImmutableDruidDataSource)Iterables.getOnlyElement((Iterable)snapshot.getDataSourcesWithAllUsedSegments())).getName());
    }

    private static DataSegment createNewSegment1(String datasource) {
        return SqlSegmentsMetadataManagerTest.createSegment(datasource, "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z");
    }

    private static DataSegment createNewSegment2(String datasource) {
        return SqlSegmentsMetadataManagerTest.createSegment(datasource, "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
    }

    @Test
    public void test_poll_doesNotRetrieveUnusedSegments() {
        this.publishWikiSegments();
        DataSegment koalaSegment1 = SqlSegmentsMetadataManagerTest.createNewSegment1("koala");
        DataSegment koalaSegment2 = SqlSegmentsMetadataManagerTest.createNewSegment2("koala");
        this.publishSegment(koalaSegment1);
        this.publishSegment(koalaSegment2);
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadataManager.isPollingDatabasePeriodically());
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2, koalaSegment1, koalaSegment2), this.retrieveAllUsedSegments());
        Assert.assertEquals((long)2L, (long)this.markSegmentsAsUnused(koalaSegment1.getId(), koalaSegment2.getId()));
        this.sqlSegmentsMetadataManager.poll();
        Assert.assertEquals(Set.of(this.wikiSegment1, this.wikiSegment2), this.retrieveAllUsedSegments());
    }

    @Test
    public void testStopAndStart() {
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadataManager.stopPollingDatabasePeriodically();
    }

    @Test
    public void testIterateAllUsedNonOvershadowedSegmentsForDatasourceInterval() {
        this.publishWikiSegments();
        Interval theInterval = Intervals.of((String)"2012-03-15T00:00:00.000/2012-03-20T00:00:00.000");
        SegmentsMetadataManagerConfig config = new SegmentsMetadataManagerConfig(Period.seconds((int)1), null, null);
        this.sqlSegmentsMetadataManager = new SqlSegmentsMetadataManager(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)this.derbyConnectorRule.getConnector(), this.segmentSchemaCache, CentralizedDatasourceSchemaConfig.create(), (ServiceEmitter)NoopServiceEmitter.instance());
        this.sqlSegmentsMetadataManager.start();
        Set segments = this.sqlSegmentsMetadataManager.getRecentDataSourcesSnapshot().getAllUsedNonOvershadowedSegments("wiki", theInterval);
        Assert.assertEquals(Set.of(this.wikiSegment1), (Object)segments);
        DataSegment wikiSegment3 = SqlSegmentsMetadataManagerTest.createSegment("wiki", "2012-03-16T00:00:00.000/2012-03-17T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishSegment(wikiSegment3);
        segments = this.sqlSegmentsMetadataManager.getRecentDataSourcesSnapshot().getAllUsedNonOvershadowedSegments("wiki", theInterval);
        Assert.assertEquals(Set.of(this.wikiSegment1), (Object)segments);
        segments = this.sqlSegmentsMetadataManager.forceUpdateDataSourcesSnapshot().getAllUsedNonOvershadowedSegments("wiki", theInterval);
        Assert.assertEquals(Set.of(this.wikiSegment1, wikiSegment3), (Object)segments);
    }

    @Test
    public void testPopulateUsedFlagLastUpdated() {
        this.allowUsedFlagLastUpdatedToBeNullable();
        DataSegment koalaSegment = SqlSegmentsMetadataManagerTest.createSegment("koala", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z");
        this.publishUnusedSegments(koalaSegment);
        this.updateUsedStatusLastUpdatedToNull(koalaSegment);
        Assert.assertEquals((long)1L, (long)this.getCountOfRowsWithLastUsedNull());
        this.sqlSegmentsMetadataManager.populateUsedFlagLastUpdated();
        Assert.assertEquals((long)0L, (long)this.getCountOfRowsWithLastUsedNull());
    }

    private int getCountOfRowsWithLastUsedNull() {
        return (Integer)this.derbyConnectorRule.getConnector().retryWithHandle(handle -> handle.select(StringUtils.format((String)"SELECT ID FROM %1$s WHERE USED_STATUS_LAST_UPDATED IS NULL", (Object[])new Object[]{this.derbyConnectorRule.segments().getTableName()}), new Object[0]).size());
    }

    private void updateSegmentPayload(DataSegment segment, byte[] payload) {
        this.derbyConnectorRule.segments().update("UPDATE %1$s SET PAYLOAD = ? WHERE ID = ?", payload, segment.getId().toString());
    }

    private void updateUsedStatusLastUpdatedToNull(DataSegment segment) {
        this.derbyConnectorRule.segments().update("UPDATE %1$s SET USED_STATUS_LAST_UPDATED = NULL WHERE ID = ?", segment.getId().toString());
    }

    private void allowUsedFlagLastUpdatedToBeNullable() {
        this.derbyConnectorRule.segments().update("ALTER TABLE %1$s ALTER COLUMN USED_STATUS_LAST_UPDATED NULL", new Object[0]);
    }

    private Set<DataSegment> retrieveAllUsedSegments() {
        return Sets.newHashSet((Iterable)this.sqlSegmentsMetadataManager.getRecentDataSourcesSnapshot().iterateAllUsedSegmentsInSnapshot());
    }
}

