/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.IndexerSqlMetadataStorageCoordinatorTestBase;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePeriod;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Handle;

public class SqlSegmentsMetadataQueryTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private static final DateTime JAN_1 = DateTimes.of((String)"2025-01-01");
    private static final String V1 = JAN_1.toString();
    private static final String V2 = JAN_1.plusDays(1).toString();
    private static final List<DataSegment> WIKI_SEGMENTS_2X5D = CreateDataSegments.ofDatasource("wiki").forIntervals(5, Granularities.DAY).withNumPartitions(2).startingAt(JAN_1).withVersion(V1).eachOfSizeInMb(500L);

    @Before
    public void setUp() {
        this.derbyConnectorRule.getConnector().createSegmentTable();
        this.insertSegments(WIKI_SEGMENTS_2X5D.toArray(new DataSegment[0]));
    }

    @Test
    public void test_markSegmentsAsUnused() {
        Assert.assertEquals(Set.copyOf(WIKI_SEGMENTS_2X5D), this.retrieveAllUsedSegments());
        Assert.assertTrue((boolean)this.retrieveAllUnusedSegments().isEmpty());
        Set<DataSegment> segmentsToUpdate = Set.of(WIKI_SEGMENTS_2X5D.get(0), WIKI_SEGMENTS_2X5D.get(1));
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsAsUnused(SqlSegmentsMetadataQueryTest.getIds(segmentsToUpdate), DateTimes.nowUtc()));
        Assert.assertEquals((long)2L, (long)numUpdatedSegments);
        Assert.assertEquals(segmentsToUpdate, this.retrieveAllUnusedSegments());
        Set<DataSegment> usedSegments = this.retrieveAllUsedSegments();
        Assert.assertEquals((long)8L, (long)usedSegments.size());
        segmentsToUpdate.forEach(updatedSegment -> Assert.assertFalse((boolean)usedSegments.contains(updatedSegment)));
    }

    @Test
    public void test_markSegmentsAsUsed() {
        Set<DataSegment> segmentsToUpdate = Set.of(WIKI_SEGMENTS_2X5D.get(0), WIKI_SEGMENTS_2X5D.get(1));
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsAsUnused(SqlSegmentsMetadataQueryTest.getIds(segmentsToUpdate), DateTimes.nowUtc()));
        Assert.assertEquals((long)2L, (long)numUpdatedSegments);
        Assert.assertEquals(segmentsToUpdate, this.retrieveAllUnusedSegments());
        numUpdatedSegments = this.update(sql -> sql.markSegmentsAsUsed(SqlSegmentsMetadataQueryTest.getIds(segmentsToUpdate), DateTimes.nowUtc()));
        Assert.assertEquals((long)2L, (long)numUpdatedSegments);
        Assert.assertEquals(Set.copyOf(WIKI_SEGMENTS_2X5D), this.retrieveAllUsedSegments());
        Assert.assertTrue((boolean)this.retrieveAllUnusedSegments().isEmpty());
    }

    @Test
    public void test_markSegmentsAsUnused_forEmptySegmentIds_isNoop() {
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsAsUnused(Set.of(), DateTimes.nowUtc()));
        Assert.assertEquals((long)0L, (long)numUpdatedSegments);
        Assert.assertEquals(Set.copyOf(WIKI_SEGMENTS_2X5D), this.retrieveAllUsedSegments());
    }

    @Test
    public void test_markSegmentsUnused_forEternityInterval() {
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsUnused("wiki", Intervals.ETERNITY, null, DateTimes.nowUtc()));
        Assert.assertEquals((long)WIKI_SEGMENTS_2X5D.size(), (long)numUpdatedSegments);
        Assert.assertEquals(Set.copyOf(WIKI_SEGMENTS_2X5D), this.retrieveAllUnusedSegments());
        Assert.assertTrue((boolean)this.retrieveAllUsedSegments().isEmpty());
    }

    @Test
    public void test_markSegmentsUnused_forSingleVersion() {
        this.insertSegments((DataSegment[])WIKI_SEGMENTS_2X5D.stream().map(segment -> DataSegment.builder((DataSegment)segment).version(V2).build()).toArray(DataSegment[]::new));
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsUnused("wiki", new Interval((ReadableInstant)JAN_1, (ReadablePeriod)Period.days((int)2)), List.of(V1), DateTimes.nowUtc()));
        Assert.assertEquals((long)4L, (long)numUpdatedSegments);
        Assert.assertEquals((long)4L, (long)this.retrieveAllUnusedSegments().size());
        Assert.assertEquals((long)16L, (long)this.retrieveAllUsedSegments().size());
    }

    @Test
    public void test_markSegmentsUnused_forMultipleVersions() {
        this.insertSegments((DataSegment[])WIKI_SEGMENTS_2X5D.stream().map(segment -> DataSegment.builder((DataSegment)segment).version(V2).build()).toArray(DataSegment[]::new));
        List<String> versionsToUpdate = List.of(V1, V2);
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsUnused("wiki", new Interval((ReadableInstant)JAN_1, (ReadablePeriod)Period.days((int)2)), versionsToUpdate, DateTimes.nowUtc()));
        Assert.assertEquals((long)8L, (long)numUpdatedSegments);
        Assert.assertEquals((long)8L, (long)this.retrieveAllUnusedSegments().size());
        Assert.assertEquals((long)12L, (long)this.retrieveAllUsedSegments().size());
    }

    @Test
    public void test_markSegmentsUnused_forAllVersions() {
        this.insertSegments((DataSegment[])WIKI_SEGMENTS_2X5D.stream().map(segment -> DataSegment.builder((DataSegment)segment).version(V2).build()).toArray(DataSegment[]::new));
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsUnused("wiki", new Interval((ReadableInstant)JAN_1, (ReadablePeriod)Period.days((int)2)), null, DateTimes.nowUtc()));
        Assert.assertEquals((long)8L, (long)numUpdatedSegments);
        Assert.assertEquals((long)8L, (long)this.retrieveAllUnusedSegments().size());
        Assert.assertEquals((long)12L, (long)this.retrieveAllUsedSegments().size());
    }

    @Test
    public void test_markSegmentsUnused_forEmptyVersions_isNoop() {
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsUnused("wiki", Intervals.ETERNITY, List.of(), DateTimes.nowUtc()));
        Assert.assertEquals((long)0L, (long)numUpdatedSegments);
        Assert.assertEquals(Set.copyOf(WIKI_SEGMENTS_2X5D), this.retrieveAllUsedSegments());
        Assert.assertTrue((boolean)this.retrieveAllUnusedSegments().isEmpty());
    }

    @Test
    public void test_retrieveSegmentForId() {
        DataSegment segmentJan1 = WIKI_SEGMENTS_2X5D.get(0);
        Assert.assertEquals((Object)segmentJan1, (Object)this.read(sql -> sql.retrieveSegmentForId(segmentJan1.getId())));
    }

    @Test
    public void test_retrieveSegmentForId_returnsNull_forUnknownId() {
        Assert.assertNull((Object)this.read(sql -> sql.retrieveSegmentForId(SegmentId.dummy((String)"wiki"))));
    }

    @Test
    public void test_retrieveUsedSegments_withOverlapsCondition() {
        Interval queryInterval = new Interval((ReadableInstant)JAN_1.plusDays(2), (ReadableInstant)JAN_1.plusDays(4));
        Set<DataSegment> result = this.readAsSet(q -> q.retrieveUsedSegments("wiki", List.of(queryInterval)));
        Assert.assertEquals((long)4L, (long)result.size());
        this.assertSegmentsOverlapInterval(result, queryInterval);
    }

    @Test
    public void test_retrieveUsedSegments_withOverlapsCondition_andUnusedSegments() {
        Set<DataSegment> segmentsToUpdate = Set.of(WIKI_SEGMENTS_2X5D.get(2));
        int numUpdatedSegments = this.update(sql -> sql.markSegmentsAsUnused(SqlSegmentsMetadataQueryTest.getIds(segmentsToUpdate), DateTimes.nowUtc()));
        Assert.assertEquals((long)1L, (long)numUpdatedSegments);
        Interval queryInterval = new Interval((ReadableInstant)JAN_1, (ReadableInstant)JAN_1.plusDays(2));
        Set<DataSegment> result = this.readAsSet(q -> q.retrieveUsedSegments("wiki", List.of(queryInterval)));
        Assert.assertEquals((long)3L, (long)result.size());
        this.assertSegmentsOverlapInterval(result, queryInterval);
    }

    @Test
    public void test_retrieveUsedSegments_withOverlapsCondition_nearEndDate() {
        Interval queryInterval = new Interval((ReadableInstant)JAN_1.plusDays(4), (ReadableInstant)JAN_1.plusDays(5));
        Set<DataSegment> result = this.readAsSet(q -> q.retrieveUsedSegments("wiki", List.of(queryInterval)));
        Assert.assertEquals((long)2L, (long)result.size());
        this.assertSegmentsOverlapInterval(result, queryInterval);
    }

    private void assertSegmentsOverlapInterval(Set<DataSegment> segments, Interval interval) {
        for (DataSegment segment : segments) {
            Assert.assertTrue((String)("Segment " + segment.getId() + " should be in interval " + interval), (boolean)segment.getInterval().overlaps((ReadableInterval)interval));
        }
    }

    private <T> T read(Function<SqlSegmentsMetadataQuery, T> function) {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        return (T)connector.inReadOnlyTransaction((handle, status) -> function.apply(SqlSegmentsMetadataQuery.forHandle((Handle)handle, (SQLMetadataConnector)connector, (MetadataStorageTablesConfig)tablesConfig, (ObjectMapper)TestHelper.JSON_MAPPER)));
    }

    private <T> Set<T> readAsSet(Function<SqlSegmentsMetadataQuery, CloseableIterator<T>> iterableReader) {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        return (Set)connector.inReadOnlyTransaction((handle, status) -> {
            SqlSegmentsMetadataQuery query = SqlSegmentsMetadataQuery.forHandle((Handle)handle, (SQLMetadataConnector)connector, (MetadataStorageTablesConfig)tablesConfig, (ObjectMapper)TestHelper.JSON_MAPPER);
            try (CloseableIterator iterator = (CloseableIterator)iterableReader.apply(query);){
                ImmutableSet immutableSet = ImmutableSet.copyOf((Iterator)iterator);
                return immutableSet;
            }
        });
    }

    private <T> T update(Function<SqlSegmentsMetadataQuery, T> function) {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        MetadataStorageTablesConfig tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        return (T)connector.retryWithHandle(handle -> function.apply(SqlSegmentsMetadataQuery.forHandle((Handle)handle, (SQLMetadataConnector)connector, (MetadataStorageTablesConfig)tablesConfig, (ObjectMapper)TestHelper.JSON_MAPPER)));
    }

    private Set<DataSegment> retrieveAllUsedSegments() {
        return this.readAsSet(sql -> sql.retrieveUsedSegments("wiki", List.of()));
    }

    private Set<DataSegment> retrieveAllUnusedSegments() {
        return this.readAsSet(sql -> sql.retrieveUnusedSegments("wiki", List.of(), null, null, null, null, null));
    }

    private void insertSegments(DataSegment ... segments) {
        IndexerSqlMetadataStorageCoordinatorTestBase.insertUsedSegments(Set.of(segments), Map.of(), this.derbyConnectorRule, TestHelper.JSON_MAPPER);
    }

    private static Set<SegmentId> getIds(Set<DataSegment> segments) {
        return segments.stream().map(DataSegment::getId).collect(Collectors.toSet());
    }
}

