/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.Set;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.metadata.SegmentsMetadataManagerConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManagerTestBase;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.segment.SqlSegmentsMetadataManagerV2;
import org.apache.druid.metadata.segment.cache.HeapMemorySegmentMetadataCache;
import org.apache.druid.metadata.segment.cache.SegmentMetadataCache;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.NoopSegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.server.coordinator.CreateDataSegments;
import org.apache.druid.server.coordinator.simulate.BlockingExecutorService;
import org.apache.druid.server.coordinator.simulate.WrappingScheduledExecutorService;
import org.apache.druid.timeline.DataSegment;
import org.assertj.core.util.Sets;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SqlSegmentsMetadataManagerV2Test
extends SqlSegmentsMetadataManagerTestBase {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule(CentralizedDatasourceSchemaConfig.enabled((boolean)true));
    private SegmentsMetadataManager manager;
    private BlockingExecutorService segmentMetadataCacheExec;
    private StubServiceEmitter emitter;
    private static final DateTime JAN_1 = DateTimes.of((String)"2025-01-01");
    private static final List<DataSegment> WIKI_SEGMENTS_1X5D = CreateDataSegments.ofDatasource("wiki").forIntervals(5, Granularities.DAY).startingAt(JAN_1).eachOfSize(500L);

    @Before
    public void setup() throws Exception {
        this.setUp(this.derbyConnectorRule);
        this.connector.createPendingSegmentsTable();
        this.emitter = new StubServiceEmitter();
        WIKI_SEGMENTS_1X5D.forEach(x$0 -> super.publishSegment((DataSegment)x$0));
    }

    private void initManager(SegmentMetadataCache.UsageMode cacheMode, boolean useSchemaCache) {
        this.segmentMetadataCacheExec = new BlockingExecutorService("test");
        HeapMemorySegmentMetadataCache segmentMetadataCache = new HeapMemorySegmentMetadataCache(this.jsonMapper, Suppliers.ofInstance((Object)new SegmentsMetadataManagerConfig(Period.seconds((int)1), cacheMode, null)), Suppliers.ofInstance((Object)this.storageConfig), (SegmentSchemaCache)(useSchemaCache ? new SegmentSchemaCache() : new NoopSegmentSchemaCache()), (SQLMetadataConnector)this.connector, (poolSize, name) -> new WrappingScheduledExecutorService(name, this.segmentMetadataCacheExec, false), (ServiceEmitter)this.emitter);
        segmentMetadataCache.start();
        segmentMetadataCache.becomeLeader();
        this.manager = new SqlSegmentsMetadataManagerV2((SegmentMetadataCache)segmentMetadataCache, this.segmentSchemaCache, (SQLMetadataConnector)this.connector, Suppliers.ofInstance((Object)this.config), this.derbyConnectorRule.metadataTablesConfigSupplier(), CentralizedDatasourceSchemaConfig::create, (ServiceEmitter)this.emitter, this.jsonMapper);
        this.manager.start();
    }

    private void syncSegmentMetadataCache() {
        this.segmentMetadataCacheExec.finishNextPendingTasks(2);
        this.segmentMetadataCacheExec.finishNextPendingTasks(2);
    }

    @After
    public void tearDown() {
        if (this.manager == null) {
            return;
        }
        if (this.manager.isPollingDatabasePeriodically()) {
            this.manager.stopPollingDatabasePeriodically();
        }
        this.manager.stop();
    }

    @Test
    public void test_manager_usesCachedSegments_ifCacheIsEnabled() {
        this.initManager(SegmentMetadataCache.UsageMode.ALWAYS, false);
        this.manager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.manager.isPollingDatabasePeriodically());
        this.syncSegmentMetadataCache();
        this.verifyDatasourceSnapshot();
        this.manager.stopPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.manager.isPollingDatabasePeriodically());
        this.emitter.verifyNotEmitted("segment/poll/time");
        this.emitter.verifyNotEmitted("segment/pollWithSchema/time");
        this.emitter.verifyNotEmitted("segment/metadataCache/fetchSchemas/time");
        this.emitter.verifyNotEmitted("segment/schemaCache/used/count");
        this.emitter.verifyEmitted("segment/metadataCache/sync/time", 2);
    }

    @Test
    public void test_manager_pollsSegments_ifCacheIsDisabled() {
        this.initManager(SegmentMetadataCache.UsageMode.NEVER, false);
        this.manager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.manager.isPollingDatabasePeriodically());
        this.verifyDatasourceSnapshot();
        this.manager.stopPollingDatabasePeriodically();
        Assert.assertFalse((boolean)this.manager.isPollingDatabasePeriodically());
        this.emitter.verifyEmitted("segment/poll/time", 1);
        this.emitter.verifyNotEmitted("segment/metadataCache/sync/time");
    }

    @Test
    public void test_manager_usesCachedSegmentsAndSchemas_ifBothCacheAndSchemaAreEnabled() {
        this.initManager(SegmentMetadataCache.UsageMode.ALWAYS, true);
        this.manager.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.manager.isPollingDatabasePeriodically());
        this.syncSegmentMetadataCache();
        this.verifyDatasourceSnapshot();
        this.manager.stopPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.manager.isPollingDatabasePeriodically());
        this.emitter.verifyNotEmitted("segment/poll/time");
        this.emitter.verifyNotEmitted("segment/pollWithSchema/time");
        this.emitter.verifyEmitted("segment/metadataCache/sync/time", 2);
        this.emitter.verifyEmitted("segment/metadataCache/fetchSchemas/time", 2);
        this.emitter.verifyEmitted("segment/schemaCache/used/count", 2);
    }

    private void verifyDatasourceSnapshot() {
        DataSourcesSnapshot snapshot = this.manager.getRecentDataSourcesSnapshot();
        Assert.assertEquals(Set.copyOf(WIKI_SEGMENTS_1X5D), (Object)Sets.newHashSet((Iterable)snapshot.iterateAllUsedSegmentsInSnapshot()));
        Assert.assertEquals(Set.copyOf(WIKI_SEGMENTS_1X5D), Set.copyOf(snapshot.getDataSource("wiki").getSegments()));
    }
}

