/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.SimpleServerView;
import org.apache.druid.client.TestHttpClient;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.ForegroundCachePopulator;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.Result;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.context.ConcurrentResponseContext;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.generator.GeneratorBasicSchemas;
import org.apache.druid.segment.generator.GeneratorSchemaInfo;
import org.apache.druid.segment.generator.SegmentGenerator;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;

public abstract class QueryRunnerBasedOnClusteredClientTestBase {
    protected static final GeneratorSchemaInfo BASE_SCHEMA_INFO = (GeneratorSchemaInfo)GeneratorBasicSchemas.SCHEMA_MAP.get("basic");
    private static final Closer CLOSER = Closer.create();
    private static final String DATASOURCE = "datasource";
    private static final boolean USE_PARALLEL_MERGE_POOL_CONFIGURED = false;
    protected final ObjectMapper objectMapper = new DefaultObjectMapper();
    protected final QueryRunnerFactoryConglomerate conglomerate;
    protected TestHttpClient httpClient;
    protected SimpleServerView simpleServerView;
    protected CachingClusteredClient cachingClusteredClient;
    protected List<DruidServer> servers;
    private SegmentGenerator segmentGenerator;
    protected StubServiceEmitter emitter = new StubServiceEmitter();

    protected QueryRunnerBasedOnClusteredClientTestBase() {
        this.conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate(CLOSER, 1000);
    }

    @AfterClass
    public static void tearDownAbstractClass() throws IOException {
        CLOSER.close();
    }

    @Before
    public void setupTestBase() {
        this.segmentGenerator = new SegmentGenerator();
        this.httpClient = new TestHttpClient(this.objectMapper);
        this.simpleServerView = new SimpleServerView(this.conglomerate, this.objectMapper, this.httpClient);
        this.emitter.flush();
        this.cachingClusteredClient = new CachingClusteredClient(this.conglomerate, (TimelineServerView)this.simpleServerView, MapCache.create((long)0L), this.objectMapper, (CachePopulator)new ForegroundCachePopulator(this.objectMapper, new CachePopulatorStats(), 0L), new CacheConfig(), new DruidHttpClientConfig(), QueryStackTests.getParallelMergeConfig(false), ForkJoinPool.commonPool(), QueryStackTests.DEFAULT_NOOP_SCHEDULER, (ServiceEmitter)this.emitter);
        this.servers = new ArrayList<DruidServer>();
    }

    @After
    public void tearDownTestBase() throws IOException {
        this.segmentGenerator.close();
    }

    protected void addServer(DruidServer server, DataSegment dataSegment, QueryableIndex queryableIndex) {
        this.addServer(server, dataSegment, queryableIndex, false);
    }

    protected void addServer(DruidServer server, DataSegment dataSegment, QueryableIndex queryableIndex, boolean throwQueryError) {
        this.servers.add(server);
        this.simpleServerView.addServer(server, dataSegment);
        this.httpClient.addServerAndRunner(server, new TestHttpClient.SimpleServerManager(this.conglomerate, dataSegment, queryableIndex, throwQueryError));
    }

    protected void prepareCluster(int numServers) {
        Preconditions.checkArgument((numServers < 25 ? 1 : 0) != 0, (Object)"Cannot be larger than 24");
        for (int i = 0; i < numServers; ++i) {
            int partitionId = i % 2;
            int intervalIndex = i / 2;
            Interval interval = Intervals.of((String)"2000-01-01T%02d/PT1H", (Object[])new Object[]{intervalIndex});
            DataSegment segment = QueryRunnerBasedOnClusteredClientTestBase.newSegment(interval, partitionId, 2);
            this.addServer(SimpleServerView.createServer(i + 1), segment, this.generateSegment(segment));
        }
    }

    protected QueryableIndex generateSegment(DataSegment segment) {
        return this.segmentGenerator.generate(segment, new GeneratorSchemaInfo(BASE_SCHEMA_INFO.getColumnSchemas(), BASE_SCHEMA_INFO.getAggs(), segment.getInterval(), BASE_SCHEMA_INFO.isWithRollup()), Granularities.NONE, 10);
    }

    protected static Query<Result<TimeseriesResultValue>> timeseriesQuery(Interval interval) {
        return Druids.newTimeseriesQueryBuilder().dataSource(DATASOURCE).intervals((List)ImmutableList.of((Object)interval)).granularity(Granularities.HOUR).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("rows")}).context((Map)ImmutableMap.of((Object)"queryFailTime", (Object)(System.currentTimeMillis() + 10000L))).build().withId(UUID.randomUUID().toString());
    }

    protected static List<Result<TimeseriesResultValue>> expectedTimeseriesResult(int expectedNumResultRows) {
        return IntStream.range(0, expectedNumResultRows).mapToObj(i -> new Result(DateTimes.of((String)StringUtils.format((String)"2000-01-01T%02d", (Object[])new Object[]{i / 2})), (Object)new TimeseriesResultValue((Map)ImmutableMap.of((Object)"rows", (Object)10)))).collect(Collectors.toList());
    }

    protected static ResponseContext responseContext() {
        ConcurrentResponseContext responseContext = ConcurrentResponseContext.createEmpty();
        responseContext.initializeRemainingResponses();
        return responseContext;
    }

    protected static DataSegment newSegment(Interval interval, int partitionId, int numCorePartitions) {
        return DataSegment.builder().dataSource(DATASOURCE).interval(interval).version("1").shardSpec((ShardSpec)new NumberedShardSpec(partitionId, numCorePartitions)).size(10L).build();
    }
}

