/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc.guice;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import org.apache.druid.client.broker.Broker;
import org.apache.druid.client.broker.BrokerClient;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceLocator;
import org.apache.druid.rpc.guice.ServiceClientModule;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

public class ServiceClientModuleTest {
    private Injector injector;
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private HttpClient httpClient;
    @Mock
    private DruidNodeDiscoveryProvider discoveryProvider;
    @Mock
    private ServiceLocator serviceLocator;
    @Mock
    private ServiceClientFactory serviceClientFactory;

    @Before
    public void setUp() {
        this.injector = Guice.createInjector((Iterable)ImmutableList.of((Object)new DruidGuiceExtensions(), (Object)new LifecycleModule(), (Object)new JacksonModule(), (Object)new ServiceClientModule(), binder -> {
            binder.bind(HttpClient.class).annotatedWith(EscalatedGlobal.class).toInstance((Object)this.httpClient);
            binder.bind(ServiceLocator.class).toInstance((Object)this.serviceLocator);
            binder.bind(DruidNodeDiscoveryProvider.class).toInstance((Object)this.discoveryProvider);
            binder.bind(ServiceClientFactory.class).toInstance((Object)this.serviceClientFactory);
        }));
    }

    @Test
    public void testGetServiceClientFactory() {
        Assert.assertNotNull((Object)this.injector.getInstance(ServiceClientFactory.class));
    }

    @Test
    public void testGetOverlordClient() {
        Assert.assertNotNull((Object)this.injector.getInstance(OverlordClient.class));
    }

    @Test
    public void testGetCoordinatorClient() {
        Assert.assertNotNull((Object)this.injector.getInstance(CoordinatorClient.class));
    }

    @Test
    public void testGetBrokerClient() {
        Assert.assertNotNull((Object)this.injector.getInstance(BrokerClient.class));
    }

    @Test
    public void testGetCoordinatorServiceClient() {
        Assert.assertNotNull((Object)this.injector.getInstance(Key.get(ServiceClient.class, Coordinator.class)));
    }

    @Test
    public void testGetOverlordServiceClient() {
        Assert.assertNotNull((Object)this.injector.getInstance(Key.get(ServiceClient.class, IndexingService.class)));
    }

    @Test
    public void testGetBrokerServiceClient() {
        Assert.assertNotNull((Object)this.injector.getInstance(Key.get(ServiceClient.class, Broker.class)));
    }
}

