/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.loading.LocalDataSegmentKiller;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LocalDataSegmentKillerTest {
    private static final String DATASOURCE_NAME = "ds";
    private final boolean zip;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public LocalDataSegmentKillerTest(boolean zip) {
        this.zip = zip;
    }

    @Parameterized.Parameters(name="zip = {0}")
    public static Iterable<Object[]> constructorFeeder() {
        return ImmutableList.of((Object)new Object[]{false}, (Object)new Object[]{true});
    }

    @Test
    public void testKill() throws Exception {
        LocalDataSegmentKiller killer = new LocalDataSegmentKiller(new LocalDataSegmentPusherConfig());
        File dataSourceDir = this.temporaryFolder.newFolder(DATASOURCE_NAME);
        File interval1Dir = new File(dataSourceDir, "interval1");
        File version11Dir = new File(interval1Dir, "v1");
        File partition011Dir = new File(version11Dir, "0");
        File partition111Dir = new File(version11Dir, "1");
        this.makePartitionDirWithIndex(partition011Dir);
        this.makePartitionDirWithIndex(partition111Dir);
        File version21Dir = new File(interval1Dir, "v2");
        File partition021Dir = new File(version21Dir, "0");
        this.makePartitionDirWithIndex(partition021Dir);
        File interval2Dir = new File(dataSourceDir, "interval2");
        File version12Dir = new File(interval2Dir, "v1");
        File partition012Dir = new File(version12Dir, "0");
        this.makePartitionDirWithIndex(partition012Dir);
        killer.kill(this.getSegmentWithPath(partition011Dir));
        Assert.assertFalse((boolean)partition011Dir.exists());
        Assert.assertTrue((boolean)partition111Dir.exists());
        Assert.assertTrue((boolean)partition021Dir.exists());
        Assert.assertTrue((boolean)partition012Dir.exists());
        killer.kill(this.getSegmentWithPath(partition111Dir));
        Assert.assertFalse((boolean)version11Dir.exists());
        Assert.assertTrue((boolean)partition021Dir.exists());
        Assert.assertTrue((boolean)partition012Dir.exists());
        killer.kill(this.getSegmentWithPath(partition021Dir));
        Assert.assertFalse((boolean)interval1Dir.exists());
        Assert.assertTrue((boolean)partition012Dir.exists());
        killer.kill(this.getSegmentWithPath(partition012Dir));
        Assert.assertFalse((boolean)dataSourceDir.exists());
        Assert.assertTrue((boolean)dataSourceDir.getParentFile().exists());
    }

    @Test
    public void testKillUniquePath() throws Exception {
        LocalDataSegmentKiller killer = new LocalDataSegmentKiller(new LocalDataSegmentPusherConfig());
        String uuid = UUID.randomUUID().toString().substring(0, 5);
        File emptyParentDir = this.temporaryFolder.newFolder();
        File dataSourceDir = new File(emptyParentDir, DATASOURCE_NAME);
        File intervalDir = new File(dataSourceDir, "interval");
        File versionDir = new File(intervalDir, "1");
        File partitionDir = new File(versionDir, "0");
        File uuidDir = new File(partitionDir, uuid);
        this.makePartitionDirWithIndex(uuidDir);
        killer.kill(this.getSegmentWithPath(uuidDir));
        Assert.assertFalse((boolean)uuidDir.exists());
        Assert.assertFalse((boolean)partitionDir.exists());
        Assert.assertFalse((boolean)versionDir.exists());
        Assert.assertFalse((boolean)intervalDir.exists());
        Assert.assertFalse((boolean)dataSourceDir.exists());
        Assert.assertTrue((boolean)emptyParentDir.exists());
        Assert.assertEquals((long)0L, (long)emptyParentDir.listFiles().length);
    }

    @Test
    public void testKillUniquePathWrongDataSourceNameInDirectory() throws Exception {
        LocalDataSegmentKiller killer = new LocalDataSegmentKiller(new LocalDataSegmentPusherConfig());
        String uuid = UUID.randomUUID().toString().substring(0, 5);
        File emptyParentDir = this.temporaryFolder.newFolder();
        File dataSourceDir = new File(emptyParentDir, "ds_wrong");
        File intervalDir = new File(dataSourceDir, "interval");
        File versionDir = new File(intervalDir, "1");
        File partitionDir = new File(versionDir, "0");
        File uuidDir = new File(partitionDir, uuid);
        this.makePartitionDirWithIndex(uuidDir);
        killer.kill(this.getSegmentWithPath(uuidDir));
        Assert.assertFalse((boolean)uuidDir.exists());
        Assert.assertFalse((boolean)partitionDir.exists());
        Assert.assertFalse((boolean)versionDir.exists());
        Assert.assertFalse((boolean)intervalDir.exists());
        Assert.assertFalse((boolean)dataSourceDir.exists());
        Assert.assertTrue((boolean)emptyParentDir.exists());
        Assert.assertEquals((long)0L, (long)emptyParentDir.listFiles().length);
    }

    private void makePartitionDirWithIndex(File path) throws IOException {
        FileUtils.mkdirp((File)path);
        if (this.zip) {
            Assert.assertTrue((boolean)new File(path, "index.zip").createNewFile());
        } else {
            Assert.assertTrue((boolean)new File(path, "index").mkdir());
        }
    }

    private DataSegment getSegmentWithPath(File baseDirectory) {
        String fileName = this.zip ? "index.zip" : "index";
        File path = new File(baseDirectory, fileName);
        return new DataSegment(DATASOURCE_NAME, Intervals.of((String)"2000/3000"), "ver", (Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)path.toURI().getPath()), (List)ImmutableList.of((Object)"product"), (List)ImmutableList.of((Object)"visited_sum", (Object)"unique_hosts"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 12334L);
    }
}

