/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.ReferenceCountedObjectProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.loading.AcquireSegmentAction;
import org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.druid.segment.loading.RoundRobinStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.SegmentLocalCacheManagerTest;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SegmentLocalCacheManagerConcurrencyTest {
    private final ObjectMapper jsonMapper = new DefaultObjectMapper();
    private final String dataSource = "test_ds";
    private final String segmentVersion;
    @TempDir
    File tempDir;
    private File localSegmentCacheFolder;
    private File otherLocalSegmentCacheFolder;
    private SegmentLocalCacheManager manager;
    private SegmentLocalCacheManager virtualStorageManager;
    private StorageLocation location;
    private StorageLocation location2;
    private ExecutorService executorService;
    private List<DataSegment> segmentsToLoad;
    private List<DataSegment> segmentsToWeakLoad;

    public SegmentLocalCacheManagerConcurrencyTest() {
        this.jsonMapper.registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local")});
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(LocalDataSegmentPuller.class, (Object)new LocalDataSegmentPuller()).addValue(IndexIO.class, (Object)TestHelper.getTestIndexIO()));
        this.segmentVersion = DateTimes.nowUtc().toString();
    }

    @BeforeEach
    public void setUp() throws Exception {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.localSegmentCacheFolder = new File(this.tempDir, "segment_cache_folder");
        this.otherLocalSegmentCacheFolder = new File(this.tempDir, "other_segment_cache_folder");
        this.segmentsToLoad = new ArrayList<DataSegment>();
        this.segmentsToWeakLoad = new ArrayList<DataSegment>();
        final ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheFolder, 4000L, null);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(this.otherLocalSegmentCacheFolder, 4000L, null);
        locations.add(locationConfig);
        locations.add(locationConfig2);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations(locations);
        SegmentLoaderConfig vsfLoaderConfig = new SegmentLoaderConfig(){

            public List<StorageLocationConfig> getLocations() {
                return locations;
            }

            public boolean isVirtualStorage() {
                return true;
            }

            public int getVirtualStorageLoadThreads() {
                return Runtime.getRuntime().availableProcessors();
            }
        };
        List storageLocations = loaderConfig.toStorageLocations();
        this.location = (StorageLocation)storageLocations.get(0);
        this.location2 = (StorageLocation)storageLocations.get(1);
        this.manager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestIndex.INDEX_IO, this.jsonMapper);
        this.virtualStorageManager = new SegmentLocalCacheManager(storageLocations, vsfLoaderConfig, (StorageLocationSelectorStrategy)new RoundRobinStorageLocationSelectorStrategy(storageLocations), TestIndex.INDEX_IO, this.jsonMapper);
        this.executorService = Execs.multiThreaded((int)10, (String)"segment-loader-local-cache-manager-concurrency-test-%d");
    }

    @AfterEach
    public void tearDown() {
        this.executorService.shutdownNow();
        for (DataSegment segment : this.segmentsToLoad) {
            this.manager.drop(segment);
        }
        for (DataSegment segment : this.segmentsToWeakLoad) {
            this.virtualStorageManager.drop(segment);
        }
        for (StorageLocation location : this.virtualStorageManager.getLocations()) {
            location.resetStats();
        }
    }

    @Test
    public void testAcquireSegment() throws IOException, ExecutionException, InterruptedException {
        File localStorageFolder = new File(this.tempDir, "local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(8, localStorageFolder, interval, this.segmentsToLoad);
        List loadFutures = this.segmentsToLoad.stream().map(segment -> this.executorService.submit(new Load(this.manager, (DataSegment)segment))).collect(Collectors.toList());
        for (Future future : loadFutures) {
            future.get();
        }
        List acquireFutures = this.segmentsToLoad.stream().map(segment -> this.executorService.submit(new LoadCached(this.manager, (DataSegment)segment, 50, 50))).collect(Collectors.toList());
        int rows = 0;
        int success = 0;
        for (Future future : acquireFutures) {
            try {
                Integer s = (Integer)future.get();
                ++success;
                if (s == null) continue;
                rows += s.intValue();
            }
            catch (Throwable t) {
                Assertions.fail();
            }
        }
        Assertions.assertEquals((int)8, (int)success);
        Assertions.assertEquals((int)9672, (int)rows);
    }

    @Test
    public void testAcquireSegmentFailTooManySegments() throws IOException {
        File localStorageFolder = new File("local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(20, localStorageFolder, interval, this.segmentsToLoad);
        List futures = this.segmentsToLoad.stream().map(segment -> this.executorService.submit(new Load(this.manager, (DataSegment)segment))).collect(Collectors.toList());
        Throwable t = Assertions.assertThrows(ExecutionException.class, () -> {
            for (Future future : futures) {
                future.get();
            }
        });
        Assertions.assertInstanceOf(SegmentLoadingException.class, (Object)t.getCause());
        Assertions.assertTrue((boolean)t.getCause().getMessage().contains("Failed to load segment"));
        Assertions.assertTrue((boolean)t.getCause().getMessage().contains("in all locations."));
    }

    @Test
    public void testAcquireSegmentBulkFailTooManySegments() throws IOException {
        File localStorageFolder = new File("local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(30, localStorageFolder, interval, this.segmentsToLoad);
        List weakLoads = this.segmentsToLoad.stream().map(segment -> new WeakLoad(this.virtualStorageManager, (DataSegment)segment, 10, 100, 1000L, false)).collect(Collectors.toList());
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (WeakLoad weakLoad : weakLoads) {
            futures.add(this.executorService.submit(weakLoad));
        }
        Throwable t = Assertions.assertThrows(ExecutionException.class, () -> {
            for (Future future : futures) {
                future.get();
            }
        });
        Assertions.assertInstanceOf(DruidException.class, (Object)t.getCause());
        Assertions.assertTrue((boolean)t.getCause().getMessage().contains("Unable to load segment"));
        Assertions.assertTrue((boolean)t.getCause().getMessage().contains("on demand, ensure enough disk space has been allocated"));
    }

    @Test
    public void testAcquireSegmentOnDemand() throws IOException {
        int segmentCount = 100;
        int iterations = 2000;
        int concurrentReads = 10;
        File localStorageFolder = new File(this.tempDir, "local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(100, localStorageFolder, interval, this.segmentsToWeakLoad);
        for (boolean sleepy : new boolean[]{true, false}) {
            this.testWeakLoad(2000, 100, 10, false, sleepy, false);
        }
    }

    @Test
    public void testAcquireSegmentOnDemandRandomSegment() throws IOException {
        int segmentCount = 24;
        int iterations = 2000;
        int concurrentReads = 10;
        File localStorageFolder = new File(this.tempDir, "local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(24, localStorageFolder, interval, this.segmentsToWeakLoad);
        for (boolean sleepy : new boolean[]{true, false}) {
            this.testWeakLoad(2000, 24, 10, true, sleepy, true);
        }
    }

    @Test
    public void testAcquireSegmentOnDemandRandomSegmentHighHitRate() throws IOException {
        int segmentCount = 10;
        int iterations = 2000;
        int concurrentReads = 10;
        File localStorageFolder = new File(this.tempDir, "local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(10, localStorageFolder, interval, this.segmentsToWeakLoad);
        for (boolean sleepy : new boolean[]{true, false}) {
            this.testWeakLoad(2000, 10, 10, true, sleepy, true);
        }
    }

    @Test
    public void testAcquireSegmentOnDemandRandomSegmentNoEvictions() throws IOException {
        int segmentCount = 8;
        int iterations = 2000;
        int concurrentReads = 10;
        File localStorageFolder = new File(this.tempDir, "local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(8, localStorageFolder, interval, this.segmentsToWeakLoad);
        for (boolean sleepy : new boolean[]{true, false}) {
            this.testWeakLoad(2000, 8, 10, true, sleepy, true);
        }
    }

    @Test
    public void testAcquireSegmentOnDemandRandomSegmentWithTimeoutBeforeAcquire() throws IOException, InterruptedException {
        int segmentCount = 24;
        int iterations = 2000;
        int concurrentReads = 10;
        File localStorageFolder = new File(this.tempDir, "local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(24, localStorageFolder, interval, this.segmentsToWeakLoad);
        ArrayList<DataSegment> currentBatch = new ArrayList<DataSegment>();
        for (int i = 0; i < 2000; ++i) {
            currentBatch.add(this.segmentsToWeakLoad.get(ThreadLocalRandom.current().nextInt(24)));
            if (currentBatch.size() != 10) continue;
            List weakLoads = currentBatch.stream().map(segment -> new WeakLoad(this.virtualStorageManager, (DataSegment)segment, 0, 0, 1L, true)).collect(Collectors.toList());
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
            for (WeakLoad weakLoad : weakLoads) {
                futures.add(this.executorService.submit(weakLoad));
            }
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Throwable t) {
                    exceptions.add(t);
                }
            }
            Assertions.assertFalse((boolean)exceptions.isEmpty());
            for (Throwable throwable : exceptions) {
                Assertions.assertTrue((throwable instanceof TimeoutException || throwable instanceof ExecutionException ? 1 : 0) != 0, (String)throwable.toString());
            }
            Thread.sleep(20L);
            Assertions.assertEquals((long)0L, (long)this.location.getActiveWeakHolds());
            Assertions.assertEquals((long)0L, (long)this.location2.getActiveWeakHolds());
            currentBatch.clear();
        }
        Assertions.assertEquals((long)0L, (long)this.location.getActiveWeakHolds());
        Assertions.assertEquals((long)0L, (long)this.location2.getActiveWeakHolds());
        Assertions.assertTrue((4 >= this.location.getWeakEntryCount() ? 1 : 0) != 0);
        Assertions.assertTrue((4 >= this.location2.getWeakEntryCount() ? 1 : 0) != 0);
        Assertions.assertTrue((4 >= this.location.getPath().listFiles().length ? 1 : 0) != 0);
        Assertions.assertTrue((4 >= this.location2.getPath().listFiles().length ? 1 : 0) != 0);
        Assertions.assertEquals((long)this.location.getStats().getEvictionCount(), (long)this.location.getStats().getUnmountCount());
        Assertions.assertEquals((long)this.location2.getStats().getEvictionCount(), (long)this.location2.getStats().getUnmountCount());
    }

    @Test
    public void testAcquireSegmentOnDemandRandomSegmentWithTimeoutAfterAcquire() throws IOException, InterruptedException {
        int segmentCount = 24;
        int iterations = 2000;
        int concurrentReads = 10;
        File localStorageFolder = new File(this.tempDir, "local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(24, localStorageFolder, interval, this.segmentsToWeakLoad);
        ArrayList<DataSegment> currentBatch = new ArrayList<DataSegment>();
        for (int i = 0; i < 2000; ++i) {
            Iterator weakLoad22;
            currentBatch.add(this.segmentsToWeakLoad.get(ThreadLocalRandom.current().nextInt(24)));
            if (currentBatch.size() != 10) continue;
            List weakLoads = currentBatch.stream().map(segment -> new WeakLoad(this.virtualStorageManager, (DataSegment)segment, 10, 100, Long.MAX_VALUE, false)).collect(Collectors.toList());
            ArrayList futures = new ArrayList();
            for (Iterator weakLoad22 : weakLoads) {
                futures.add(this.executorService.submit(weakLoad22));
            }
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (Future future : futures) {
                try {
                    future.get(20L, TimeUnit.MILLISECONDS);
                }
                catch (Throwable throwable) {
                    exceptions.add(throwable);
                }
            }
            Assertions.assertFalse((boolean)exceptions.isEmpty());
            weakLoad22 = exceptions.iterator();
            while (weakLoad22.hasNext()) {
                Throwable throwable = (Throwable)weakLoad22.next();
                Assertions.assertTrue((throwable instanceof TimeoutException || throwable instanceof ExecutionException ? 1 : 0) != 0, (String)throwable.toString());
            }
            while (true) {
                boolean allDone = true;
                for (Future future : futures) {
                    allDone = allDone && future.isDone();
                }
                if (allDone) break;
                Thread.sleep(5L);
            }
            Assertions.assertEquals((long)0L, (long)this.location.getActiveWeakHolds());
            Assertions.assertEquals((long)0L, (long)this.location2.getActiveWeakHolds());
            currentBatch.clear();
        }
        Assertions.assertTrue((this.location.getStats().getHitCount() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.location2.getStats().getHitCount() >= 0L ? 1 : 0) != 0);
        this.assertNoLooseEnds();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMixedWeakLoadAndAcquireCachedSegmentOfWeakLoads() throws IOException, InterruptedException {
        int segmentCount = 10;
        int iterations = 2000;
        int concurrentReads = 10;
        File localStorageFolder = new File(this.tempDir, "local_storage_folder");
        Interval interval = Intervals.of((String)"2019-01-01/P1D");
        this.makeSegmentsToLoad(10, localStorageFolder, interval, this.segmentsToWeakLoad);
        ArrayList<DataSegment> currentBatch = new ArrayList<DataSegment>();
        int minLoadCount = 5;
        int totalSuccess = 0;
        int totalEmpty = 0;
        int totalRows = 0;
        for (int i = 0; i < 2000; ++i) {
            void var15_15;
            currentBatch.add(this.segmentsToWeakLoad.get(ThreadLocalRandom.current().nextInt(10)));
            if (currentBatch.size() != 10) continue;
            int weakLoadCount = 0;
            ArrayList<Callable<Integer>> callables = new ArrayList<Callable<Integer>>();
            for (DataSegment dataSegment : currentBatch) {
                if (weakLoadCount < 5 && ThreadLocalRandom.current().nextBoolean()) {
                    callables.add(new WeakLoad(this.virtualStorageManager, dataSegment, 0, 50, Long.MAX_VALUE, false));
                    ++weakLoadCount;
                    continue;
                }
                callables.add(new LoadCached(this.virtualStorageManager, dataSegment, 50, 50));
            }
            ArrayList futures = new ArrayList();
            for (Callable load : callables) {
                futures.add(this.executorService.submit(load));
            }
            boolean bl = false;
            int rows = 0;
            int empty = 0;
            for (Future future : futures) {
                try {
                    Integer s = (Integer)future.get();
                    ++var15_15;
                    if (s != null) {
                        rows += s.intValue();
                        continue;
                    }
                    ++empty;
                }
                catch (Throwable t) {
                    Assertions.fail();
                }
            }
            Assertions.assertEquals((long)0L, (long)this.location.getActiveWeakHolds());
            Assertions.assertEquals((long)0L, (long)this.location2.getActiveWeakHolds());
            totalSuccess += var15_15;
            totalEmpty += empty;
            totalRows += rows;
            currentBatch.clear();
        }
        Assertions.assertEquals((int)2000, (int)totalSuccess);
        Assertions.assertEquals((int)totalRows, (int)(totalSuccess * 1209 - totalEmpty * 1209));
        Assertions.assertTrue((totalSuccess > 1000 ? 1 : 0) != 0);
        Assertions.assertTrue((totalEmpty > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.location.getStats().getHitCount() >= 0L ? 1 : 0) != 0);
        Assertions.assertTrue((this.location2.getStats().getHitCount() >= 0L ? 1 : 0) != 0);
        this.assertNoLooseEnds();
    }

    private void testWeakLoad(int iterations, int segmentCount, int concurrentReads, boolean random, boolean sleepy, boolean expectHits) {
        int totalSuccess = 0;
        int totalFailures = 0;
        ArrayList<DataSegment> currentBatch = new ArrayList<DataSegment>();
        for (DataSegment segment : this.segmentsToWeakLoad) {
            this.virtualStorageManager.drop(segment);
        }
        this.location.resetStats();
        this.location2.resetStats();
        for (int i = 0; i < iterations; ++i) {
            int segment = random ? ThreadLocalRandom.current().nextInt(segmentCount) : i % segmentCount;
            currentBatch.add(this.segmentsToWeakLoad.get(segment));
            if (currentBatch.size() != concurrentReads) continue;
            BatchResult result = this.testWeakBatch(i, currentBatch, sleepy);
            totalFailures += result.exceptions.size();
            Assertions.assertEquals((long)(totalSuccess += result.success), (long)(this.location.getStats().getLoadCount() + this.location.getStats().getHitCount() + this.location2.getStats().getLoadCount() + this.location2.getStats().getHitCount()), (String)StringUtils.format((String)"iteration[%s] - loc1: loads[%s] hits[%s] loc2: loads[%s] hits[%s]", (Object[])new Object[]{i, this.location.getStats().getLoadCount(), this.location.getStats().getHitCount(), this.location2.getStats().getLoadCount(), this.location2.getStats().getHitCount()}));
            currentBatch.clear();
        }
        if (!currentBatch.isEmpty()) {
            BatchResult result = this.testWeakBatch(iterations, currentBatch, sleepy);
            totalSuccess += result.success;
            totalFailures += result.exceptions.size();
        }
        Assertions.assertEquals((int)iterations, (int)(totalSuccess + totalFailures));
        Assertions.assertEquals((long)totalSuccess, (long)(this.location.getStats().getLoadCount() + this.location.getStats().getHitCount() + this.location2.getStats().getLoadCount() + this.location2.getStats().getHitCount()));
        Assertions.assertTrue(((long)totalFailures <= this.location.getStats().getRejectCount() + this.location2.getStats().getRejectCount() ? 1 : 0) != 0);
        if (expectHits) {
            Assertions.assertTrue((this.location.getStats().getHitCount() >= 0L ? 1 : 0) != 0);
            Assertions.assertTrue((this.location2.getStats().getHitCount() >= 0L ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((long)0L, (long)this.location.getStats().getHitCount());
            Assertions.assertEquals((long)0L, (long)this.location2.getStats().getHitCount());
        }
        this.assertNoLooseEnds();
    }

    private BatchResult testWeakBatch(int iteration, List<DataSegment> currentBatch, boolean sleepy) {
        ArrayList<WeakLoad> weakLoads = new ArrayList<WeakLoad>();
        HashSet<SegmentId> segments = new HashSet<SegmentId>();
        for (DataSegment dataSegment : currentBatch) {
            weakLoads.add(new WeakLoad(this.virtualStorageManager, dataSegment, 0, sleepy ? 20 : 0, Long.MAX_VALUE, false));
            segments.add(dataSegment.getId());
        }
        ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
        for (WeakLoad weakLoad : weakLoads) {
            futures.add(this.executorService.submit(weakLoad));
        }
        ArrayList<Throwable> arrayList = new ArrayList<Throwable>();
        int success = 0;
        int rows = 0;
        for (Future future : futures) {
            try {
                Integer s = (Integer)future.get();
                if (s == null) continue;
                ++success;
                rows += s.intValue();
            }
            catch (Throwable t) {
                arrayList.add(t);
            }
        }
        int expectedSuccess = Math.min(8, segments.size());
        int n = segments.size() > 8 ? 2 : 0;
        Assertions.assertEquals((int)(success * 1209), (int)rows);
        Assertions.assertTrue((expectedSuccess <= success ? 1 : 0) != 0, (String)("iteration " + iteration + " expected " + expectedSuccess + " tasks to succeed but got " + success));
        Assertions.assertTrue((n >= arrayList.size() ? 1 : 0) != 0, (String)("iteration " + iteration + " expected " + n + " tasks to fail but got " + arrayList.size()));
        for (Throwable t : arrayList) {
            Assertions.assertInstanceOf(DruidException.class, (Object)t.getCause());
            Assertions.assertTrue((boolean)t.getCause().getMessage().contains("Unable to load segment["));
            Assertions.assertTrue((boolean)t.getCause().getMessage().contains("on demand, ensure enough disk space has been allocated to load all segments involved in the query"));
        }
        return new BatchResult(arrayList, success, rows);
    }

    private void assertNoLooseEnds() {
        Assertions.assertEquals((long)0L, (long)this.location.getActiveWeakHolds());
        Assertions.assertEquals((long)0L, (long)this.location2.getActiveWeakHolds());
        Assertions.assertTrue((4 >= this.location.getWeakEntryCount() ? 1 : 0) != 0);
        Assertions.assertTrue((4 >= this.location2.getWeakEntryCount() ? 1 : 0) != 0);
        Assertions.assertTrue((4 >= this.location.getPath().listFiles().length ? 1 : 0) != 0);
        Assertions.assertTrue((4 >= this.location2.getPath().listFiles().length ? 1 : 0) != 0);
        Assertions.assertTrue((this.location.getStats().getLoadCount() >= 4L ? 1 : 0) != 0);
        Assertions.assertTrue((this.location2.getStats().getLoadCount() >= 4L ? 1 : 0) != 0);
        Assertions.assertEquals((long)this.location.getStats().getEvictionCount(), (long)this.location.getStats().getUnmountCount());
        Assertions.assertEquals((long)this.location2.getStats().getEvictionCount(), (long)this.location2.getStats().getUnmountCount());
        Assertions.assertEquals((long)(this.location.getStats().getLoadCount() - 4L), (long)this.location.getStats().getEvictionCount());
        Assertions.assertEquals((long)(this.location2.getStats().getLoadCount() - 4L), (long)this.location2.getStats().getEvictionCount());
        Assertions.assertEquals((long)(this.location.getStats().getLoadCount() - 4L), (long)this.location.getStats().getUnmountCount());
        Assertions.assertEquals((long)(this.location2.getStats().getLoadCount() - 4L), (long)this.location2.getStats().getUnmountCount());
    }

    private void makeSegmentsToLoad(int segmentCount, File localStorageFolder, Interval interval, List<DataSegment> segmentsToLoad) throws IOException {
        segmentsToLoad.clear();
        for (int partitionId = 0; partitionId < segmentCount; ++partitionId) {
            String segmentPath = Paths.get(localStorageFolder.getCanonicalPath(), "test_ds", StringUtils.format((String)"%s_%s", (Object[])new Object[]{interval.getStart().toString(), interval.getEnd().toString()}), this.segmentVersion, String.valueOf(partitionId)).toString();
            File localSegmentFile = new File(localStorageFolder, segmentPath + "_build");
            File indexZip = new File(new File(localStorageFolder, segmentPath), "index.zip");
            SegmentLocalCacheManagerTest.makeSegmentZip(localSegmentFile, indexZip);
            DataSegment segment = this.newSegment(interval, partitionId, 1000L).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)indexZip.getAbsolutePath()));
            segmentsToLoad.add(segment);
        }
    }

    private DataSegment newSegment(Interval interval, int partitionId, long size) {
        return DataSegment.builder().dataSource("test_ds").interval(interval).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version(this.segmentVersion).dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)new NumberedShardSpec(partitionId, 0)).binaryVersion(Integer.valueOf(9)).size(size).build();
    }

    private static class WeakLoad
    implements Callable<Integer> {
        private final int delayMin;
        private final int delayMax;
        private final long timeout;
        private final SegmentLocalCacheManager segmentManager;
        private final DataSegment segment;
        private final boolean expectTimeout;

        private WeakLoad(SegmentLocalCacheManager segmentManager, DataSegment segment, int delayMin, int delayMax, long timeout, boolean expectTimeout) {
            this.segmentManager = segmentManager;
            this.segment = segment;
            this.delayMin = delayMin;
            this.delayMax = delayMax;
            this.timeout = timeout;
            this.expectTimeout = expectTimeout;
        }

        @Override
        public Integer call() throws SegmentLoadingException {
            Closer closer = Closer.create();
            AcquireSegmentAction action = (AcquireSegmentAction)closer.register((Closeable)this.segmentManager.acquireSegment(this.segment));
            try {
                ReferenceCountedObjectProvider referenceProvider = (ReferenceCountedObjectProvider)action.getSegmentFuture().get(this.timeout, TimeUnit.MILLISECONDS);
                if (referenceProvider == null) {
                    Assertions.fail((String)"this shouldn't happen");
                }
                Optional<Segment> segment = referenceProvider.acquireReference().map(arg_0 -> ((Closer)closer).register(arg_0));
                if (segment.isPresent()) {
                    PhysicalSegmentInspector gadget = (PhysicalSegmentInspector)segment.get().as(PhysicalSegmentInspector.class);
                    if (this.delayMin >= 0 && this.delayMax > 0) {
                        Thread.sleep(ThreadLocalRandom.current().nextInt(this.delayMin, this.delayMax));
                    }
                    Integer n = gadget.getNumRows();
                    return n;
                }
                Integer n = null;
                return n;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                CloseableUtils.closeAndWrapExceptions((Closeable)closer);
            }
        }
    }

    private static class LoadCached
    implements Callable<Integer> {
        private final int maxDelayBefore;
        private final int maxDelayAfter;
        private final SegmentLocalCacheManager segmentManager;
        private final DataSegment segment;

        private LoadCached(SegmentLocalCacheManager segmentManager, DataSegment segment, int maxDelayBefore, int maxDelayAfter) {
            this.segmentManager = segmentManager;
            this.segment = segment;
            this.maxDelayBefore = maxDelayBefore;
            this.maxDelayAfter = maxDelayAfter;
        }

        @Override
        public Integer call() {
            Closer closer = Closer.create();
            try {
                if (this.maxDelayBefore > 0) {
                    Thread.sleep(ThreadLocalRandom.current().nextInt(this.maxDelayBefore));
                }
                Optional<Segment> segmentReference = this.segmentManager.acquireCachedSegment(this.segment).map(arg_0 -> ((Closer)closer).register(arg_0));
                if (segmentReference.isPresent()) {
                    PhysicalSegmentInspector gadget = (PhysicalSegmentInspector)segmentReference.get().as(PhysicalSegmentInspector.class);
                    if (this.maxDelayAfter > 0) {
                        Thread.sleep(ThreadLocalRandom.current().nextInt(this.maxDelayAfter));
                    }
                    Integer n = gadget.getNumRows();
                    return n;
                }
                Integer n = null;
                return n;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                CloseableUtils.closeAndWrapExceptions((Closeable)closer);
            }
        }
    }

    private static class BatchResult {
        public final List<Throwable> exceptions;
        public final int success;
        public final int rows;

        public BatchResult(List<Throwable> exceptions, int success, int rows) {
            this.exceptions = exceptions;
            this.success = success;
            this.rows = rows;
        }
    }

    private static class Load
    implements Callable<Void> {
        private final SegmentLocalCacheManager segmentManager;
        private final DataSegment segment;

        private Load(SegmentLocalCacheManager segmentManager, DataSegment segment) {
            this.segmentManager = segmentManager;
            this.segment = segment;
        }

        @Override
        public Void call() throws SegmentLoadingException {
            this.segmentManager.load(this.segment);
            return null;
        }
    }
}

