/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.guice.LocalDataStorageDruidModule;
import org.apache.druid.jackson.SegmentizerModule;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.ReferenceCountedObjectProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.TestSegmentUtils;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.loading.AcquireSegmentAction;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.druid.segment.loading.RandomStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.RoundRobinStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.TombstoneLoadSpec;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.apache.druid.timeline.partition.TombstoneShardSpec;
import org.apache.druid.utils.CompressionUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class SegmentLocalCacheManagerTest
extends InitializedNullHandlingTest {
    private static final String TEST_DATA_BASE_RELATIVE_PATH = "test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/";
    private static final String TEST_DATA_RELATIVE_PATH = "test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/0";
    private static final String TEST_DATA_RELATIVE_PATH_2 = "test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/1";
    private static final String TEST_DATA_RELATIVE_PATH_3 = "test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/2";
    private static final String TEST_DATA_RELATIVE_PATH_4 = "test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/3";
    @Rule
    public final TemporaryFolder tmpFolder = new TemporaryFolder();
    private ObjectMapper jsonMapper;
    private File segmentDeepStorageDir;
    private File localSegmentCacheDir;
    private SegmentLocalCacheManager manager;

    @Before
    public void setUp() throws Exception {
        this.jsonMapper = TestHelper.makeJsonMapper();
        this.jsonMapper.registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local"), new NamedType(TombstoneLoadSpec.class, "tombstone")});
        this.jsonMapper.registerSubtypes(new Class[]{TestSegmentUtils.TestLoadSpec.class});
        this.jsonMapper.registerSubtypes(new Class[]{TestSegmentUtils.TestSegmentizerFactory.class});
        this.jsonMapper.registerModule((Module)new SegmentizerModule());
        this.jsonMapper.registerModules((Iterable)new LocalDataStorageDruidModule().getJacksonModules());
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(LocalDataSegmentPuller.class, (Object)new LocalDataSegmentPuller()).addValue(IndexIO.class, (Object)TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT)).addValue(ObjectMapper.class, (Object)this.jsonMapper).addValue(DataSegment.PruneSpecsHolder.class, (Object)DataSegment.PruneSpecsHolder.DEFAULT).addValue(ExprMacroTable.class, (Object)TestExprMacroTable.INSTANCE));
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.segmentDeepStorageDir = this.tmpFolder.newFolder("segment_deep_storage");
        this.localSegmentCacheDir = this.tmpFolder.newFolder("segment_cache");
        this.manager = this.makeDefaultManager(this.jsonMapper);
        Assert.assertTrue((boolean)this.manager.canHandleSegments());
    }

    @Test
    public void testCanHandleSegmentsWithConfigLocations() {
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig(){

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(SegmentLocalCacheManagerTest.this.localSegmentCacheDir, null, null));
            }
        };
        this.manager = new SegmentLocalCacheManager((List)ImmutableList.of(), loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy((List)ImmutableList.of()), TestIndex.INDEX_IO, this.jsonMapper);
        Assert.assertTrue((boolean)this.manager.canHandleSegments());
    }

    @Test
    public void testCanHandleSegmentsWithLocations() {
        ImmutableList locations = ImmutableList.of((Object)new StorageLocation(this.localSegmentCacheDir, 10000000000L, null));
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager((List)locations, new SegmentLoaderConfig(), (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy((List)locations), TestIndex.INDEX_IO, this.jsonMapper);
        Assert.assertTrue((boolean)manager.canHandleSegments());
    }

    @Test
    public void testCanHandleSegmentsWithEmptyLocationsAndConfigLocations() {
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager((List)ImmutableList.of(), new SegmentLoaderConfig(), (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy((List)ImmutableList.of()), TestIndex.INDEX_IO, this.jsonMapper);
        Assert.assertFalse((boolean)manager.canHandleSegments());
    }

    @Test
    public void testGetCachedSegmentsWhenCanHandleSegmentsIsFalse() {
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(null, new SegmentLoaderConfig(), (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(null), TestIndex.INDEX_IO, this.jsonMapper);
        MatcherAssert.assertThat((Object)((DruidException)Assert.assertThrows(DruidException.class, () -> manager.getCachedSegments())), (Matcher)DruidExceptionMatcher.defensive().expectMessageIs("canHandleSegments() is false. getCachedSegments() must be invoked only when canHandleSegments() returns true."));
    }

    @Test
    public void testGetCachedSegments() throws IOException {
        SegmentLocalCacheManager manager = this.makeDefaultManager(this.jsonMapper);
        File baseInfoDir = new File(((StorageLocation)manager.getLocations().get(0)).getPath(), "/info_dir/");
        FileUtils.mkdirp((File)baseInfoDir);
        DataSegment segment1 = TestSegmentUtils.makeSegment((String)"test_segment_loader", (String)"v0", (Interval)Intervals.of((String)"2014-10-20T00:00:00Z/P1D"));
        this.writeSegmentFile(segment1);
        manager.storeInfoFile(segment1);
        DataSegment segment2 = TestSegmentUtils.makeSegment((String)"test_segment_loader", (String)"v1", (Interval)Intervals.of((String)"2015-10-20T00:00:00Z/P1D"));
        this.writeSegmentFile(segment2);
        manager.storeInfoFile(segment2);
        Assert.assertTrue((boolean)manager.canHandleSegments());
        MatcherAssert.assertThat((Object)manager.getCachedSegments(), (Matcher)Matchers.containsInAnyOrder((Object[])new DataSegment[]{segment1, segment2}));
    }

    @Test
    public void testGetCachedSegmentsWithMissingSegmentFile() throws IOException {
        SegmentLocalCacheManager manager = this.makeDefaultManager(this.jsonMapper);
        File baseInfoDir = new File(((StorageLocation)manager.getLocations().get(0)).getPath(), "/info_dir/");
        FileUtils.mkdirp((File)baseInfoDir);
        DataSegment segment1 = TestSegmentUtils.makeSegment((String)"test_segment_loader", (String)"v0", (Interval)Intervals.of((String)"2014-10-20T00:00:00Z/P1D"));
        this.writeSegmentFile(segment1);
        manager.storeInfoFile(segment1);
        DataSegment segment2 = TestSegmentUtils.makeSegment((String)"test_segment_loader", (String)"v1", (Interval)Intervals.of((String)"2015-10-20T00:00:00Z/P1D"));
        this.writeSegmentFile(segment2);
        manager.storeInfoFile(segment2);
        DataSegment segment3 = TestSegmentUtils.makeSegment((String)"test_segment_loader", (String)"v1", (Interval)Intervals.of((String)"2016-10-20T00:00:00Z/P1D"));
        manager.storeInfoFile(segment3);
        File segment3InfoFile = new File(baseInfoDir, segment3.getId().toString());
        Assert.assertTrue((boolean)segment3InfoFile.exists());
        Assert.assertTrue((boolean)manager.canHandleSegments());
        MatcherAssert.assertThat((Object)manager.getCachedSegments(), (Matcher)Matchers.containsInAnyOrder((Object[])new DataSegment[]{segment1, segment2}));
        Assert.assertFalse((boolean)segment3InfoFile.exists());
    }

    @Test
    public void testGetCachedSegmentsLegacyPathsMigrated() throws Exception {
        DataSegment segmentToBootstrap = this.makeTestDataSegment(this.segmentDeepStorageDir);
        FileUtils.mkdirp((File)new File(this.localSegmentCacheDir, "info_dir"));
        this.manager.storeInfoFile(segmentToBootstrap);
        File segmentZip = this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        File unzippedSegmentPathInLocation = new File(this.localSegmentCacheDir, DataSegmentPusher.getDefaultStorageDir((DataSegment)segmentToBootstrap, (boolean)false));
        FileUtils.mkdirp((File)unzippedSegmentPathInLocation);
        CompressionUtils.unzip((File)segmentZip, (File)unzippedSegmentPathInLocation);
        for (DataSegment segment : this.manager.getCachedSegments()) {
            this.manager.bootstrap(segment, SegmentLazyLoadFailCallback.NOOP);
        }
        Assert.assertNotNull((Object)this.manager.getSegmentFiles(segmentToBootstrap));
        Assert.assertFalse((boolean)unzippedSegmentPathInLocation.exists());
        Assert.assertFalse((boolean)new File(this.localSegmentCacheDir, segmentToBootstrap.getDataSource()).exists());
        Assert.assertTrue((boolean)new File(this.localSegmentCacheDir, segmentToBootstrap.getId().toString()).exists());
    }

    @Test
    public void testGetCachedSegmentsLegacyPathsMigratedResilience() throws Exception {
        DataSegment segmentToBootstrap = this.makeTestDataSegment(this.segmentDeepStorageDir);
        FileUtils.mkdirp((File)new File(this.localSegmentCacheDir, "info_dir"));
        this.manager.storeInfoFile(segmentToBootstrap);
        File segmentZip = this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        File unzippedSegmentPathInLocation = new File(this.localSegmentCacheDir, DataSegmentPusher.getDefaultStorageDir((DataSegment)segmentToBootstrap, (boolean)false));
        FileUtils.mkdirp((File)unzippedSegmentPathInLocation);
        CompressionUtils.unzip((File)segmentZip, (File)unzippedSegmentPathInLocation);
        File unzippedSegmentInDestination = new File(this.localSegmentCacheDir, segmentToBootstrap.getId().toString());
        FileUtils.mkdirp((File)unzippedSegmentInDestination);
        CompressionUtils.unzip((File)segmentZip, (File)unzippedSegmentInDestination);
        for (DataSegment segment : this.manager.getCachedSegments()) {
            this.manager.bootstrap(segment, SegmentLazyLoadFailCallback.NOOP);
        }
        Assert.assertNotNull((Object)this.manager.getSegmentFiles(segmentToBootstrap));
        Assert.assertFalse((boolean)unzippedSegmentPathInLocation.exists());
        Assert.assertFalse((boolean)new File(this.localSegmentCacheDir, segmentToBootstrap.getDataSource()).exists());
        Assert.assertTrue((boolean)new File(this.localSegmentCacheDir, segmentToBootstrap.getId().toString()).exists());
    }

    @Test
    public void testIfSegmentIsLoaded() throws IOException {
        DataSegment cachedSegment = this.dataSegmentWithInterval("2014-10-20T00:00:00Z/P1D");
        File cachedSegmentFile = new File(this.localSegmentCacheDir, cachedSegment.getId().toString());
        FileUtils.mkdirp((File)cachedSegmentFile);
        Assert.assertTrue((String)"Expect cache hit", (boolean)this.manager.isSegmentCached(cachedSegment));
        DataSegment uncachedSegment = this.dataSegmentWithInterval("2014-10-21T00:00:00Z/P1D");
        Assert.assertFalse((String)"Expect cache miss", (boolean)this.manager.isSegmentCached(uncachedSegment));
    }

    @Test
    public void testLoadSegmentInPageCache() throws IOException, SegmentLoadingException {
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig(){

            public int getNumThreadsToLoadSegmentsIntoPageCacheOnDownload() {
                return 1;
            }

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(SegmentLocalCacheManagerTest.this.localSegmentCacheDir, null, null));
            }
        };
        List locations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(locations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(locations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToDownload = this.makeTestDataSegment(this.localSegmentCacheDir);
        File localSegmentFile = new File(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        SegmentLocalCacheManagerTest.makeSegmentZip(localSegmentFile, new File(this.segmentDeepStorageDir.getCanonicalPath() + "/test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/0/index.zip"));
        manager.getSegmentFiles(segmentToDownload);
    }

    @Test
    public void testGetAndCleanSegmentFiles() throws Exception {
        DataSegment segmentToDownload = this.makeTestDataSegment(this.segmentDeepStorageDir);
        File localSegmentFile = new File(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        SegmentLocalCacheManagerTest.makeSegmentZip(localSegmentFile, new File(this.segmentDeepStorageDir.getCanonicalPath() + "/test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/0/index.zip"));
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)this.manager.isSegmentCached(segmentToDownload));
        this.manager.load(segmentToDownload);
        this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentCached(segmentToDownload));
        this.manager.drop(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)this.manager.isSegmentCached(segmentToDownload));
    }

    @Test
    public void testRetrySuccessAtFirstLocation() throws Exception {
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, 10000000000L, null);
        locations.add(locationConfig);
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(localStorageFolder2, 1000000000L, null);
        locations.add(locationConfig2);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations(locations);
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToDownload = this.makeTestDataSegment(this.segmentDeepStorageDir);
        File localSegmentFile = new File(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        SegmentLocalCacheManagerTest.makeSegmentZip(localSegmentFile, new File(localSegmentFile, "index.zip"));
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        manager.load(segmentToDownload);
        File segmentFile = manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        manager.drop(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload));
    }

    @Test
    public void testRetrySuccessAtSecondLocation() throws Exception {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(false);
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, 1000000000L, null);
        locations.add(locationConfig);
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(localStorageFolder2, 10000000L, null);
        locations.add(locationConfig2);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations(locations);
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, new SegmentLoaderConfig().withLocations(locations), (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToDownload = this.makeTestDataSegment(this.segmentDeepStorageDir);
        File localSegmentFile = new File(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        SegmentLocalCacheManagerTest.makeSegmentZip(localSegmentFile, new File(localSegmentFile, "index.zip"));
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        manager.load(segmentToDownload);
        File segmentFile = manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        manager.drop(segmentToDownload);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload));
    }

    @Test
    public void testRetryAllFail() throws Exception {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(false);
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, 1000000000L, null);
        locations.add(locationConfig);
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        localStorageFolder2.setWritable(false);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(localStorageFolder2, 10000000L, null);
        locations.add(locationConfig2);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations(locations);
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, new SegmentLoaderConfig().withLocations(locations), (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToDownload = this.makeTestDataSegment(this.segmentDeepStorageDir);
        File localSegmentFile = new File(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        FileUtils.mkdirp((File)localSegmentFile);
        File indexZip = new File(localSegmentFile, "index.zip");
        indexZip.createNewFile();
        try {
            manager.load(segmentToDownload);
            Assert.fail();
        }
        catch (SegmentLoadingException segmentLoadingException) {
            // empty catch block
        }
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload));
        manager.drop(segmentToDownload);
    }

    @Test
    public void testEmptyToFullOrder() throws Exception {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        File localStorageFolder = this.tmpFolder.newFolder("local_storage_folder");
        localStorageFolder.setWritable(true);
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, 10L, null);
        locations.add(locationConfig);
        File localStorageFolder2 = this.tmpFolder.newFolder("local_storage_folder2");
        localStorageFolder2.setWritable(true);
        StorageLocationConfig locationConfig2 = new StorageLocationConfig(localStorageFolder2, 10L, null);
        locations.add(locationConfig2);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations(locations);
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, new SegmentLoaderConfig().withLocations(locations), (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToDownload = this.makeTestDataSegment(this.segmentDeepStorageDir);
        File localSegmentFile = new File(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        SegmentLocalCacheManagerTest.makeSegmentZip(localSegmentFile, new File(this.segmentDeepStorageDir + "/test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/0/index.zip"));
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        manager.load(segmentToDownload);
        File segmentFile = manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        DataSegment segmentToDownload2 = this.makeTestDataSegment(this.segmentDeepStorageDir, 1, TEST_DATA_RELATIVE_PATH_2);
        File localSegmentFile2 = new File(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_2);
        SegmentLocalCacheManagerTest.makeSegmentZip(localSegmentFile2, new File(this.segmentDeepStorageDir + "/test_segment_loader/2011-01-12T00:00:00.000Z_2011-04-15T00:00:00.001Z/2015-05-27T03:38:35.683Z/1/index.zip"));
        manager.load(segmentToDownload2);
        File segmentFile2 = manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload2));
        manager.drop(segmentToDownload2);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload2));
    }

    @Test
    public void testSegmentDistributionUsingRoundRobinStrategy() throws Exception {
        ArrayList<StorageLocationConfig> locationConfigs = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = this.createStorageLocationConfig("local_storage_folder", 10000000000L, true);
        StorageLocationConfig locationConfig2 = this.createStorageLocationConfig("local_storage_folder2", 1000000000L, true);
        StorageLocationConfig locationConfig3 = this.createStorageLocationConfig("local_storage_folder3", 1000000000L, true);
        locationConfigs.add(locationConfig);
        locationConfigs.add(locationConfig2);
        locationConfigs.add(locationConfig3);
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        for (StorageLocationConfig locConfig : locationConfigs) {
            locations.add(new StorageLocation(locConfig.getPath(), locConfig.getMaxSize(), locConfig.getFreeSpacePercent()));
        }
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(locations, new SegmentLoaderConfig().withLocations(locationConfigs), (StorageLocationSelectorStrategy)new RoundRobinStorageLocationSelectorStrategy(locations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToDownload1 = this.makeTestDataSegment(this.segmentDeepStorageDir);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload1));
        manager.load(segmentToDownload1);
        File segmentFile = manager.getSegmentFiles(segmentToDownload1);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload1));
        manager.drop(segmentToDownload1);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload1));
        DataSegment segmentToDownload2 = this.makeTestDataSegment(this.segmentDeepStorageDir, 1, TEST_DATA_RELATIVE_PATH_2);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_2);
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload2));
        manager.load(segmentToDownload2);
        File segmentFile2 = manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload2));
        manager.drop(segmentToDownload2);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload2));
        DataSegment segmentToDownload3 = this.makeTestDataSegment(this.segmentDeepStorageDir, 2, TEST_DATA_RELATIVE_PATH_3);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_3);
        manager.load(segmentToDownload3);
        File segmentFile3 = manager.getSegmentFiles(segmentToDownload3);
        Assert.assertTrue((boolean)segmentFile3.getAbsolutePath().contains("/local_storage_folder3/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload3));
        manager.drop(segmentToDownload3);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload3));
        DataSegment segmentToDownload4 = this.makeTestDataSegment(this.segmentDeepStorageDir, 3, TEST_DATA_RELATIVE_PATH_4);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_4);
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload4));
        manager.load(segmentToDownload4);
        File segmentFile1 = manager.getSegmentFiles(segmentToDownload4);
        Assert.assertTrue((boolean)segmentFile1.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload4));
        manager.drop(segmentToDownload4);
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload4));
    }

    @Test
    public void testSegmentDistributionUsingLeastBytesUsedStrategy() throws Exception {
        ArrayList<StorageLocationConfig> locations = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = this.createStorageLocationConfig("local_storage_folder", 10000000000L, true);
        StorageLocationConfig locationConfig2 = this.createStorageLocationConfig("local_storage_folder2", 1000000000L, true);
        StorageLocationConfig locationConfig3 = this.createStorageLocationConfig("local_storage_folder3", 1000000000L, true);
        locations.add(locationConfig);
        locations.add(locationConfig2);
        locations.add(locationConfig3);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations(locations);
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, new SegmentLoaderConfig().withLocations(locations), (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToDownload = this.makeTestDataSegment(this.segmentDeepStorageDir);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        manager.load(segmentToDownload);
        File segmentFile = manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        DataSegment segmentToDownload2 = this.makeTestDataSegment(this.segmentDeepStorageDir, 5L, 1, TEST_DATA_RELATIVE_PATH_2);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_2);
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload2));
        manager.load(segmentToDownload2);
        File segmentFile2 = manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload2));
        DataSegment segmentToDownload3 = this.makeTestDataSegment(this.segmentDeepStorageDir, 20L, 2, TEST_DATA_RELATIVE_PATH_3);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_3);
        manager.load(segmentToDownload3);
        File segmentFile3 = manager.getSegmentFiles(segmentToDownload3);
        Assert.assertTrue((boolean)segmentFile3.getAbsolutePath().contains("/local_storage_folder3/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload3));
        DataSegment segmentToDownload4 = this.makeTestDataSegment(this.segmentDeepStorageDir, 10L, 3, TEST_DATA_RELATIVE_PATH_4);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_4);
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload4));
        manager.load(segmentToDownload4);
        File segmentFile1 = manager.getSegmentFiles(segmentToDownload4);
        Assert.assertTrue((boolean)segmentFile1.getAbsolutePath().contains("/local_storage_folder2/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload4));
    }

    @Test
    public void testSegmentDistributionUsingRandomStrategy() throws Exception {
        ArrayList<StorageLocationConfig> locationConfigs = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = this.createStorageLocationConfig("local_storage_folder", 10L, true);
        StorageLocationConfig locationConfig2 = this.createStorageLocationConfig("local_storage_folder2", 100L, false);
        StorageLocationConfig locationConfig3 = this.createStorageLocationConfig("local_storage_folder3", 9L, true);
        locationConfigs.add(locationConfig);
        locationConfigs.add(locationConfig2);
        locationConfigs.add(locationConfig3);
        SegmentLoaderConfig segmentLoaderConfig = new SegmentLoaderConfig().withLocations(locationConfigs);
        List locations = segmentLoaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(locations, segmentLoaderConfig, (StorageLocationSelectorStrategy)new RandomStorageLocationSelectorStrategy(locations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToDownload = this.makeTestDataSegment(this.segmentDeepStorageDir);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        manager.load(segmentToDownload);
        File segmentFile = manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((boolean)segmentFile.getAbsolutePath().contains("/local_storage_folder/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload));
        DataSegment segmentToDownload2 = this.makeTestDataSegment(this.segmentDeepStorageDir, 9L, 1, TEST_DATA_RELATIVE_PATH_2);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_2);
        Assert.assertFalse((String)"Expect cache miss before downloading segment", (boolean)manager.isSegmentCached(segmentToDownload2));
        manager.load(segmentToDownload2);
        File segmentFile2 = manager.getSegmentFiles(segmentToDownload2);
        Assert.assertTrue((boolean)segmentFile2.getAbsolutePath().contains("/local_storage_folder3/"));
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)manager.isSegmentCached(segmentToDownload2));
        DataSegment segmentToDownload3 = this.makeTestDataSegment(this.segmentDeepStorageDir, 20L, 2, TEST_DATA_RELATIVE_PATH_3);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH_3);
        try {
            manager.load(segmentToDownload3);
            Assert.fail();
        }
        catch (SegmentLoadingException segmentLoadingException) {
            // empty catch block
        }
        Assert.assertFalse((String)"Expect cache miss after dropping segment", (boolean)manager.isSegmentCached(segmentToDownload3));
    }

    @Test
    public void testGetSegmentFilesWhenDownloadStartMarkerExists() throws Exception {
        DataSegment segmentToDownload = this.makeTestDataSegment(this.segmentDeepStorageDir);
        File localSegmentFile = new File(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        SegmentLocalCacheManagerTest.makeSegmentZip(localSegmentFile, new File(localSegmentFile, "index.zip"));
        this.manager.load(segmentToDownload);
        File cachedSegmentDir = this.manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentCached(segmentToDownload));
        File downloadMarker = new File(new File(this.localSegmentCacheDir, segmentToDownload.getId().toString()), "downloadStartMarker");
        Assert.assertTrue((boolean)downloadMarker.createNewFile());
        SegmentLocalCacheManager manager = this.makeDefaultManager(this.jsonMapper);
        manager.load(segmentToDownload);
        manager.getSegmentFiles(segmentToDownload);
        Assert.assertTrue((String)"Don't expect cache miss for corrupted segment file", (boolean)manager.isSegmentCached(segmentToDownload));
        Assert.assertTrue((boolean)cachedSegmentDir.exists());
        Assert.assertFalse((boolean)downloadMarker.exists());
    }

    @Test
    public void testGetBootstrapSegment() throws SegmentLoadingException {
        StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheDir, 10000L, null);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations((List)ImmutableList.of((Object)locationConfig));
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment dataSegment = TestSegmentUtils.makeSegment((String)"foo", (String)"v1", (Interval)Intervals.of((String)"2020/2021"));
        manager.bootstrap(dataSegment, SegmentLazyLoadFailCallback.NOOP);
        Segment actualBootstrapSegment = manager.acquireCachedSegment(dataSegment).orElse(null);
        Assert.assertNotNull((Object)actualBootstrapSegment);
        Assert.assertEquals((Object)dataSegment.getId(), (Object)actualBootstrapSegment.getId());
        Assert.assertEquals((Object)dataSegment.getInterval(), (Object)actualBootstrapSegment.getDataInterval());
    }

    @Test
    public void testGetBootstrapSegmentLazy() throws SegmentLoadingException {
        final StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheDir, 10000L, null);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig(){

            public boolean isLazyLoadOnStart() {
                return true;
            }

            public List<StorageLocationConfig> getLocations() {
                return List.of(locationConfig);
            }
        };
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment dataSegment = TestSegmentUtils.makeSegment((String)"foo", (String)"v1", (Interval)Intervals.of((String)"2020/2021"));
        manager.bootstrap(dataSegment, () -> {});
        Segment actualBootstrapSegment = manager.acquireCachedSegment(dataSegment).orElse(null);
        Assert.assertNotNull((Object)actualBootstrapSegment);
        Assert.assertEquals((Object)dataSegment.getId(), (Object)actualBootstrapSegment.getId());
        Assert.assertEquals((Object)dataSegment.getInterval(), (Object)actualBootstrapSegment.getDataInterval());
    }

    @Test
    public void testGetSegmentVirtualStorage() throws Exception {
        final StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheDir, 10000L, null);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig(){

            public List<StorageLocationConfig> getLocations() {
                return ImmutableList.of((Object)locationConfig);
            }

            public boolean isVirtualStorage() {
                return true;
            }
        };
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToLoad = this.makeTestDataSegment(this.segmentDeepStorageDir);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        manager.load(segmentToLoad);
        Assert.assertNull((Object)manager.getSegmentFiles(segmentToLoad));
        Assert.assertFalse((boolean)manager.acquireCachedSegment(segmentToLoad).isPresent());
        AcquireSegmentAction segmentAction = manager.acquireSegment(segmentToLoad);
        ReferenceCountedObjectProvider referenceProvider = (ReferenceCountedObjectProvider)segmentAction.getSegmentFuture().get();
        Optional theSegment = referenceProvider.acquireReference();
        Assert.assertTrue((boolean)theSegment.isPresent());
        Assert.assertNotNull((Object)manager.getSegmentFiles(segmentToLoad));
        Assert.assertEquals((Object)segmentToLoad.getId(), (Object)((Segment)theSegment.get()).getId());
        Assert.assertEquals((Object)segmentToLoad.getInterval(), (Object)((Segment)theSegment.get()).getDataInterval());
        ((Segment)theSegment.get()).close();
        segmentAction.close();
        manager.drop(segmentToLoad);
        Assert.assertNull((Object)manager.getSegmentFiles(segmentToLoad));
        AcquireSegmentAction segmentActionAfterDrop = manager.acquireSegment(segmentToLoad);
        ReferenceCountedObjectProvider referenceProviderAfterDrop = (ReferenceCountedObjectProvider)segmentActionAfterDrop.getSegmentFuture().get();
        Optional theSegmentAfterDrop = referenceProviderAfterDrop.acquireReference();
        Assert.assertTrue((boolean)theSegmentAfterDrop.isPresent());
        Assert.assertNotNull((Object)manager.getSegmentFiles(segmentToLoad));
        Assert.assertEquals((Object)segmentToLoad.getId(), (Object)((Segment)theSegmentAfterDrop.get()).getId());
        Assert.assertEquals((Object)segmentToLoad.getInterval(), (Object)((Segment)theSegmentAfterDrop.get()).getDataInterval());
        ((Segment)theSegmentAfterDrop.get()).close();
        segmentActionAfterDrop.close();
    }

    @Test
    public void testGetBootstrapSegmentVirtualStorage() throws Exception {
        final StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheDir, 10000L, null);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig(){

            public List<StorageLocationConfig> getLocations() {
                return ImmutableList.of((Object)locationConfig);
            }

            public boolean isVirtualStorage() {
                return true;
            }
        };
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToBootstrap = this.makeTestDataSegment(this.segmentDeepStorageDir);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        manager.bootstrap(segmentToBootstrap, SegmentLazyLoadFailCallback.NOOP);
        Assert.assertNull((Object)manager.getSegmentFiles(segmentToBootstrap));
        Assert.assertFalse((boolean)manager.acquireCachedSegment(segmentToBootstrap).isPresent());
        AcquireSegmentAction segmentAction = manager.acquireSegment(segmentToBootstrap);
        ReferenceCountedObjectProvider referenceProvider = (ReferenceCountedObjectProvider)segmentAction.getSegmentFuture().get();
        Optional theSegment = referenceProvider.acquireReference();
        Assert.assertTrue((boolean)theSegment.isPresent());
        Assert.assertNotNull((Object)manager.getSegmentFiles(segmentToBootstrap));
        Assert.assertEquals((Object)segmentToBootstrap.getId(), (Object)((Segment)theSegment.get()).getId());
        Assert.assertEquals((Object)segmentToBootstrap.getInterval(), (Object)((Segment)theSegment.get()).getDataInterval());
        ((Segment)theSegment.get()).close();
        segmentAction.close();
        manager.drop(segmentToBootstrap);
        Assert.assertNull((Object)manager.getSegmentFiles(segmentToBootstrap));
        AcquireSegmentAction segmentActionAfterDrop = manager.acquireSegment(segmentToBootstrap);
        ReferenceCountedObjectProvider referenceProviderDrop = (ReferenceCountedObjectProvider)segmentActionAfterDrop.getSegmentFuture().get();
        Optional theSegmentAfterDrop = referenceProviderDrop.acquireReference();
        Assert.assertTrue((boolean)theSegmentAfterDrop.isPresent());
        Assert.assertNotNull((Object)manager.getSegmentFiles(segmentToBootstrap));
        Assert.assertEquals((Object)segmentToBootstrap.getId(), (Object)((Segment)theSegmentAfterDrop.get()).getId());
        Assert.assertEquals((Object)segmentToBootstrap.getInterval(), (Object)((Segment)theSegmentAfterDrop.get()).getDataInterval());
        ((Segment)theSegmentAfterDrop.get()).close();
        segmentActionAfterDrop.close();
    }

    @Test
    public void testGetBootstrapSegmentVirtualStorageSegmentAlreadyCached() throws Exception {
        final StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheDir, 10000L, null);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig(){

            public List<StorageLocationConfig> getLocations() {
                return ImmutableList.of((Object)locationConfig);
            }

            public boolean isVirtualStorage() {
                return true;
            }
        };
        List storageLocations = loaderConfig.toStorageLocations();
        SegmentLocalCacheManager manager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestHelper.getTestIndexIO((ObjectMapper)this.jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), this.jsonMapper);
        DataSegment segmentToBootstrap = this.makeTestDataSegment(this.segmentDeepStorageDir);
        FileUtils.mkdirp((File)new File(this.localSegmentCacheDir, "info_dir"));
        manager.storeInfoFile(segmentToBootstrap);
        File segmentZip = this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        File unzippedSegmentPathInLocation = new File(this.localSegmentCacheDir, segmentToBootstrap.getId().toString());
        FileUtils.mkdirp((File)unzippedSegmentPathInLocation);
        CompressionUtils.unzip((File)segmentZip, (File)unzippedSegmentPathInLocation);
        for (DataSegment segment : manager.getCachedSegments()) {
            manager.bootstrap(segment, SegmentLazyLoadFailCallback.NOOP);
        }
        Assert.assertNotNull((Object)manager.getSegmentFiles(segmentToBootstrap));
    }

    @Test
    public void testGetSegmentAfterDroppedWithNoVirtualStorageEnabled() throws Exception {
        SegmentLocalCacheManager manager = this.makeDefaultManager(this.jsonMapper);
        DataSegment segmentToLoad = this.makeTestDataSegment(this.segmentDeepStorageDir);
        this.createSegmentZipInLocation(this.segmentDeepStorageDir, TEST_DATA_RELATIVE_PATH);
        manager.load(segmentToLoad);
        Assert.assertNotNull((Object)manager.getSegmentFiles(segmentToLoad));
        manager.drop(segmentToLoad);
        Assert.assertNull((Object)manager.getSegmentFiles(segmentToLoad));
        AcquireSegmentAction segmentAction = manager.acquireSegment(segmentToLoad);
        ReferenceCountedObjectProvider referenceProvider = (ReferenceCountedObjectProvider)segmentAction.getSegmentFuture().get();
        Optional theSegment = referenceProvider.acquireReference();
        Assert.assertFalse((boolean)theSegment.isPresent());
        segmentAction.close();
        Assert.assertNull((Object)manager.getSegmentFiles(segmentToLoad));
    }

    @Test
    public void testIfTombstoneIsLoaded() throws IOException, SegmentLoadingException {
        DataSegment tombstone = DataSegment.builder().dataSource("foo").interval(Intervals.of((String)"2014-10-20T00:00:00Z/P1D")).version("version").loadSpec(Collections.singletonMap("type", "tombstone")).shardSpec((ShardSpec)TombstoneShardSpec.INSTANCE).size(1L).build();
        File cachedSegmentFile = new File(this.localSegmentCacheDir, "test_segment_loader/2014-10-20T00:00:00.000Z_2014-10-21T00:00:00.000Z/2015-05-27T03:38:35.683Z/0");
        FileUtils.mkdirp((File)cachedSegmentFile);
        this.manager.load(tombstone);
        this.manager.getSegmentFiles(tombstone);
        Assert.assertTrue((String)"Expect cache hit after downloading segment", (boolean)this.manager.isSegmentCached(tombstone));
    }

    @Test
    public void testGetTombstoneSegment() throws SegmentLoadingException {
        Interval interval = Intervals.of((String)"2014-01-01/2014-01-02");
        DataSegment tombstone = DataSegment.builder().dataSource("foo").interval(interval).version("v1").loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"tombstone")).shardSpec((ShardSpec)TombstoneShardSpec.INSTANCE).size(100L).build();
        this.manager.load(tombstone);
        Segment segment = this.manager.acquireCachedSegment(tombstone).orElse(null);
        Assert.assertEquals((Object)tombstone.getId(), (Object)segment.getId());
        Assert.assertEquals((Object)interval, (Object)segment.getDataInterval());
        CursorFactory cursorFactory = (CursorFactory)segment.as(CursorFactory.class);
        Assert.assertNotNull((Object)cursorFactory);
        Assert.assertTrue((boolean)segment.isTombstone());
        QueryableIndex queryableIndex = (QueryableIndex)segment.as(QueryableIndex.class);
        Assert.assertNotNull((Object)queryableIndex);
        Assert.assertEquals((Object)interval, (Object)queryableIndex.getDataInterval());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getMetadata());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getNumRows());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getAvailableDimensions());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getBitmapFactoryForDimensions());
        Assert.assertThrows(UnsupportedOperationException.class, () -> ((QueryableIndex)queryableIndex).getDimensionHandlers());
        Assert.assertThrows(UnsupportedOperationException.class, () -> queryableIndex.getColumnHolder("foo"));
    }

    private SegmentLocalCacheManager makeDefaultManager(ObjectMapper jsonMapper) {
        ArrayList<StorageLocationConfig> locationConfigs = new ArrayList<StorageLocationConfig>();
        StorageLocationConfig locationConfig = new StorageLocationConfig(this.localSegmentCacheDir, 10000000000L, null);
        locationConfigs.add(locationConfig);
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig().withLocations(locationConfigs);
        List locations = loaderConfig.toStorageLocations();
        return new SegmentLocalCacheManager(locations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(locations), TestHelper.getTestIndexIO((ObjectMapper)jsonMapper, (ColumnConfig)ColumnConfig.DEFAULT), jsonMapper);
    }

    private File createSegmentZipInLocation(File src, String relativePath) throws Exception {
        File tmpSegmentFile = this.tmpFolder.newFile();
        FileUtils.mkdirp((File)new File(src, relativePath));
        return SegmentLocalCacheManagerTest.makeSegmentZip(tmpSegmentFile, new File(src, relativePath + "/index.zip"));
    }

    private StorageLocationConfig createStorageLocationConfig(String localPath, long maxSize, boolean writable) throws Exception {
        File localStorageFolder = this.tmpFolder.newFolder(localPath);
        localStorageFolder.setWritable(writable);
        StorageLocationConfig locationConfig = new StorageLocationConfig(localStorageFolder, maxSize, Double.valueOf(1.0));
        return locationConfig;
    }

    private DataSegment dataSegmentWithInterval(String intervalStr) {
        return this.dataSegmentWithInterval(intervalStr, 10L);
    }

    private DataSegment dataSegmentWithInterval(String intervalStr, long size) {
        return this.dataSegmentWithInterval(intervalStr, size, 0);
    }

    private DataSegment dataSegmentWithInterval(String intervalStr, long size, int partition) {
        return DataSegment.builder().dataSource("test_segment_loader").interval(Intervals.of((String)intervalStr)).loadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)"somewhere")).version("2015-05-27T03:38:35.683Z").dimensions((List)ImmutableList.of()).metrics((List)ImmutableList.of()).shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(partition))).binaryVersion(Integer.valueOf(9)).size(size).build();
    }

    private DataSegment makeTestDataSegment(File segmentSrcFolder) throws IOException {
        return this.makeTestDataSegment(segmentSrcFolder, 10L, 0, TEST_DATA_RELATIVE_PATH);
    }

    private DataSegment makeTestDataSegment(File segmentSrcFolder, int partition, String relativePath) throws IOException {
        return this.makeTestDataSegment(segmentSrcFolder, 10L, partition, relativePath);
    }

    private DataSegment makeTestDataSegment(File segmentSrcFolder, long size, int partition, String relativePath) throws IOException {
        return this.dataSegmentWithInterval("2011-01-12T00:00:00.000Z/2011-04-15T00:00:00.001Z", size, partition).withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)(segmentSrcFolder.getCanonicalPath() + "/" + relativePath + "/index.zip")));
    }

    private void writeSegmentFile(DataSegment segment) throws IOException {
        File segmentFile = new File(this.localSegmentCacheDir, segment.getId().toString());
        FileUtils.mkdirp((File)segmentFile);
    }

    static File makeSegmentZip(File segmentFiles, File zipOutFile) throws IOException {
        TestIndex.persist((IncrementalIndex)TestIndex.getIncrementalTestIndex(), (IndexSpec)IndexSpec.getDefault(), (File)segmentFiles);
        FileUtils.mkdirp((File)zipOutFile.getParentFile());
        CompressionUtils.zip((File)segmentFiles, (File)zipOutFile);
        return zipOutFile;
    }
}

