/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.loading.CacheEntry;
import org.apache.druid.segment.loading.CacheEntryIdentifier;
import org.apache.druid.segment.loading.SegmentCacheEntryIdentifier;
import org.apache.druid.segment.loading.StorageLocation;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class StorageLocationTest {
    @TempDir
    File tempDir;
    ExecutorService executorService;

    StorageLocationTest() {
    }

    @BeforeEach
    public void setup() {
        this.executorService = Execs.multiThreaded((int)10, (String)"storage-location-test-%d");
    }

    @Test
    public void testWeakReserveAndReclaim() {
        StorageLocation location = new StorageLocation(this.tempDir, 100L, null);
        TestCacheEntry entry1 = new TestCacheEntry("1", 25L);
        TestCacheEntry entry2 = new TestCacheEntry("2", 25L);
        TestCacheEntry entry3 = new TestCacheEntry("3", 25L);
        TestCacheEntry entry4 = new TestCacheEntry("4", 25L);
        TestCacheEntry entry5 = new TestCacheEntry("5", 25L);
        location.reserveWeak((CacheEntry)entry1);
        location.reserveWeak((CacheEntry)entry2);
        location.reserveWeak((CacheEntry)entry3);
        location.reserveWeak((CacheEntry)entry4);
        Assertions.assertEquals((long)100L, (long)location.currentWeakSizeBytes());
        Assertions.assertTrue((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry4.getId()));
        location.reserveWeak((CacheEntry)entry5);
        Assertions.assertEquals((long)100L, (long)location.currentWeakSizeBytes());
        Assertions.assertFalse((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry5.getId()));
        Assertions.assertEquals((long)100L, (long)location.currentWeakSizeBytes());
    }

    @Test
    public void testRemoveFromHead() {
        StorageLocation location = new StorageLocation(this.tempDir, 100L, null);
        TestCacheEntry entry1 = new TestCacheEntry("1", 25L);
        TestCacheEntry entry2 = new TestCacheEntry("2", 25L);
        TestCacheEntry entry3 = new TestCacheEntry("3", 25L);
        TestCacheEntry entry4 = new TestCacheEntry("4", 25L);
        location.reserveWeak((CacheEntry)entry1);
        location.reserveWeak((CacheEntry)entry2);
        location.reserveWeak((CacheEntry)entry3);
        location.reserveWeak((CacheEntry)entry4);
        Assertions.assertTrue((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry4.getId()));
        location.release((CacheEntry)entry1);
        location.release((CacheEntry)entry2);
        location.release((CacheEntry)entry3);
        location.release((CacheEntry)entry4);
        Assertions.assertFalse((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry4.getId()));
    }

    @Test
    public void testRemoveFromTail() {
        StorageLocation location = new StorageLocation(this.tempDir, 100L, null);
        TestCacheEntry entry1 = new TestCacheEntry("1", 25L);
        TestCacheEntry entry2 = new TestCacheEntry("2", 25L);
        TestCacheEntry entry3 = new TestCacheEntry("3", 25L);
        TestCacheEntry entry4 = new TestCacheEntry("4", 25L);
        location.reserveWeak((CacheEntry)entry1);
        location.reserveWeak((CacheEntry)entry2);
        location.reserveWeak((CacheEntry)entry3);
        location.reserveWeak((CacheEntry)entry4);
        Assertions.assertTrue((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry4.getId()));
        location.release((CacheEntry)entry4);
        location.release((CacheEntry)entry3);
        location.release((CacheEntry)entry2);
        location.release((CacheEntry)entry1);
        Assertions.assertFalse((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry4.getId()));
    }

    @Test
    public void testRemoveRandom() {
        StorageLocation location = new StorageLocation(this.tempDir, 100L, null);
        TestCacheEntry entry1 = new TestCacheEntry("1", 25L);
        TestCacheEntry entry2 = new TestCacheEntry("2", 25L);
        TestCacheEntry entry3 = new TestCacheEntry("3", 25L);
        TestCacheEntry entry4 = new TestCacheEntry("4", 25L);
        ArrayList<TestCacheEntry> entries = new ArrayList<TestCacheEntry>();
        entries.add(entry1);
        entries.add(entry2);
        entries.add(entry3);
        entries.add(entry4);
        location.reserveWeak((CacheEntry)entry1);
        location.reserveWeak((CacheEntry)entry2);
        location.reserveWeak((CacheEntry)entry3);
        location.reserveWeak((CacheEntry)entry4);
        Assertions.assertTrue((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry4.getId()));
        while (!entries.isEmpty()) {
            int toRemove = ThreadLocalRandom.current().nextInt(entries.size());
            CacheEntry entry = (CacheEntry)entries.get(toRemove);
            location.release(entry);
            entries.remove(toRemove);
        }
        Assertions.assertFalse((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry4.getId()));
        Assertions.assertEquals((long)0L, (long)location.currentSizeBytes());
        Assertions.assertEquals((long)0L, (long)location.currentWeakSizeBytes());
    }

    @Test
    public void testBulkReservation() {
        StorageLocation location = new StorageLocation(this.tempDir, 100L, null);
        TestCacheEntry entry1 = new TestCacheEntry("1", 25L);
        TestCacheEntry entry2 = new TestCacheEntry("2", 25L);
        TestCacheEntry entry3 = new TestCacheEntry("3", 25L);
        TestCacheEntry entry4 = new TestCacheEntry("4", 25L);
        TestCacheEntry entry5 = new TestCacheEntry("5", 25L);
        TestCacheEntry entry6 = new TestCacheEntry("6", 25L);
        TestCacheEntry entry7 = new TestCacheEntry("7", 25L);
        TestCacheEntry entry8 = new TestCacheEntry("8", 25L);
        Closer closer = Closer.create();
        Assertions.assertNotNull((Object)closer.register((Closeable)location.addWeakReservationHold(entry1.getId(), () -> entry1)));
        Assertions.assertNotNull((Object)closer.register((Closeable)location.addWeakReservationHold(entry2.getId(), () -> entry2)));
        Assertions.assertTrue((boolean)location.reserveWeak((CacheEntry)entry3));
        Assertions.assertTrue((boolean)location.reserveWeak((CacheEntry)entry4));
        Assertions.assertEquals((long)100L, (long)location.currentWeakSizeBytes());
        Assertions.assertTrue((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry4.getId()));
        Assertions.assertNotNull((Object)closer.register((Closeable)location.addWeakReservationHold(entry5.getId(), () -> entry5)));
        Assertions.assertEquals((long)100L, (long)location.currentWeakSizeBytes());
        Assertions.assertTrue((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry4.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry5.getId()));
        Assertions.assertTrue((boolean)location.reserveWeak((CacheEntry)entry6));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry4.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry5.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry6.getId()));
        Assertions.assertTrue((boolean)location.reserveWeak((CacheEntry)entry7));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry4.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry5.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry6.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry7.getId()));
        CloseableUtils.closeAndWrapExceptions((Closeable)closer);
        Assertions.assertTrue((boolean)location.reserveWeak((CacheEntry)entry8));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry1.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry2.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry3.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry4.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry5.getId()));
        Assertions.assertFalse((boolean)location.isWeakReserved(entry6.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry7.getId()));
        Assertions.assertTrue((boolean)location.isWeakReserved(entry8.getId()));
        Assertions.assertEquals((long)100L, (long)location.currentWeakSizeBytes());
    }

    @Test
    public void testStorageLocationFreePercent() {
        StorageLocation locationPlain = this.fakeLocation(100000L, 5000L, 10000L, null);
        Assertions.assertTrue((boolean)locationPlain.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2012/2013", 9000L)).isSuccess());
        Assertions.assertFalse((boolean)locationPlain.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2012/2013", 11000L)).isSuccess());
        StorageLocation locationFree = this.fakeLocation(100000L, 25000L, 10000L, 10.0);
        Assertions.assertTrue((boolean)locationFree.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2012/2013", 9000L)).isSuccess());
        Assertions.assertFalse((boolean)locationFree.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2012/2013", 11000L)).isSuccess());
        StorageLocation locationFull = this.fakeLocation(100000L, 15000L, 10000L, 10.0);
        Assertions.assertTrue((boolean)locationFull.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2012/2013", 4000L)).isSuccess());
        Assertions.assertFalse((boolean)locationFull.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2012/2013", 6000L)).isSuccess());
    }

    @Test
    public void testStorageLocationRealFileSystem() {
        StorageLocation location = new StorageLocation(this.tempDir, 10000L, Double.valueOf(100.0));
        Assertions.assertFalse((boolean)location.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2012/2013", 5000L)).isSuccess());
        location = new StorageLocation(this.tempDir, 10000L, Double.valueOf(1.0E-4));
        Assertions.assertTrue((boolean)location.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2012/2013", 1L)).isSuccess());
    }

    @Test
    public void testStorageLocation() {
        long expectedAvail = 1000L;
        StorageLocation loc = new StorageLocation(this.tempDir, expectedAvail, null);
        this.verifyLoc(expectedAvail, loc);
        TestSegmentCacheEntry entry1 = StorageLocationTest.makeSegmentEntry("2012-01-01/2012-01-02", 10L);
        TestSegmentCacheEntry entry2 = StorageLocationTest.makeSegmentEntry("2012-01-01/2012-01-02", 10L);
        TestSegmentCacheEntry entry3 = StorageLocationTest.makeSegmentEntry("2012-01-02/2012-01-03", 23L);
        loc.reserve((CacheEntry)entry1);
        this.verifyLoc(expectedAvail -= 10L, loc);
        loc.reserve((CacheEntry)entry2);
        this.verifyLoc(expectedAvail, loc);
        loc.reserve((CacheEntry)entry3);
        this.verifyLoc(expectedAvail -= 23L, loc);
        loc.release((CacheEntry)entry1);
        this.verifyLoc(expectedAvail += 10L, loc);
        loc.release((CacheEntry)StorageLocationTest.makeSegmentEntry("2012-01-01/2012-01-02", 10L));
        this.verifyLoc(expectedAvail, loc);
        loc.release((CacheEntry)entry3);
        this.verifyLoc(expectedAvail += 23L, loc);
    }

    @Test
    public void testReserveAndRelease() {
        StorageLocation loc = new StorageLocation(this.tempDir, 1000L, null);
        TestCacheEntry entry1 = new TestCacheEntry("testPath", 100L);
        TestCacheEntry entry2 = new TestCacheEntry("testPath", 100L);
        Assertions.assertTrue((boolean)loc.reserve((CacheEntry)entry1));
        Assertions.assertEquals((long)900L, (long)loc.availableSizeBytes());
        Assertions.assertTrue((boolean)loc.isReserved(entry1.getId()));
        Assertions.assertFalse((boolean)loc.reserve((CacheEntry)entry2));
        loc.release((CacheEntry)entry1);
        Assertions.assertEquals((long)1000L, (long)loc.availableSizeBytes());
        Assertions.assertFalse((boolean)loc.isReserved(entry2.getId()));
        loc.release((CacheEntry)entry2);
    }

    @Test
    public void testReserveWeakExistsConcurrency() throws ExecutionException, InterruptedException {
        StorageLocation loc = new StorageLocation(this.tempDir, 1000L, null);
        TestSegmentCacheEntry entry = StorageLocationTest.makeSegmentEntry("2024/2025", 10L);
        loc.reserveWeak((CacheEntry)entry);
        entry.mount(loc);
        for (int i = 0; i < 1000; ++i) {
            ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
            for (int j = 0; j < 10; ++j) {
                futures.add(this.executorService.submit(() -> {
                    try {
                        StorageLocation.ReservationHold hold = loc.addWeakReservationHoldIfExists((CacheEntryIdentifier)entry.getId());
                        Assertions.assertNotNull((Object)hold);
                        hold.close();
                        return true;
                    }
                    catch (Throwable t) {
                        return false;
                    }
                }));
            }
            for (Future future : futures) {
                Assertions.assertTrue((boolean)((Boolean)future.get()));
            }
        }
        Assertions.assertEquals((long)0L, (long)loc.getActiveWeakHolds());
    }

    private void verifyLoc(long maxSize, StorageLocation loc) {
        Assertions.assertEquals((long)maxSize, (long)loc.availableSizeBytes());
        int i = 0;
        while ((long)i <= maxSize) {
            Assertions.assertTrue((boolean)loc.canHandle((CacheEntry)StorageLocationTest.makeSegmentEntry("2013/2014", i)).isSuccess(), (String)String.valueOf(i));
            ++i;
        }
    }

    private StorageLocation fakeLocation(long total, long free, long max, Double percent) {
        File file = (File)EasyMock.mock(File.class);
        EasyMock.expect((Object)file.getTotalSpace()).andReturn((Object)total).anyTimes();
        EasyMock.expect((Object)file.getFreeSpace()).andReturn((Object)free).anyTimes();
        EasyMock.replay((Object[])new Object[]{file});
        return new StorageLocation(file, max, percent);
    }

    private static DataSegment makeSegment(String intervalString, long size) {
        return new DataSegment("test", Intervals.of((String)intervalString), "1", (Map)ImmutableMap.of(), Collections.singletonList("d"), Collections.singletonList("m"), null, null, size);
    }

    private SegmentId newSegmentId(String intervalString) {
        return SegmentId.of((String)"test", (Interval)Intervals.of((String)intervalString), (String)"1", (int)0);
    }

    private static TestSegmentCacheEntry makeSegmentEntry(String intervalString, long size) {
        return new TestSegmentCacheEntry(intervalString, size);
    }

    private static final class TestCacheEntry
    implements CacheEntry {
        private final StringCacheIdentifier id;
        private final long size;
        private boolean isMounted = false;

        private TestCacheEntry(String id, long size) {
            this.id = new StringCacheIdentifier(id);
            this.size = size;
        }

        public StringCacheIdentifier getId() {
            return this.id;
        }

        public long getSize() {
            return this.size;
        }

        public boolean isMounted() {
            return true;
        }

        public void mount(StorageLocation location) {
        }

        public void unmount() {
        }
    }

    public static final class TestSegmentCacheEntry
    implements CacheEntry {
        private final SegmentCacheEntryIdentifier identifier;
        private final DataSegment segment;
        private boolean isMounted = false;

        public TestSegmentCacheEntry(String intervalString, long size) {
            this.segment = StorageLocationTest.makeSegment(intervalString, size);
            this.identifier = new SegmentCacheEntryIdentifier(this.segment.getId());
        }

        public SegmentCacheEntryIdentifier getId() {
            return this.identifier;
        }

        public long getSize() {
            return this.segment.getSize();
        }

        public boolean isMounted() {
            return this.isMounted;
        }

        public void mount(StorageLocation location) {
            this.isMounted = true;
        }

        public void unmount() {
            this.isMounted = false;
        }
    }

    public static final class StringCacheIdentifier
    implements CacheEntryIdentifier {
        private final String string;

        public StringCacheIdentifier(String string) {
            this.string = string;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringCacheIdentifier that = (StringCacheIdentifier)o;
            return Objects.equals(this.string, that.string);
        }

        public int hashCode() {
            return Objects.hashCode(this.string);
        }
    }
}

