/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.SimpleRowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.segment.realtime.appenderator.TestAppenderatorConfig;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.LinearShardSpec;

public class BatchAppenderatorTester
implements AutoCloseable {
    public static final String DATASOURCE = "foo";
    private final DataSchema schema;
    private final AppenderatorConfig tuningConfig;
    private final SegmentGenerationMetrics metrics;
    private final ObjectMapper objectMapper;
    private final Appenderator appenderator;
    private final ServiceEmitter emitter;
    private final List<DataSegment> pushedSegments = new CopyOnWriteArrayList<DataSegment>();

    public BatchAppenderatorTester(int maxRowsInMemory) {
        this(maxRowsInMemory, -1L, null, false);
    }

    public BatchAppenderatorTester(int maxRowsInMemory, boolean enablePushFailure) {
        this(maxRowsInMemory, -1L, null, enablePushFailure);
    }

    public BatchAppenderatorTester(int maxRowsInMemory, long maxSizeInBytes, boolean enablePushFailure) {
        this(maxRowsInMemory, maxSizeInBytes, null, enablePushFailure);
    }

    public BatchAppenderatorTester(int maxRowsInMemory, long maxSizeInBytes, File basePersistDirectory, boolean enablePushFailure) {
        this(maxRowsInMemory, maxSizeInBytes, basePersistDirectory, enablePushFailure, (RowIngestionMeters)new SimpleRowIngestionMeters(), false);
    }

    public BatchAppenderatorTester(int maxRowsInMemory, long maxSizeInBytes, @Nullable File basePersistDirectory, boolean enablePushFailure, RowIngestionMeters rowIngestionMeters) {
        this(maxRowsInMemory, maxSizeInBytes, basePersistDirectory, enablePushFailure, rowIngestionMeters, false);
    }

    public BatchAppenderatorTester(int maxRowsInMemory, long maxSizeInBytes, @Nullable File basePersistDirectory, final boolean enablePushFailure, RowIngestionMeters rowIngestionMeters, boolean skipBytesInMemoryOverheadCheck) {
        this.objectMapper = new DefaultObjectMapper();
        this.objectMapper.registerSubtypes(new Class[]{LinearShardSpec.class});
        Map parserMap = (Map)this.objectMapper.convertValue((Object)new MapInputRowParser((ParseSpec)new JSONParseSpec(new TimestampSpec("ts", "auto", null), DimensionsSpec.EMPTY, null, null, null)), Map.class);
        this.schema = DataSchema.builder().withDataSource(DATASOURCE).withAggregators(new AggregatorFactory[]{new CountAggregatorFactory("count"), new LongSumAggregatorFactory("met", "met")}).withGranularity((GranularitySpec)new UniformGranularitySpec(Granularities.MINUTE, Granularities.NONE, null)).withParserMap(parserMap).withObjectMapper(this.objectMapper).build();
        this.tuningConfig = new TestAppenderatorConfig(TuningConfig.DEFAULT_APPENDABLE_INDEX, maxRowsInMemory, maxSizeInBytes == 0L ? this.getDefaultMaxBytesInMemory() : maxSizeInBytes, skipBytesInMemoryOverheadCheck, IndexSpec.getDefault(), 0, false, 0L, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance(), -1, basePersistDirectory == null ? BatchAppenderatorTester.createNewBasePersistDirectory() : basePersistDirectory, null);
        this.metrics = new SegmentGenerationMetrics();
        IndexIO indexIO = new IndexIO(this.objectMapper, ColumnConfig.DEFAULT);
        IndexMergerV9 indexMerger = new IndexMergerV9(this.objectMapper, indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        this.emitter = new ServiceEmitter("test", "test", (Emitter)new NoopEmitter());
        this.emitter.start();
        EmittingLogger.registerEmitter((ServiceEmitter)this.emitter);
        DataSegmentPusher dataSegmentPusher = new DataSegmentPusher(){
            private boolean mustFail = true;

            @Deprecated
            public String getPathForHadoop(String dataSource) {
                return this.getPathForHadoop();
            }

            public String getPathForHadoop() {
                throw new UnsupportedOperationException();
            }

            public DataSegment push(File file, DataSegment segment, boolean useUniquePath) throws IOException {
                if (enablePushFailure && this.mustFail) {
                    this.mustFail = false;
                    throw new IOException("Push failure test");
                }
                if (enablePushFailure) {
                    this.mustFail = true;
                }
                BatchAppenderatorTester.this.pushedSegments.add(segment);
                return segment;
            }

            public Map<String, Object> makeLoadSpec(URI uri) {
                throw new UnsupportedOperationException();
            }
        };
        this.appenderator = Appenderators.createBatch((String)this.schema.getDataSource(), (DataSchema)this.schema, (AppenderatorConfig)this.tuningConfig, (SegmentGenerationMetrics)this.metrics, (DataSegmentPusher)dataSegmentPusher, (ObjectMapper)this.objectMapper, (IndexIO)indexIO, (IndexMerger)indexMerger, (RowIngestionMeters)rowIngestionMeters, (ParseExceptionHandler)new ParseExceptionHandler(rowIngestionMeters, false, Integer.MAX_VALUE, 0), (CentralizedDatasourceSchemaConfig)CentralizedDatasourceSchemaConfig.create());
    }

    private long getDefaultMaxBytesInMemory() {
        return Runtime.getRuntime().totalMemory() / 3L;
    }

    public DataSchema getSchema() {
        return this.schema;
    }

    public AppenderatorConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public SegmentGenerationMetrics getMetrics() {
        return this.metrics;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public Appenderator getAppenderator() {
        return this.appenderator;
    }

    public List<DataSegment> getPushedSegments() {
        return this.pushedSegments;
    }

    @Override
    public void close() throws Exception {
        this.appenderator.close();
        this.emitter.close();
        FileUtils.deleteDirectory((File)this.tuningConfig.getBasePersistDirectory());
    }

    private static File createNewBasePersistDirectory() {
        return FileUtils.createTempDir((String)"druid-batch-persist");
    }
}

