/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.MapCache;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.indexing.worker.config.WorkerConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.druid.query.DirectQueryProcessingPool;
import org.apache.druid.query.Druids;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.NoopRowIngestionMeters;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.NoopDataSegmentPusher;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.segment.realtime.appenderator.TaskDirectory;
import org.apache.druid.segment.realtime.appenderator.UnifiedIndexerAppenderatorsManager;
import org.apache.druid.segment.writeout.OnHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.logging.log4j.ThreadContext;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class UnifiedIndexerAppenderatorsManagerTest
extends InitializedNullHandlingTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private final WorkerConfig workerConfig = new WorkerConfig();
    private final UnifiedIndexerAppenderatorsManager manager = new UnifiedIndexerAppenderatorsManager((QueryProcessingPool)DirectQueryProcessingPool.INSTANCE, this.workerConfig, MapCache.create((long)10L), new CacheConfig(), new CachePopulatorStats(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), TestHelper.makeJsonMapper(), (ServiceEmitter)new NoopServiceEmitter(), () -> DefaultQueryRunnerFactoryConglomerate.buildFromQueryRunnerFactories((Map)ImmutableMap.of()));
    private AppenderatorConfig appenderatorConfig;
    private Appenderator appenderator;

    @Before
    public void setup() {
        this.appenderatorConfig = (AppenderatorConfig)EasyMock.createMock(AppenderatorConfig.class);
        EasyMock.expect((Object)this.appenderatorConfig.getMaxPendingPersists()).andReturn((Object)0);
        EasyMock.expect((Object)this.appenderatorConfig.isSkipBytesInMemoryOverheadCheck()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.appenderatorConfig});
        TaskDirectory taskDirectory = (TaskDirectory)EasyMock.createMock(TaskDirectory.class);
        EasyMock.expect((Object)taskDirectory.getTaskLogFile("taskId")).andReturn((Object)new File("/mnt/var/taskId"));
        EasyMock.replay((Object[])new Object[]{taskDirectory});
        this.appenderator = this.manager.createBatchAppenderatorForTask("taskId", DataSchema.builder().withDataSource("myDataSource").withTimestamp(new TimestampSpec("__time", "millis", null)).withGranularity((GranularitySpec)new UniformGranularitySpec(Granularities.HOUR, Granularities.HOUR, Boolean.valueOf(false), Collections.emptyList())).build(), this.appenderatorConfig, taskDirectory, new SegmentGenerationMetrics(), (DataSegmentPusher)new NoopDataSegmentPusher(), TestHelper.makeJsonMapper(), TestHelper.getTestIndexIO(), (IndexMerger)TestHelper.getTestIndexMergerV9((SegmentWriteOutMediumFactory)OnHeapMemorySegmentWriteOutMediumFactory.instance()), (RowIngestionMeters)new NoopRowIngestionMeters(), new ParseExceptionHandler((RowIngestionMeters)new NoopRowIngestionMeters(), false, 0, 0), CentralizedDatasourceSchemaConfig.create());
    }

    @Test
    public void test_getBundle_knownDataSource() {
        UnifiedIndexerAppenderatorsManager.DatasourceBundle bundle = this.manager.getBundle((Query)Druids.newScanQueryBuilder().dataSource(this.appenderator.getDataSource()).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY)).build());
        Assert.assertEquals((Object)"myDataSource", (Object)bundle.getWalker().getDataSource());
    }

    @Test
    public void test_getBundle_unknownDataSource() {
        ScanQuery query = Druids.newScanQueryBuilder().dataSource("unknown").intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY)).build();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Could not find segment walker for datasource");
        this.manager.getBundle((Query)query);
    }

    @Test
    public void test_removeAppenderatorsForTask() {
        Assert.assertEquals((Object)ImmutableSet.of((Object)"myDataSource"), this.manager.getDatasourceBundles().keySet());
        this.manager.removeAppenderatorsForTask("taskId", "myDataSource");
        Assert.assertTrue((boolean)this.manager.getDatasourceBundles().isEmpty());
    }

    @Test
    public void test_removeAppenderatorsForTask_withoutCreate() {
        this.manager.removeAppenderatorsForTask("someOtherTaskId", "someOtherDataSource");
        this.manager.removeAppenderatorsForTask("someOtherTaskId", "myDataSource");
        Assert.assertEquals((Object)ImmutableSet.of((Object)"myDataSource"), this.manager.getDatasourceBundles().keySet());
    }

    @Test
    public void test_limitedPool_persist() throws IOException {
        UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger limitedPoolIndexMerger = new UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger((IndexMerger)new NoopIndexMerger(), (ListeningExecutorService)DirectQueryProcessingPool.INSTANCE);
        File file = new File("xyz");
        Assert.assertEquals((Object)file, (Object)limitedPoolIndexMerger.persist(null, null, file, null, null, null));
        Assert.assertEquals((Object)file, (Object)limitedPoolIndexMerger.persist(null, null, file, null, null));
        IncrementalIndex index = (IncrementalIndex)EasyMock.createMock(IncrementalIndex.class);
        EasyMock.expect((Object)index.getInterval()).andReturn(null);
        EasyMock.replay((Object[])new Object[]{index});
        Assert.assertEquals((Object)file, (Object)limitedPoolIndexMerger.persist(index, file, null, null));
        EasyMock.verify((Object[])new Object[]{index});
    }

    @Test
    public void test_limitedPool_persistFail() {
        UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger limitedPoolIndexMerger = new UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger((IndexMerger)new NoopIndexMerger(true), (ListeningExecutorService)DirectQueryProcessingPool.INSTANCE);
        File file = new File("xyz");
        Assert.assertThrows((String)"failed", RuntimeException.class, () -> limitedPoolIndexMerger.persist(null, null, file, null, null, null));
    }

    @Test
    public void test_limitedPool_mergeQueryableIndexFail() {
        UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger limitedPoolIndexMerger = new UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger((IndexMerger)new NoopIndexMerger(true), (ListeningExecutorService)DirectQueryProcessingPool.INSTANCE);
        File file = new File("xyz");
        Assert.assertThrows((String)"failed", RuntimeException.class, () -> limitedPoolIndexMerger.mergeQueryableIndex(null, false, null, null, file, null, null, null, null, -1));
    }

    @Test
    public void test_limitedPool_mergeQueryableIndex() throws IOException {
        UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger limitedPoolIndexMerger = new UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger((IndexMerger)new NoopIndexMerger(), (ListeningExecutorService)DirectQueryProcessingPool.INSTANCE);
        File file = new File("xyz");
        Assert.assertEquals((Object)file, (Object)limitedPoolIndexMerger.mergeQueryableIndex(null, false, null, file, null, null, -1));
        Assert.assertEquals((Object)file, (Object)limitedPoolIndexMerger.mergeQueryableIndex(null, false, null, null, file, null, null, null, null, -1));
    }

    @Test
    public void test_limitedPool_merge() {
        UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger limitedPoolIndexMerger = new UnifiedIndexerAppenderatorsManager.LimitedPoolIndexMerger((IndexMerger)new NoopIndexMerger(), (ListeningExecutorService)DirectQueryProcessingPool.INSTANCE);
        File file = new File("xyz");
        this.expectedException.expect(UnsupportedOperationException.class);
        Assert.assertEquals((Object)file, (Object)limitedPoolIndexMerger.merge(null, false, null, file, null, null, -1));
    }

    @Test
    public void test_getWorkerConfig() {
        Assert.assertSame((Object)this.workerConfig, (Object)this.manager.getWorkerConfig());
    }

    @Test
    public void test_setTaskThreadContext() {
        this.appenderator.setTaskThreadContext();
        Map threadContext = ThreadContext.getContext();
        Assert.assertEquals(Map.of("task.log.id", "taskId", "task.log.file", "/mnt/var/taskId"), (Object)threadContext);
        Appenderators.clearTaskThreadContextForIndexers();
    }

    private static class NoopIndexMerger
    implements IndexMerger {
        private final boolean failCalls;

        public NoopIndexMerger(boolean failCalls) {
            this.failCalls = failCalls;
        }

        public NoopIndexMerger() {
            this(false);
        }

        public File persist(IncrementalIndex index, Interval dataInterval, File outDir, IndexSpec indexSpec, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory) throws IOException {
            if (this.failCalls) {
                throw new IOException("failed");
            }
            return outDir;
        }

        public File mergeQueryableIndex(List<QueryableIndex> indexes, boolean rollup, AggregatorFactory[] metricAggs, @Nullable DimensionsSpec dimensionsSpec, File outDir, IndexSpec indexSpec, IndexSpec indexSpecForIntermediatePersists, ProgressIndicator progress, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, int maxColumnsToMerge) throws IOException {
            if (this.failCalls) {
                throw new IOException("failed");
            }
            return outDir;
        }

        public File merge(List<IndexableAdapter> indexes, boolean rollup, AggregatorFactory[] metricAggs, File outDir, DimensionsSpec dimensionsSpec, IndexSpec indexSpec, int maxColumnsToMerge) throws IOException {
            if (this.failCalls) {
                throw new IOException("failed");
            }
            return outDir;
        }
    }
}

