/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.druid.common.utils.SocketUtil;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.guice.http.DruidHttpClientConfig;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.AsyncManagementForwardingServlet;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.BaseJettyTest;
import org.apache.druid.server.initialization.jetty.JettyServerInitUtils;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.security.AllowAllAuthenticator;
import org.apache.druid.server.security.AllowAllAuthorizer;
import org.apache.druid.server.security.AuthenticationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.ee8.servlet.DefaultServlet;
import org.eclipse.jetty.ee8.servlet.ServletContextHandler;
import org.eclipse.jetty.ee8.servlet.ServletHolder;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncManagementForwardingServletTest
extends BaseJettyTest {
    private static final ExpectedRequest COORDINATOR_EXPECTED_REQUEST = new ExpectedRequest();
    private static final ExpectedRequest OVERLORD_EXPECTED_REQUEST = new ExpectedRequest();
    private static int coordinatorPort;
    private static int overlordPort;
    private static boolean isValidLeader;
    private Server coordinator;
    private Server overlord;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        coordinatorPort = SocketUtil.findOpenPortFrom((int)(this.port + 1));
        overlordPort = SocketUtil.findOpenPortFrom((int)(coordinatorPort + 1));
        this.coordinator = AsyncManagementForwardingServletTest.makeTestServer(coordinatorPort, COORDINATOR_EXPECTED_REQUEST);
        this.overlord = AsyncManagementForwardingServletTest.makeTestServer(overlordPort, OVERLORD_EXPECTED_REQUEST);
        this.coordinator.start();
        this.overlord.start();
        isValidLeader = true;
    }

    @After
    public void tearDown() throws Exception {
        this.coordinator.stop();
        this.overlord.stop();
        COORDINATOR_EXPECTED_REQUEST.reset();
        OVERLORD_EXPECTED_REQUEST.reset();
        isValidLeader = true;
    }

    @Override
    protected Injector setupInjector() {
        return Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of(binder -> {
            JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test", "localhost", false, null, null, true, false));
            binder.bind(JettyServerInitializer.class).to(ProxyJettyServerInit.class).in(LazySingleton.class);
            LifecycleModule.register((Binder)binder, Server.class);
        }));
    }

    @Test
    public void testCoordinatorDatasources() throws Exception {
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path = "/druid/coordinator/v1/datasources";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method = "GET";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.headers = ImmutableMap.of((Object)"Authorization", (Object)"Basic bXl1c2VyOm15cGFzc3dvcmQ=");
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method);
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.headers.forEach(connection::setRequestProperty);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertTrue((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testCoordinatorLoadStatus() throws Exception {
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path = "/druid/coordinator/v1/loadstatus";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.query = "full";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method = "GET";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.headers = ImmutableMap.of((Object)"Authorization", (Object)"Basic bXl1c2VyOm15cGFzc3dvcmQ=");
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d%s?%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path, AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.query})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method);
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.headers.forEach(connection::setRequestProperty);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertTrue((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testCoordinatorEnable() throws Exception {
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path = "/druid/coordinator/v1/datasources/myDatasource";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method = "POST";
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertTrue((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testCoordinatorDisable() throws Exception {
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path = "/druid/coordinator/v1/datasources/myDatasource/intervals/2016-06-27_2016-06-28";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method = "DELETE";
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertTrue((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testCoordinatorProxyStatus() throws Exception {
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path = "/status";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method = "GET";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.headers = ImmutableMap.of((Object)"Authorization", (Object)"Basic bXl1c2VyOm15cGFzc3dvcmQ=");
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/proxy/coordinator%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method);
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.headers.forEach(connection::setRequestProperty);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertTrue((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testCoordinatorProxySegments() throws Exception {
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path = "/druid/coordinator/v1/metadata/datasources/myDatasource/segments";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method = "POST";
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.headers = ImmutableMap.of((Object)"Authorization", (Object)"Basic bXl1c2VyOm15cGFzc3dvcmQ=");
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.body = "[\"2012-01-01T00:00:00.000/2012-01-03T00:00:00.000\", \"2012-01-05T00:00:00.000/2012-01-07T00:00:00.000\"]";
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/proxy/coordinator%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.path})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.method);
        AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.headers.forEach(connection::setRequestProperty);
        connection.setDoOutput(true);
        OutputStream os = connection.getOutputStream();
        os.write(AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.body.getBytes(StandardCharsets.UTF_8));
        os.close();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertTrue((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testOverlordPostTask() throws Exception {
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.path = "/druid/indexer/v1/task";
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.method = "POST";
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.headers = ImmutableMap.of((Object)"Authorization", (Object)"Basic bXl1c2VyOm15cGFzc3dvcmQ=", (Object)"Content-Type", (Object)"application/json");
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.body = "{\"type\": \"index\", \"spec\": \"stuffGoesHere\"}";
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.path})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.method);
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.headers.forEach(connection::setRequestProperty);
        connection.setDoOutput(true);
        OutputStream os = connection.getOutputStream();
        os.write(AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.body.getBytes(StandardCharsets.UTF_8));
        os.close();
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertTrue((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testOverlordTaskStatus() throws Exception {
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.path = "/druid/indexer/v1/task/myTaskId/status";
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.method = "GET";
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.headers = ImmutableMap.of((Object)"Authorization", (Object)"Basic bXl1c2VyOm15cGFzc3dvcmQ=");
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.path})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.method);
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.headers.forEach(connection::setRequestProperty);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertTrue((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testOverlordProxyLeader() throws Exception {
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.path = "/druid/indexer/v1/leader";
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.method = "GET";
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.headers = ImmutableMap.of((Object)"Authorization", (Object)"Basic bXl1c2VyOm15cGFzc3dvcmQ=");
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/proxy/overlord%s", (Object[])new Object[]{this.port, AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.path})).openConnection();
        connection.setRequestMethod(AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.method);
        AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.headers.forEach(connection::setRequestProperty);
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertTrue((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testProxyEnabledCheck() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/proxy/enabled", (Object[])new Object[]{this.port})).openConnection();
        connection.setRequestMethod("GET");
        Assert.assertEquals((long)200L, (long)connection.getResponseCode());
        byte[] bytes = new byte[connection.getContentLength()];
        Assert.assertEquals((long)connection.getInputStream().read(bytes), (long)connection.getContentLength());
        Assert.assertEquals((Object)ImmutableMap.of((Object)"enabled", (Object)true), (Object)new ObjectMapper().readValue(bytes, Map.class));
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testBadProxyDestination() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/proxy/other/status", (Object[])new Object[]{this.port})).openConnection();
        connection.setRequestMethod("GET");
        Assert.assertEquals((long)400L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testCoordinatorNoPath() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/proxy/coordinator", (Object[])new Object[]{this.port})).openConnection();
        connection.setRequestMethod("GET");
        Assert.assertEquals((long)403L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testOverlordNoPath() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/proxy/overlord", (Object[])new Object[]{this.port})).openConnection();
        connection.setRequestMethod("GET");
        Assert.assertEquals((long)403L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testCoordinatorLeaderUnknown() throws Exception {
        isValidLeader = false;
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/druid/coordinator/status", (Object[])new Object[]{this.port})).openConnection();
        connection.setRequestMethod("GET");
        Assert.assertEquals((long)503L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testOverlordLeaderUnknown() throws Exception {
        isValidLeader = false;
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/druid/indexer/status", (Object[])new Object[]{this.port})).openConnection();
        connection.setRequestMethod("GET");
        Assert.assertEquals((long)503L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
        isValidLeader = true;
    }

    @Test
    public void testUnsupportedProxyDestination() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/proxy/other/status2", (Object[])new Object[]{this.port})).openConnection();
        connection.setRequestMethod("GET");
        Assert.assertEquals((long)400L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    @Test
    public void testLocalRequest() throws Exception {
        HttpURLConnection connection = (HttpURLConnection)new URL(StringUtils.format((String)"http://localhost:%d/status", (Object[])new Object[]{this.port})).openConnection();
        connection.setRequestMethod("GET");
        Assert.assertEquals((long)404L, (long)connection.getResponseCode());
        Assert.assertFalse((String)"coordinator called", (boolean)AsyncManagementForwardingServletTest.COORDINATOR_EXPECTED_REQUEST.called);
        Assert.assertFalse((String)"overlord called", (boolean)AsyncManagementForwardingServletTest.OVERLORD_EXPECTED_REQUEST.called);
    }

    private static Server makeTestServer(int port, final ExpectedRequest expectedRequest) {
        Server server = new Server(port);
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        servletContextHandler.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                this.handle(req, resp);
            }

            protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                this.handle(req, resp);
            }

            protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                this.handle(req, resp);
            }

            protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                this.handle(req, resp);
            }

            private void handle(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                boolean passed = expectedRequest.path.equals(req.getRequestURI());
                passed &= expectedRequest.query == null || expectedRequest.query.equals(req.getQueryString());
                passed &= expectedRequest.method.equals(req.getMethod());
                if (expectedRequest.headers != null) {
                    for (Map.Entry<String, String> header : expectedRequest.headers.entrySet()) {
                        passed &= header.getValue().equals(req.getHeader(header.getKey()));
                    }
                }
                boolean bl = expectedRequest.body == null || expectedRequest.body.equals(IOUtils.toString((Reader)req.getReader()));
                expectedRequest.called = true;
                resp.setStatus((passed &= bl) ? 200 : 400);
            }
        }), "/*");
        server.setHandler((Supplier)servletContextHandler);
        return server;
    }

    private static class ExpectedRequest {
        private boolean called = false;
        private String path;
        private String query;
        private String method;
        private Map<String, String> headers;
        private String body;

        private ExpectedRequest() {
        }

        private void reset() {
            this.called = false;
            this.path = null;
            this.query = null;
            this.method = null;
            this.headers = null;
            this.body = null;
        }
    }

    public static class ProxyJettyServerInit
    implements JettyServerInitializer {
        public void initialize(Server server, Injector injector) {
            ServletContextHandler root = new ServletContextHandler(1);
            root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
            TestDruidLeaderSelector coordinatorLeaderSelector = new TestDruidLeaderSelector(){

                @Override
                public String getCurrentLeader() {
                    if (isValidLeader) {
                        return StringUtils.format((String)"http://localhost:%d", (Object[])new Object[]{coordinatorPort});
                    }
                    return null;
                }
            };
            TestDruidLeaderSelector overlordLeaderSelector = new TestDruidLeaderSelector(){

                @Override
                public String getCurrentLeader() {
                    if (isValidLeader) {
                        return StringUtils.format((String)"http://localhost:%d", (Object[])new Object[]{overlordPort});
                    }
                    return null;
                }
            };
            ServletHolder holder = new ServletHolder((Servlet)new AsyncManagementForwardingServlet((ObjectMapper)injector.getInstance(ObjectMapper.class), injector.getProvider(HttpClient.class), (DruidHttpClientConfig)injector.getInstance(DruidHttpClientConfig.class), (DruidLeaderSelector)coordinatorLeaderSelector, (DruidLeaderSelector)overlordLeaderSelector, new AuthorizerMapper((Map)ImmutableMap.of((Object)"allowAll", (Object)new AllowAllAuthorizer()))));
            holder.setInitParameter("maxThreads", "256");
            root.addServlet(holder, "/druid/coordinator/*");
            root.addServlet(holder, "/druid/indexer/*");
            root.addServlet(holder, "/proxy/*");
            AuthenticationUtils.addAuthenticationFilterChain((ServletContextHandler)root, (List)ImmutableList.of((Object)new AllowAllAuthenticator()));
            JettyServerInitUtils.addExtensionFilters((ServletContextHandler)root, (Injector)injector);
            Handler.Sequence handlerList = new Handler.Sequence(new Handler[]{JettyServerInitUtils.wrapWithDefaultGzipHandler((ServletContextHandler)root, (int)4096, (int)-1)});
            server.setHandler((Handler)handlerList);
        }
    }

    private static class TestDruidLeaderSelector
    implements DruidLeaderSelector {
        private TestDruidLeaderSelector() {
        }

        @Nullable
        public String getCurrentLeader() {
            return null;
        }

        public boolean isLeader() {
            return false;
        }

        public int localTerm() {
            return 0;
        }

        public void registerListener(DruidLeaderSelector.Listener listener) {
        }

        public void unregisterListener() {
        }
    }
}

