/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Druids;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChestTestHelper;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.UnionDataSource;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.union.UnionQuery;
import org.apache.druid.segment.FrameBasedInlineSegmentWrangler;
import org.apache.druid.segment.InlineSegmentWrangler;
import org.apache.druid.segment.MapSegmentWrangler;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.FrameBasedInlineJoinableFactory;
import org.apache.druid.segment.join.InlineJoinableFactory;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.segment.join.MapJoinableFactory;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.server.ClientQuerySegmentWalker;
import org.apache.druid.server.ObservableQueryScheduler;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ClientQuerySegmentWalkerTest {
    private static final Logger log = new Logger(ClientQuerySegmentWalkerTest.class);
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    private static final String MULTI = "multi";
    private static final String GLOBAL = "broadcast";
    private static final String ARRAY = "array";
    private static final String ARRAY_UNKNOWN = "array_nulls";
    private static final Interval INTERVAL = Intervals.of((String)"2000/P1Y");
    private static final String VERSION = "A";
    private static final ShardSpec SHARD_SPEC = new NumberedShardSpec(0, 1);
    private static final InlineDataSource FOO_INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.builder().add((Object)new Object[]{INTERVAL.getStartMillis(), "x", 1}).add((Object)new Object[]{INTERVAL.getStartMillis(), "x", 2}).add((Object)new Object[]{INTERVAL.getStartMillis(), "y", 3}).add((Object)new Object[]{INTERVAL.getStartMillis(), "z", 4}).build(), (RowSignature)RowSignature.builder().addTimeColumn().add("s", ColumnType.STRING).add("n", ColumnType.LONG).build());
    private static final InlineDataSource BAR_INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.builder().add((Object)new Object[]{INTERVAL.getStartMillis(), "a", 1}).add((Object)new Object[]{INTERVAL.getStartMillis(), "a", 2}).add((Object)new Object[]{INTERVAL.getStartMillis(), "b", 3}).add((Object)new Object[]{INTERVAL.getStartMillis(), "c", 4}).build(), (RowSignature)RowSignature.builder().addTimeColumn().add("s", ColumnType.STRING).add("n", ColumnType.LONG).build());
    private static final InlineDataSource MULTI_VALUE_INLINE = InlineDataSource.fromIterable((Iterable)ImmutableList.builder().add((Object)new Object[]{INTERVAL.getStartMillis(), ImmutableList.of((Object)"a", (Object)"b"), 1}).add((Object)new Object[]{INTERVAL.getStartMillis(), ImmutableList.of((Object)"a", (Object)"c"), 2}).add((Object)new Object[]{INTERVAL.getStartMillis(), ImmutableList.of((Object)"b"), 3}).add((Object)new Object[]{INTERVAL.getStartMillis(), ImmutableList.of((Object)"c"), 4}).build(), (RowSignature)RowSignature.builder().addTimeColumn().add("s", ColumnType.STRING).add("n", ColumnType.LONG).build());
    private static final List<Object[]> ARRAY_INLINE_ROWS = ImmutableList.builder().add((Object)new Object[]{INTERVAL.getStartMillis(), "x", 1, ImmutableList.of((Object)1.0, (Object)2.0), ImmutableList.of((Object)1L, (Object)2L), ImmutableList.of((Object)"1.0", (Object)"2.0")}).add((Object)new Object[]{INTERVAL.getStartMillis(), "x", 2, ImmutableList.of((Object)2.0, (Object)4.0), ImmutableList.of((Object)2L, (Object)4L), ImmutableList.of((Object)"2.0", (Object)"4.0")}).add((Object)new Object[]{INTERVAL.getStartMillis(), "y", 3, ImmutableList.of((Object)3.0, (Object)6.0), ImmutableList.of((Object)3L, (Object)6L), ImmutableList.of((Object)"3.0", (Object)"6.0")}).add((Object)new Object[]{INTERVAL.getStartMillis(), "z", 4, ImmutableList.of((Object)4.0, (Object)8.0), ImmutableList.of((Object)4L, (Object)8L), ImmutableList.of((Object)"4.0", (Object)"8.0")}).build();
    private static final InlineDataSource ARRAY_INLINE = InlineDataSource.fromIterable(ARRAY_INLINE_ROWS, (RowSignature)RowSignature.builder().addTimeColumn().add("s", ColumnType.STRING).add("n", ColumnType.LONG).add("ad", ColumnType.DOUBLE_ARRAY).add("al", ColumnType.LONG_ARRAY).add("as", ColumnType.STRING_ARRAY).build());
    private static final InlineDataSource ARRAY_INLINE_UNKNOWN = InlineDataSource.fromIterable(ARRAY_INLINE_ROWS, (RowSignature)RowSignature.builder().addTimeColumn().add("s", ColumnType.STRING).add("n", ColumnType.LONG).add("ad", null).add("al", null).add("as", null).build());
    private static final String DUMMY_QUERY_ID = "dummyQueryId";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private Closer closer;
    private QueryRunnerFactoryConglomerate conglomerate;
    private final StubServiceEmitter emitter = new StubServiceEmitter();
    private final List<ExpectedQuery> issuedQueries = new ArrayList<ExpectedQuery>();
    private ClientQuerySegmentWalker walker;
    private ObservableQueryScheduler scheduler;

    @Before
    public void setUp() {
        this.closer = Closer.create();
        this.emitter.flush();
        this.conglomerate = QueryStackTests.createQueryRunnerFactoryConglomerate(this.closer);
        this.scheduler = new ObservableQueryScheduler(8, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)NoQueryLaningStrategy.INSTANCE, new ServerConfig(false));
        this.initWalker((Map<String, String>)ImmutableMap.of(), this.scheduler);
    }

    @After
    public void tearDown() throws IOException {
        this.closer.close();
    }

    @Test
    public void testTimeseriesOnTable() {
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource(FOO).granularity(Granularities.ALL).intervals(Collections.singletonList(INTERVAL)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "n")}).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)false)).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{INTERVAL.getStartMillis(), 10L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTimeseriesOnAutomaticGlobalTable() {
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource(GLOBAL).granularity(Granularities.ALL).intervals(Collections.singletonList(INTERVAL)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "n")}).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)false)).build().withId(DUMMY_QUERY_ID);
        TimeseriesQuery expectedClusterQuery = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new GlobalTableDataSource(GLOBAL)).granularity(Granularities.ALL).intervals(Collections.singletonList(INTERVAL)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "n")}).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)false)).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(expectedClusterQuery)), (List<Object[]>)ImmutableList.of((Object)new Object[]{INTERVAL.getStartMillis(), 10L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTimeseriesOnInline() {
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)FOO_INLINE).granularity(Granularities.ALL).intervals(Collections.singletonList(INTERVAL)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "n")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.local(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{INTERVAL.getStartMillis(), 10L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTimeseriesOnGroupByOnTable() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource(FOO).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).build();
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)subquery)).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)new ArrayList<ExpectedQuery>((Collection<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withId(DUMMY_QUERY_ID).withSubQueryId("1.1")), (Object)ExpectedQuery.local(query.withDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"x"}, (Object)new Object[]{"y"}, (Object)new Object[]{"z"}), (RowSignature)RowSignature.builder().add("s", ColumnType.STRING).build()))))), (List<Object[]>)ImmutableList.of((Object)new Object[]{Intervals.ETERNITY.getStartMillis(), 3L}));
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testGroupByOnGroupByOnTable() {
        GroupByQuery subquery = (GroupByQuery)GroupByQuery.builder().setDataSource(FOO).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).build().withId("queryId");
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)subquery)).setGranularity(Granularities.ALL).setInterval((List)Intervals.ONLY_ETERNITY).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withSubQueryId("1.1"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testGroupByOnGroupByOnInlineTable() {
        GroupByQuery subquery = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)FOO_INLINE).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).build().withId("queryId");
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)subquery)).setGranularity(Granularities.ALL).setInterval((List)Intervals.ONLY_ETERNITY).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.local(query.withDataSource((DataSource)new QueryDataSource(subquery.withSubQueryId("1.1"))))), (List<Object[]>)ImmutableList.of((Object)new Object[]{3L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testGroupByOnUnionOfTwoTables() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource(FOO), (Object)new TableDataSource(BAR)))).setGranularity(Granularities.ALL).setInterval((List)Intervals.ONLY_ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query.withDataSource((DataSource)new TableDataSource(FOO)).withSubQueryId("foo.1")), (Object)ExpectedQuery.cluster(query.withDataSource((DataSource)new TableDataSource(BAR)).withSubQueryId("bar.2"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 2L}, (Object)new Object[]{"b", 1L}, (Object)new Object[]{"c", 1L}, (Object)new Object[]{"x", 2L}, (Object)new Object[]{"y", 1L}, (Object)new Object[]{"z", 1L}));
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testGroupByOnUnionOfOneTable() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource(FOO)))).setGranularity(Granularities.ALL).setInterval((List)Intervals.ONLY_ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query.withDataSource((DataSource)new TableDataSource(FOO)))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"x", 2L}, (Object)new Object[]{"y", 1L}, (Object)new Object[]{"z", 1L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testJoinOnGroupByOnTable() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource(FOO).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).setDimFilter((DimFilter)new SelectorDimFilter("s", "y", null)).build();
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource(FOO), (DataSource)new QueryDataSource((Query)subquery), (String)"j.", (String)"\"j.s\" == \"s\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)new JoinableFactoryWrapper(QueryStackTests.makeJoinableFactoryFromDefault(null, null, null)), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).setGranularity(Granularities.ALL).setInterval((List)Intervals.ONLY_ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s"), DefaultDimensionSpec.of((String)"j.s")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withId(DUMMY_QUERY_ID).withSubQueryId("2.1")), (Object)ExpectedQuery.cluster(query.withDataSource(query.getDataSource().withChildren((List)ImmutableList.of((Object)((DataSource)query.getDataSource().getChildren().get(0)), (Object)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"y"}), (RowSignature)RowSignature.builder().add("s", ColumnType.STRING).build())))))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"y", "y", 1L}));
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testJoinOnGroupByOnUnionOfTables() {
        UnionDataSource unionDataSource = new UnionDataSource((List)ImmutableList.of((Object)new TableDataSource(FOO), (Object)new TableDataSource(BAR)));
        GroupByQuery subquery = GroupByQuery.builder().setDataSource((DataSource)unionDataSource).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).setDimFilter((DimFilter)new SelectorDimFilter("s", "y", null)).build();
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)JoinDataSource.create((DataSource)unionDataSource, (DataSource)new QueryDataSource((Query)subquery), (String)"j.", (String)"\"j.s\" == \"s\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), (JoinableFactoryWrapper)new JoinableFactoryWrapper(QueryStackTests.makeJoinableFactoryFromDefault(null, null, null)), (JoinAlgorithm)JoinAlgorithm.BROADCAST)).setGranularity(Granularities.ALL).setInterval((List)Intervals.ONLY_ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s"), DefaultDimensionSpec.of((String)"j.s")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withDataSource((DataSource)subquery.getDataSource().getChildren().get(0)).withId(DUMMY_QUERY_ID).withSubQueryId("2.1.foo.1")), (Object)ExpectedQuery.cluster(subquery.withDataSource((DataSource)subquery.getDataSource().getChildren().get(1)).withId(DUMMY_QUERY_ID).withSubQueryId("2.1.bar.2")), (Object)ExpectedQuery.cluster(query.withDataSource(query.getDataSource().withChildren((List)ImmutableList.of((Object)((DataSource)unionDataSource.getChildren().get(0)), (Object)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"y"}), (RowSignature)RowSignature.builder().add("s", ColumnType.STRING).build())))).withSubQueryId("foo.1")), (Object)ExpectedQuery.cluster(query.withDataSource(query.getDataSource().withChildren((List)ImmutableList.of((Object)((DataSource)unionDataSource.getChildren().get(1)), (Object)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"y"}), (RowSignature)RowSignature.builder().add("s", ColumnType.STRING).build())))).withSubQueryId("bar.2"))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"y", "y", 1L}));
        Assert.assertEquals((long)4L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)4L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)4L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)4L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testGroupByOnScanMultiValue() {
        ScanQuery subquery = new Druids.ScanQueryBuilder().dataSource(MULTI).columns(new String[]{"s", "n"}).eternityInterval().resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)new QueryDataSource((Query)subquery)).setGranularity(Granularities.ALL).setInterval((List)Intervals.ONLY_ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).setAggregatorSpecs(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_n", "n")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withId(DUMMY_QUERY_ID).withSubQueryId("1.1")), (Object)ExpectedQuery.local(query.withDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"c"), 2}, (Object)new Object[]{ImmutableList.of((Object)"b"), 3}, (Object)new Object[]{ImmutableList.of((Object)"c"), 4}), (RowSignature)RowSignature.builder().add("s", null).add("n", null).build())))), (List<Object[]>)ImmutableList.of((Object)new Object[]{"a", 3L}, (Object)new Object[]{"b", 4L}, (Object)new Object[]{"c", 6L}));
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTopNScanMultiValue() {
        ScanQuery subquery = new Druids.ScanQueryBuilder().dataSource(MULTI).columns(new String[]{"s", "n"}).eternityInterval().resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build();
        TopNQuery query = (TopNQuery)new TopNQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)subquery)).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"s")).metric("sum_n").threshold(100).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_n", "n")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withId(DUMMY_QUERY_ID).withSubQueryId("1.1")), (Object)ExpectedQuery.local(query.withDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{ImmutableList.of((Object)"a", (Object)"b"), 1}, (Object)new Object[]{ImmutableList.of((Object)"a", (Object)"c"), 2}, (Object)new Object[]{ImmutableList.of((Object)"b"), 3}, (Object)new Object[]{ImmutableList.of((Object)"c"), 4}), (RowSignature)RowSignature.builder().add("s", null).add("n", null).build())))), (List<Object[]>)ImmutableList.of((Object)new Object[]{Intervals.ETERNITY.getStartMillis(), "c", 6L}, (Object)new Object[]{Intervals.ETERNITY.getStartMillis(), "b", 4L}, (Object)new Object[]{Intervals.ETERNITY.getStartMillis(), "a", 3L}));
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testJoinOnTableErrorCantInlineTable() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource((DataSource)JoinDataSource.create((DataSource)new TableDataSource(FOO), (DataSource)new TableDataSource(BAR), (String)"j.", (String)"\"j.s\" == \"s\"", (JoinType)JoinType.INNER, null, (ExprMacroTable)ExprMacroTable.nil(), null, (JoinAlgorithm)JoinAlgorithm.BROADCAST)).setGranularity(Granularities.ALL).setInterval((List)Intervals.ONLY_ETERNITY).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s"), DefaultDimensionSpec.of((String)"j.s")}).setAggregatorSpecs(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Cannot handle subquery structure for dataSource");
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testTimeseriesOnGroupByOnTableErrorTooManyRows() {
        this.initWalker((Map<String, String>)ImmutableMap.of((Object)"maxSubqueryRows", (Object)"2"));
        GroupByQuery subquery = GroupByQuery.builder().setDataSource(FOO).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).build();
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)subquery)).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.expectedException.expect(ResourceLimitExceededException.class);
        this.expectedException.expectMessage("Cannot issue the query, subqueries generated results beyond maximum[2] rows. Try setting the 'maxSubqueryBytes' in the query context to 'auto' for enabling byte based limit, which chooses an optimal limit based on memory size and result's heap usage or manually configure the values of either 'maxSubqueryBytes' or 'maxSubqueryRows' in the query context. Manually alter the value carefully as it can cause the broker to go out of memory.");
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testScanOnScanWithStringExpression() {
        this.initWalker((Map<String, String>)ImmutableMap.of((Object)"maxSubqueryRows", (Object)"1", (Object)"maxSubqueryBytes", (Object)"1000"), this.scheduler);
        Query subquery = Druids.newScanQueryBuilder().dataSource(FOO).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY)).columns(new String[]{"s"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build().withId(DUMMY_QUERY_ID);
        Query query = Druids.newScanQueryBuilder().dataSource((DataSource)new QueryDataSource(subquery)).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY)).virtualColumns(new VirtualColumn[]{new ExpressionVirtualColumn("v", "case_searched(s == 'x',2,3)", ColumnType.LONG, ExprMacroTable.nil())}).columns(new String[]{"v"}).resultFormat(ScanQuery.ResultFormat.RESULT_FORMAT_COMPACTED_LIST).build().withId(DUMMY_QUERY_ID);
        this.testQuery(query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withId(DUMMY_QUERY_ID).withSubQueryId("1.1")), (Object)ExpectedQuery.local(query.withDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"x"}, (Object)new Object[]{"x"}, (Object)new Object[]{"y"}, (Object)new Object[]{"z"}), (RowSignature)RowSignature.builder().add("s", null).build())))), (List<Object[]>)ImmutableList.of((Object)new Object[]{2L}, (Object)new Object[]{2L}, (Object)new Object[]{3L}, (Object)new Object[]{3L}));
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTimeseriesOnGroupByOnTableErrorTooLarge() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource(FOO).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).build();
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)subquery)).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).context((Map)ImmutableMap.of((Object)"maxSubqueryBytes", (Object)"1")).build().withId(DUMMY_QUERY_ID);
        this.expectedException.expect(ResourceLimitExceededException.class);
        this.expectedException.expectMessage("Cannot issue the query, subqueries generated results beyond maximum[1] bytes. Increase the JVM's memory or set the 'maxSubqueryBytes' in the query context to increase the space allocated for subqueries to materialize their results. Manually alter the value carefully as it can cause the broker to go out of memory.");
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of(), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testMetricsWithMaxSubqueryRowsEnabled() {
        GroupByQuery subquery = GroupByQuery.builder().setDataSource(FOO).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).build();
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)subquery)).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)new ArrayList<ExpectedQuery>((Collection<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withId(DUMMY_QUERY_ID).withSubQueryId("1.1")), (Object)ExpectedQuery.local(query.withDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"x"}, (Object)new Object[]{"y"}, (Object)new Object[]{"z"}), (RowSignature)RowSignature.builder().add("s", ColumnType.STRING).build()))))), (List<Object[]>)ImmutableList.of((Object)new Object[]{Intervals.ETERNITY.getStartMillis(), 3L}));
        for (ServiceMetricEvent event : this.emitter.getMetricEvents("subquery/rows")) {
            EventMap map = event.toMap();
            if (!"subquery/rows".equals(map.get((Object)"metric"))) continue;
            Assert.assertTrue((boolean)map.containsKey((Object)"host"));
            Assert.assertTrue((boolean)map.containsKey((Object)"service"));
            Assert.assertEquals((Object)DUMMY_QUERY_ID, (Object)map.get((Object)"id"));
            Assert.assertEquals((Object)"1.1", (Object)map.get((Object)"subQueryId"));
            Assert.assertEquals((Object)3, (Object)map.get((Object)"value"));
        }
    }

    @Test
    public void testMetricsWithMaxSubqueryBytesEnabled() {
        EventMap map;
        GroupByQuery subquery = GroupByQuery.builder().setDataSource(FOO).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"s")}).build();
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource((DataSource)new QueryDataSource((Query)subquery)).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("cnt")}).context((Map)ImmutableMap.of((Object)"maxSubqueryBytes", (Object)"10000")).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)new ArrayList<ExpectedQuery>((Collection<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subquery.withId(DUMMY_QUERY_ID).withSubQueryId("1.1")), (Object)ExpectedQuery.local(query.withDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{"x"}, (Object)new Object[]{"y"}, (Object)new Object[]{"z"}), (RowSignature)RowSignature.builder().add("s", ColumnType.STRING).build()))))), (List<Object[]>)ImmutableList.of((Object)new Object[]{Intervals.ETERNITY.getStartMillis(), 3L}));
        for (ServiceMetricEvent event : this.emitter.getMetricEvents("subquery/rows")) {
            map = event.toMap();
            Assert.assertTrue((boolean)map.containsKey((Object)"host"));
            Assert.assertTrue((boolean)map.containsKey((Object)"service"));
            Assert.assertEquals((Object)DUMMY_QUERY_ID, (Object)map.get((Object)"id"));
            Assert.assertEquals((Object)"1.1", (Object)map.get((Object)"subQueryId"));
            Assert.assertEquals((Object)3, (Object)map.get((Object)"value"));
        }
        for (ServiceMetricEvent event : this.emitter.getMetricEvents("subquery/bytes")) {
            map = event.toMap();
            Assert.assertTrue((boolean)map.containsKey((Object)"host"));
            Assert.assertTrue((boolean)map.containsKey((Object)"service"));
            Assert.assertEquals((Object)DUMMY_QUERY_ID, (Object)map.get((Object)"id"));
            Assert.assertEquals((Object)"1.1", (Object)map.get((Object)"subQueryId"));
            Assert.assertEquals((Object)43L, (Object)map.get((Object)"value"));
        }
    }

    @Test
    public void testGroupByOnArraysDoubles() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("ad", "ad", ColumnType.DOUBLE_ARRAY)}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{new Object[]{1.0, 2.0}}, (Object)new Object[]{new Object[]{2.0, 4.0}}, (Object)new Object[]{new Object[]{3.0, 6.0}}, (Object)new Object[]{new Object[]{4.0, 8.0}}));
    }

    @Test
    public void testGroupByOnArraysDoublesAsString() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"ad")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.toString(new Object[]{1.0, 2.0})}, (Object)new Object[]{Arrays.toString(new Object[]{2.0, 4.0})}, (Object)new Object[]{Arrays.toString(new Object[]{3.0, 6.0})}, (Object)new Object[]{Arrays.toString(new Object[]{4.0, 8.0})}));
    }

    @Test
    public void testGroupByOnArraysUnknownDoubles() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY_UNKNOWN).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"ad")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1.0"}, (Object)new Object[]{"2.0"}, (Object)new Object[]{"3.0"}, (Object)new Object[]{"4.0"}, (Object)new Object[]{"6.0"}, (Object)new Object[]{"8.0"}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testGroupByOnArraysLongs() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("al", "al", ColumnType.LONG_ARRAY)}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{new Object[]{1L, 2L}}, (Object)new Object[]{new Object[]{2L, 4L}}, (Object)new Object[]{new Object[]{3L, 6L}}, (Object)new Object[]{new Object[]{4L, 8L}}));
    }

    @Test
    public void testGroupByOnArraysLongsAsString() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"al")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.toString(new Object[]{1L, 2L})}, (Object)new Object[]{Arrays.toString(new Object[]{2L, 4L})}, (Object)new Object[]{Arrays.toString(new Object[]{3L, 6L})}, (Object)new Object[]{Arrays.toString(new Object[]{4L, 8L})}));
    }

    @Test
    public void testGroupByOnArraysUnknownLongs() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY_UNKNOWN).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"al")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1"}, (Object)new Object[]{"2"}, (Object)new Object[]{"3"}, (Object)new Object[]{"4"}, (Object)new Object[]{"6"}, (Object)new Object[]{"8"}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testGroupByOnArraysStrings() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{new DefaultDimensionSpec("as", "as", ColumnType.STRING_ARRAY)}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{new Object[]{"1.0", "2.0"}}, (Object)new Object[]{new Object[]{"2.0", "4.0"}}, (Object)new Object[]{new Object[]{"3.0", "6.0"}}, (Object)new Object[]{new Object[]{"4.0", "8.0"}}));
    }

    @Test
    public void testGroupByOnArraysStringsasString() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"as")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{Arrays.toString(new Object[]{"1.0", "2.0"})}, (Object)new Object[]{Arrays.toString(new Object[]{"2.0", "4.0"})}, (Object)new Object[]{Arrays.toString(new Object[]{"3.0", "6.0"})}, (Object)new Object[]{Arrays.toString(new Object[]{"4.0", "8.0"})}));
    }

    @Test
    public void testGroupByOnArraysUnknownStrings() {
        GroupByQuery query = (GroupByQuery)GroupByQuery.builder().setDataSource(ARRAY_UNKNOWN).setGranularity(Granularities.ALL).setInterval(Collections.singletonList(INTERVAL)).setDimensions(new DimensionSpec[]{DefaultDimensionSpec.of((String)"as")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{"1.0"}, (Object)new Object[]{"2.0"}, (Object)new Object[]{"3.0"}, (Object)new Object[]{"4.0"}, (Object)new Object[]{"6.0"}, (Object)new Object[]{"8.0"}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTopNArraysDoubles() {
        TopNQuery query = (TopNQuery)new TopNQueryBuilder().dataSource(ARRAY).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"ad")).metric("sum_n").threshold(1000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_n", "n")}).build().withId(DUMMY_QUERY_ID);
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Cannot create query type helper from invalid type [ARRAY<DOUBLE>]");
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testTopNOnArraysUnknownDoubles() {
        TopNQuery query = (TopNQuery)new TopNQueryBuilder().dataSource(ARRAY_UNKNOWN).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"ad")).metric("sum_n").threshold(1000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_n", "n")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "4.0", 6L}, (Object)new Object[]{946684800000L, "8.0", 4L}, (Object)new Object[]{946684800000L, "2.0", 3L}, (Object)new Object[]{946684800000L, "3.0", 3L}, (Object)new Object[]{946684800000L, "6.0", 3L}, (Object)new Object[]{946684800000L, "1.0", 1L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTopNOnArraysLongs() {
        TopNQuery query = (TopNQuery)new TopNQueryBuilder().dataSource(ARRAY).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"al")).metric("sum_n").threshold(1000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_n", "n")}).build().withId(DUMMY_QUERY_ID);
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Cannot create query type helper from invalid type [ARRAY<LONG>]");
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testTopNOnArraysUnknownLongs() {
        TopNQuery query = (TopNQuery)new TopNQueryBuilder().dataSource(ARRAY_UNKNOWN).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"al")).metric("sum_n").threshold(1000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_n", "n")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "4", 6L}, (Object)new Object[]{946684800000L, "8", 4L}, (Object)new Object[]{946684800000L, "2", 3L}, (Object)new Object[]{946684800000L, "3", 3L}, (Object)new Object[]{946684800000L, "6", 3L}, (Object)new Object[]{946684800000L, "1", 1L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTopNOnArraysStrings() {
        TopNQuery query = (TopNQuery)new TopNQueryBuilder().dataSource(ARRAY).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"as")).metric("sum_n").threshold(1000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_n", "n")}).build().withId(DUMMY_QUERY_ID);
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Cannot create query type helper from invalid type [ARRAY<STRING>]");
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of());
    }

    @Test
    public void testTopNOnArraysUnknownStrings() {
        TopNQuery query = (TopNQuery)new TopNQueryBuilder().dataSource(ARRAY_UNKNOWN).granularity(Granularities.ALL).intervals((List)Intervals.ONLY_ETERNITY).dimension((DimensionSpec)DefaultDimensionSpec.of((String)"as")).metric("sum_n").threshold(1000).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_n", "n")}).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{946684800000L, "4.0", 6L}, (Object)new Object[]{946684800000L, "8.0", 4L}, (Object)new Object[]{946684800000L, "2.0", 3L}, (Object)new Object[]{946684800000L, "3.0", 3L}, (Object)new Object[]{946684800000L, "6.0", 3L}, (Object)new Object[]{946684800000L, "1.0", 1L}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTimeseriesOnArrays() {
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource(ARRAY).granularity(Granularities.ALL).intervals(Collections.singletonList(INTERVAL)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "al")}).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)false)).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{INTERVAL.getStartMillis(), null}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testTimeseriesOnArraysUnknown() {
        TimeseriesQuery query = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource(ARRAY_UNKNOWN).granularity(Granularities.ALL).intervals(Collections.singletonList(INTERVAL)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "al")}).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)false)).build().withId(DUMMY_QUERY_ID);
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(query)), (List<Object[]>)ImmutableList.of((Object)new Object[]{INTERVAL.getStartMillis(), null}));
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalReleased().get());
    }

    @Test
    public void testUnionQuery() {
        TimeseriesQuery subQuery1 = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource(FOO).granularity(Granularities.ALL).intervals(Collections.singletonList(INTERVAL)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "n")}).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)false)).build().withId(DUMMY_QUERY_ID);
        TimeseriesQuery subQuery2 = (TimeseriesQuery)Druids.newTimeseriesQueryBuilder().dataSource(BAR).granularity(Granularities.ALL).intervals(Collections.singletonList(INTERVAL)).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum", "n")}).context((Map)ImmutableMap.of((Object)"grandTotal", (Object)false)).build().withId(DUMMY_QUERY_ID);
        ScanQuery query = Druids.newScanQueryBuilder().columns(new String[]{"sum"}).intervals((QuerySegmentSpec)new MultipleIntervalSegmentSpec(Collections.singletonList(Intervals.ETERNITY))).dataSource((Query)new UnionQuery((List)ImmutableList.of((Object)subQuery1, (Object)subQuery2))).build();
        this.testQuery((Query)query, (List<ExpectedQuery>)ImmutableList.of((Object)ExpectedQuery.cluster(subQuery1.withSubQueryId("1.1")), (Object)ExpectedQuery.cluster(subQuery2.withSubQueryId("1.1")), (Object)ExpectedQuery.local(query.withDataSource((DataSource)InlineDataSource.fromIterable((Iterable)ImmutableList.of((Object)new Object[]{946684800000L, 10L}, (Object)new Object[]{946684800000L, 10L}), (RowSignature)RowSignature.builder().add("__time", ColumnType.LONG).add("sum", ColumnType.LONG).build())))), (List<Object[]>)ImmutableList.of((Object)new Object[]{10L}, (Object)new Object[]{10L}));
        Assert.assertEquals((long)3L, (long)this.scheduler.getTotalRun().get());
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalPrioritizedAndLaned().get());
        Assert.assertEquals((long)3L, (long)this.scheduler.getTotalAcquired().get());
        Assert.assertEquals((long)3L, (long)this.scheduler.getTotalReleased().get());
    }

    private void initWalker(Map<String, String> serverProperties) {
        this.initWalker(serverProperties, QueryStackTests.DEFAULT_NOOP_SCHEDULER);
    }

    private void initWalker(Map<String, String> serverProperties, QueryScheduler schedulerForTest) {
        ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
        ServerConfig serverConfig = (ServerConfig)jsonMapper.convertValue(serverProperties, ServerConfig.class);
        MapSegmentWrangler segmentWrangler = new MapSegmentWrangler((Map)ImmutableMap.builder().put(InlineDataSource.class, (Object)new InlineSegmentWrangler()).put(FrameBasedInlineDataSource.class, (Object)new FrameBasedInlineSegmentWrangler()).build());
        JoinableFactory globalFactory = new JoinableFactory(){

            public boolean isDirectlyJoinable(DataSource dataSource) {
                return ((GlobalTableDataSource)dataSource).getName().equals(ClientQuerySegmentWalkerTest.GLOBAL);
            }

            public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
                return Optional.empty();
            }
        };
        MapJoinableFactory joinableFactory = new MapJoinableFactory((Set)ImmutableSet.of((Object)globalFactory, (Object)new InlineJoinableFactory(), (Object)new FrameBasedInlineJoinableFactory()), (Map)ImmutableMap.builder().put(InlineJoinableFactory.class, InlineDataSource.class).put(FrameBasedInlineJoinableFactory.class, FrameBasedInlineDataSource.class).put(globalFactory.getClass(), GlobalTableDataSource.class).build());
        JoinableFactoryWrapper joinableFactoryWrapper = new JoinableFactoryWrapper((JoinableFactory)joinableFactory);
        Injector injector = QueryStackTests.injectorWithLookup();
        class CapturingWalker
        implements QuerySegmentWalker {
            private QuerySegmentWalker baseWalker;
            private ClusterOrLocal how;

            CapturingWalker(QuerySegmentWalker baseWalker, ClusterOrLocal how) {
                this.baseWalker = baseWalker;
                this.how = how;
            }

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                QueryRunner baseRunner = this.baseWalker.getQueryRunnerForIntervals(query, intervals);
                return (queryPlus, responseContext) -> {
                    log.info("Query (%s): %s", new Object[]{this.how, queryPlus.getQuery()});
                    ClientQuerySegmentWalkerTest.this.issuedQueries.add(new ExpectedQuery(queryPlus.getQuery(), this.how));
                    return baseRunner.run(queryPlus, responseContext);
                };
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                QueryRunner baseRunner = this.baseWalker.getQueryRunnerForSegments(query, specs);
                return (queryPlus, responseContext) -> {
                    log.info("Query (%s): %s", new Object[]{this.how, queryPlus.getQuery()});
                    ClientQuerySegmentWalkerTest.this.issuedQueries.add(new ExpectedQuery(queryPlus.getQuery(), this.how));
                    return baseRunner.run(queryPlus, responseContext);
                };
            }
        }
        this.walker = QueryStackTests.createClientQuerySegmentWalker(injector, new CapturingWalker(QueryStackTests.createClusterQuerySegmentWalker(Map.of(FOO, ClientQuerySegmentWalkerTest.makeTimeline(FOO), BAR, ClientQuerySegmentWalkerTest.makeTimeline(BAR), MULTI, ClientQuerySegmentWalkerTest.makeTimeline(MULTI), GLOBAL, ClientQuerySegmentWalkerTest.makeTimeline(GLOBAL), ARRAY, ClientQuerySegmentWalkerTest.makeTimeline(ARRAY), ARRAY_UNKNOWN, ClientQuerySegmentWalkerTest.makeTimeline(ARRAY_UNKNOWN)), Map.of(ClientQuerySegmentWalkerTest.makeDataSegment(FOO), ClientQuerySegmentWalkerTest.makeReferenceProvider(FOO_INLINE), ClientQuerySegmentWalkerTest.makeDataSegment(BAR), ClientQuerySegmentWalkerTest.makeReferenceProvider(BAR_INLINE), ClientQuerySegmentWalkerTest.makeDataSegment(MULTI), ClientQuerySegmentWalkerTest.makeReferenceProvider(MULTI_VALUE_INLINE), ClientQuerySegmentWalkerTest.makeDataSegment(GLOBAL), ClientQuerySegmentWalkerTest.makeReferenceProvider(FOO_INLINE), ClientQuerySegmentWalkerTest.makeDataSegment(ARRAY), ClientQuerySegmentWalkerTest.makeReferenceProvider(ARRAY_INLINE), ClientQuerySegmentWalkerTest.makeDataSegment(ARRAY_UNKNOWN), ClientQuerySegmentWalkerTest.makeReferenceProvider(ARRAY_INLINE_UNKNOWN)), this.conglomerate, schedulerForTest, injector), ClusterOrLocal.CLUSTER), new CapturingWalker((QuerySegmentWalker)QueryStackTests.createLocalQuerySegmentWalker(this.conglomerate, (SegmentWrangler)segmentWrangler, joinableFactoryWrapper, schedulerForTest, (ServiceEmitter)this.emitter), ClusterOrLocal.LOCAL), this.conglomerate, (JoinableFactory)joinableFactory, serverConfig, (ServiceEmitter)this.emitter);
    }

    private <T> void testQuery(Query<T> query, List<ExpectedQuery> expectedQueries, List<Object[]> expectedResults) {
        this.issuedQueries.clear();
        Sequence resultSequence = QueryPlus.wrap(query).run((QuerySegmentWalker)this.walker, ResponseContext.createEmpty());
        List arrays = this.conglomerate.findFactory(query).getToolchest().resultsAsArrays(query, resultSequence).toList();
        for (Object[] array : arrays) {
            log.info("Result: %s", new Object[]{Arrays.toString(array)});
        }
        QueryToolChestTestHelper.assertArrayResultsEquals(expectedResults, (Sequence)Sequences.simple((Iterable)arrays));
        Assert.assertEquals(expectedQueries, this.issuedQueries);
    }

    private static DataSegment makeDataSegment(String name) {
        SegmentId segmentId = SegmentId.of((String)name, (Interval)INTERVAL, (String)VERSION, (ShardSpec)SHARD_SPEC);
        return DataSegment.builder((SegmentId)segmentId).shardSpec(SHARD_SPEC).size(1L).build();
    }

    private static ReferenceCountedSegmentProvider makeReferenceProvider(InlineDataSource dataSource) {
        return ReferenceCountedSegmentProvider.of((Segment)new RowBasedSegment(Sequences.simple((Iterable)dataSource.getRows()), dataSource.rowAdapter(), dataSource.getRowSignature()));
    }

    private static VersionedIntervalTimeline<String, DataSegment> makeTimeline(String name) {
        VersionedIntervalTimeline timeline = new VersionedIntervalTimeline(Comparator.naturalOrder());
        timeline.add(INTERVAL, (Object)VERSION, SHARD_SPEC.createChunk((Object)ClientQuerySegmentWalkerTest.makeDataSegment(name)));
        return timeline;
    }

    private static class ExpectedQuery {
        private final Query<?> query;
        private final ClusterOrLocal how;

        ExpectedQuery(Query<?> query, ClusterOrLocal how) {
            ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
            contextBuilder.put((Object)"queryFailTime", (Object)0L).put((Object)"defaultTimeout", (Object)0L).put((Object)"finalize", (Object)true).put((Object)"maxScatterGatherBytes", (Object)0L).put((Object)"sortByDimsFirst", (Object)false).put((Object)"resultAsArray", (Object)true).put((Object)"applyLimitPushDown", (Object)true).put((Object)"groupByOutermost", (Object)true).put((Object)"fudgeTimestamp", (Object)"1979").put((Object)"queryResourceId", (Object)"dummy").put((Object)"serialization", (Object)"blast");
            Query modifiedQuery = query.withOverriddenContext((Map)contextBuilder.build());
            if (modifiedQuery.getDataSource() instanceof FrameBasedInlineDataSource) {
                try {
                    modifiedQuery = modifiedQuery.withDataSource((DataSource)TestHelper.JSON_MAPPER.readValue(TestHelper.JSON_MAPPER.writeValueAsBytes((Object)modifiedQuery.getDataSource()), DataSource.class));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            this.query = modifiedQuery;
            this.how = how;
        }

        static ExpectedQuery local(Query<?> query) {
            return new ExpectedQuery(query, ClusterOrLocal.LOCAL);
        }

        static ExpectedQuery cluster(Query<?> query) {
            return new ExpectedQuery(query, ClusterOrLocal.CLUSTER);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExpectedQuery that = (ExpectedQuery)o;
            return Objects.equals(this.query, that.query) && this.how == that.how;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.query, this.how});
        }

        public String toString() {
            return "ExpectedQuery{query=" + this.query + ", how=" + this.how + "}";
        }
    }

    private static enum ClusterOrLocal {
        CLUSTER,
        LOCAL;

    }
}

