/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.guava.YieldingAccumulator;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.query.BadJsonQueryException;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.DefaultQueryRunnerFactoryConglomerate;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TruncatedResponseContextException;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NullFilter;
import org.apache.druid.query.policy.NoopPolicyEnforcer;
import org.apache.druid.query.policy.Policy;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.policy.RowFilterPolicy;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryLifecycle;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryPrioritizationStrategy;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResourceQueryResultPusherFactory;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.ResourceIOReaderWriterFactory;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.mocks.ExceptionalInputStream;
import org.apache.druid.server.mocks.MockHttpServletRequest;
import org.apache.druid.server.mocks.MockHttpServletResponse;
import org.apache.druid.server.scheduling.HiLoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ThresholdBasedQueryPrioritizationStrategy;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.eclipse.jetty.http.HttpHeader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class QueryResourceTest {
    private static final DefaultQueryRunnerFactoryConglomerate CONGLOMERATE = DefaultQueryRunnerFactoryConglomerate.buildFromQueryRunnerFactories((Map)ImmutableMap.of());
    private static final AuthenticationResult AUTHENTICATION_RESULT = new AuthenticationResult("druid", "druid", null, null);
    private final MockHttpServletRequest testServletRequest = new MockHttpServletRequest();
    private static final QuerySegmentWalker TEST_SEGMENT_WALKER = new QuerySegmentWalker(){

        public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
            return (queryPlus, responseContext) -> Sequences.empty();
        }

        public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
            return this.getQueryRunnerForIntervals(null, null);
        }
    };
    private static final String SIMPLE_TIMESERIES_QUERY = "{\n    \"queryType\": \"timeseries\",\n    \"dataSource\": \"mmx_metrics\",\n    \"granularity\": \"hour\",\n    \"intervals\": [\n      \"2014-12-17/2015-12-30\"\n    ],\n    \"aggregations\": [\n      {\n        \"type\": \"count\",\n        \"name\": \"rows\"\n      }\n    ]\n}";
    private static final String SIMPLE_TIMESERIES_QUERY_SMALLISH_INTERVAL = "{\n    \"queryType\": \"timeseries\",\n    \"dataSource\": \"mmx_metrics\",\n    \"granularity\": \"hour\",\n    \"intervals\": [\n      \"2014-12-17/2014-12-30\"\n    ],\n    \"aggregations\": [\n      {\n        \"type\": \"count\",\n        \"name\": \"rows\"\n      }\n    ]\n}";
    private static final String SIMPLE_TIMESERIES_QUERY_LOW_PRIORITY = "{\n    \"queryType\": \"timeseries\",\n    \"dataSource\": \"mmx_metrics\",\n    \"granularity\": \"hour\",\n    \"intervals\": [\n      \"2014-12-17/2015-12-30\"\n    ],\n    \"aggregations\": [\n      {\n        \"type\": \"count\",\n        \"name\": \"rows\"\n      }\n    ],\n    \"context\": { \"priority\": -1 }}";
    private static final String SIMPLE_TIMESERIES_QUERY_WRITE_EXCEPTION_AS_ROW = "{\n    \"queryType\": \"timeseries\",\n    \"dataSource\": \"mmx_metrics\",\n    \"granularity\": \"hour\",\n    \"intervals\": [\n      \"2014-12-17/2015-12-30\"\n    ],\n    \"aggregations\": [\n      {\n        \"type\": \"count\",\n        \"name\": \"rows\"\n      }\n    ],\n    \"context\": { \"writeExceptionBodyAsResponseRow\": \"true\" }}";
    private static final ServiceEmitter NOOP_SERVICE_EMITTER = new NoopServiceEmitter();
    private static final DruidNode DRUID_NODE = new DruidNode("broker", "localhost", true, Integer.valueOf(8082), null, true, false);
    private ObjectMapper jsonMapper;
    private ObjectMapper smileMapper;
    private QueryResource queryResource;
    private QueryScheduler queryScheduler;
    private TestRequestLogger testRequestLogger;
    private StubServiceEmitter emitter;

    @BeforeClass
    public static void staticSetup() {
        EmittingLogger.registerEmitter((ServiceEmitter)NOOP_SERVICE_EMITTER);
    }

    @Before
    public void setup() {
        Injector injector = GuiceInjectors.makeStartupInjector();
        this.jsonMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        this.smileMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Smile.class));
        this.testServletRequest.contentType = "application/json";
        this.testServletRequest.headers.put("Accept", "application/json");
        this.testServletRequest.remoteAddr = "localhost";
        this.queryScheduler = QueryStackTests.DEFAULT_NOOP_SCHEDULER;
        this.testRequestLogger = new TestRequestLogger();
        this.emitter = new StubServiceEmitter();
        this.queryResource = this.createQueryResource(ResponseContextConfig.newConfig((boolean)true));
    }

    private QueryResource createQueryResource(ResponseContextConfig responseContextConfig) {
        return new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, responseContextConfig, DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
    }

    @Test
    public void testGoodQuery() throws IOException {
        this.expectPermissiveHappyPathAuth();
        MockHttpServletResponse servletResponse = this.expectAsyncRequestFlow(SIMPLE_TIMESERIES_QUERY);
        Assert.assertEquals((long)200L, (long)servletResponse.getStatus());
        Assert.assertTrue((boolean)servletResponse.containsHeader(HttpHeader.TRAILER.toString()));
        Map fields = (Map)servletResponse.getTrailerFields().get();
        Assert.assertFalse((boolean)fields.containsKey("X-Error-Message"));
        Assert.assertTrue((boolean)fields.containsKey("X-Druid-Response-Complete"));
        Assert.assertEquals(fields.get("X-Druid-Response-Complete"), (Object)"true");
    }

    @Test
    public void testGoodQueryWithQueryConfigOverrideDefault() throws IOException {
        String overrideConfigKey = "priority";
        String overrideConfigValue = "678";
        DefaultQueryConfig overrideConfig = new DefaultQueryConfig((Map)ImmutableMap.of((Object)"priority", (Object)"678"));
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)overrideConfig)), this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        this.expectPermissiveHappyPathAuth();
        MockHttpServletResponse response = this.expectAsyncRequestFlow(SIMPLE_TIMESERIES_QUERY);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        List responses = (List)this.jsonMapper.readValue(response.baos.toByteArray(), (TypeReference)new TypeReference<List<Result<TimeBoundaryResultValue>>>(){});
        Assert.assertEquals((long)0L, (long)responses.size());
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getNativeQuerylogs().size());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext());
        Assert.assertTrue((boolean)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().containsKey("priority"));
        Assert.assertEquals((Object)"678", this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().get("priority"));
    }

    @Test
    public void testGoodQueryThrowsDruidExceptionFromLifecycleExecute() throws IOException {
        String overrideConfigKey = "priority";
        String overrideConfigValue = "678";
        DefaultQueryConfig overrideConfig = new DefaultQueryConfig((Map)ImmutableMap.of((Object)overrideConfigKey, (Object)overrideConfigValue));
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build("failing for coverage!", new Object[0]);
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                throw new UnsupportedOperationException();
            }
        }, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)overrideConfig)), this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        this.expectPermissiveHappyPathAuth();
        Response response = this.expectSynchronousRequestFlow(SIMPLE_TIMESERIES_QUERY);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((Object)500, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
        ErrorResponse entity = (ErrorResponse)response.getEntity();
        MatcherAssert.assertThat((Object)entity.getUnderlyingException(), (Matcher)new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.RUNTIME_FAILURE, "general").expectMessageIs("failing for coverage!"));
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getNativeQuerylogs().size());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext());
        Assert.assertTrue((boolean)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().containsKey(overrideConfigKey));
        Assert.assertEquals((Object)overrideConfigValue, this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().get(overrideConfigKey));
    }

    @Test
    public void testResponseWithIncludeTrailerHeader() throws IOException {
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                return (queryPlus, responseContext) -> new Sequence<T>(){

                    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                        if (accumulator instanceof QueryResultPusher.StreamingHttpResponseAccumulator) {
                            try {
                                ((QueryResultPusher.StreamingHttpResponseAccumulator)accumulator).flush();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw new QueryTimeoutException();
                    }

                    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                        return Yielders.done(initValue, null);
                    }
                };
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                throw new UnsupportedOperationException();
            }
        }, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        this.expectPermissiveHappyPathAuth();
        MockHttpServletResponse response = this.expectAsyncRequestFlow(this.testServletRequest, SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8), this.queryResource);
        Assert.assertTrue((boolean)response.containsHeader(HttpHeader.TRAILER.toString()));
        Assert.assertEquals((Object)response.getHeader(HttpHeader.TRAILER.toString()), (Object)"X-Druid-Response-Complete");
        Map fields = (Map)response.getTrailerFields().get();
        Assert.assertTrue((boolean)fields.containsKey("X-Error-Message"));
        Assert.assertEquals(fields.get("X-Error-Message"), (Object)"Query did not complete within configured timeout period. You can increase query timeout or tune the performance of query.");
        Assert.assertTrue((boolean)fields.containsKey("X-Druid-Response-Complete"));
        Assert.assertEquals(fields.get("X-Druid-Response-Complete"), (Object)"false");
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((Object)504, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testResponseWithMidFlightExceptions() throws IOException {
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                return (queryPlus, responseContext) -> new Sequence<T>(){

                    public <OutType> OutType accumulate(OutType initValue, Accumulator<OutType, T> accumulator) {
                        accumulator.accumulate(null, (Object)new TimeBoundaryResultValue((Object)ImmutableMap.of((Object)"maxTime", (Object)DateTimes.of((String)"2014-08-02"))));
                        throw InvalidInput.exception((String)"mid-flight exception", (Object[])new Object[0]);
                    }

                    public <OutType> Yielder<OutType> toYielder(OutType initValue, YieldingAccumulator<OutType, T> accumulator) {
                        throw new UnsupportedOperationException("not implemented");
                    }
                };
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                throw new UnsupportedOperationException();
            }
        }, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        this.expectPermissiveHappyPathAuth();
        MockHttpServletResponse response = this.expectAsyncRequestFlow(this.testServletRequest, SIMPLE_TIMESERIES_QUERY_WRITE_EXCEPTION_AS_ROW.getBytes(StandardCharsets.UTF_8), this.queryResource);
        String actualOutput = response.baos.toString(Charset.defaultCharset());
        Assert.assertEquals((Object)"[{\"maxTime\":\"2014-08-02T00:00:00.000Z\"},{\"error\":\"druidException\",\"errorCode\":\"invalidInput\",\"persona\":\"USER\",\"category\":\"INVALID_INPUT\",\"errorMessage\":\"mid-flight exception\",\"context\":{}}]", (Object)actualOutput);
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((Object)400, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testResponseContextContainsMissingSegments_whenLastSegmentIsMissing() throws IOException {
        final SegmentDescriptor missingSegDesc = new SegmentDescriptor(Intervals.of((String)"2025-01-01/P1D"), "0", 1);
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                return (queryPlus, responseContext) -> new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

                    public Iterator<T> make() {
                        List<ImmutableMap> data = Collections.singletonList(ImmutableMap.of((Object)"dummy", (Object)1));
                        final Iterator<ImmutableMap> realIterator = data.iterator();
                        return new Iterator<T>(){
                            private boolean done = false;

                            @Override
                            public boolean hasNext() {
                                if (realIterator.hasNext()) {
                                    return true;
                                }
                                if (!this.done) {
                                    responseContext.addMissingSegments((List)ImmutableList.of((Object)missingSegDesc));
                                    this.done = true;
                                }
                                return false;
                            }

                            @Override
                            public T next() {
                                return realIterator.next();
                            }
                        };
                    }

                    public void cleanup(Iterator<T> iterFromMake) {
                    }
                });
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                throw new UnsupportedOperationException();
            }
        }, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        this.expectPermissiveHappyPathAuth();
        MockHttpServletResponse response = this.expectAsyncRequestFlow(this.testServletRequest, SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8), this.queryResource);
        Assert.assertTrue((boolean)response.containsHeader(HttpHeader.TRAILER.toString()));
        Assert.assertEquals((Object)"X-Druid-Response-Complete", (Object)response.getHeader(HttpHeader.TRAILER.toString()));
        Map fields = (Map)response.getTrailerFields().get();
        Assert.assertTrue((boolean)response.containsHeader("X-Druid-Response-Context"));
        Assert.assertEquals((Object)this.jsonMapper.writeValueAsString((Object)ImmutableMap.of((Object)"missingSegments", (Object)ImmutableList.of((Object)missingSegDesc))), (Object)response.getHeader("X-Druid-Response-Context"));
        Assert.assertTrue((boolean)fields.containsKey("X-Druid-Response-Complete"));
        Assert.assertEquals((Object)"true", fields.get("X-Druid-Response-Complete"));
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((Object)200, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testQueryThrowsRuntimeExceptionFromLifecycleExecute() throws IOException {
        final String embeddedExceptionMessage = "Embedded Exception Message!";
        String overrideConfigKey = "priority";
        String overrideConfigValue = "678";
        final DefaultQueryConfig overrideConfig = new DefaultQueryConfig((Map)ImmutableMap.of((Object)overrideConfigKey, (Object)overrideConfigValue));
        final QuerySegmentWalker querySegmentWalker = new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                throw new RuntimeException("something", new RuntimeException(embeddedExceptionMessage));
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                throw new UnsupportedOperationException();
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory(null, null, null, null, null, null, (PolicyEnforcer)NoopPolicyEnforcer.instance(), null, Suppliers.ofInstance((Object)overrideConfig)){

            public QueryLifecycle factorize() {
                return new QueryLifecycle((QueryRunnerFactoryConglomerate)CONGLOMERATE, querySegmentWalker, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)QueryResourceTest.this.emitter, QueryResourceTest.this.testRequestLogger, AuthTestUtils.TEST_AUTHORIZER_MAPPER, overrideConfig, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), System.currentTimeMillis(), System.nanoTime()){

                    public void emitLogsAndMetrics(@Nullable Throwable e, @Nullable String remoteAddress, long bytesWritten) {
                        super.emitLogsAndMetrics(e, remoteAddress, bytesWritten);
                        Assert.assertTrue((boolean)Throwables.getStackTraceAsString((Throwable)e).contains(embeddedExceptionMessage));
                    }
                };
            }
        }, this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        this.expectPermissiveHappyPathAuth();
        Response response = this.expectSynchronousRequestFlow(SIMPLE_TIMESERIES_QUERY);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
        ErrorResponse entity = (ErrorResponse)response.getEntity();
        MatcherAssert.assertThat((Object)entity.getUnderlyingException(), (Matcher)new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.RUNTIME_FAILURE, "legacyQueryException").expectMessageIs("something"));
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((Object)500, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testGoodQueryWithQueryConfigDoesNotOverrideQueryContext() throws IOException {
        String overrideConfigKey = "priority";
        String overrideConfigValue = "678";
        DefaultQueryConfig overrideConfig = new DefaultQueryConfig((Map)ImmutableMap.of((Object)overrideConfigKey, (Object)overrideConfigValue));
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)overrideConfig)), this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        this.expectPermissiveHappyPathAuth();
        MockHttpServletResponse response = this.expectAsyncRequestFlow(SIMPLE_TIMESERIES_QUERY_LOW_PRIORITY);
        List responses = (List)this.jsonMapper.readValue(response.baos.toByteArray(), (TypeReference)new TypeReference<List<Result<TimeBoundaryResultValue>>>(){});
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)responses.size());
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getNativeQuerylogs().size());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext());
        Assert.assertTrue((boolean)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().containsKey(overrideConfigKey));
        Assert.assertEquals((Object)-1, this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().get(overrideConfigKey));
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((Object)200, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testTruncatedResponseContextShouldFail() throws IOException {
        this.expectPermissiveHappyPathAuth();
        QueryResource queryResource = this.createQueryResource(ResponseContextConfig.forTest((boolean)true, (int)0));
        MockHttpServletResponse response = this.expectAsyncRequestFlow(this.testServletRequest, SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8), queryResource);
        Assert.assertEquals((long)1L, (long)queryResource.getInterruptedQueryCount());
        Assert.assertEquals((long)500L, (long)response.getStatus());
        String expectedException = new QueryInterruptedException((Throwable)new TruncatedResponseContextException("Serialized response context exceeds the max size[0]", new Object[0]), DRUID_NODE.getHostAndPortToUse()).toString();
        Assert.assertEquals((Object)expectedException, (Object)((QueryInterruptedException)((Object)this.jsonMapper.readValue(response.baos.toByteArray(), QueryInterruptedException.class))).toString());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((Object)500, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testTruncatedResponseContextShouldSucceed() throws IOException {
        this.expectPermissiveHappyPathAuth();
        QueryResource queryResource = this.createQueryResource(ResponseContextConfig.forTest((boolean)false, (int)0));
        MockHttpServletResponse response = this.expectAsyncRequestFlow(this.testServletRequest, SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8), queryResource);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((long)1L, (long)queryResource.getSuccessfulQueryCount());
        Assert.assertEquals((Object)200, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testGoodQueryWithNullAcceptHeader() throws IOException {
        this.testServletRequest.headers.remove("Accept");
        this.expectPermissiveHappyPathAuth();
        MockHttpServletResponse response = this.expectAsyncRequestFlow(SIMPLE_TIMESERIES_QUERY);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((long)1L, (long)this.queryResource.getSuccessfulQueryCount());
        Assert.assertEquals((Object)200, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testGoodQueryWithEmptyAcceptHeader() throws IOException {
        this.expectPermissiveHappyPathAuth();
        this.testServletRequest.headers.put("Accept", "");
        MockHttpServletResponse response = this.expectAsyncRequestFlow(SIMPLE_TIMESERIES_QUERY);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((long)1L, (long)this.queryResource.getSuccessfulQueryCount());
        Assert.assertEquals((Object)200, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testGoodQueryWithJsonRequestAndSmileAcceptHeader() throws IOException {
        this.expectPermissiveHappyPathAuth();
        this.testServletRequest.headers.put("Accept", "application/x-jackson-smile");
        MockHttpServletResponse response = this.expectAsyncRequestFlow(SIMPLE_TIMESERIES_QUERY);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/x-jackson-smile", (Object)response.getContentType());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((long)1L, (long)this.queryResource.getSuccessfulQueryCount());
        Assert.assertEquals((Object)200, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testGoodQueryWithSmileRequestAndSmileAcceptHeader() throws IOException {
        this.testServletRequest.contentType = "application/x-jackson-smile";
        this.expectPermissiveHappyPathAuth();
        this.testServletRequest.headers.put("Accept", "application/x-jackson-smile");
        MockHttpServletResponse response = this.expectAsyncRequestFlow(this.testServletRequest, this.smileMapper.writeValueAsBytes((Object)this.jsonMapper.readTree(SIMPLE_TIMESERIES_QUERY)));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/x-jackson-smile", (Object)response.getContentType());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((long)1L, (long)this.queryResource.getSuccessfulQueryCount());
        Assert.assertEquals((Object)200, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testGoodQueryWithSmileRequestNoSmileAcceptHeader() throws IOException {
        this.testServletRequest.contentType = "application/x-jackson-smile";
        this.expectPermissiveHappyPathAuth();
        this.testServletRequest.headers.remove("Accept");
        MockHttpServletResponse response = this.expectAsyncRequestFlow(this.testServletRequest, this.smileMapper.writeValueAsBytes((Object)this.jsonMapper.readTree(SIMPLE_TIMESERIES_QUERY)));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/x-jackson-smile", (Object)response.getContentType());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((long)1L, (long)this.queryResource.getSuccessfulQueryCount());
        Assert.assertEquals((Object)200, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test
    public void testBadQuery() throws IOException {
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream("Meka Leka Hi Meka Hiney Ho".getBytes(StandardCharsets.UTF_8)), null, (HttpServletRequest)this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        QueryException e = (QueryException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryException.class);
        Assert.assertEquals((Object)"Json parse failed", (Object)e.getErrorCode());
        Assert.assertEquals((Object)BadJsonQueryException.ERROR_CLASS, (Object)e.getErrorClass());
    }

    @Test
    public void testResourceLimitExceeded() throws IOException {
        Response response = this.queryResource.doPost((InputStream)new ExceptionalInputStream(() -> new ResourceLimitExceededException("You require too much of something")), null, (HttpServletRequest)this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        QueryException e = (QueryException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryException.class);
        Assert.assertEquals((Object)"Resource limit exceeded", (Object)e.getErrorCode());
        Assert.assertEquals((Object)ResourceLimitExceededException.class.getName(), (Object)e.getErrorClass());
    }

    @Test
    public void testUnsupportedQueryThrowsException() throws IOException {
        String errorMessage = "This will be support in Druid 9999";
        Response response = this.queryResource.doPost((InputStream)new ExceptionalInputStream(() -> new QueryUnsupportedException(errorMessage)), null, (HttpServletRequest)this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)501L, (long)response.getStatus());
        QueryException ex = (QueryException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryException.class);
        Assert.assertEquals((Object)errorMessage, (Object)ex.getMessage());
        Assert.assertEquals((Object)"Unsupported query", (Object)ex.getErrorCode());
    }

    @Test
    public void testSecuredQuery() throws Exception {
        this.expectPermissiveHappyPathAuth();
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (resource.getName().equals("allow")) {
                            return Access.allowWithRestriction((Policy)RowFilterPolicy.from((DimFilter)new NullFilter("col", null)));
                        }
                        return new Access(false);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), authMapper, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.queryScheduler, authMapper, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        try {
            this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, (HttpServletRequest)this.testServletRequest.mimic());
            Assert.fail((String)"doPost did not throw ForbiddenException for an unauthorized query");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        MockHttpServletResponse response = this.expectAsyncRequestFlow("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\"}", this.testServletRequest.mimic());
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        List responses = (List)this.jsonMapper.readValue(response.baos.toByteArray(), (TypeReference)new TypeReference<List<Result<TimeBoundaryResultValue>>>(){});
        Assert.assertEquals((long)0L, (long)responses.size());
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getNativeQuerylogs().size());
        Assert.assertEquals((Object)true, this.testRequestLogger.getNativeQuerylogs().get(0).getQueryStats().getStats().get("success"));
        Assert.assertEquals((Object)"druid", this.testRequestLogger.getNativeQuerylogs().get(0).getQueryStats().getStats().get("identity"));
    }

    @Test
    public void testQueryTimeoutException() throws Exception {
        QuerySegmentWalker timeoutSegmentWalker = new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                throw new QueryTimeoutException();
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                return this.getQueryRunnerForIntervals(null, null);
            }
        };
        QueryResource timeoutQueryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, timeoutSegmentWalker, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.queryScheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.jsonMapper));
        this.expectPermissiveHappyPathAuth();
        Response response = this.expectSynchronousRequestFlow(this.testServletRequest, SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8), timeoutQueryResource);
        Assert.assertEquals((long)504L, (long)response.getStatus());
        ErrorResponse entity = (ErrorResponse)response.getEntity();
        MatcherAssert.assertThat((Object)entity.getUnderlyingException(), (Matcher)new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.TIMEOUT, "legacyQueryException").expectMessageIs("Query did not complete within configured timeout period. You can increase query timeout or tune the performance of query."));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.jsonMapper.writeValue((OutputStream)baos, (Object)entity);
        QueryTimeoutException ex = (QueryTimeoutException)((Object)this.jsonMapper.readValue(baos.toByteArray(), QueryTimeoutException.class));
        Assert.assertEquals((Object)"Query did not complete within configured timeout period. You can increase query timeout or tune the performance of query.", (Object)ex.getMessage());
        Assert.assertEquals((Object)"Query timeout", (Object)ex.getErrorCode());
        Assert.assertEquals((long)1L, (long)timeoutQueryResource.getTimedOutQueryCount());
        this.emitter.verifyEmitted("query/time", 1);
        Assert.assertEquals((Object)504, (Object)((ServiceMetricEvent)this.emitter.getMetricEvents("query/time").get(0)).toMap().get((Object)"statusCode"));
    }

    @Test(timeout=60000L)
    public void testSecuredCancelQuery() throws Exception {
        final CountDownLatch waitForCancellationLatch = new CountDownLatch(1);
        CountDownLatch waitFinishLatch = new CountDownLatch(2);
        final CountDownLatch startAwaitLatch = new CountDownLatch(1);
        final CountDownLatch cancelledCountDownLatch = new CountDownLatch(1);
        this.expectPermissiveHappyPathAuth();
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (action.equals((Object)Action.READ)) {
                            try {
                                startAwaitLatch.countDown();
                                waitForCancellationLatch.await();
                            }
                            catch (InterruptedException e) {
                                cancelledCountDownLatch.countDown();
                                throw new QueryInterruptedException((Throwable)e);
                            }
                            return new Access(true);
                        }
                        return new Access(true);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), authMapper, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.queryScheduler, authMapper, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        String queryString = "{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}";
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query query = (Query)mapper.readValue("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}", Query.class);
        AtomicReference responseFromEndpoint = new AtomicReference();
        ListenableFuture future = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"test_query_resource_%s")).submit(() -> {
            try {
                responseFromEndpoint.set(this.queryResource.doPost((InputStream)new ByteArrayInputStream("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}".getBytes(StandardCharsets.UTF_8)), null, (HttpServletRequest)this.testServletRequest));
                Response response = null;
                return response;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                waitFinishLatch.countDown();
            }
        });
        this.queryScheduler.registerQueryFuture(query, future);
        startAwaitLatch.await();
        Executors.newSingleThreadExecutor().submit(() -> {
            Response response = this.queryResource.cancelQuery("id_1", (HttpServletRequest)this.testServletRequest);
            Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)response.getStatus());
            waitForCancellationLatch.countDown();
            waitFinishLatch.countDown();
        });
        waitFinishLatch.await();
        cancelledCountDownLatch.await();
        Assert.assertTrue((boolean)future.isCancelled());
        Response response = (Response)responseFromEndpoint.get();
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test(timeout=60000L)
    public void testDenySecuredCancelQuery() throws Exception {
        final CountDownLatch waitForCancellationLatch = new CountDownLatch(1);
        CountDownLatch waitFinishLatch = new CountDownLatch(2);
        CountDownLatch startAwaitLatch = new CountDownLatch(1);
        this.expectPermissiveHappyPathAuth();
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (action.equals((Object)Action.READ)) {
                            try {
                                waitForCancellationLatch.await();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            return new Access(true);
                        }
                        return new Access(false);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), authMapper, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.queryScheduler, authMapper, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
        String queryString = "{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}";
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query query = (Query)mapper.readValue("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}", Query.class);
        ListenableFuture future = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"test_query_resource_%s")).submit(() -> {
            try {
                startAwaitLatch.countDown();
                MockHttpServletRequest localRequest = this.testServletRequest.mimic();
                MockHttpServletResponse retVal = MockHttpServletResponse.forRequest(localRequest);
                this.queryResource.doPost((InputStream)new ByteArrayInputStream("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}".getBytes(StandardCharsets.UTF_8)), null, (HttpServletRequest)localRequest);
                MockHttpServletResponse mockHttpServletResponse = retVal;
                return mockHttpServletResponse;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                waitFinishLatch.countDown();
            }
        });
        this.queryScheduler.registerQueryFuture(query, future);
        startAwaitLatch.await();
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                this.queryResource.cancelQuery("id_1", (HttpServletRequest)this.testServletRequest.mimic());
            }
            catch (ForbiddenException e) {
                waitForCancellationLatch.countDown();
                waitFinishLatch.countDown();
            }
        });
        waitFinishLatch.await();
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)((HttpServletResponse)future.get()).getStatus());
    }

    @Test(timeout=10000L)
    public void testTooManyQuery() throws InterruptedException, ExecutionException {
        this.expectPermissiveHappyPathAuth();
        CountDownLatch waitTwoScheduled = new CountDownLatch(2);
        QueryScheduler laningScheduler = new QueryScheduler(2, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)NoQueryLaningStrategy.INSTANCE, new ServerConfig(false));
        ArrayList<Future<Boolean>> back2 = new ArrayList<Future<Boolean>>();
        this.createScheduledQueryResource(laningScheduler, Collections.emptyList(), (Collection<CountDownLatch>)ImmutableList.of((Object)waitTwoScheduled));
        back2.add(this.eventuallyAssertAsyncResponse(SIMPLE_TIMESERIES_QUERY, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus())));
        back2.add(this.eventuallyAssertAsyncResponse(SIMPLE_TIMESERIES_QUERY, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus())));
        waitTwoScheduled.await();
        back2.add(this.eventuallyaAssertSynchronousResponse(SIMPLE_TIMESERIES_QUERY, response -> {
            QueryCapacityExceededException ex;
            Assert.assertEquals((long)429L, (long)response.getStatus());
            ErrorResponse entity = (ErrorResponse)response.getEntity();
            MatcherAssert.assertThat((Object)entity.getUnderlyingException(), (Matcher)new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.CAPACITY_EXCEEDED, "legacyQueryException").expectMessageIs("Too many concurrent queries, total query capacity of 2 exceeded. Please try your query again later."));
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.jsonMapper.writeValue((OutputStream)baos, (Object)entity);
                ex = (QueryCapacityExceededException)this.jsonMapper.readValue(baos.toByteArray(), QueryCapacityExceededException.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((Object)QueryCapacityExceededException.makeTotalErrorMessage((int)2), (Object)ex.getMessage());
            Assert.assertEquals((Object)"Query capacity exceeded", (Object)ex.getErrorCode());
        }));
        for (Future future : back2) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
        Assert.assertEquals((long)2L, (long)this.queryResource.getSuccessfulQueryCount());
        Assert.assertEquals((long)1L, (long)this.queryResource.getFailedQueryCount());
        this.emitter.verifyEmitted("query/time", 3);
        Map<Integer, Long> codeFrequencies = this.emitter.getMetricEvents("query/time").stream().map(ServiceMetricEvent::toMap).map(map -> (int)((Integer)map.get((Object)"statusCode"))).collect(Collectors.groupingBy(code -> code, Collectors.counting()));
        Assert.assertEquals(Map.of(200, 2L, 429, 1L), codeFrequencies);
    }

    @Test(timeout=10000L)
    public void testTooManyQueryInLane() throws InterruptedException, ExecutionException {
        this.expectPermissiveHappyPathAuth();
        CountDownLatch waitTwoStarted = new CountDownLatch(2);
        CountDownLatch waitOneScheduled = new CountDownLatch(1);
        QueryScheduler scheduler = new QueryScheduler(40, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)new HiLoQueryLaningStrategy(Integer.valueOf(2)), new ServerConfig());
        ArrayList<Future<Boolean>> back2 = new ArrayList<Future<Boolean>>();
        this.createScheduledQueryResource(scheduler, (Collection<CountDownLatch>)ImmutableList.of((Object)waitTwoStarted), (Collection<CountDownLatch>)ImmutableList.of((Object)waitOneScheduled));
        back2.add(this.eventuallyAssertAsyncResponse(SIMPLE_TIMESERIES_QUERY_LOW_PRIORITY, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus())));
        waitOneScheduled.await();
        back2.add(this.eventuallyaAssertSynchronousResponse(SIMPLE_TIMESERIES_QUERY_LOW_PRIORITY, response -> {
            QueryCapacityExceededException ex;
            Assert.assertEquals((long)429L, (long)response.getStatus());
            ErrorResponse entity = (ErrorResponse)response.getEntity();
            MatcherAssert.assertThat((Object)entity.getUnderlyingException(), (Matcher)new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.CAPACITY_EXCEEDED, "legacyQueryException").expectMessageIs("Too many concurrent queries for lane 'low', query capacity of 1 exceeded. Please try your query again later."));
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.jsonMapper.writeValue((OutputStream)baos, (Object)entity);
                ex = (QueryCapacityExceededException)this.jsonMapper.readValue(baos.toByteArray(), QueryCapacityExceededException.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((Object)QueryCapacityExceededException.makeLaneErrorMessage((String)"low", (int)1), (Object)ex.getMessage());
            Assert.assertEquals((Object)"Query capacity exceeded", (Object)ex.getErrorCode());
        }));
        waitTwoStarted.await();
        back2.add(this.eventuallyAssertAsyncResponse(SIMPLE_TIMESERIES_QUERY, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus())));
        for (Future future : back2) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
        this.emitter.verifyEmitted("query/time", 3);
        Map<Integer, Long> codeFrequencies = this.emitter.getMetricEvents("query/time").stream().map(ServiceMetricEvent::toMap).map(map -> (int)((Integer)map.get((Object)"statusCode"))).collect(Collectors.groupingBy(code -> code, Collectors.counting()));
        Assert.assertEquals(Map.of(200, 2L, 429, 1L), codeFrequencies);
    }

    @Test(timeout=10000L)
    public void testTooManyQueryInLaneImplicitFromDurationThreshold() throws InterruptedException, ExecutionException {
        this.expectPermissiveHappyPathAuth();
        CountDownLatch waitTwoStarted = new CountDownLatch(2);
        CountDownLatch waitOneScheduled = new CountDownLatch(1);
        QueryScheduler scheduler = new QueryScheduler(40, (QueryPrioritizationStrategy)new ThresholdBasedQueryPrioritizationStrategy(null, "P90D", null, null, null), (QueryLaningStrategy)new HiLoQueryLaningStrategy(Integer.valueOf(1)), new ServerConfig());
        ArrayList<Future<Boolean>> back2 = new ArrayList<Future<Boolean>>();
        this.createScheduledQueryResource(scheduler, (Collection<CountDownLatch>)ImmutableList.of((Object)waitTwoStarted), (Collection<CountDownLatch>)ImmutableList.of((Object)waitOneScheduled));
        back2.add(this.eventuallyAssertAsyncResponse(SIMPLE_TIMESERIES_QUERY, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus())));
        waitOneScheduled.await();
        back2.add(this.eventuallyaAssertSynchronousResponse(SIMPLE_TIMESERIES_QUERY, response -> {
            QueryCapacityExceededException ex;
            Assert.assertEquals((long)429L, (long)response.getStatus());
            ErrorResponse entity = (ErrorResponse)response.getEntity();
            MatcherAssert.assertThat((Object)entity.getUnderlyingException(), (Matcher)new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.CAPACITY_EXCEEDED, "legacyQueryException").expectMessageIs("Too many concurrent queries for lane 'low', query capacity of 1 exceeded. Please try your query again later."));
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.jsonMapper.writeValue((OutputStream)baos, (Object)entity);
                ex = (QueryCapacityExceededException)this.jsonMapper.readValue(baos.toByteArray(), QueryCapacityExceededException.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((Object)QueryCapacityExceededException.makeLaneErrorMessage((String)"low", (int)1), (Object)ex.getMessage());
            Assert.assertEquals((Object)"Query capacity exceeded", (Object)ex.getErrorCode());
        }));
        waitTwoStarted.await();
        back2.add(this.eventuallyAssertAsyncResponse(SIMPLE_TIMESERIES_QUERY_SMALLISH_INTERVAL, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus())));
        for (Future future : back2) {
            Assert.assertTrue((boolean)((Boolean)future.get()));
        }
        this.emitter.verifyEmitted("query/time", 3);
        Map<Integer, Long> codeFrequencies = this.emitter.getMetricEvents("query/time").stream().map(ServiceMetricEvent::toMap).map(map -> (int)((Integer)map.get((Object)"statusCode"))).collect(Collectors.groupingBy(code -> code, Collectors.counting()));
        Assert.assertEquals(Map.of(200, 2L, 429, 1L), codeFrequencies);
    }

    @Test
    public void testNativeQueryWriter_goodResponse() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        QueryResource.NativeQueryWriter writer = new QueryResource.NativeQueryWriter(this.jsonMapper, (OutputStream)baos);
        writer.writeResponseStart();
        writer.writeRow(Arrays.asList("foo", "bar"));
        writer.writeRow(Collections.singletonList("baz"));
        writer.writeResponseEnd();
        writer.close();
        Assert.assertEquals((Object)ImmutableList.of((Object)ImmutableList.of((Object)"foo", (Object)"bar"), (Object)ImmutableList.of((Object)"baz")), (Object)this.jsonMapper.readValue(baos.toByteArray(), Object.class));
    }

    @Test
    public void testNativeQueryWriter_truncatedResponse() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        QueryResource.NativeQueryWriter writer = new QueryResource.NativeQueryWriter(this.jsonMapper, (OutputStream)baos);
        writer.writeResponseStart();
        writer.writeRow(Arrays.asList("foo", "bar"));
        writer.close();
        JsonProcessingException e = (JsonProcessingException)Assert.assertThrows(JsonProcessingException.class, () -> this.jsonMapper.readValue(baos.toByteArray(), Object.class));
        MatcherAssert.assertThat((Object)((Object)e), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"expected close marker for Array")));
    }

    private void createScheduledQueryResource(final QueryScheduler scheduler, final Collection<CountDownLatch> beforeScheduler, final Collection<CountDownLatch> inScheduler) {
        QuerySegmentWalker texasRanger = new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                return (queryPlus, responseContext) -> {
                    beforeScheduler.forEach(CountDownLatch::countDown);
                    return Sequences.simple((Iterable)scheduler.run(scheduler.prioritizeAndLaneQuery(queryPlus, (Set)ImmutableSet.of()), (Sequence)new LazySequence(() -> {
                        inScheduler.forEach(CountDownLatch::countDown);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return Sequences.empty();
                    })).toList());
                };
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                return this.getQueryRunnerForIntervals(null, null);
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory((QueryRunnerFactoryConglomerate)CONGLOMERATE, texasRanger, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)this.emitter, (RequestLogger)this.testRequestLogger, new AuthConfig(), (PolicyEnforcer)NoopPolicyEnforcer.instance(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, scheduler, null, new QueryResourceQueryResultPusherFactory(this.jsonMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE), new ResourceIOReaderWriterFactory(this.jsonMapper, this.smileMapper));
    }

    private Future<Boolean> eventuallyAssertAsyncResponse(String query, Consumer<MockHttpServletResponse> asserts) {
        return Executors.newSingleThreadExecutor().submit(() -> {
            try {
                asserts.accept(this.expectAsyncRequestFlow(query, this.testServletRequest.mimic()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        });
    }

    private void expectPermissiveHappyPathAuth() {
        this.testServletRequest.setAttribute("Druid-Authentication-Result", AUTHENTICATION_RESULT);
    }

    @Nonnull
    private MockHttpServletResponse expectAsyncRequestFlow(String simpleTimeseriesQuery) throws IOException {
        return this.expectAsyncRequestFlow(simpleTimeseriesQuery, this.testServletRequest);
    }

    @Nonnull
    private MockHttpServletResponse expectAsyncRequestFlow(String query, MockHttpServletRequest req) throws IOException {
        return this.expectAsyncRequestFlow(req, query.getBytes(StandardCharsets.UTF_8));
    }

    @Nonnull
    private MockHttpServletResponse expectAsyncRequestFlow(MockHttpServletRequest req, byte[] queryBytes) throws IOException {
        return this.expectAsyncRequestFlow(req, queryBytes, this.queryResource);
    }

    @Nonnull
    private MockHttpServletResponse expectAsyncRequestFlow(MockHttpServletRequest req, byte[] queryBytes, QueryResource queryResource) throws IOException {
        MockHttpServletResponse response = MockHttpServletResponse.forRequest(req);
        Assert.assertNull((Object)queryResource.doPost((InputStream)new ByteArrayInputStream(queryBytes), null, (HttpServletRequest)req));
        return response;
    }

    private Future<Boolean> eventuallyaAssertSynchronousResponse(String query, Consumer<Response> asserts) {
        return Executors.newSingleThreadExecutor().submit(() -> {
            try {
                asserts.accept(this.expectSynchronousRequestFlow(this.testServletRequest.mimic(), query.getBytes(StandardCharsets.UTF_8), this.queryResource));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        });
    }

    private Response expectSynchronousRequestFlow(String simpleTimeseriesQuery) throws IOException {
        return this.expectSynchronousRequestFlow(this.testServletRequest, simpleTimeseriesQuery.getBytes(StandardCharsets.UTF_8), this.queryResource);
    }

    private Response expectSynchronousRequestFlow(MockHttpServletRequest req, byte[] bytes, QueryResource queryResource) throws IOException {
        return queryResource.doPost((InputStream)new ByteArrayInputStream(bytes), null, (HttpServletRequest)req);
    }
}

