/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.QueryResultPusher;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.mocks.MockHttpServletRequest;
import org.junit.Assert;
import org.junit.Test;

public class QueryResultPusherTest {
    private static final DruidNode DRUID_NODE = new DruidNode("broker", "localhost", true, Integer.valueOf(8082), null, true, false);

    @Test
    public void testResultPusherRetainsNestedExceptionBacktraces() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
        ResponseContextConfig responseContextConfig = ResponseContextConfig.newConfig((boolean)true);
        DruidNode selfNode = DRUID_NODE;
        NoopQueryMetricCounter counter = new NoopQueryMetricCounter();
        String queryId = "someQuery";
        MediaType contentType = MediaType.APPLICATION_JSON_TYPE;
        HashMap extraHeaders = new HashMap();
        final AtomicBoolean recordFailureInvoked = new AtomicBoolean();
        final String embeddedExceptionMessage = "Embedded Exception Message!";
        RuntimeException embeddedException = new RuntimeException(embeddedExceptionMessage);
        final RuntimeException topException = new RuntimeException("Where's the party?", embeddedException);
        final QueryResultPusher.ResultsWriter resultWriter = new QueryResultPusher.ResultsWriter(){

            public void close() {
            }

            public Response.ResponseBuilder start() {
                throw topException;
            }

            public void recordSuccess(long numBytes) {
            }

            public void recordFailure(Exception e) {
                Assert.assertTrue((boolean)Throwables.getStackTraceAsString((Throwable)e).contains(embeddedExceptionMessage));
                recordFailureInvoked.set(true);
            }

            public QueryResultPusher.Writer makeWriter(OutputStream out) {
                return null;
            }

            public QueryResponse<Object> getQueryResponse() {
                return null;
            }
        };
        QueryResultPusher pusher = new QueryResultPusher(request, (ObjectMapper)jsonMapper, responseContextConfig, selfNode, counter, queryId, contentType, extraHeaders, Collections.emptyMap()){

            public void writeException(Exception e, OutputStream out) {
            }

            public QueryResultPusher.ResultsWriter start() {
                return resultWriter;
            }
        };
        pusher.push();
        Assert.assertTrue((String)"recordFailure(e) should have been invoked!", (boolean)recordFailureInvoked.get());
    }

    static class NoopQueryMetricCounter
    implements QueryResource.QueryMetricCounter {
        NoopQueryMetricCounter() {
        }

        public void incrementSuccess() {
        }

        public void incrementFailed() {
        }

        public void incrementInterrupted() {
        }

        public void incrementTimedOut() {
        }
    }
}

