/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.io.Closeables;
import com.google.inject.Injector;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.error.DruidException;
import org.apache.druid.query.FrameBasedInlineDataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.segment.FrameBasedInlineSegmentWrangler;
import org.apache.druid.segment.IncrementalIndexSegment;
import org.apache.druid.segment.InlineSegmentWrangler;
import org.apache.druid.segment.LookupSegmentWrangler;
import org.apache.druid.segment.MapSegmentWrangler;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexSegment;
import org.apache.druid.segment.ReferenceCountedSegmentProvider;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentWrangler;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.sql.calcite.util.datasets.TestDataSet;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.LinearShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;

public class SpecificSegmentsQuerySegmentWalker
implements QuerySegmentWalker,
Closeable {
    private final QuerySegmentWalker walker;
    private final Map<String, VersionedIntervalTimeline<String, DataSegment>> timelines;
    private final Map<DataSegment, ReferenceCountedSegmentProvider> referenceProviders;
    private final List<CompleteSegment> segments = new ArrayList<CompleteSegment>();
    private static final LookupExtractorFactoryContainerProvider LOOKUP_EXTRACTOR_FACTORY_CONTAINER_PROVIDER = new LookupExtractorFactoryContainerProvider(){

        public Set<String> getAllLookupNames() {
            return Collections.emptySet();
        }

        public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
            return Optional.empty();
        }

        public String getCanonicalLookupName(String lookupName) {
            return lookupName;
        }
    };

    public static SpecificSegmentsQuerySegmentWalker createWalker(QueryRunnerFactoryConglomerate conglomerate) {
        return SpecificSegmentsQuerySegmentWalker.createWalker(QueryStackTests.injectorWithLookup(), conglomerate);
    }

    public static SpecificSegmentsQuerySegmentWalker createWalker(Injector injector, QueryRunnerFactoryConglomerate conglomerate, SegmentWrangler segmentWrangler, JoinableFactoryWrapper joinableFactoryWrapper, QueryScheduler scheduler) {
        HashMap<String, VersionedIntervalTimeline<String, DataSegment>> timelines = new HashMap<String, VersionedIntervalTimeline<String, DataSegment>>();
        HashMap<DataSegment, ReferenceCountedSegmentProvider> referenceProviders = new HashMap<DataSegment, ReferenceCountedSegmentProvider>();
        NoopServiceEmitter emitter = new NoopServiceEmitter();
        ServerConfig serverConfig = new ServerConfig();
        return new SpecificSegmentsQuerySegmentWalker(timelines, referenceProviders, (QuerySegmentWalker)QueryStackTests.createClientQuerySegmentWalker(injector, QueryStackTests.createClusterQuerySegmentWalker(timelines, referenceProviders, conglomerate, scheduler, injector), (QuerySegmentWalker)QueryStackTests.createLocalQuerySegmentWalker(conglomerate, segmentWrangler, joinableFactoryWrapper, scheduler, emitter), conglomerate, joinableFactoryWrapper.getJoinableFactory(), serverConfig, emitter));
    }

    public static SpecificSegmentsQuerySegmentWalker createWalker(Injector injector, QueryRunnerFactoryConglomerate conglomerate) {
        return SpecificSegmentsQuerySegmentWalker.createWalker(injector, conglomerate, (SegmentWrangler)new MapSegmentWrangler((Map)ImmutableMap.builder().put(InlineDataSource.class, (Object)new InlineSegmentWrangler()).put(FrameBasedInlineDataSource.class, (Object)new FrameBasedInlineSegmentWrangler()).put(LookupDataSource.class, (Object)new LookupSegmentWrangler(LOOKUP_EXTRACTOR_FACTORY_CONTAINER_PROVIDER)).build()), new JoinableFactoryWrapper(QueryStackTests.makeJoinableFactoryForLookup(LOOKUP_EXTRACTOR_FACTORY_CONTAINER_PROVIDER)), QueryStackTests.DEFAULT_NOOP_SCHEDULER);
    }

    public SpecificSegmentsQuerySegmentWalker(Map<String, VersionedIntervalTimeline<String, DataSegment>> timelines, Map<DataSegment, ReferenceCountedSegmentProvider> referenceProviders, QuerySegmentWalker walker) {
        this.timelines = timelines;
        this.referenceProviders = referenceProviders;
        this.walker = walker;
    }

    public SpecificSegmentsQuerySegmentWalker add(DataSegment descriptor, Segment segment) {
        return this.add(new CompleteSegment(descriptor, segment));
    }

    public SpecificSegmentsQuerySegmentWalker add(CompleteSegment completeSegment) {
        DataSegment descriptor = completeSegment.getDataSegment();
        Segment segment = completeSegment.getSegment();
        ReferenceCountedSegmentProvider referenceCountingSegment = ReferenceCountedSegmentProvider.of((Segment)segment);
        VersionedIntervalTimeline timeline = this.timelines.computeIfAbsent(descriptor.getDataSource(), datasource -> new VersionedIntervalTimeline((Comparator)Ordering.natural()));
        timeline.add(descriptor.getInterval(), (Object)descriptor.getVersion(), descriptor.getShardSpec().createChunk((Object)descriptor));
        this.referenceProviders.put(descriptor, referenceCountingSegment);
        this.segments.add(completeSegment);
        return this;
    }

    public SpecificSegmentsQuerySegmentWalker add(DataSegment descriptor, QueryableIndex index) {
        return this.add(descriptor, (Segment)new QueryableIndexSegment(index, descriptor.getId()));
    }

    public SpecificSegmentsQuerySegmentWalker add(DataSegment descriptor, IncrementalIndex index) {
        return this.add(descriptor, (Segment)new IncrementalIndexSegment(index, descriptor.getId()));
    }

    public List<DataSegment> getSegments() {
        return Lists.transform(this.segments, CompleteSegment::getDataSegment);
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return this.walker.getQueryRunnerForIntervals(query, intervals);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        return this.walker.getQueryRunnerForSegments(query, specs);
    }

    @Override
    public void close() throws IOException {
        for (Closeable closeable : this.segments) {
            Closeables.close((Closeable)closeable, (boolean)true);
        }
    }

    public SpecificSegmentsQuerySegmentWalker add(TestDataSet dataset, ObjectMapper jsonMapper, File tmpDir) {
        QueryableIndex indexNumericDims = dataset.makeIndex(jsonMapper, tmpDir);
        return this.add(DataSegment.builder().dataSource(dataset.getName()).interval(indexNumericDims.getDataInterval()).version("1").shardSpec((ShardSpec)new LinearShardSpec(Integer.valueOf(0))).size(0L).build(), indexNumericDims);
    }

    public CompleteSegment getSegment(SegmentId segmentId) {
        ArrayList<CompleteSegment> matches = new ArrayList<CompleteSegment>(1);
        for (CompleteSegment s : this.segments) {
            SegmentId id = s.getDataSegment().getId();
            if (!id.equals((Object)segmentId)) continue;
            matches.add(s);
        }
        if (matches.size() != 1) {
            throw DruidException.defensive((String)"SegmentId [%s] has unexpected number of matches! [%s]", (Object[])new Object[]{segmentId, matches});
        }
        return (CompleteSegment)matches.get(0);
    }
}

