/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.audit;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import org.apache.druid.audit.AuditEntry;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.server.audit.AuditManagerConfig;
import org.apache.druid.server.audit.AuditSerdeHelper;
import org.apache.druid.server.audit.SQLAuditManager;
import org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class SQLAuditManagerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private SQLAuditManager auditManager;
    private StubServiceEmitter serviceEmitter;
    private final ObjectMapper mapper = new DefaultObjectMapper();
    private final ObjectMapper mapperSkipNull = new DefaultObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);

    @Before
    public void setUp() {
        this.serviceEmitter = new StubServiceEmitter("audit-test", "localhost");
        this.connector = this.derbyConnectorRule.getConnector();
        this.connector.createAuditTable();
        this.auditManager = this.createAuditManager(new SQLAuditManagerConfig(null, null, null, null, null));
    }

    private SQLAuditManager createAuditManager(SQLAuditManagerConfig config) {
        return new SQLAuditManager((AuditManagerConfig)config, new AuditSerdeHelper((AuditManagerConfig)config, null, this.mapper, this.mapperSkipNull), (SQLMetadataConnector)this.connector, this.derbyConnectorRule.metadataTablesConfigSupplier(), (ServiceEmitter)this.serviceEmitter, this.mapper);
    }

    @Test
    public void testAuditMetricEventWithPayload() throws IOException {
        SQLAuditManager auditManager = this.createAuditManager(new SQLAuditManagerConfig(null, null, null, null, Boolean.valueOf(true)));
        AuditEntry entry = this.createAuditEntry("testKey", "testType", DateTimes.nowUtc());
        auditManager.doAudit(entry);
        List auditMetricEvents = this.serviceEmitter.getMetricEvents("config/audit");
        Assert.assertEquals((long)1L, (long)auditMetricEvents.size());
        ServiceMetricEvent metric = (ServiceMetricEvent)auditMetricEvents.get(0);
        AuditEntry dbEntry = this.lookupAuditEntryForKey("testKey");
        Assert.assertNotNull((Object)dbEntry);
        Assert.assertEquals((Object)dbEntry.getKey(), metric.getUserDims().get("key"));
        Assert.assertEquals((Object)dbEntry.getType(), metric.getUserDims().get("type"));
        Assert.assertEquals((Object)dbEntry.getPayload().serialized(), metric.getUserDims().get("payload"));
        Assert.assertEquals((Object)dbEntry.getAuditInfo().getAuthor(), metric.getUserDims().get("author"));
        Assert.assertEquals((Object)dbEntry.getAuditInfo().getComment(), metric.getUserDims().get("comment"));
        Assert.assertEquals((Object)dbEntry.getAuditInfo().getIp(), metric.getUserDims().get("remote_address"));
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntry() throws IOException {
        AuditEntry entry = this.createAuditEntry("key1", "type1", DateTimes.nowUtc());
        this.auditManager.doAudit(entry);
        AuditEntry dbEntry = this.lookupAuditEntryForKey(entry.getKey());
        Assert.assertEquals((Object)entry, (Object)dbEntry);
        List auditMetricEvents = this.serviceEmitter.getMetricEvents("config/audit");
        Assert.assertNotNull((Object)auditMetricEvents);
        Assert.assertEquals((long)1L, (long)auditMetricEvents.size());
        ServiceMetricEvent metric = (ServiceMetricEvent)auditMetricEvents.get(0);
        Assert.assertEquals((Object)dbEntry.getKey(), metric.getUserDims().get("key"));
        Assert.assertEquals((Object)dbEntry.getType(), metric.getUserDims().get("type"));
        Assert.assertNull(metric.getUserDims().get("payload"));
        Assert.assertEquals((Object)dbEntry.getAuditInfo().getAuthor(), metric.getUserDims().get("author"));
        Assert.assertEquals((Object)dbEntry.getAuditInfo().getComment(), metric.getUserDims().get("comment"));
        Assert.assertEquals((Object)dbEntry.getAuditInfo().getIp(), metric.getUserDims().get("remote_address"));
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistory() {
        AuditEntry event = this.createAuditEntry("testKey", "testType", DateTimes.nowUtc());
        this.auditManager.doAudit(event);
        this.auditManager.doAudit(event);
        List auditEntries = this.auditManager.fetchAuditHistory("testKey", "testType", Intervals.of((String)"2000-01-01T00:00:00Z/2100-01-03T00:00:00Z"));
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        Assert.assertEquals((Object)event, auditEntries.get(0));
        Assert.assertEquals((Object)event, auditEntries.get(1));
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistoryByKeyAndTypeWithLimit() {
        AuditEntry entry1 = this.createAuditEntry("key1", "type1", DateTimes.nowUtc());
        AuditEntry entry2 = this.createAuditEntry("key2", "type2", DateTimes.nowUtc());
        this.auditManager.doAudit(entry1);
        this.auditManager.doAudit(entry2);
        List auditEntries = this.auditManager.fetchAuditHistory(entry1.getKey(), entry1.getType(), 1);
        Assert.assertEquals((long)1L, (long)auditEntries.size());
        Assert.assertEquals((Object)entry1, auditEntries.get(0));
    }

    @Test(timeout=60000L)
    public void testRemoveAuditLogsOlderThanWithEntryOlderThanTime() throws IOException {
        AuditEntry entry = this.createAuditEntry("key1", "type1", DateTimes.nowUtc());
        this.auditManager.doAudit(entry);
        AuditEntry dbEntry = this.lookupAuditEntryForKey(entry.getKey());
        Assert.assertEquals((Object)entry, (Object)dbEntry);
        this.auditManager.removeAuditLogsOlderThan(System.currentTimeMillis());
        Assert.assertNull((Object)this.lookupAuditEntryForKey(entry.getKey()));
    }

    @Test(timeout=60000L)
    public void testRemoveAuditLogsOlderThanWithEntryNotOlderThanTime() throws IOException {
        AuditEntry entry = this.createAuditEntry("key", "type", DateTimes.nowUtc());
        this.auditManager.doAudit(entry);
        AuditEntry dbEntry = this.lookupAuditEntryForKey(entry.getKey());
        Assert.assertEquals((Object)entry, (Object)dbEntry);
        this.auditManager.removeAuditLogsOlderThan(DateTimes.of((String)"2012-01-01T00:00:00Z").getMillis());
        dbEntry = this.lookupAuditEntryForKey(entry.getKey());
        Assert.assertEquals((Object)entry, (Object)dbEntry);
    }

    @Test(timeout=60000L)
    public void testFetchAuditHistoryByTypeWithLimit() {
        AuditEntry entry1 = this.createAuditEntry("testKey", "testType", DateTimes.of((String)"2022-01"));
        AuditEntry entry2 = this.createAuditEntry("testKey", "testType", DateTimes.of((String)"2022-03"));
        AuditEntry entry3 = this.createAuditEntry("testKey", "testType", DateTimes.of((String)"2022-02"));
        this.auditManager.doAudit(entry1);
        this.auditManager.doAudit(entry2);
        this.auditManager.doAudit(entry3);
        List auditEntries = this.auditManager.fetchAuditHistory("testType", 2);
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        Assert.assertEquals((Object)entry2, auditEntries.get(0));
        Assert.assertEquals((Object)entry3, auditEntries.get(1));
    }

    @Test(expected=IllegalArgumentException.class, timeout=10000L)
    public void testFetchAuditHistoryLimitBelowZero() {
        this.auditManager.fetchAuditHistory("testType", -1);
    }

    @Test(expected=IllegalArgumentException.class, timeout=10000L)
    public void testFetchAuditHistoryLimitZero() {
        this.auditManager.fetchAuditHistory("testType", 0);
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntryWithPayloadOverSkipPayloadLimit() throws IOException {
        SQLAuditManager auditManager = this.createAuditManager(new SQLAuditManagerConfig(null, HumanReadableBytes.valueOf((int)10), null, null, null));
        AuditEntry entry = this.createAuditEntry("key", "type", DateTimes.nowUtc());
        auditManager.doAudit(entry);
        AuditEntry dbEntry = this.lookupAuditEntryForKey(entry.getKey());
        Assert.assertEquals((Object)entry.getKey(), (Object)dbEntry.getKey());
        Assert.assertEquals((Object)"Payload truncated as it exceeds 'druid.audit.manager.maxPayloadSizeBytes'[10].", (Object)dbEntry.getPayload().serialized());
        Assert.assertEquals((Object)entry.getType(), (Object)dbEntry.getType());
        Assert.assertEquals((Object)entry.getAuditInfo(), (Object)dbEntry.getAuditInfo());
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntryWithPayloadUnderSkipPayloadLimit() throws IOException {
        SQLAuditManager auditManager = this.createAuditManager(new SQLAuditManagerConfig(null, HumanReadableBytes.valueOf((int)500), null, null, null));
        AuditEntry entry = this.createAuditEntry("key", "type", DateTimes.nowUtc());
        auditManager.doAudit(entry);
        AuditEntry dbEntry = this.lookupAuditEntryForKey(entry.getKey());
        Assert.assertEquals((Object)entry, (Object)dbEntry);
    }

    @Test(timeout=60000L)
    public void testCreateAuditEntryWithSkipNullsInPayload() throws IOException {
        SQLAuditManager auditManagerSkipNull = this.createAuditManager(new SQLAuditManagerConfig(null, null, Boolean.valueOf(true), null, null));
        AuditInfo auditInfo = new AuditInfo("testAuthor", "testIdentity", "testComment", "127.0.0.1");
        TreeMap<String, String> payloadMap = new TreeMap<String, String>();
        payloadMap.put("version", "x");
        payloadMap.put("something", null);
        this.auditManager.doAudit(AuditEntry.builder().key("key1").type("type1").auditInfo(auditInfo).payload(payloadMap).build());
        AuditEntry entryWithNulls = this.lookupAuditEntryForKey("key1");
        Assert.assertEquals((Object)"{\"something\":null,\"version\":\"x\"}", (Object)entryWithNulls.getPayload().serialized());
        auditManagerSkipNull.doAudit(AuditEntry.builder().key("key2").type("type2").auditInfo(auditInfo).payload(payloadMap).build());
        AuditEntry entryWithoutNulls = this.lookupAuditEntryForKey("key2");
        Assert.assertEquals((Object)"{\"version\":\"x\"}", (Object)entryWithoutNulls.getPayload().serialized());
    }

    @After
    public void cleanup() {
        this.dropTable(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable());
    }

    private void dropTable(String tableName) {
        int rowsAffected = (Integer)this.connector.getDBI().withHandle(handle -> handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute());
        Assert.assertEquals((long)0L, (long)rowsAffected);
    }

    private AuditEntry lookupAuditEntryForKey(String key) throws IOException {
        byte[] payload = this.connector.lookup(((MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get()).getAuditTable(), "audit_key", "payload", key);
        if (payload == null) {
            return null;
        }
        return (AuditEntry)this.mapper.readValue(payload, AuditEntry.class);
    }

    private AuditEntry createAuditEntry(String key, String type, DateTime auditTime) {
        return AuditEntry.builder().key(key).type(type).serializedPayload(StringUtils.format((String)"Test payload for key[%s], type[%s]", (Object[])new Object[]{key, type})).auditInfo(new AuditInfo("author", "identity", "comment", "127.0.0.1")).auditTime(auditTime).build();
    }
}

