/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.List;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.indexer.granularity.GranularitySpec;
import org.apache.druid.indexer.granularity.UniformGranularitySpec;
import org.apache.druid.indexer.partitions.DimensionRangePartitionsSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskDimensionsConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.timeline.CompactionState;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class CompactionStatusTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();
    private static final DataSegment WIKI_SEGMENT = DataSegment.builder().dataSource("wiki").interval(Intervals.of((String)"2013-01-01/PT1H")).size(100000000L).version("v1").build();

    @Test
    public void testFindPartitionsSpecWhenGivenIsNull() {
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from(null);
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsDynamicWithNullMaxTotalRows() {
        DynamicPartitionsSpec partitionsSpec = new DynamicPartitionsSpec(null, null);
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)new DynamicPartitionsSpec(null, Long.valueOf(Long.MAX_VALUE)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsDynamicWithMaxTotalRows() {
        DynamicPartitionsSpec partitionsSpec = new DynamicPartitionsSpec(null, Long.valueOf(1000L));
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)partitionsSpec, (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsDynamicWithMaxRowsPerSegment() {
        DynamicPartitionsSpec partitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(1000L));
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)partitionsSpec, (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecFromConfigWithDeprecatedMaxRowsPerSegmentAndMaxTotalRowsReturnGivenValues() {
        InlineSchemaDataSourceCompactionConfig config = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("datasource").withMaxRowsPerSegment(Integer.valueOf(100)).withTuningConfig(new UserCompactionTaskQueryTuningConfig(null, null, null, Long.valueOf(1000L), null, null, null, null, null, null, null, null, null, null, null, null, null, null, null)).build();
        Assert.assertEquals((Object)new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(1000L)), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)config)));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsHashed() {
        HashedPartitionsSpec partitionsSpec = new HashedPartitionsSpec(null, Integer.valueOf(100), Collections.singletonList("dim"));
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)partitionsSpec, (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsRangeWithMaxRows() {
        DimensionRangePartitionsSpec partitionsSpec = new DimensionRangePartitionsSpec(null, Integer.valueOf(10000), Collections.singletonList("dim"), false);
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)partitionsSpec, (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testFindPartitionsSpecWhenGivenIsRangeWithTargetRows() {
        DimensionRangePartitionsSpec partitionsSpec = new DimensionRangePartitionsSpec(Integer.valueOf(10000), null, Collections.singletonList("dim"), false);
        ClientCompactionTaskQueryTuningConfig tuningConfig = ClientCompactionTaskQueryTuningConfig.from((DataSourceCompactionConfig)CompactionStatusTest.createCompactionConfig((PartitionsSpec)partitionsSpec));
        Assert.assertEquals((Object)new DimensionRangePartitionsSpec(null, Integer.valueOf(15000), Collections.singletonList("dim"), false), (Object)CompactionStatus.findPartitionsSpecFromConfig((ClientCompactionTaskQueryTuningConfig)tuningConfig));
    }

    @Test
    public void testStatusWhenLastCompactionStateIsNull() {
        this.verifyCompactionStatusIsPendingBecause(null, (DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build(), "not compacted yet");
    }

    @Test
    public void testStatusWhenLastCompactionStateIsEmpty() {
        this.verifyCompactionStatusIsPendingBecause(new CompactionState(null, null, null, null, null, null, null), (DataSourceCompactionConfig)InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build(), "'partitionsSpec' mismatch: required['dynamic' with 5,000,000 rows], current[null]");
    }

    @Test
    public void testStatusOnPartitionsSpecMismatch() {
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, null, null, null);
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build();
        this.verifyCompactionStatusIsPendingBecause(lastCompactionState, (DataSourceCompactionConfig)compactionConfig, "'partitionsSpec' mismatch: required['dynamic' with 5,000,000 rows], current['dynamic' with 100 rows]");
    }

    @Test
    public void testStatusOnIndexSpecMismatch() {
        IndexSpec currentIndexSpec = IndexSpec.builder().withDimensionCompression(CompressionStrategy.ZSTD).build();
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, currentIndexSpec, null, null);
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, null)).build();
        this.verifyCompactionStatusIsPendingBecause(lastCompactionState, (DataSourceCompactionConfig)compactionConfig, "'indexSpec' mismatch: required[IndexSpec{bitmapSerdeFactory=RoaringBitmapSerdeFactory{}, dimensionCompression=lz4, stringDictionaryEncoding=Utf8{}, metricCompression=lz4, longEncoding=longs, complexMetricCompression=null, autoColumnFormatSpec=null, jsonCompression=null, segmentLoader=null}], current[IndexSpec{bitmapSerdeFactory=RoaringBitmapSerdeFactory{}, dimensionCompression=zstd, stringDictionaryEncoding=Utf8{}, metricCompression=lz4, longEncoding=longs, complexMetricCompression=null, autoColumnFormatSpec=null, jsonCompression=null, segmentLoader=null}]");
    }

    @Test
    public void testStatusOnSegmentGranularityMismatch() {
        UniformGranularitySpec currentGranularitySpec = new UniformGranularitySpec(Granularities.HOUR, null, null);
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        IndexSpec currentIndexSpec = IndexSpec.builder().withDimensionCompression(CompressionStrategy.ZSTD).build();
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, currentIndexSpec, (GranularitySpec)currentGranularitySpec, null);
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, currentIndexSpec)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.DAY, null, null)).build();
        this.verifyCompactionStatusIsPendingBecause(lastCompactionState, (DataSourceCompactionConfig)compactionConfig, "'segmentGranularity' mismatch: required[DAY], current[HOUR]");
    }

    @Test
    public void testStatusWhenLastCompactionStateSameAsRequired() {
        UniformGranularitySpec currentGranularitySpec = new UniformGranularitySpec(Granularities.HOUR, null, null);
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        IndexSpec currentIndexSpec = IndexSpec.builder().withDimensionCompression(CompressionStrategy.ZSTD).build();
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, currentIndexSpec, (GranularitySpec)currentGranularitySpec, null);
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, currentIndexSpec)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).build();
        DataSegment segment = DataSegment.builder((DataSegment)WIKI_SEGMENT).lastCompactionState(lastCompactionState).build();
        CompactionStatus status = CompactionStatus.compute((CompactionCandidate)CompactionCandidate.from(Collections.singletonList(segment)), (DataSourceCompactionConfig)compactionConfig, (ObjectMapper)OBJECT_MAPPER);
        Assert.assertTrue((boolean)status.isComplete());
    }

    @Test
    public void testStatusWhenProjectionsMatch() {
        UniformGranularitySpec currentGranularitySpec = new UniformGranularitySpec(Granularities.HOUR, null, null);
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        IndexSpec currentIndexSpec = IndexSpec.builder().withDimensionCompression(CompressionStrategy.ZSTD).build();
        AggregateProjectionSpec projection1 = AggregateProjectionSpec.builder((String)"foo").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__virtualGranularity")}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__virtualGranularity"), new StringDimensionSchema("a")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long")}).build();
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, currentIndexSpec, (GranularitySpec)currentGranularitySpec, List.of(projection1));
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, currentIndexSpec)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).withProjections(List.of(projection1)).build();
        DataSegment segment = DataSegment.builder((DataSegment)WIKI_SEGMENT).lastCompactionState(lastCompactionState).build();
        CompactionStatus status = CompactionStatus.compute((CompactionCandidate)CompactionCandidate.from(Collections.singletonList(segment)), (DataSourceCompactionConfig)compactionConfig, (ObjectMapper)OBJECT_MAPPER);
        Assert.assertTrue((boolean)status.isComplete());
    }

    @Test
    public void testStatusWhenProjectionsMismatch() {
        UniformGranularitySpec currentGranularitySpec = new UniformGranularitySpec(Granularities.HOUR, null, null);
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        IndexSpec currentIndexSpec = IndexSpec.builder().withDimensionCompression(CompressionStrategy.ZSTD).build();
        AggregateProjectionSpec projection1 = AggregateProjectionSpec.builder((String)"1").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__virtualGranularity")}).groupingColumns(new DimensionSchema[]{new LongDimensionSchema("__virtualGranularity"), new StringDimensionSchema("a")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long")}).build();
        AggregateProjectionSpec projection2 = AggregateProjectionSpec.builder((String)"2").aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long")}).build();
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, null, null, null, currentIndexSpec, (GranularitySpec)currentGranularitySpec, List.of(projection1));
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, currentIndexSpec)).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).withProjections(List.of(projection1, projection2)).build();
        DataSegment segment = DataSegment.builder((DataSegment)WIKI_SEGMENT).lastCompactionState(lastCompactionState).build();
        CompactionStatus status = CompactionStatus.compute((CompactionCandidate)CompactionCandidate.from(Collections.singletonList(segment)), (DataSourceCompactionConfig)compactionConfig, (ObjectMapper)OBJECT_MAPPER);
        Assert.assertFalse((boolean)status.isComplete());
    }

    @Test
    public void testStatusWhenAutoSchemaMatch() {
        UniformGranularitySpec currentGranularitySpec = new UniformGranularitySpec(Granularities.HOUR, null, null);
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, DimensionsSpec.builder().setDimensions(List.of(AutoTypeColumnSchema.of((String)"x").getEffectiveSchema(IndexSpec.getDefault().getEffectiveSpec()), AutoTypeColumnSchema.of((String)"y").getEffectiveSchema(IndexSpec.getDefault().getEffectiveSpec()))).build(), null, null, IndexSpec.getDefault().getEffectiveSpec(), (GranularitySpec)currentGranularitySpec, Collections.emptyList());
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withDimensionsSpec(new UserCompactionTaskDimensionsConfig(List.of(new AutoTypeColumnSchema("x", null, NestedCommonFormatColumnFormatSpec.builder().setDoubleColumnCompression(CompressionStrategy.LZ4).build()), AutoTypeColumnSchema.of((String)"y")))).withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, IndexSpec.getDefault())).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).withProjections(Collections.emptyList()).build();
        DataSegment segment = DataSegment.builder((DataSegment)WIKI_SEGMENT).lastCompactionState(lastCompactionState).build();
        CompactionStatus status = CompactionStatus.compute((CompactionCandidate)CompactionCandidate.from(Collections.singletonList(segment)), (DataSourceCompactionConfig)compactionConfig, (ObjectMapper)OBJECT_MAPPER);
        Assert.assertTrue((boolean)status.isComplete());
    }

    @Test
    public void testStatusWhenAutoSchemaMismatch() {
        UniformGranularitySpec currentGranularitySpec = new UniformGranularitySpec(Granularities.HOUR, null, null);
        DynamicPartitionsSpec currentPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(100), Long.valueOf(0L));
        CompactionState lastCompactionState = new CompactionState((PartitionsSpec)currentPartitionsSpec, DimensionsSpec.builder().setDimensions(List.of(AutoTypeColumnSchema.of((String)"x").getEffectiveSchema(IndexSpec.getDefault()), AutoTypeColumnSchema.of((String)"y").getEffectiveSchema(IndexSpec.getDefault()))).build(), null, null, IndexSpec.getDefault(), (GranularitySpec)currentGranularitySpec, Collections.emptyList());
        InlineSchemaDataSourceCompactionConfig compactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withDimensionsSpec(new UserCompactionTaskDimensionsConfig(List.of(new AutoTypeColumnSchema("x", null, NestedCommonFormatColumnFormatSpec.builder().setDoubleColumnCompression(CompressionStrategy.ZSTD).build()), AutoTypeColumnSchema.of((String)"y")))).withTuningConfig(CompactionStatusTest.createTuningConfig((PartitionsSpec)currentPartitionsSpec, IndexSpec.getDefault())).withGranularitySpec(new UserCompactionTaskGranularityConfig(Granularities.HOUR, null, null)).withProjections(Collections.emptyList()).build();
        DataSegment segment = DataSegment.builder((DataSegment)WIKI_SEGMENT).lastCompactionState(lastCompactionState).build();
        CompactionStatus status = CompactionStatus.compute((CompactionCandidate)CompactionCandidate.from(Collections.singletonList(segment)), (DataSourceCompactionConfig)compactionConfig, (ObjectMapper)OBJECT_MAPPER);
        Assert.assertFalse((boolean)status.isComplete());
    }

    private void verifyCompactionStatusIsPendingBecause(CompactionState lastCompactionState, DataSourceCompactionConfig compactionConfig, String expectedReason) {
        DataSegment segment = DataSegment.builder((DataSegment)WIKI_SEGMENT).lastCompactionState(lastCompactionState).build();
        CompactionStatus status = CompactionStatus.compute((CompactionCandidate)CompactionCandidate.from(Collections.singletonList(segment)), (DataSourceCompactionConfig)compactionConfig, (ObjectMapper)OBJECT_MAPPER);
        Assert.assertFalse((boolean)status.isComplete());
        Assert.assertEquals((Object)expectedReason, (Object)status.getReason());
    }

    private static DataSourceCompactionConfig createCompactionConfig(PartitionsSpec partitionsSpec) {
        return InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withTuningConfig(CompactionStatusTest.createTuningConfig(partitionsSpec, null)).build();
    }

    private static UserCompactionTaskQueryTuningConfig createTuningConfig(PartitionsSpec partitionsSpec, IndexSpec indexSpec) {
        return new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, partitionsSpec, indexSpec, null, null, null, null, null, null, null, null, null, null, null, null);
    }
}

