/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.jackson.SegmentizerModule;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.GlobalTableDataSource;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.TestIndex;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.join.BroadcastTableJoinableFactory;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.loading.BroadcastJoinableMMappedQueryableSegmentizerFactory;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.loading.LeastBytesUsedStorageLocationSelectorStrategy;
import org.apache.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.druid.segment.loading.LocalLoadSpec;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.segment.loading.SegmentLocalCacheManager;
import org.apache.druid.segment.loading.SegmentizerFactory;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.segment.loading.StorageLocationSelectorStrategy;
import org.apache.druid.segment.writeout.OffHeapMemorySegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.testing.InitializedNullHandlingTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class SegmentManagerBroadcastJoinIndexedTableTest
extends InitializedNullHandlingTest {
    private static final String TABLE_NAME = "test";
    private static final String PREFIX = "j0";
    private static final JoinConditionAnalysis JOIN_CONDITION_ANALYSIS = JoinConditionAnalysis.forExpression((String)StringUtils.format((String)"market == \"%s.market\"", (Object[])new Object[]{"j0"}), (String)"j0", (ExprMacroTable)ExprMacroTable.nil());
    private static final Set<String> KEY_COLUMNS = ImmutableSet.of((Object)"market", (Object)"longNumericNull", (Object)"doubleNumericNull", (Object)"floatNumericNull", (Object)"partial_null_column");
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private LocalDataSegmentPuller segmentPuller;
    private ObjectMapper objectMapper;
    private IndexIO indexIO;
    private File segmentCacheDir;
    private File segmentDeepStorageDir;
    private SegmentLocalCacheManager segmentCacheManager;
    private SegmentManager segmentManager;
    private BroadcastTableJoinableFactory joinableFactory;

    @Before
    public void setup() throws IOException {
        this.segmentPuller = new LocalDataSegmentPuller();
        this.objectMapper = new DefaultObjectMapper().registerModule((Module)new SegmentizerModule()).registerModule((Module)new SimpleModule().registerSubtypes(new NamedType[]{new NamedType(LocalLoadSpec.class, "local")}));
        this.indexIO = new IndexIO(this.objectMapper, ColumnConfig.DEFAULT);
        this.objectMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(LocalDataSegmentPuller.class, (Object)this.segmentPuller).addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)this.objectMapper).addValue(IndexIO.class, (Object)this.indexIO));
        this.segmentCacheDir = this.temporaryFolder.newFolder();
        this.segmentDeepStorageDir = this.temporaryFolder.newFolder();
        SegmentLoaderConfig loaderConfig = new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentManagerBroadcastJoinIndexedTableTest.this.segmentCacheDir;
            }

            public List<StorageLocationConfig> getLocations() {
                return Collections.singletonList(new StorageLocationConfig(SegmentManagerBroadcastJoinIndexedTableTest.this.segmentCacheDir, null, null));
            }
        };
        List storageLocations = loaderConfig.toStorageLocations();
        this.segmentCacheManager = new SegmentLocalCacheManager(storageLocations, loaderConfig, (StorageLocationSelectorStrategy)new LeastBytesUsedStorageLocationSelectorStrategy(storageLocations), TestIndex.INDEX_IO, this.objectMapper);
        this.segmentManager = new SegmentManager((SegmentCacheManager)this.segmentCacheManager);
        this.joinableFactory = new BroadcastTableJoinableFactory(this.segmentManager);
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
    }

    @After
    public void teardown() throws IOException {
        FileUtils.deleteDirectory((File)this.segmentCacheDir);
    }

    @Test
    public void testLoadIndexedTable() throws IOException, SegmentLoadingException {
        GlobalTableDataSource dataSource = new GlobalTableDataSource(TABLE_NAME);
        Assert.assertFalse((boolean)this.joinableFactory.isDirectlyJoinable((DataSource)dataSource));
        String version = DateTimes.nowUtc().toString();
        IncrementalIndex data = TestIndex.makeSampleNumericIncrementalIndex();
        String interval = "2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z";
        DataSegment segment = this.createSegment(data, "2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z", version);
        this.segmentManager.loadSegment(segment);
        Assert.assertTrue((boolean)this.joinableFactory.isDirectlyJoinable((DataSource)dataSource));
        Optional<Joinable> maybeJoinable = this.makeJoinable((DataSource)dataSource);
        Assert.assertTrue((boolean)maybeJoinable.isPresent());
        Joinable joinable = maybeJoinable.get();
        Assert.assertEquals((long)1210L, (long)joinable.getCardinality("market"));
        Assert.assertEquals((long)1210L, (long)joinable.getCardinality("placement"));
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)"preferred")), (Object)joinable.getCorrelatedColumnValues("market", "spot", "placement", Long.MAX_VALUE, false));
        Optional bytes = this.joinableFactory.computeJoinCacheKey((DataSource)dataSource, JOIN_CONDITION_ANALYSIS);
        Assert.assertTrue((boolean)bytes.isPresent());
        this.assertSegmentIdEquals(segment.getId(), (byte[])bytes.get());
        this.segmentManager.dropSegment(segment);
        maybeJoinable = this.makeJoinable((DataSource)dataSource);
        Assert.assertFalse((boolean)maybeJoinable.isPresent());
        bytes = this.joinableFactory.computeJoinCacheKey((DataSource)dataSource, JOIN_CONDITION_ANALYSIS);
        Assert.assertFalse((boolean)bytes.isPresent());
    }

    @Test
    public void testLoadMultipleIndexedTableOverwrite() throws IOException, SegmentLoadingException {
        GlobalTableDataSource dataSource = new GlobalTableDataSource(TABLE_NAME);
        Assert.assertFalse((boolean)this.joinableFactory.isDirectlyJoinable((DataSource)dataSource));
        String version = DateTimes.nowUtc().toString();
        String version2 = DateTimes.nowUtc().plus(1000L).toString();
        String interval = "2011-01-12T00:00:00.000Z/2011-03-28T00:00:00.000Z";
        String interval2 = "2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z";
        IncrementalIndex data = TestIndex.makeSampleNumericTopIncrementalIndex();
        IncrementalIndex data2 = TestIndex.makeSampleNumericBottomIncrementalIndex();
        DataSegment segment1 = this.createSegment(data, "2011-01-12T00:00:00.000Z/2011-03-28T00:00:00.000Z", version);
        DataSegment segment2 = this.createSegment(data2, "2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z", version2);
        this.segmentManager.loadSegment(segment1);
        this.segmentManager.loadSegment(segment2);
        Assert.assertTrue((boolean)this.joinableFactory.isDirectlyJoinable((DataSource)dataSource));
        Optional<Joinable> maybeJoinable = this.makeJoinable((DataSource)dataSource);
        Assert.assertTrue((boolean)maybeJoinable.isPresent());
        Joinable joinable = maybeJoinable.get();
        Assert.assertEquals((long)733L, (long)joinable.getCardinality("market"));
        Assert.assertEquals((long)733L, (long)joinable.getCardinality("placement"));
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)"preferred")), (Object)joinable.getCorrelatedColumnValues("market", "spot", "placement", Long.MAX_VALUE, false));
        Optional cacheKey = this.joinableFactory.computeJoinCacheKey((DataSource)dataSource, JOIN_CONDITION_ANALYSIS);
        Assert.assertTrue((boolean)cacheKey.isPresent());
        this.assertSegmentIdEquals(segment2.getId(), (byte[])cacheKey.get());
        this.segmentManager.dropSegment(segment2);
        maybeJoinable = this.makeJoinable((DataSource)dataSource);
        Assert.assertTrue((boolean)maybeJoinable.isPresent());
        joinable = maybeJoinable.get();
        Assert.assertEquals((long)478L, (long)joinable.getCardinality("market"));
        Assert.assertEquals((long)478L, (long)joinable.getCardinality("placement"));
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)"preferred")), (Object)joinable.getCorrelatedColumnValues("market", "spot", "placement", Long.MAX_VALUE, false));
        cacheKey = this.joinableFactory.computeJoinCacheKey((DataSource)dataSource, JOIN_CONDITION_ANALYSIS);
        Assert.assertTrue((boolean)cacheKey.isPresent());
        this.assertSegmentIdEquals(segment1.getId(), (byte[])cacheKey.get());
    }

    @Test
    public void testLoadMultipleIndexedTable() throws IOException, SegmentLoadingException {
        GlobalTableDataSource dataSource = new GlobalTableDataSource(TABLE_NAME);
        Assert.assertFalse((boolean)this.joinableFactory.isDirectlyJoinable((DataSource)dataSource));
        String version = DateTimes.nowUtc().toString();
        String version2 = DateTimes.nowUtc().plus(1000L).toString();
        String interval = "2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z";
        String interval2 = "2011-01-12T00:00:00.000Z/2011-03-28T00:00:00.000Z";
        IncrementalIndex data = TestIndex.makeSampleNumericBottomIncrementalIndex();
        IncrementalIndex data2 = TestIndex.makeSampleNumericTopIncrementalIndex();
        this.segmentManager.loadSegment(this.createSegment(data, "2011-01-12T00:00:00.000Z/2011-05-01T00:00:00.000Z", version));
        Assert.assertTrue((boolean)this.joinableFactory.isDirectlyJoinable((DataSource)dataSource));
        Optional<Joinable> maybeJoinable = this.makeJoinable((DataSource)dataSource);
        Assert.assertTrue((boolean)maybeJoinable.isPresent());
        Joinable joinable = maybeJoinable.get();
        Assert.assertEquals((long)733L, (long)joinable.getCardinality("market"));
        Assert.assertEquals((long)733L, (long)joinable.getCardinality("placement"));
        Assert.assertEquals(Optional.of(ImmutableSet.of((Object)"preferred")), (Object)joinable.getCorrelatedColumnValues("market", "spot", "placement", Long.MAX_VALUE, false));
        this.segmentManager.loadSegment(this.createSegment(data2, "2011-01-12T00:00:00.000Z/2011-03-28T00:00:00.000Z", version2));
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(StringUtils.format((String)"Currently only single segment datasources are supported for broadcast joins, dataSource[%s] has multiple segments. Reingest the data so that it is entirely contained within a single segment to use in JOIN queries.", (Object[])new Object[]{TABLE_NAME}));
        this.makeJoinable((DataSource)dataSource);
    }

    @Test
    public void emptyCacheKeyForUnsupportedCondition() {
        GlobalTableDataSource dataSource = new GlobalTableDataSource(TABLE_NAME);
        JoinConditionAnalysis condition = (JoinConditionAnalysis)EasyMock.mock(JoinConditionAnalysis.class);
        EasyMock.expect((Object)condition.canHashJoin()).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{condition});
        Assert.assertNull(this.joinableFactory.build((DataSource)dataSource, condition).orElse(null));
    }

    private Optional<Joinable> makeJoinable(DataSource dataSource) {
        return this.joinableFactory.build(dataSource, JOIN_CONDITION_ANALYSIS);
    }

    private DataSegment createSegment(IncrementalIndex data, String interval, String version) throws IOException {
        DataSegment tmpSegment = new DataSegment(TABLE_NAME, Intervals.of((String)interval), version, Collections.emptyMap(), Collections.emptyList(), Collections.emptyList(), (ShardSpec)new NumberedShardSpec(0, 0), Integer.valueOf(9), 100L);
        String storageDir = DataSegmentPusher.getDefaultStorageDir((DataSegment)tmpSegment, (boolean)false);
        File segmentDir = new File(this.segmentDeepStorageDir, storageDir);
        FileUtils.mkdirp((File)segmentDir);
        IndexMergerV9 indexMerger = new IndexMergerV9(this.objectMapper, this.indexIO, (SegmentWriteOutMediumFactory)OffHeapMemorySegmentWriteOutMediumFactory.instance());
        BroadcastJoinableMMappedQueryableSegmentizerFactory factory = new BroadcastJoinableMMappedQueryableSegmentizerFactory(this.indexIO, KEY_COLUMNS);
        indexMerger.persist(data, Intervals.of((String)interval), segmentDir, IndexSpec.builder().withSegmentLoader((SegmentizerFactory)factory).build(), null);
        File factoryJson = new File(segmentDir, "factory.json");
        this.objectMapper.writeValue(factoryJson, (Object)factory);
        return tmpSegment.withLoadSpec((Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)segmentDir.getAbsolutePath()));
    }

    private void assertSegmentIdEquals(SegmentId id, byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.get();
        byteBuffer.get();
        long start = byteBuffer.getLong();
        byteBuffer.get();
        long end = byteBuffer.getLong();
        byteBuffer.get();
        String version = StringUtils.fromUtf8((ByteBuffer)byteBuffer, (int)StringUtils.estimatedBinaryLengthAsUTF8((String)id.getVersion()));
        byteBuffer.get();
        String dataSource = StringUtils.fromUtf8((ByteBuffer)byteBuffer, (int)StringUtils.estimatedBinaryLengthAsUTF8((String)id.getDataSource()));
        byteBuffer.get();
        int partition = byteBuffer.getInt();
        Assert.assertEquals((Object)id, (Object)SegmentId.of((String)dataSource, (Interval)Intervals.utc((long)start, (long)end), (String)version, (int)partition));
    }
}

