/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Set;
import org.apache.druid.client.BootstrapSegmentsResponse;
import org.apache.druid.client.coordinator.NoopCoordinatorClient;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.timeline.DataSegment;

public class TestCoordinatorClient
extends NoopCoordinatorClient {
    private final Set<DataSegment> bootstrapSegments;
    private final CoordinatorDynamicConfig config;

    public TestCoordinatorClient() {
        this(new HashSet<DataSegment>(), CoordinatorDynamicConfig.builder().build());
    }

    public TestCoordinatorClient(Set<DataSegment> bootstrapSegments) {
        this(bootstrapSegments, CoordinatorDynamicConfig.builder().build());
    }

    public TestCoordinatorClient(Set<DataSegment> bootstrapSegments, CoordinatorDynamicConfig config) {
        this.bootstrapSegments = bootstrapSegments;
        this.config = config;
    }

    public ListenableFuture<BootstrapSegmentsResponse> fetchBootstrapSegments() {
        return Futures.immediateFuture((Object)new BootstrapSegmentsResponse(CloseableIterators.withEmptyBaggage(this.bootstrapSegments.iterator())));
    }

    public ListenableFuture<CoordinatorDynamicConfig> getCoordinatorDynamicConfig() {
        return Futures.immediateFuture((Object)this.config);
    }
}

