/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.catalog.MapMetadataCatalog;
import org.apache.druid.catalog.MetadataCatalog;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.DatasourceProjectionMetadata;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.table.TableBuilder;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.StringDimensionSchema;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.expression.TestExprMacroTable;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.server.coordinator.CatalogDataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CatalogDataSourceCompactionConfigTest {
    private static final String TEST_DS = "test";
    private static final String TEST_DS_PROJECTIONS_ONLY_SCHEMA = "test_projections";
    private static final ObjectMapper MAPPER;
    private static final MapMetadataCatalog METADATA_CATALOG;
    private static final AggregateProjectionSpec TEST_PROJECTION_SPEC_1;

    @Test
    public void testProjections() {
        CatalogDataSourceCompactionConfig config = new CatalogDataSourceCompactionConfig(TEST_DS, null, null, null, null, null, (MetadataCatalog)METADATA_CATALOG);
        Assertions.assertEquals((Object)TEST_PROJECTION_SPEC_1, config.getProjections().get(0));
    }

    @Test
    public void testSerde() throws JsonProcessingException {
        CatalogDataSourceCompactionConfig config = new CatalogDataSourceCompactionConfig("foo", null, null, null, null, null, (MetadataCatalog)METADATA_CATALOG);
        Assertions.assertEquals((Object)config, (Object)MAPPER.readValue(MAPPER.writeValueAsString((Object)config), DataSourceCompactionConfig.class));
    }

    @Test
    public void testEqualsAndHashcode() {
        EqualsVerifier.forClass(CatalogDataSourceCompactionConfig.class).usingGetClass().withIgnoredFields(new String[]{"catalog", "tableId"}).verify();
    }

    static {
        TEST_PROJECTION_SPEC_1 = AggregateProjectionSpec.builder((String)"string_sum_long_hourly").virtualColumns(new VirtualColumn[]{Granularities.toVirtualColumn((Granularity)Granularities.HOUR, (String)"__virtualGranularity")}).groupingColumns(new DimensionSchema[]{new StringDimensionSchema("string")}).aggregators(new AggregatorFactory[]{new LongSumAggregatorFactory("sum_long", "long")}).build();
        MAPPER = new DefaultObjectMapper();
        METADATA_CATALOG = new MapMetadataCatalog(MAPPER);
        MAPPER.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(MetadataCatalog.class, (Object)METADATA_CATALOG).addValue(ExprMacroTable.class.getName(), (Object)TestExprMacroTable.INSTANCE).addValue(ObjectMapper.class.getName(), (Object)MAPPER));
        METADATA_CATALOG.addSpec(TableId.datasource((String)TEST_DS), TableBuilder.datasource((String)TEST_DS, (String)"P1D").columns((List)ImmutableList.of((Object)new ColumnSpec("__time", ColumnType.LONG.asTypeString(), null), (Object)new ColumnSpec("string", ColumnType.STRING.asTypeString(), null), (Object)new ColumnSpec("double", ColumnType.DOUBLE.asTypeString(), null), (Object)new ColumnSpec("long", ColumnType.LONG.asTypeString(), null))).property("projections", (Object)ImmutableList.of((Object)new DatasourceProjectionMetadata(TEST_PROJECTION_SPEC_1))).buildSpec());
        METADATA_CATALOG.addSpec(TableId.datasource((String)TEST_DS_PROJECTIONS_ONLY_SCHEMA), TableBuilder.datasource((String)TEST_DS_PROJECTIONS_ONLY_SCHEMA, (String)"P1D").property("projections", (Object)ImmutableList.of((Object)new DatasourceProjectionMetadata(TEST_PROJECTION_SPEC_1))).buildSpec());
    }
}

