/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.List;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigHistory;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.InlineSchemaDataSourceCompactionConfig;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSourceCompactionConfigHistoryTest {
    private final AuditInfo auditInfo = new AuditInfo("author", "identity", "comment", "ip");
    private final DataSourceCompactionConfig wikiCompactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").build();
    private DataSourceCompactionConfigHistory wikiAuditHistory;

    @Before
    public void setup() {
        this.wikiAuditHistory = new DataSourceCompactionConfigHistory("wiki");
    }

    @Test
    public void testAddDatasourceConfigShouldAddToHistory() {
        DateTime auditTime = DateTimes.nowUtc();
        this.wikiAuditHistory.add(DruidCompactionConfig.empty().withDatasourceConfig(this.wikiCompactionConfig), this.auditInfo, auditTime);
        Assert.assertEquals((long)1L, (long)this.wikiAuditHistory.getEntries().size());
        DataSourceCompactionConfigAuditEntry auditEntry = (DataSourceCompactionConfigAuditEntry)this.wikiAuditHistory.getEntries().get(0);
        Assert.assertEquals((Object)this.wikiCompactionConfig, (Object)auditEntry.getCompactionConfig());
        Assert.assertEquals((Object)this.auditInfo, (Object)auditEntry.getAuditInfo());
        Assert.assertEquals((Object)auditTime, (Object)auditEntry.getAuditTime());
    }

    @Test
    public void testAddDeleteDatasourceConfigShouldAddBothToHistory() {
        DateTime auditTime = DateTimes.nowUtc();
        this.wikiAuditHistory.add(DruidCompactionConfig.empty().withDatasourceConfig(this.wikiCompactionConfig), this.auditInfo, auditTime);
        this.wikiAuditHistory.add(DruidCompactionConfig.empty(), this.auditInfo, auditTime.plusHours(2));
        List entries = this.wikiAuditHistory.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        DataSourceCompactionConfigAuditEntry firstEntry = (DataSourceCompactionConfigAuditEntry)entries.get(0);
        Assert.assertEquals((Object)this.wikiCompactionConfig, (Object)firstEntry.getCompactionConfig());
        Assert.assertEquals((Object)this.auditInfo, (Object)firstEntry.getAuditInfo());
        Assert.assertEquals((Object)auditTime, (Object)firstEntry.getAuditTime());
        DataSourceCompactionConfigAuditEntry secondEntry = (DataSourceCompactionConfigAuditEntry)entries.get(1);
        Assert.assertNull((Object)secondEntry.getCompactionConfig());
        Assert.assertEquals((Object)firstEntry.getGlobalConfig(), (Object)secondEntry.getGlobalConfig());
        Assert.assertEquals((Object)this.auditInfo, (Object)secondEntry.getAuditInfo());
        Assert.assertEquals((Object)auditTime.plusHours(2), (Object)secondEntry.getAuditTime());
    }

    @Test
    public void testAddDeleteAnotherDatasourceConfigShouldNotAddToHistory() {
        InlineSchemaDataSourceCompactionConfig koalaCompactionConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("koala").build();
        this.wikiAuditHistory.add(DruidCompactionConfig.empty().withDatasourceConfig((DataSourceCompactionConfig)koalaCompactionConfig), this.auditInfo, DateTimes.nowUtc());
        this.wikiAuditHistory.add(DruidCompactionConfig.empty(), this.auditInfo, DateTimes.nowUtc());
        Assert.assertTrue((boolean)this.wikiAuditHistory.getEntries().isEmpty());
    }

    @Test
    public void testAddDeleteAddDatasourceConfigShouldAddAllToHistory() {
        DateTime auditTime = DateTimes.nowUtc();
        this.wikiAuditHistory.add(DruidCompactionConfig.empty().withDatasourceConfig(this.wikiCompactionConfig), this.auditInfo, auditTime);
        this.wikiAuditHistory.add(DruidCompactionConfig.empty(), this.auditInfo, auditTime.plusHours(2));
        this.wikiAuditHistory.add(DruidCompactionConfig.empty().withDatasourceConfig(this.wikiCompactionConfig), this.auditInfo, auditTime.plusHours(3));
        List entries = this.wikiAuditHistory.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        DataSourceCompactionConfigAuditEntry firstEntry = (DataSourceCompactionConfigAuditEntry)entries.get(0);
        DataSourceCompactionConfigAuditEntry thirdEntry = (DataSourceCompactionConfigAuditEntry)entries.get(2);
        Assert.assertTrue((boolean)firstEntry.hasSameConfig(thirdEntry));
    }

    @Test
    public void testAddModifyDatasourceConfigShouldAddBothToHistory() {
        DateTime auditTime = DateTimes.nowUtc();
        this.wikiAuditHistory.add(DruidCompactionConfig.empty().withDatasourceConfig(this.wikiCompactionConfig), this.auditInfo, auditTime);
        InlineSchemaDataSourceCompactionConfig updatedWikiConfig = InlineSchemaDataSourceCompactionConfig.builder().forDataSource("wiki").withSkipOffsetFromLatest(Period.hours((int)5)).build();
        this.wikiAuditHistory.add(DruidCompactionConfig.empty().withDatasourceConfig((DataSourceCompactionConfig)updatedWikiConfig), this.auditInfo, auditTime.plusHours(3));
        List entries = this.wikiAuditHistory.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        DataSourceCompactionConfigAuditEntry firstEntry = (DataSourceCompactionConfigAuditEntry)entries.get(0);
        DataSourceCompactionConfigAuditEntry secondEntry = (DataSourceCompactionConfigAuditEntry)entries.get(1);
        Assert.assertEquals((Object)firstEntry.getGlobalConfig(), (Object)secondEntry.getGlobalConfig());
        Assert.assertEquals((Object)this.wikiCompactionConfig, (Object)firstEntry.getCompactionConfig());
        Assert.assertEquals((Object)updatedWikiConfig, (Object)secondEntry.getCompactionConfig());
        Assert.assertFalse((boolean)firstEntry.hasSameConfig(secondEntry));
    }

    @Test
    public void testAddAndModifyClusterConfigShouldAddTwice() {
        DruidCompactionConfig originalConfig = DruidCompactionConfig.empty().withDatasourceConfig(this.wikiCompactionConfig);
        this.wikiAuditHistory.add(originalConfig, this.auditInfo, DateTimes.nowUtc());
        DruidCompactionConfig updatedConfig = originalConfig.withClusterConfig(new ClusterCompactionConfig(Double.valueOf(0.2), null, null, null, null));
        this.wikiAuditHistory.add(updatedConfig, this.auditInfo, DateTimes.nowUtc());
        List entries = this.wikiAuditHistory.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        DataSourceCompactionConfigAuditEntry firstEntry = (DataSourceCompactionConfigAuditEntry)entries.get(0);
        DataSourceCompactionConfigAuditEntry secondEntry = (DataSourceCompactionConfigAuditEntry)entries.get(1);
        Assert.assertEquals((Object)secondEntry.getCompactionConfig(), (Object)firstEntry.getCompactionConfig());
        Assert.assertEquals((Object)originalConfig.clusterConfig(), (Object)firstEntry.getGlobalConfig());
        Assert.assertEquals((Object)updatedConfig.clusterConfig(), (Object)secondEntry.getGlobalConfig());
        Assert.assertFalse((boolean)firstEntry.hasSameConfig(secondEntry));
    }
}

