/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import java.util.Properties;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordinator.config.CoordinatorKillConfigs;
import org.apache.druid.server.coordinator.config.CoordinatorPeriodConfig;
import org.apache.druid.server.coordinator.config.CoordinatorRunConfig;
import org.apache.druid.server.coordinator.config.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.config.HttpLoadQueuePeonConfig;
import org.apache.druid.server.coordinator.config.KillUnusedSegmentsConfig;
import org.apache.druid.server.coordinator.config.MetadataCleanupConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.junit.Assert;
import org.junit.Test;

public class DruidCoordinatorConfigTest {
    @Test
    public void testCoordinatorRunConfigDefaultValues() {
        Properties props = new Properties();
        CoordinatorRunConfig config = this.deserializeFrom(props, "druid.coordinator", CoordinatorRunConfig.class);
        Assert.assertEquals((Object)Duration.standardMinutes((long)1L), (Object)config.getPeriod());
        Assert.assertEquals((Object)Duration.standardMinutes((long)5L), (Object)config.getStartDelay());
    }

    @Test
    public void testCoordinatorRunConfigOverrideValues() {
        Properties props = new Properties();
        props.setProperty("druid.coordinator.startDelay", "PT10M");
        props.setProperty("druid.coordinator.period", "PT30S");
        CoordinatorRunConfig config = this.deserializeFrom(props, "druid.coordinator", CoordinatorRunConfig.class);
        Assert.assertEquals((Object)Duration.standardSeconds((long)30L), (Object)config.getPeriod());
        Assert.assertEquals((Object)Duration.standardMinutes((long)10L), (Object)config.getStartDelay());
    }

    @Test
    public void testCoordinatorPeriodConfigDefaultValues() {
        Properties props = new Properties();
        CoordinatorPeriodConfig config = this.deserializeFrom(props, "druid.coordinator.period", CoordinatorPeriodConfig.class);
        Assert.assertEquals((Object)Duration.standardMinutes((long)30L), (Object)config.getIndexingPeriod());
        Assert.assertEquals((Object)Duration.standardMinutes((long)60L), (Object)config.getMetadataStoreManagementPeriod());
    }

    @Test
    public void testCoordinatorPeriodConfigOverrideValues() {
        Properties props = new Properties();
        props.setProperty("druid.coordinator.period.indexingPeriod", "PT1M");
        props.setProperty("druid.coordinator.period.metadataStoreManagementPeriod", "PT3M");
        CoordinatorPeriodConfig config = this.deserializeFrom(props, "druid.coordinator.period", CoordinatorPeriodConfig.class);
        Assert.assertEquals((Object)Duration.standardMinutes((long)1L), (Object)config.getIndexingPeriod());
        Assert.assertEquals((Object)Duration.standardMinutes((long)3L), (Object)config.getMetadataStoreManagementPeriod());
    }

    @Test
    public void testLoadQueuePeonConfigDefaultValues() {
        Properties props = new Properties();
        HttpLoadQueuePeonConfig config = this.deserializeFrom(props, "druid.coordinator.loadqueuepeon.http", HttpLoadQueuePeonConfig.class);
        Assert.assertEquals((Object)Duration.standardMinutes((long)1L), (Object)config.getRepeatDelay());
        Assert.assertEquals((Object)Duration.standardMinutes((long)5L), (Object)config.getHostTimeout());
        Assert.assertEquals((Object)Duration.standardMinutes((long)15L), (Object)config.getLoadTimeout());
        Assert.assertNull((Object)config.getBatchSize());
    }

    @Test
    public void testLoadQueuePeonConfigOverrideValues() {
        Properties props = new Properties();
        props.setProperty("druid.coordinator.loadqueuepeon.http.repeatDelay", "PT20M");
        props.setProperty("druid.coordinator.loadqueuepeon.http.hostTimeout", "PT10M");
        props.setProperty("druid.coordinator.loadqueuepeon.http.batchSize", "100");
        HttpLoadQueuePeonConfig config = this.deserializeFrom(props, "druid.coordinator.loadqueuepeon.http", HttpLoadQueuePeonConfig.class);
        Assert.assertEquals((Object)Duration.standardMinutes((long)20L), (Object)config.getRepeatDelay());
        Assert.assertEquals((Object)Duration.standardMinutes((long)10L), (Object)config.getHostTimeout());
        Assert.assertEquals((Object)Duration.standardMinutes((long)15L), (Object)config.getLoadTimeout());
        Assert.assertEquals((Object)100, (Object)config.getBatchSize());
    }

    @Test
    public void testMetadataCleanupConfigDefaultValues() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(null, null, null);
        Assert.assertTrue((boolean)config.isCleanupEnabled());
        Assert.assertEquals((Object)Duration.standardDays((long)1L), (Object)config.getCleanupPeriod());
        Assert.assertEquals((Object)Duration.standardDays((long)90L), (Object)config.getDurationToRetain());
    }

    @Test
    public void testMetadataCleanupConfigOverrideValues() {
        MetadataCleanupConfig config = new MetadataCleanupConfig(Boolean.valueOf(false), Period.parse((String)"PT5H").toStandardDuration(), Period.parse((String)"P1D").toStandardDuration());
        Assert.assertFalse((boolean)config.isCleanupEnabled());
        Assert.assertEquals((Object)Duration.standardHours((long)5L), (Object)config.getCleanupPeriod());
        Assert.assertEquals((Object)Duration.standardHours((long)24L), (Object)config.getDurationToRetain());
    }

    @Test
    public void testKillUnusedSegmentsConfigDefaultValues() {
        CoordinatorKillConfigs killConfigs = this.createKillConfig().build();
        KillUnusedSegmentsConfig config = killConfigs.unusedSegments(null);
        Assert.assertFalse((boolean)config.isCleanupEnabled());
        Assert.assertFalse((boolean)config.isIgnoreDurationToRetain());
        Assert.assertEquals((Object)Duration.standardDays((long)1L), (Object)config.getCleanupPeriod());
        Assert.assertEquals((Object)Duration.standardDays((long)30L), (Object)config.getBufferPeriod());
        Assert.assertEquals((Object)Duration.standardDays((long)90L), (Object)config.getDurationToRetain());
        Assert.assertEquals((long)100L, (long)config.getMaxSegments());
    }

    @Test
    public void testKillUnusedSegmentsConfigOverrideValues() {
        KillUnusedSegmentsConfig inputConfig = new KillUnusedSegmentsConfig(Boolean.valueOf(true), Period.parse((String)"PT30M").toStandardDuration(), Period.parse((String)"PT12H").toStandardDuration(), Boolean.valueOf(true), Period.parse((String)"PT60M").toStandardDuration(), Integer.valueOf(500), Period.days((int)2));
        CoordinatorKillConfigs killConfigs = this.createKillConfig().unusedSegments(inputConfig).build();
        KillUnusedSegmentsConfig config = killConfigs.unusedSegments(null);
        Assert.assertTrue((boolean)config.isCleanupEnabled());
        Assert.assertTrue((boolean)config.isIgnoreDurationToRetain());
        Assert.assertEquals((Object)Duration.standardMinutes((long)30L), (Object)config.getCleanupPeriod());
        Assert.assertEquals((Object)Duration.standardMinutes((long)60L), (Object)config.getBufferPeriod());
        Assert.assertEquals((Object)Duration.standardHours((long)12L), (Object)config.getDurationToRetain());
        Assert.assertEquals((long)500L, (long)config.getMaxSegments());
    }

    @Test
    public void testKillUnusedSegmentsPeriodLessThanIndexingPeriod() {
        KillUnusedSegmentsConfig killUnusedConfig = KillUnusedSegmentsConfig.builder().withCleanupPeriod(Duration.standardSeconds((long)5L)).build();
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().unusedSegments(killUnusedConfig).build(), new CoordinatorPeriodConfig(null, Duration.standardSeconds((long)10L)), "'druid.coordinator.kill.period'[PT5S] must be greater than or equal to 'druid.coordinator.period.indexingPeriod'[PT10S]", new Object[0]);
    }

    @Test
    public void testKillUnusedSegmentsMaxSegmentsNegative() {
        KillUnusedSegmentsConfig killUnusedConfig = KillUnusedSegmentsConfig.builder().withMaxSegmentsToKill(Integer.valueOf(-5)).build();
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().unusedSegments(killUnusedConfig).build(), new CoordinatorPeriodConfig(null, Duration.standardSeconds((long)10L)), "'druid.coordinator.kill.maxSegments'[-5] must be a positive integer.", new Object[0]);
    }

    @Test
    public void testCoordinatorKillConfigDefaultValues() {
        CoordinatorKillConfigs killConfigs = this.deserializeFrom(new Properties(), "druid.coordinator.kill", CoordinatorKillConfigs.class);
        Assert.assertEquals((Object)MetadataCleanupConfig.DEFAULT, (Object)killConfigs.auditLogs());
        Assert.assertEquals((Object)MetadataCleanupConfig.DEFAULT, (Object)killConfigs.supervisors());
        Assert.assertEquals((Object)MetadataCleanupConfig.DEFAULT, (Object)killConfigs.compactionConfigs());
        Assert.assertEquals((Object)MetadataCleanupConfig.DEFAULT, (Object)killConfigs.datasources());
        Assert.assertEquals((Object)MetadataCleanupConfig.DEFAULT, (Object)killConfigs.rules());
        Assert.assertEquals((Object)MetadataCleanupConfig.DEFAULT, (Object)killConfigs.pendingSegments());
        Assert.assertEquals((Object)MetadataCleanupConfig.DEFAULT, (Object)killConfigs.segmentSchemas());
    }

    @Test
    public void testCoordinatorKillConfigOverrideValues() {
        Properties props = new Properties();
        props.setProperty("druid.coordinator.kill.audit.on", "false");
        props.setProperty("druid.coordinator.kill.audit.period", "PT10H");
        props.setProperty("druid.coordinator.kill.audit.durationToRetain", "PT20H");
        props.setProperty("druid.coordinator.kill.compaction.on", "false");
        props.setProperty("druid.coordinator.kill.compaction.period", "PT20H");
        props.setProperty("druid.coordinator.kill.compaction.durationToRetain", "PT30H");
        props.setProperty("druid.coordinator.kill.datasource.on", "false");
        props.setProperty("druid.coordinator.kill.datasource.period", "PT5H");
        props.setProperty("druid.coordinator.kill.datasource.durationToRetain", "PT10H");
        props.setProperty("druid.coordinator.kill.rule.on", "false");
        props.setProperty("druid.coordinator.kill.rule.period", "PT11H");
        props.setProperty("druid.coordinator.kill.rule.durationToRetain", "PT12H");
        props.setProperty("druid.coordinator.kill.supervisor.on", "false");
        props.setProperty("druid.coordinator.kill.supervisor.period", "PT1H");
        props.setProperty("druid.coordinator.kill.supervisor.durationToRetain", "PT2H");
        props.setProperty("druid.coordinator.kill.pendingSegments.on", "false");
        props.setProperty("druid.coordinator.kill.segmentSchema.on", "false");
        props.setProperty("druid.coordinator.kill.segmentSchema.period", "PT2H");
        props.setProperty("druid.coordinator.kill.segmentSchema.durationToRetain", "PT8H");
        CoordinatorKillConfigs killConfigs = this.deserializeFrom(props, "druid.coordinator.kill", CoordinatorKillConfigs.class);
        Assert.assertEquals((Object)new MetadataCleanupConfig(Boolean.valueOf(false), Duration.standardHours((long)10L), Duration.standardHours((long)20L)), (Object)killConfigs.auditLogs());
        Assert.assertEquals((Object)new MetadataCleanupConfig(Boolean.valueOf(false), Duration.standardHours((long)20L), Duration.standardHours((long)30L)), (Object)killConfigs.compactionConfigs());
        Assert.assertEquals((Object)new MetadataCleanupConfig(Boolean.valueOf(false), Duration.standardHours((long)5L), Duration.standardHours((long)10L)), (Object)killConfigs.datasources());
        Assert.assertEquals((Object)new MetadataCleanupConfig(Boolean.valueOf(false), Duration.standardHours((long)11L), Duration.standardHours((long)12L)), (Object)killConfigs.rules());
        Assert.assertEquals((Object)new MetadataCleanupConfig(Boolean.valueOf(false), Duration.standardHours((long)1L), Duration.standardHours((long)2L)), (Object)killConfigs.supervisors());
        Assert.assertEquals((Object)new MetadataCleanupConfig(Boolean.valueOf(false), Duration.standardHours((long)2L), Duration.standardHours((long)8L)), (Object)killConfigs.segmentSchemas());
        Assert.assertFalse((boolean)killConfigs.pendingSegments().isCleanupEnabled());
    }

    @Test
    public void testCoordinatorConfigFailsWhenCleanupPeriodIsInvalid() {
        MetadataCleanupConfig cleanupConfig = new MetadataCleanupConfig(Boolean.valueOf(true), Duration.standardMinutes((long)30L), null);
        CoordinatorPeriodConfig periodConfig = new CoordinatorPeriodConfig(Duration.standardHours((long)1L), null);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().audit(cleanupConfig).build(), periodConfig, "'druid.coordinator.kill.audit.period'[PT1800S] must be greater than 'druid.coordinator.period.metadataStoreManagementPeriod'[PT3600S]", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().compaction(cleanupConfig).build(), periodConfig, "'druid.coordinator.kill.compaction.period'[PT1800S] must be greater than 'druid.coordinator.period.metadataStoreManagementPeriod'[PT3600S]", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().datasource(cleanupConfig).build(), periodConfig, "'druid.coordinator.kill.datasource.period'[PT1800S] must be greater than 'druid.coordinator.period.metadataStoreManagementPeriod'[PT3600S]", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().rules(cleanupConfig).build(), periodConfig, "'druid.coordinator.kill.rule.period'[PT1800S] must be greater than 'druid.coordinator.period.metadataStoreManagementPeriod'[PT3600S]", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().supervisors(cleanupConfig).build(), periodConfig, "'druid.coordinator.kill.supervisor.period'[PT1800S] must be greater than 'druid.coordinator.period.metadataStoreManagementPeriod'[PT3600S]", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().segmentSchema(cleanupConfig).build(), periodConfig, "'druid.coordinator.kill.segmentSchema.period'[PT1800S] must be greater than 'druid.coordinator.period.metadataStoreManagementPeriod'[PT3600S]", new Object[0]);
    }

    @Test
    public void testCoordinatorConfigFailsWhenRetainDurationIsNegative() {
        MetadataCleanupConfig cleanupConfig = new MetadataCleanupConfig(Boolean.valueOf(true), null, Duration.standardSeconds((long)1L).negated());
        CoordinatorPeriodConfig defaultPeriodConfig = new CoordinatorPeriodConfig(null, null);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().audit(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.audit.durationToRetain'[PT-1S] must be 0 milliseconds or higher", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().compaction(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.compaction.durationToRetain'[PT-1S] must be 0 milliseconds or higher", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().datasource(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.datasource.durationToRetain'[PT-1S] must be 0 milliseconds or higher", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().rules(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.rule.durationToRetain'[PT-1S] must be 0 milliseconds or higher", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().supervisors(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.supervisor.durationToRetain'[PT-1S] must be 0 milliseconds or higher", new Object[0]);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().segmentSchema(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.segmentSchema.durationToRetain'[PT-1S] must be 0 milliseconds or higher", new Object[0]);
    }

    @Test
    public void testCoordinatorConfigFailsWhenRetainDurationIsHigherThanCurrentTime() {
        Duration futureRetainDuration = Duration.millis((long)System.currentTimeMillis()).plus(10000L);
        MetadataCleanupConfig cleanupConfig = new MetadataCleanupConfig(Boolean.valueOf(true), null, futureRetainDuration);
        CoordinatorPeriodConfig defaultPeriodConfig = new CoordinatorPeriodConfig(null, null);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().audit(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.audit.durationToRetain'[%s] cannot be greater than current time in milliseconds", futureRetainDuration);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().compaction(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.compaction.durationToRetain'[%s] cannot be greater than current time in milliseconds", futureRetainDuration);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().datasource(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.datasource.durationToRetain'[%s] cannot be greater than current time in milliseconds", futureRetainDuration);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().rules(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.rule.durationToRetain'[%s] cannot be greater than current time in milliseconds", futureRetainDuration);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().supervisors(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.supervisor.durationToRetain'[%s] cannot be greater than current time in milliseconds", futureRetainDuration);
        this.verifyCoordinatorConfigFailsWith(this.createKillConfig().segmentSchema(cleanupConfig).build(), defaultPeriodConfig, "'druid.coordinator.kill.segmentSchema.durationToRetain'[%s] cannot be greater than current time in milliseconds", futureRetainDuration);
    }

    @Test
    public void testSomeBasicStuff() {
        Duration millis = Duration.millis((long)1L);
        Duration days = Duration.standardDays((long)1L);
        System.out.println(millis.getMillis() + ", " + days);
    }

    private KillConfigBuilder createKillConfig() {
        return new KillConfigBuilder();
    }

    private void verifyCoordinatorConfigFailsWith(CoordinatorKillConfigs killConfig, CoordinatorPeriodConfig periodConfig, String expectedMessageFormat, Object ... args) {
        DruidException exception = (DruidException)Assert.assertThrows(DruidException.class, () -> new DruidCoordinatorConfig(new CoordinatorRunConfig(null, null), periodConfig, killConfig, null, null));
        String expectedMessage = StringUtils.format((String)expectedMessageFormat, (Object[])args);
        MatcherAssert.assertThat((Object)exception, (Matcher)new DruidExceptionMatcher(DruidException.Persona.OPERATOR, DruidException.Category.INVALID_INPUT, "general").expectMessageIs(expectedMessage));
    }

    private Injector createInjector(String propertyPrefix, Class<?> clazz) {
        return GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> JsonConfigProvider.bind((Binder)binder, (String)propertyPrefix, (Class)clazz)));
    }

    private <T> T deserializeFrom(Properties props, String propertyPrefix, Class<T> type) {
        Injector injector = this.createInjector(propertyPrefix, type);
        JsonConfigProvider provider = JsonConfigProvider.of((String)propertyPrefix, type);
        provider.inject(props, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        return (T)provider.get();
    }

    private static class KillConfigBuilder {
        MetadataCleanupConfig audit;
        MetadataCleanupConfig compaction;
        MetadataCleanupConfig datasource;
        MetadataCleanupConfig rules;
        MetadataCleanupConfig supervisors;
        MetadataCleanupConfig pendingSegments;
        MetadataCleanupConfig segmentSchema;
        KillUnusedSegmentsConfig unusedSegments;

        private KillConfigBuilder() {
        }

        KillConfigBuilder audit(MetadataCleanupConfig config) {
            this.audit = config;
            return this;
        }

        KillConfigBuilder compaction(MetadataCleanupConfig config) {
            this.compaction = config;
            return this;
        }

        KillConfigBuilder datasource(MetadataCleanupConfig config) {
            this.datasource = config;
            return this;
        }

        KillConfigBuilder rules(MetadataCleanupConfig config) {
            this.rules = config;
            return this;
        }

        KillConfigBuilder supervisors(MetadataCleanupConfig config) {
            this.supervisors = config;
            return this;
        }

        KillConfigBuilder segmentSchema(MetadataCleanupConfig config) {
            this.segmentSchema = config;
            return this;
        }

        KillConfigBuilder unusedSegments(KillUnusedSegmentsConfig config) {
            this.unusedSegments = config;
            return this;
        }

        CoordinatorKillConfigs build() {
            return new CoordinatorKillConfigs(this.pendingSegments, this.supervisors, this.audit, this.datasource, this.rules, this.compaction, this.segmentSchema, this.unusedSegments == null ? null : Boolean.valueOf(this.unusedSegments.isCleanupEnabled()), this.unusedSegments == null ? null : this.unusedSegments.getCleanupPeriod(), this.unusedSegments == null ? null : this.unusedSegments.getDurationToRetain(), this.unusedSegments == null ? null : Boolean.valueOf(this.unusedSegments.isIgnoreDurationToRetain()), this.unusedSegments == null ? null : this.unusedSegments.getBufferPeriod(), this.unusedSegments == null ? null : Integer.valueOf(this.unusedSegments.getMaxSegments()), this.unusedSegments == null ? null : this.unusedSegments.getMaxInterval());
        }
    }
}

