/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.balancer;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.coordinator.balancer.SegmentsCostCache;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.junit.Assert;
import org.junit.Test;

public class SegmentsCostCacheTest {
    private static final String DATA_SOURCE = "dataSource";
    private static final DateTime REFERENCE_TIME = DateTimes.of((String)"2014-01-01T00:00:00");
    private static final double EPSILON = 1.0E-8;

    @Test
    public void segmentCacheTest() {
        SegmentsCostCache.Builder cacheBuilder = SegmentsCostCache.builder();
        cacheBuilder.addSegment(SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 0), 100L));
        SegmentsCostCache cache = cacheBuilder.build();
        Assert.assertEquals((double)7.8735899489011E-4, (double)cache.cost(SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, -2), 100L)), (double)1.0E-8);
    }

    @Test
    public void notInCalculationIntervalCostTest() {
        SegmentsCostCache.Builder cacheBuilder = SegmentsCostCache.builder();
        cacheBuilder.addSegment(SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 0), 100L));
        SegmentsCostCache cache = cacheBuilder.build();
        Assert.assertEquals((double)0.0, (double)cache.cost(SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, (int)TimeUnit.DAYS.toHours(50L)), 100L)), (double)1.0E-8);
    }

    @Test
    public void twoSegmentsCostTest() {
        DataSegment segmentA = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 0), 100L);
        DataSegment segmentB = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, -2), 100L);
        SegmentsCostCache.Bucket.Builder prototype = SegmentsCostCache.Bucket.builder((Interval)new Interval((ReadableInstant)REFERENCE_TIME.minusHours(5), (ReadableInstant)REFERENCE_TIME.plusHours(5)));
        prototype.addSegment(segmentA);
        SegmentsCostCache.Bucket bucket = prototype.build();
        double segmentCost = bucket.cost(segmentB);
        Assert.assertEquals((double)7.8735899489011E-4, (double)segmentCost, (double)1.0E-8);
    }

    @Test
    public void calculationIntervalTest() {
        DataSegment segmentA = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 0), 100L);
        DataSegment segmentB = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, (int)TimeUnit.DAYS.toHours(50L)), 100L);
        SegmentsCostCache.Bucket.Builder prototype = SegmentsCostCache.Bucket.builder((Interval)new Interval((ReadableInstant)REFERENCE_TIME.minusHours(5), (ReadableInstant)REFERENCE_TIME.plusHours(5)));
        prototype.addSegment(segmentA);
        SegmentsCostCache.Bucket bucket = prototype.build();
        Assert.assertTrue((boolean)bucket.inCalculationInterval(segmentA));
        Assert.assertFalse((boolean)bucket.inCalculationInterval(segmentB));
    }

    @Test
    public void sameSegmentCostTest() {
        DataSegment segmentA = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 0), 100L);
        DataSegment segmentB = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 0), 100L);
        SegmentsCostCache.Bucket.Builder prototype = SegmentsCostCache.Bucket.builder((Interval)new Interval((ReadableInstant)REFERENCE_TIME.minusHours(5), (ReadableInstant)REFERENCE_TIME.plusHours(5)));
        prototype.addSegment(segmentA);
        SegmentsCostCache.Bucket bucket = prototype.build();
        double segmentCost = bucket.cost(segmentB);
        Assert.assertEquals((double)8.26147353873985E-4, (double)segmentCost, (double)1.0E-8);
    }

    @Test
    public void multipleSegmentsCostTest() {
        DataSegment segmentA = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, -2), 100L);
        DataSegment segmentB = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 0), 100L);
        DataSegment segmentC = SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 2), 100L);
        SegmentsCostCache.Bucket.Builder prototype = SegmentsCostCache.Bucket.builder((Interval)new Interval((ReadableInstant)REFERENCE_TIME.minusHours(5), (ReadableInstant)REFERENCE_TIME.plusHours(5)));
        prototype.addSegment(segmentA);
        prototype.addSegment(segmentC);
        SegmentsCostCache.Bucket bucket = prototype.build();
        double segmentCost = bucket.cost(segmentB);
        Assert.assertEquals((double)0.001574717989780039, (double)segmentCost, (double)1.0E-8);
    }

    @Test
    public void randomSegmentsCostTest() {
        ArrayList<DataSegment> dataSegments = new ArrayList<DataSegment>(1000);
        Random random = new Random(1L);
        for (int i = 0; i < 1000; ++i) {
            dataSegments.add(SegmentsCostCacheTest.createSegment(DATA_SOURCE, SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, random.nextInt(20)), 100L));
        }
        DataSegment referenceSegment = SegmentsCostCacheTest.createSegment("ANOTHER_DATA_SOURCE", SegmentsCostCacheTest.shifted1HInterval(REFERENCE_TIME, 5), 100L);
        SegmentsCostCache.Bucket.Builder prototype = SegmentsCostCache.Bucket.builder((Interval)new Interval((ReadableInstant)REFERENCE_TIME.minusHours(1), (ReadableInstant)REFERENCE_TIME.plusHours(25)));
        dataSegments.forEach(arg_0 -> ((SegmentsCostCache.Bucket.Builder)prototype).addSegment(arg_0));
        SegmentsCostCache.Bucket bucket = prototype.build();
        double cost = bucket.cost(referenceSegment);
        Assert.assertEquals((double)0.7065117101966677, (double)cost, (double)1.0E-8);
    }

    private static Interval shifted1HInterval(DateTime REFERENCE_TIME, int shiftInHours) {
        return new Interval((ReadableInstant)REFERENCE_TIME.plusHours(shiftInHours), (ReadableInstant)REFERENCE_TIME.plusHours(shiftInHours + 1));
    }

    private static DataSegment createSegment(String dataSource, Interval interval, long size) {
        return new DataSegment(dataSource, interval, UUID.randomUUID().toString(), new ConcurrentHashMap(), new ArrayList(), new ArrayList(), null, Integer.valueOf(0), size);
    }
}

