/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.Map;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.server.coordinator.stats.Stats;
import org.junit.Assert;
import org.junit.Test;

public class HistoricalCloningTest
extends CoordinatorSimulationBaseTest {
    private static final long SIZE_1TB = 1000000L;
    private DruidServer historicalT11;
    private DruidServer historicalT12;
    private DruidServer historicalT13;
    private final String datasource = "wiki";

    @Override
    public void setUp() {
        this.historicalT11 = HistoricalCloningTest.createHistorical(1, "tier_t1", 1000000L);
        this.historicalT12 = HistoricalCloningTest.createHistorical(2, "tier_t1", 1000000L);
        this.historicalT13 = HistoricalCloningTest.createHistorical(3, "tier_t1", 1000000L);
    }

    @Test
    public void testSimpleCloning() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X1D).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withDynamicConfig(CoordinatorDynamicConfig.builder().withCloneServers(Map.of(this.historicalT12.getHost(), this.historicalT11.getHost())).withSmartSegmentLoading(true).build()).withImmediateSegmentLoading(true).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10L);
        this.verifyValue(Stats.Segments.ASSIGNED_TO_CLONE.getMetricName(), Map.of("server", this.historicalT12.getName()), 10L);
        this.verifyValue("segment/loadQueue/success", Map.of("server", this.historicalT11.getName(), "description", "LOAD: NORMAL"), 10L);
        this.verifyValue("segment/loadQueue/success", Map.of("server", this.historicalT12.getName(), "description", "LOAD: NORMAL"), 10L);
        Assert.assertEquals((long)CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.size(), (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.size(), (long)this.historicalT12.getTotalSegments());
        CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.forEach(segment -> {
            Assert.assertEquals((Object)segment, (Object)this.historicalT11.getSegment(segment.getId()));
            Assert.assertEquals((Object)segment, (Object)this.historicalT12.getSegment(segment.getId()));
        });
    }

    @Test
    public void testAddingNewHistorical() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X1D).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withDynamicConfig(CoordinatorDynamicConfig.builder().withCloneServers(Map.of(this.historicalT12.getHost(), this.historicalT11.getHost())).withSmartSegmentLoading(true).build()).withImmediateSegmentLoading(true).build();
        CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.forEach(segment -> {
            this.historicalT11.addDataSegment(segment);
            this.historicalT12.addDataSegment(segment);
        });
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)10L, (long)this.historicalT12.getTotalSegments());
        DruidServer newHistorical = HistoricalCloningTest.createHistorical(3, "tier_t1", 10000L);
        this.addServer(newHistorical);
        this.runCoordinatorCycle();
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
        Assert.assertEquals((long)5L, (long)newHistorical.getTotalSegments());
        this.verifyValue(Stats.Segments.DROPPED_FROM_CLONE.getMetricName(), Map.of("server", this.historicalT12.getName()), 5L);
    }

    @Test
    public void testCloningServerDisappearsAndRelaunched() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X1D).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).withDynamicConfig(CoordinatorDynamicConfig.builder().withCloneServers(Map.of(this.historicalT12.getHost(), this.historicalT11.getHost())).withSmartSegmentLoading(true).build()).withImmediateSegmentLoading(true).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)10L, (long)this.historicalT12.getTotalSegments());
        this.removeServer(this.historicalT12);
        CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.forEach(segment -> this.historicalT12.removeDataSegment(segment.getId()));
        this.runCoordinatorCycle();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)0L, (long)this.historicalT12.getTotalSegments());
        this.addServer(this.historicalT12);
        this.runCoordinatorCycle();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)10L, (long)this.historicalT12.getTotalSegments());
        this.verifyValue(Stats.Segments.ASSIGNED_TO_CLONE.getMetricName(), Map.of("server", this.historicalT12.getName()), 10L);
        this.verifyValue("segment/loadQueue/success", Map.of("server", this.historicalT12.getName(), "description", "LOAD: NORMAL"), 10L);
        Assert.assertEquals((long)CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.size(), (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.size(), (long)this.historicalT12.getTotalSegments());
        CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.forEach(segment -> {
            Assert.assertEquals((Object)segment, (Object)this.historicalT11.getSegment(segment.getId()));
            Assert.assertEquals((Object)segment, (Object)this.historicalT12.getSegment(segment.getId()));
        });
    }

    @Test
    public void testClonedServerDoesNotFollowReplicationLimit() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X100D).withServers(this.historicalT11).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withDynamicConfig(CoordinatorDynamicConfig.builder().withCloneServers(Map.of(this.historicalT12.getHost(), this.historicalT11.getHost())).withSmartSegmentLoading(true).withReplicationThrottleLimit(2).build()).withImmediateSegmentLoading(true).build();
        CoordinatorSimulationBaseTest.Segments.WIKI_10X100D.forEach(segment -> this.historicalT11.addDataSegment(segment));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        Assert.assertEquals((long)1000L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)0L, (long)this.historicalT12.getTotalSegments());
        this.addServer(this.historicalT12);
        this.runCoordinatorCycle();
        Assert.assertEquals((long)1000L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)1000L, (long)this.historicalT12.getTotalSegments());
        this.verifyValue(Stats.Segments.ASSIGNED_TO_CLONE.getMetricName(), Map.of("server", this.historicalT12.getName()), 1000L);
        this.verifyValue("segment/loadQueue/success", Map.of("server", this.historicalT12.getName(), "description", "LOAD: NORMAL"), 1000L);
    }

    @Test
    public void testCloningHistoricalWithReplicationLimit() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X1D).withServers(this.historicalT11, this.historicalT12, this.historicalT13).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).withImmediateSegmentLoading(true).withDynamicConfig(CoordinatorDynamicConfig.builder().withCloneServers(Map.of(this.historicalT12.getHost(), this.historicalT11.getHost())).withSmartSegmentLoading(false).withReplicationThrottleLimit(2).withMaxSegmentsToMove(0).build()).withImmediateSegmentLoading(true).build();
        CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.forEach(arg_0 -> ((DruidServer)this.historicalT13).addDataSegment(arg_0));
        this.startSimulation(sim);
        while (this.historicalT11.getTotalSegments() < CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.size()) {
            this.runCoordinatorCycle();
            Assert.assertEquals((long)this.historicalT11.getTotalSegments(), (long)this.historicalT12.getTotalSegments());
            this.verifyValue("segment/assigned/count", 2L);
            this.verifyValue(Stats.Segments.ASSIGNED_TO_CLONE.getMetricName(), Map.of("server", this.historicalT12.getName()), 2L);
        }
        Assert.assertEquals((long)CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.size(), (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.size(), (long)this.historicalT12.getTotalSegments());
        Assert.assertEquals((long)CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.size(), (long)this.historicalT13.getTotalSegments());
        CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.forEach(segment -> {
            Assert.assertEquals((Object)segment, (Object)this.historicalT11.getSegment(segment.getId()));
            Assert.assertEquals((Object)segment, (Object)this.historicalT12.getSegment(segment.getId()));
            Assert.assertEquals((Object)segment, (Object)this.historicalT13.getSegment(segment.getId()));
        });
    }

    @Test
    public void test_loadsAreCancelledOnClone_ifSegmentsAreRemovedFromSource() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X1D).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withDynamicConfig(CoordinatorDynamicConfig.builder().withCloneServers(Map.of(this.historicalT12.getHost(), this.historicalT11.getHost())).withSmartSegmentLoading(true).build()).build();
        CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue(Stats.Segments.ASSIGNED_TO_CLONE.getMetricName(), Map.of("server", this.historicalT12.getName()), 10L);
        this.deleteSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X1D.subList(0, 5));
        this.runCoordinatorCycle();
        this.verifyValue("segment/loadQueue/cancelled", Map.of("server", this.historicalT12.getName()), 5L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
    }
}

