/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class SegmentBalancingTest
extends CoordinatorSimulationBaseTest {
    private DruidServer historicalT11;
    private DruidServer historicalT12;
    private final String datasource = "wiki";
    private final List<DataSegment> segments = CoordinatorSimulationBaseTest.Segments.WIKI_10X1D;

    @Override
    public void setUp() {
        this.historicalT11 = SegmentBalancingTest.createHistorical(1, "tier_t1", 10000L);
        this.historicalT12 = SegmentBalancingTest.createHistorical(2, "tier_t1", 10000L);
    }

    @Test
    public void testBalancingDoesNotOverReplicate() {
        this.testBalancingWithAutoSyncInventory(true);
    }

    @Test
    public void testBalancingWithStaleViewDoesNotOverReplicate() {
        this.testBalancingWithAutoSyncInventory(false);
    }

    private void testBalancingWithAutoSyncInventory(boolean autoSyncInventory) {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withAutoInventorySync(autoSyncInventory).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        if (!autoSyncInventory) {
            this.syncInventoryView();
        }
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 5L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
        this.verifyDatasourceIsFullyLoaded("wiki");
    }

    @Test
    public void testBalancingDoesNotUnderReplicateSegment() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 5L);
        this.loadQueuedSegmentsSkipCallbacks();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
        this.runCoordinatorCycle();
        this.loadQueuedSegmentsSkipCallbacks();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
        this.verifyNotEmitted("segment/dropped/count");
        this.verifyNotEmitted("segment/moved/count");
        this.loadQueuedSegments();
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
    }

    @Test
    public void testDropDoesNotHappenWhenLoadFails() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 5L);
        this.removeServer(this.historicalT12);
        this.loadQueuedSegments();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)0L, (long)this.historicalT12.getTotalSegments());
        this.verifyDatasourceIsFullyLoaded("wiki");
    }

    @Test
    public void testBalancingOfFullyReplicatedSegment() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 5L);
        this.verifyValue("segment/loadQueue/count", SegmentBalancingTest.filterByServer(this.historicalT12), 5L);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/dropped/count");
        this.verifyValue("segment/loadQueue/count", SegmentBalancingTest.filterByServer(this.historicalT12), 5L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
        this.verifyDatasourceIsFullyLoaded("wiki");
    }

    @Test
    public void testBalancingMovesSegmentsInLoadQueue() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10L);
        this.verifyValue("segment/loadQueue/count", SegmentBalancingTest.filterByServer(this.historicalT11), 10L);
        this.addServer(this.historicalT12);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/assigned/count");
        this.verifyValue("segment/loadQueue/cancelled", 5L);
        this.verifyValue("segment/moved/count", 5L);
        this.verifyValue("segment/loadQueue/count", SegmentBalancingTest.filterByServer(this.historicalT11), 5L);
        this.verifyValue("segment/loadQueue/count", SegmentBalancingTest.filterByServer(this.historicalT12), 5L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
    }

    @Test
    public void testBalancingDoesNotMoveLoadedSegmentsWhenTierIsBusy() {
        CoordinatorDynamicConfig dynamicConfig = CoordinatorDynamicConfig.builder().withSmartSegmentLoading(false).withMaxSegmentsToMove(3).withMaxSegmentsInNodeLoadingQueue(0).build();
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withDynamicConfig(dynamicConfig).withSegments(this.segments).withServers(this.historicalT11).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.startSimulation(sim);
        this.segments.subList(2, this.segments.size()).forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 2L);
        this.addServer(this.historicalT12);
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 3L);
        this.verifyValue("segment/loadQueue/cancelled", 2L);
        this.verifyValue("segment/loadQueue/count", SegmentBalancingTest.filterByServer(this.historicalT12), 3L);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/moved/count");
        this.loadQueuedSegments();
        this.runCoordinatorCycle();
        Assert.assertTrue((this.getValue("segment/moved/count", null).intValue() > 0 ? 1 : 0) != 0);
    }

    @Test(timeout=60000L)
    public void testMaxSegmentsAreMovedWhenClusterIsSkewed() {
        long size1TB = 1000000L;
        List<DruidServer> historicals = IntStream.range(0, 10).mapToObj(i -> SegmentBalancingTest.createHistorical(i + 1, "tier_t1", 1000000L)).collect(Collectors.toList());
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(CoordinatorSimulationBaseTest.Segments.KOALA_100X100D).withServers(historicals).withRules("koala", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10000L);
        this.verifyNotEmitted("segment/moved/count");
        this.verifySum("segment/moveSkipped/count", 100L);
        for (int i2 = 11; i2 <= 20; ++i2) {
            this.addServer(SegmentBalancingTest.createHistorical(i2, "tier_t1", 1000000L));
        }
        this.runCoordinatorCycle();
        this.verifyValue("segment/moved/count", 500L);
        this.verifyNotEmitted("segment/moveSkipped/count");
    }
}

