/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.druid.client.DruidServer;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulation;
import org.apache.druid.server.coordinator.simulate.CoordinatorSimulationBaseTest;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Test;

public class SegmentLoadingTest
extends CoordinatorSimulationBaseTest {
    private DruidServer historicalT11;
    private DruidServer historicalT12;
    private DruidServer historicalT13;
    private DruidServer historicalT21;
    private DruidServer historicalT22;
    private final String datasource = "wiki";
    private final List<DataSegment> segments = CoordinatorSimulationBaseTest.Segments.WIKI_10X1D;

    @Override
    public void setUp() {
        this.historicalT11 = SegmentLoadingTest.createHistorical(1, "tier_t1", 10000L);
        this.historicalT12 = SegmentLoadingTest.createHistorical(2, "tier_t1", 10000L);
        this.historicalT13 = SegmentLoadingTest.createHistorical(3, "tier_t1", 10000L);
        this.historicalT21 = SegmentLoadingTest.createHistorical(1, "tier_t2", 10000L);
        this.historicalT22 = SegmentLoadingTest.createHistorical(2, "tier_t2", 10000L);
    }

    @Test
    public void testSecondReplicaOnAnyTierIsThrottled() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).withDynamicConfig(this.withReplicationThrottleLimit(2)).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 2L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)2L, (long)this.historicalT12.getTotalSegments());
    }

    @Test
    public void testLoadingDoesNotOverassignHistorical() {
        DruidServer historicalT11 = SegmentLoadingTest.createHistorical(1, "tier_t1", 1000L);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(historicalT11).withDynamicConfig(this.withReplicationThrottleLimit(10)).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withImmediateSegmentLoading(false).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 2L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)2L, (long)historicalT11.getTotalSegments());
    }

    @Test
    public void testTierShiftDoesNotCauseUnderReplication() {
        DataSegment segment = this.segments.get(0);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(Collections.singletonList(segment)).withDynamicConfig(this.withReplicationThrottleLimit(10)).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t2", 3).forever()).withServers(this.historicalT11, this.historicalT12, this.historicalT21, this.historicalT22).build();
        this.historicalT11.addDataSegment(segment);
        this.historicalT12.addDataSegment(segment);
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/dropped/count");
        this.verifyValue("segment/assigned/count", SegmentLoadingTest.filterByTier("tier_t2"), 2L);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/dropped/count");
        this.verifyValue("segment/assigned/count", SegmentLoadingTest.filterByTier("tier_t2"), 0L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)2L, (long)this.getNumLoadedSegments(this.historicalT21, this.historicalT22));
        Assert.assertEquals((long)2L, (long)this.getNumLoadedSegments(this.historicalT11, this.historicalT12));
        this.runCoordinatorCycle();
        this.verifyValue("segment/dropped/count", SegmentLoadingTest.filterByTier("tier_t1"), 2L);
        this.verifyValue("segment/assigned/count", SegmentLoadingTest.filterByTier("tier_t2"), 0L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)2L, (long)this.getNumLoadedSegments(this.historicalT21, this.historicalT22));
        Assert.assertEquals((long)0L, (long)this.getNumLoadedSegments(this.historicalT11, this.historicalT12));
        DruidServer historicalT23 = SegmentLoadingTest.createHistorical(3, "tier_t2", 10000L);
        this.addServer(historicalT23);
        this.historicalT13.addDataSegment(segment);
        this.addServer(this.historicalT13);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/dropped/count");
        this.verifyValue("segment/assigned/count", SegmentLoadingTest.filterByTier("tier_t2"), 1L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)3L, (long)this.getNumLoadedSegments(this.historicalT21, this.historicalT22, historicalT23));
        Assert.assertEquals((long)1L, (long)this.historicalT13.getTotalSegments());
        this.runCoordinatorCycle();
        this.verifyValue("segment/dropped/count", SegmentLoadingTest.filterByTier("tier_t1"), 1L);
        this.verifyNotEmitted("segment/assigned/count");
        this.loadQueuedSegments();
        Assert.assertEquals((long)3L, (long)this.getNumLoadedSegments(this.historicalT21, this.historicalT22, historicalT23));
        Assert.assertEquals((long)0L, (long)this.getNumLoadedSegments(this.historicalT11, this.historicalT12, this.historicalT13));
        this.verifyDatasourceIsFullyLoaded("wiki");
    }

    @Test
    public void testTierAddDoesNotCauseUnderReplication() {
        DataSegment segment = this.segments.get(0);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(Collections.singletonList(segment)).withDynamicConfig(this.withReplicationThrottleLimit(10)).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).andOn("tier_t2", 1).forever()).withServers(this.historicalT11, this.historicalT12, this.historicalT21).build();
        this.historicalT11.addDataSegment(segment);
        this.historicalT12.addDataSegment(segment);
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/dropped/count");
        this.verifyValue("segment/assigned/count", SegmentLoadingTest.filterByTier("tier_t2"), 1L);
        this.runCoordinatorCycle();
        this.verifyNotEmitted("segment/dropped/count");
        this.verifyNotEmitted("segment/assigned/count");
        this.loadQueuedSegments();
        Assert.assertEquals((long)1L, (long)this.getNumLoadedSegments(this.historicalT21));
        Assert.assertEquals((long)2L, (long)this.getNumLoadedSegments(this.historicalT11, this.historicalT12));
        this.runCoordinatorCycle();
        this.verifyValue("segment/dropped/count", SegmentLoadingTest.filterByTier("tier_t1"), 1L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)1L, (long)this.getNumLoadedSegments(this.historicalT21));
        Assert.assertEquals((long)1L, (long)this.getNumLoadedSegments(this.historicalT11, this.historicalT12));
    }

    @Test
    public void testImmediateLoadingDoesNotOverassignHistorical() {
        DruidServer historicalT11 = SegmentLoadingTest.createHistorical(1, "tier_t1", 1000L);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(historicalT11).withDynamicConfig(this.withReplicationThrottleLimit(10)).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withImmediateSegmentLoading(true).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 2L);
        Assert.assertEquals((long)2L, (long)historicalT11.getTotalSegments());
    }

    @Test
    public void testMaxSegmentsInNodeLoadingQueue() {
        CoordinatorDynamicConfig dynamicConfig = CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(0).withReplicationThrottleLimit(10).withMaxSegmentsInNodeLoadingQueue(5).withUseRoundRobinSegmentAssignment(false).withSmartSegmentLoading(false).build();
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11).withDynamicConfig(dynamicConfig).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 5L);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 0L);
        this.historicalT11.addDataSegment(this.segments.get(9));
        this.historicalT11.addDataSegment(this.segments.get(8));
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 0L);
        this.verifyValue("segment/loadQueue/cancelled", 2L);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 2L);
    }

    @Test
    public void testFirstReplicaOnTierIsNotThrottled() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT21).withDynamicConfig(this.withReplicationThrottleLimit(2)).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).andOn("tier_t2", 1).forever()).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", SegmentLoadingTest.filterByTier("tier_t2"), 10L);
        this.loadQueuedSegments();
        this.verifyDatasourceIsFullyLoaded("wiki");
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)10L, (long)this.historicalT21.getTotalSegments());
    }

    @Test
    public void testImmediateLoadingDoesNotViolateThrottleLimit() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).withImmediateSegmentLoading(true).withDynamicConfig(this.withReplicationThrottleLimit(2)).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 2L);
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)2L, (long)this.historicalT12.getTotalSegments());
    }

    @Test
    public void testLoadOfFullyReplicatedSegmentGetsCancelled() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withDynamicConfig(this.withReplicationThrottleLimit(10)).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).build();
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10L);
        this.verifyValue("segment/loadQueue/count", SegmentLoadingTest.filterByServer(this.historicalT12), 10L);
        this.addServer(this.historicalT13);
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT13).addDataSegment(arg_0));
        this.runCoordinatorCycle();
        this.verifyValue("segment/loadQueue/cancelled", 10L);
        this.verifyValue("segment/loadQueue/count", SegmentLoadingTest.filterByServer(this.historicalT12), 0L);
    }

    @Test
    public void testBroadcastReplicasAreNotThrottled() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12, this.historicalT13).withDynamicConfig(this.withReplicationThrottleLimit(0)).withRules("wiki", CoordinatorSimulationBaseTest.Broadcast.forever()).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", SegmentLoadingTest.filterByDatasource("wiki"), 30L);
        this.verifyNotEmitted("segment/dropped/count");
    }

    @Test
    public void testReplicasAreNotAssignedIfTierIsBusy() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withDynamicConfig(this.withReplicationThrottleLimit(5)).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).build();
        this.startSimulation(sim);
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 5L);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 0L);
        this.loadQueuedSegments();
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 5L);
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
    }

    @Test
    public void testAllLoadsOnDecommissioningServerAreCancelled() {
        CoordinatorDynamicConfig dynamicConfig = this.withReplicationThrottleLimit(100);
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11, this.historicalT12).withDynamicConfig(dynamicConfig).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 2).forever()).build();
        this.startSimulation(sim);
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10L);
        this.setDynamicConfig(CoordinatorDynamicConfig.builder().withDecommissioningNodes(Collections.singleton(this.historicalT12.getName())).build(dynamicConfig));
        this.runCoordinatorCycle();
        this.verifyValue("segment/loadQueue/cancelled", 10L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)10L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)0L, (long)this.historicalT12.getTotalSegments());
    }

    @Test
    public void testLoadOfUnusedSegmentIsCancelled() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withSegments(this.segments).withServers(this.historicalT11).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.verifyValue("segment/assigned/count", 10L);
        this.setRetentionRules("wiki", CoordinatorSimulationBaseTest.Drop.forever());
        this.runCoordinatorCycle();
        this.verifyValue("segment/deleted/count", 10L);
        this.runCoordinatorCycle();
        this.verifyValue("segment/loadQueue/count", 0L);
        this.verifyValue("segment/loadQueue/cancelled", 10L);
    }

    @Test
    public void testSegmentsAreDroppedFromFullServersFirst() {
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withServers(this.historicalT11, this.historicalT12).withDynamicConfig(this.withReplicationThrottleLimit(100)).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withRules("koala", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).build();
        this.startSimulation(sim);
        this.addSegments(this.segments);
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.segments.forEach(arg_0 -> ((DruidServer)this.historicalT12).addDataSegment(arg_0));
        List<DataSegment> koalaSegments = CoordinatorSimulationBaseTest.Segments.KOALA_100X100D.subList(0, 2);
        this.addSegments(koalaSegments);
        koalaSegments.forEach(arg_0 -> ((DruidServer)this.historicalT11).addDataSegment(arg_0));
        this.runCoordinatorCycle();
        this.verifyValue("segment/dropQueue/count", SegmentLoadingTest.filterByServer(this.historicalT11), 6L);
        this.verifyValue("segment/dropQueue/count", SegmentLoadingTest.filterByServer(this.historicalT12), 4L);
        this.loadQueuedSegments();
        Assert.assertEquals((long)this.historicalT11.getCurrSize(), (long)this.historicalT12.getCurrSize());
    }

    @Test
    public void testSegmentLoadingModes() {
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().withTurboLoadingNodes(Set.of(this.historicalT11.getName())).build();
        CoordinatorSimulation sim = CoordinatorSimulation.builder().withServers(this.historicalT11, this.historicalT12).withDynamicConfig(config).withRules("wiki", CoordinatorSimulationBaseTest.Load.on("tier_t1", 1).forever()).withSegments(CoordinatorSimulationBaseTest.Segments.WIKI_10X1D).build();
        this.startSimulation(sim);
        this.runCoordinatorCycle();
        this.loadQueuedSegments();
        this.verifyValue("segment/assigned/count", 10L);
        Assert.assertEquals((long)5L, (long)this.historicalT11.getTotalSegments());
        Assert.assertEquals((long)5L, (long)this.historicalT12.getTotalSegments());
        this.runCoordinatorCycle();
        this.verifyValue("segment/loadQueue/success", Map.of("server", this.historicalT11.getName(), "description", "LOAD: TURBO"), 5L);
        this.verifyValue("segment/loadQueue/success", Map.of("server", this.historicalT12.getName(), "description", "LOAD: NORMAL"), 5L);
    }

    private int getNumLoadedSegments(DruidServer ... servers) {
        int numLoaded = 0;
        for (DruidServer server : servers) {
            numLoaded += server.getTotalSegments();
        }
        return numLoaded;
    }

    private CoordinatorDynamicConfig withReplicationThrottleLimit(int replicationThrottleLimit) {
        return CoordinatorDynamicConfig.builder().withSmartSegmentLoading(false).withMaxSegmentsToMove(0).withMaxSegmentsInNodeLoadingQueue(0).withReplicationThrottleLimit(replicationThrottleLimit).build();
    }
}

