/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.simulate;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.druid.discovery.DruidLeaderSelector;

public class TestDruidLeaderSelector
implements DruidLeaderSelector {
    private final AtomicInteger localTerm = new AtomicInteger(0);
    private final AtomicBoolean isLeader = new AtomicBoolean(false);
    private volatile DruidLeaderSelector.Listener listener;

    public void becomeLeader() {
        if (this.isLeader.compareAndSet(false, true)) {
            if (this.listener != null) {
                this.listener.becomeLeader();
            }
            this.localTerm.incrementAndGet();
        }
    }

    public void stopBeingLeader() {
        if (this.isLeader.compareAndSet(true, false) && this.listener != null) {
            this.listener.stopBeingLeader();
        }
    }

    @Nullable
    public String getCurrentLeader() {
        return "me";
    }

    public boolean isLeader() {
        return this.isLeader.get();
    }

    public int localTerm() {
        return this.localTerm.get();
    }

    public void registerListener(DruidLeaderSelector.Listener listener) {
        this.listener = listener;
        if (this.isLeader()) {
            listener.becomeLeader();
        }
    }

    public void unregisterListener() {
        this.listener = null;
    }
}

