/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.http.CoordinatorCompactionResource;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CoordinatorCompactionResourceTest {
    private DruidCoordinator mock;
    private final String dataSourceName = "datasource_1";
    private final AutoCompactionSnapshot expectedSnapshot = new AutoCompactionSnapshot("datasource_1", AutoCompactionSnapshot.ScheduleStatus.RUNNING, null, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L);

    @Before
    public void setUp() {
        this.mock = (DruidCoordinator)EasyMock.createStrictMock(DruidCoordinator.class);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.mock});
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithEmptyQueryParameter() {
        Map<String, AutoCompactionSnapshot> expected = Map.of("datasource_1", this.expectedSnapshot);
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshot()).andReturn(expected).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock).getCompactionSnapshotForDataSource("");
        Assert.assertEquals((Object)new CompactionStatusResponse(List.of(this.expectedSnapshot)), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithNullQueryParameter() {
        String dataSourceName = "datasource_1";
        ImmutableMap expected = ImmutableMap.of((Object)dataSourceName, (Object)this.expectedSnapshot);
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshot()).andReturn((Object)expected).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock).getCompactionSnapshotForDataSource(null);
        Assert.assertEquals((Object)new CompactionStatusResponse(List.of(this.expectedSnapshot)), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithValidQueryParameter() {
        String dataSourceName = "datasource_1";
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshotForDataSource(dataSourceName)).andReturn((Object)this.expectedSnapshot).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock).getCompactionSnapshotForDataSource(dataSourceName);
        Assert.assertEquals((Object)new CompactionStatusResponse(Collections.singletonList(this.expectedSnapshot)), (Object)response.getEntity());
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetCompactionSnapshotForDataSourceWithInvalidQueryParameter() {
        String dataSourceName = "invalid_datasource";
        EasyMock.expect((Object)this.mock.getAutoCompactionSnapshotForDataSource(dataSourceName)).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock).getCompactionSnapshotForDataSource(dataSourceName);
        Assert.assertEquals((long)404L, (long)response.getStatus());
    }

    @Test
    public void testGetProgressForNullDatasourceReturnsBadRequest() {
        EasyMock.replay((Object[])new Object[]{this.mock});
        Response response = new CoordinatorCompactionResource(this.mock).getCompactionProgress(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Object responseEntity = response.getEntity();
        Assert.assertTrue((boolean)(responseEntity instanceof ErrorResponse));
        MatcherAssert.assertThat((Object)((ErrorResponse)responseEntity).getUnderlyingException(), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("No DataSource specified"));
    }
}

