/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.Futures;
import java.util.List;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.rpc.RequestBuilder;
import org.apache.druid.rpc.ServiceClient;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordinator.CoordinatorConfigManager;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.http.CoordinatorDynamicConfigSyncer;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class CoordinatorDynamicConfigSyncerTest {
    private CoordinatorDynamicConfigSyncer target;
    private ServiceClient serviceClient;
    private CoordinatorConfigManager coordinatorConfigManager;
    private DruidNodeDiscovery druidNodeDiscovery;

    @Before
    public void setUp() throws Exception {
        this.serviceClient = (ServiceClient)Mockito.mock(ServiceClient.class);
        BytesFullResponseHolder holder = (BytesFullResponseHolder)Mockito.mock(BytesFullResponseHolder.class);
        ((BytesFullResponseHolder)Mockito.doReturn((Object)HttpResponseStatus.OK).when((Object)holder)).getStatus();
        ((ServiceClient)Mockito.doReturn((Object)Futures.immediateFuture((Object)holder)).when((Object)this.serviceClient)).asyncRequest((RequestBuilder)ArgumentMatchers.any(), (HttpResponseHandler)ArgumentMatchers.any());
        this.coordinatorConfigManager = (CoordinatorConfigManager)Mockito.mock(CoordinatorConfigManager.class);
        DruidNodeDiscoveryProvider provider = (DruidNodeDiscoveryProvider)Mockito.mock(DruidNodeDiscoveryProvider.class);
        this.druidNodeDiscovery = (DruidNodeDiscovery)Mockito.mock(DruidNodeDiscovery.class);
        ((DruidNodeDiscoveryProvider)Mockito.doReturn((Object)this.druidNodeDiscovery).when((Object)provider)).getForNodeRole(NodeRole.BROKER);
        this.target = new CoordinatorDynamicConfigSyncer((serviceName, serviceLocator, retryPolicy) -> this.serviceClient, this.coordinatorConfigManager, (ObjectMapper)DefaultObjectMapper.INSTANCE, provider, (ServiceEmitter)Mockito.mock(ServiceEmitter.class));
    }

    @Test
    public void testSync() {
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().withMaxSegmentsToMove(105).withReplicantLifetime(500).withReplicationThrottleLimit(5).build();
        ((CoordinatorConfigManager)Mockito.doReturn((Object)config).when((Object)this.coordinatorConfigManager)).getCurrentDynamicConfig();
        List<DiscoveryDruidNode> nodes = List.of(new DiscoveryDruidNode(new DruidNode("service", "host", false, Integer.valueOf(8080), null, true, false), NodeRole.BROKER, null, null));
        ((DruidNodeDiscovery)Mockito.doReturn(nodes).when((Object)this.druidNodeDiscovery)).getAllNodes();
        this.target.broadcastConfigToBrokers();
        RequestBuilder requestBuilder = new RequestBuilder(HttpMethod.POST, "/druid-internal/v1/config/coordinator").jsonContent((ObjectMapper)DefaultObjectMapper.INSTANCE, (Object)config);
        ((ServiceClient)Mockito.verify((Object)this.serviceClient)).asyncRequest((RequestBuilder)ArgumentMatchers.eq((Object)requestBuilder), (HttpResponseHandler)ArgumentMatchers.any());
    }
}

