/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.http.SegmentLoadingMode;
import org.apache.druid.utils.JvmUtils;
import org.junit.Assert;
import org.junit.Test;

public class CoordinatorDynamicConfigTest {
    private static final int EXPECTED_DEFAULT_MAX_SEGMENTS_IN_NODE_LOADING_QUEUE = 500;
    private final ObjectMapper mapper = TestHelper.makeJsonMapper();

    @Test
    public void testSerde() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"killTaskSlotRatio\": 0.15,\n  \"maxKillTaskSlots\": 2,\n  \"maxSegmentsInNodeLoadingQueue\": 1,\n  \"decommissioningNodes\": [\"host1\", \"host2\"],\n  \"pauseCoordination\": false,\n  \"replicateAfterLoadTimeout\": false,\n  \"turboLoadingNodes\":[\"host1\", \"host3\"],\n  \"cloneServers\":{\"host5\": \"host6\"}\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of((Object)"host1", (Object)"host2");
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        ImmutableSet turboLoadingNodes = ImmutableSet.of((Object)"host1", (Object)"host3");
        ImmutableMap cloneServers = ImmutableMap.of((Object)"host5", (Object)"host6");
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)decommissioning, false, false, (Set<String>)turboLoadingNodes, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningNodes((Set)ImmutableSet.of((Object)"host1")).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), false, false, (Set<String>)turboLoadingNodes, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), false, false, (Set<String>)turboLoadingNodes, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().withPauseCoordination(true).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, false, (Set<String>)turboLoadingNodes, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().withReplicateAfterLoadTimeout(true).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true, (Set<String>)turboLoadingNodes, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.15, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true, (Set<String>)turboLoadingNodes, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().withKillTaskSlotRatio(Double.valueOf(0.1)).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, 2, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true, (Set<String>)turboLoadingNodes, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().withMaxKillTaskSlots(Integer.valueOf(5)).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, 5, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true, (Set<String>)turboLoadingNodes, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().withTurboLoadingNodes((Set)ImmutableSet.of((Object)"host3")).withCloneServers((Map)ImmutableMap.of((Object)"host3", (Object)"host4")).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, 5, 1, (Set<String>)ImmutableSet.of((Object)"host1"), true, true, (Set<String>)ImmutableSet.of((Object)"host3"), (Map<String, String>)ImmutableMap.of((Object)"host3", (Object)"host4"));
    }

    @Test
    public void testDeserializationWithUnknownProperties() throws Exception {
        String jsonStr = "{\n  \"unknownProperty\": 2, \n  \"maxSegmentsInNodeLoadingQueue\": 15\n}\n";
        CoordinatorDynamicConfig dynamicConfig = (CoordinatorDynamicConfig)this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class);
        Assert.assertEquals((long)15L, (long)dynamicConfig.getMaxSegmentsInNodeLoadingQueue());
    }

    @Test
    public void testConstructorWithNullsShouldKillUnusedSegmentsInAllDataSources() {
        CoordinatorDynamicConfig config = new CoordinatorDynamicConfig(1L, 1, 1, 2, 10, null, null, null, null, null, (Object)ImmutableSet.of((Object)"host1"), true, true, Boolean.valueOf(false), Boolean.valueOf(false), null, (Set)ImmutableSet.of((Object)"host1"), null);
        Assert.assertTrue((boolean)config.getSpecificDataSourcesToKillUnusedSegmentsIn().isEmpty());
    }

    @Test
    public void testConstructorWithSpecificDataSourcesToKillShouldNotKillUnusedSegmentsInAllDatasources() {
        CoordinatorDynamicConfig config = new CoordinatorDynamicConfig(1L, 1, 1, 2, 10, (Object)ImmutableSet.of((Object)"test1"), null, null, null, null, (Object)ImmutableSet.of((Object)"host1"), true, true, Boolean.valueOf(false), Boolean.valueOf(false), null, (Set)ImmutableSet.of((Object)"host1"), null);
        Assert.assertEquals((Object)ImmutableSet.of((Object)"test1"), (Object)config.getSpecificDataSourcesToKillUnusedSegmentsIn());
    }

    @Test
    public void testDecommissioningParametersBackwardCompatibility() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1,\n  \"turboLoadingNodes\": [\"host3\",\"host4\"],\n  \"cloneServers\": {\"host3\":\"host4\", \"host5\":\"host6\"}\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of();
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        ImmutableSet turboLoading = ImmutableSet.of((Object)"host3", (Object)"host4");
        ImmutableMap cloneServers = ImmutableMap.of((Object)"host3", (Object)"host4", (Object)"host5", (Object)"host6");
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, Integer.MAX_VALUE, 1, (Set<String>)decommissioning, false, false, (Set<String>)turboLoading, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().withDecommissioningNodes((Set)ImmutableSet.of((Object)"host1")).build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, Integer.MAX_VALUE, 1, (Set<String>)ImmutableSet.of((Object)"host1"), false, false, (Set<String>)turboLoading, (Map<String, String>)cloneServers);
        actual = CoordinatorDynamicConfig.builder().build(actual);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, Integer.MAX_VALUE, 1, (Set<String>)ImmutableSet.of((Object)"host1"), false, false, (Set<String>)turboLoading, (Map<String, String>)cloneServers);
    }

    @Test
    public void testSerdeWithStringInKillDataSourceWhitelist() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"killDataSourceWhitelist\": \"test1, test2\", \n  \"maxSegmentsInNodeLoadingQueue\": 1\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)ImmutableSet.of((Object)"test1", (Object)"test2"), 0.1, Integer.MAX_VALUE, 1, (Set<String>)ImmutableSet.of(), false, false, (Set<String>)ImmutableSet.of(), (Map<String, String>)ImmutableMap.of());
    }

    @Test
    public void testHandleMissingPercentOfSegmentsToConsiderPerMove() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2, \n  \"killDataSourceWhitelist\": [\"test1\",\"test2\"],\n  \"maxSegmentsInNodeLoadingQueue\": 1,\n  \"decommissioningNodes\": [\"host1\", \"host2\"],\n  \"pauseCoordination\": false\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        ImmutableSet decommissioning = ImmutableSet.of((Object)"host1", (Object)"host2");
        ImmutableSet whitelist = ImmutableSet.of((Object)"test1", (Object)"test2");
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)whitelist, 0.1, Integer.MAX_VALUE, 1, (Set<String>)decommissioning, false, false, (Set<String>)ImmutableSet.of(), (Map<String, String>)ImmutableMap.of());
    }

    @Test
    public void testDeserializeWithoutMaxSegmentsInNodeLoadingQueue() throws Exception {
        String jsonStr = "{\n  \"millisToWaitBeforeDeleting\": 1,\n  \"maxSegmentsToMove\": 1,\n  \"replicantLifetime\": 1,\n  \"replicationThrottleLimit\": 1,\n  \"balancerComputeThreads\": 2\n}\n";
        CoordinatorDynamicConfig actual = (CoordinatorDynamicConfig)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, CoordinatorDynamicConfig.class)), CoordinatorDynamicConfig.class);
        this.assertConfig(actual, 1L, 1, 1, 1, 2, (Set<String>)ImmutableSet.of(), 0.1, Integer.MAX_VALUE, 500, (Set<String>)ImmutableSet.of(), false, false, (Set<String>)ImmutableSet.of(), (Map<String, String>)ImmutableMap.of());
    }

    @Test
    public void testBuilderDefaults() {
        CoordinatorDynamicConfig defaultConfig = CoordinatorDynamicConfig.builder().build();
        ImmutableSet emptyList = ImmutableSet.of();
        this.assertConfig(defaultConfig, 900000L, 100, 15, 500, CoordinatorDynamicConfigTest.getDefaultNumBalancerThreads(), (Set<String>)emptyList, 0.1, Integer.MAX_VALUE, 500, (Set<String>)emptyList, false, false, (Set<String>)ImmutableSet.of(), (Map<String, String>)ImmutableMap.of());
    }

    @Test
    public void testBuilderWithDefaultSpecificDataSourcesToKillUnusedSegmentsInSpecified() {
        CoordinatorDynamicConfig defaultConfig = CoordinatorDynamicConfig.builder().withSpecificDataSourcesToKillUnusedSegmentsIn((Set)ImmutableSet.of((Object)"DATASOURCE")).build();
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().build(defaultConfig);
        this.assertConfig(config, 900000L, 100, 15, 500, CoordinatorDynamicConfigTest.getDefaultNumBalancerThreads(), (Set<String>)ImmutableSet.of((Object)"DATASOURCE"), 0.1, Integer.MAX_VALUE, 500, (Set<String>)ImmutableSet.of(), false, false, (Set<String>)ImmutableSet.of(), (Map<String, String>)ImmutableMap.of());
    }

    @Test
    public void testUpdate() {
        CoordinatorDynamicConfig current = CoordinatorDynamicConfig.builder().withSpecificDataSourcesToKillUnusedSegmentsIn((Set)ImmutableSet.of((Object)"x")).build();
        Assert.assertEquals((Object)current, (Object)CoordinatorDynamicConfig.builder().build(current));
    }

    @Test
    public void testTurboLoadingNodes() {
        CoordinatorDynamicConfig config = CoordinatorDynamicConfig.builder().withTurboLoadingNodes((Set)ImmutableSet.of((Object)"localhost:8083")).build();
        Assert.assertEquals((Object)SegmentLoadingMode.NORMAL, (Object)config.getLoadingModeForServer("localhost:8082"));
        Assert.assertEquals((Object)SegmentLoadingMode.TURBO, (Object)config.getLoadingModeForServer("localhost:8083"));
    }

    @Test
    public void testEqualsAndHashCode() {
        CoordinatorDynamicConfig config1 = CoordinatorDynamicConfig.builder().build();
        CoordinatorDynamicConfig config2 = CoordinatorDynamicConfig.builder().build();
        Assert.assertEquals((Object)config1, (Object)config2);
        Assert.assertEquals((long)config1.hashCode(), (long)config2.hashCode());
    }

    private void assertConfig(CoordinatorDynamicConfig config, long expectedLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, int expectedMaxSegmentsToMove, int expectedReplicantLifetime, int expectedReplicationThrottleLimit, int expectedBalancerComputeThreads, Set<String> expectedSpecificDataSourcesToKillUnusedSegmentsIn, Double expectedKillTaskSlotRatio, @Nullable Integer expectedMaxKillTaskSlots, int expectedMaxSegmentsInNodeLoadingQueue, Set<String> decommissioningNodes, boolean pauseCoordination, boolean replicateAfterLoadTimeout, Set<String> turboLoadingNodes, Map<String, String> cloneServers) {
        Assert.assertEquals((long)expectedLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, (long)config.getMarkSegmentAsUnusedDelayMillis());
        Assert.assertEquals((long)expectedMaxSegmentsToMove, (long)config.getMaxSegmentsToMove());
        Assert.assertEquals((long)expectedReplicantLifetime, (long)config.getReplicantLifetime());
        Assert.assertEquals((long)expectedReplicationThrottleLimit, (long)config.getReplicationThrottleLimit());
        Assert.assertEquals((long)expectedBalancerComputeThreads, (long)config.getBalancerComputeThreads());
        Assert.assertEquals(expectedSpecificDataSourcesToKillUnusedSegmentsIn, (Object)config.getSpecificDataSourcesToKillUnusedSegmentsIn());
        Assert.assertEquals((double)expectedKillTaskSlotRatio, (double)config.getKillTaskSlotRatio(), (double)0.001);
        Assert.assertEquals((long)expectedMaxKillTaskSlots.intValue(), (long)config.getMaxKillTaskSlots());
        Assert.assertEquals((long)expectedMaxSegmentsInNodeLoadingQueue, (long)config.getMaxSegmentsInNodeLoadingQueue());
        Assert.assertEquals(decommissioningNodes, (Object)config.getDecommissioningNodes());
        Assert.assertEquals((Object)pauseCoordination, (Object)config.getPauseCoordination());
        Assert.assertEquals((Object)replicateAfterLoadTimeout, (Object)config.getReplicateAfterLoadTimeout());
        Assert.assertEquals(turboLoadingNodes, (Object)config.getTurboLoadingNodes());
        Assert.assertEquals(cloneServers, (Object)config.getCloneServers());
    }

    private static int getDefaultNumBalancerThreads() {
        return Math.max(1, JvmUtils.getRuntimeInfo().getAvailableProcessors() / 2);
    }

    @Test
    public void testEquals() {
        EqualsVerifier.forClass(CoordinatorDynamicConfig.class).withIgnoredFields(new String[]{"validDebugDimensions"}).usingGetClass().verify();
    }
}

