/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.Response;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.DruidExceptionMatcher;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.rpc.HttpResponseException;
import org.apache.druid.server.http.ServletResourceUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.Assert;
import org.junit.Test;

public class ServletResourceUtilsTest {
    @Test
    public void testSanitizeException() {
        String message = "some message";
        Assert.assertEquals((Object)"some message", ServletResourceUtils.sanitizeException((Throwable)new Throwable("some message")).get("error"));
        Assert.assertEquals((Object)"null", ServletResourceUtils.sanitizeException(null).get("error"));
        Assert.assertEquals((Object)"some message", ServletResourceUtils.sanitizeException((Throwable)new Throwable(){

            @Override
            public String toString() {
                return "some message";
            }
        }).get("error"));
    }

    @Test
    public void testBuildErrorReponseFrom() {
        DruidException exception = InvalidInput.exception((String)"Invalid value of [%s]", (Object[])new Object[]{"inputKey"});
        Response response = ServletResourceUtils.buildErrorResponseFrom((DruidException)exception);
        Assert.assertEquals((long)exception.getStatusCode(), (long)response.getStatus());
        Object entity = response.getEntity();
        Assert.assertTrue((boolean)(entity instanceof ErrorResponse));
        MatcherAssert.assertThat((Object)((ErrorResponse)entity).getUnderlyingException(), (Matcher)DruidExceptionMatcher.invalidInput().expectMessageIs("Invalid value of [inputKey]"));
    }

    @Test
    public void test_getDefaultValueIfCauseIs404ElseThrow() {
        StringFullResponseHolder notFoundResponseHolder = new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"abc", (Object)ServletResourceUtils.getDefaultValueIfCauseIs404ElseThrow((Exception)new ISE((Throwable)new HttpResponseException(notFoundResponseHolder), "", new Object[0]), () -> "abc"));
        StringFullResponseHolder badRequestResponseHolder = new StringFullResponseHolder((HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST), StandardCharsets.UTF_8);
        Assert.assertThrows(RuntimeException.class, () -> ServletResourceUtils.getDefaultValueIfCauseIs404ElseThrow((Exception)new ISE((Throwable)new HttpResponseException(badRequestResponseHolder), "", new Object[0]), () -> "abc"));
        Assert.assertThrows(RuntimeException.class, () -> ServletResourceUtils.getDefaultValueIfCauseIs404ElseThrow((Exception)new ISE("", new Object[0]), () -> "abc"));
    }
}

