/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.commons.io.IOUtils;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.BaseJettyTest;
import org.apache.druid.server.initialization.TLSServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.eclipse.jetty.server.Server;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class JettyCertRenewTest
extends BaseJettyTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private Injector injector;
    private BaseJettyTest.LatchedRequestStateHolder latchedRequestState;
    private Path tmpKeyStore;
    private Path tmpTrustStore;
    private PasswordProvider pp;

    @Override
    public void setProperties() {
        super.setProperties();
        System.setProperty("druid.server.http.showDetailedJettyErrors", "true");
    }

    @Override
    protected Injector setupInjector() {
        TLSServerConfig tlsConfig;
        try {
            File keyStore = new File(JettyCertRenewTest.class.getClassLoader().getResource("server.jks").getFile());
            this.tmpKeyStore = Files.copy(keyStore.toPath(), new File(this.folder.newFolder(), "server.jks").toPath(), new CopyOption[0]);
            File trustStore = new File(JettyCertRenewTest.class.getClassLoader().getResource("truststore.jks").getFile());
            this.tmpTrustStore = Files.copy(trustStore.toPath(), new File(this.folder.newFolder(), "truststore.jks").toPath(), new CopyOption[0]);
            this.pp = () -> "druid123";
            tlsConfig = TLSServerConfig.builder().keyStorePath(this.tmpKeyStore.toString()).keyStoreType("jks").keyStorePasswordProvider(this.pp).keyManagerPasswordProvider(this.pp).trustStorePath(this.tmpTrustStore.toString()).trustStoreAlgorithm("PKIX").trustStorePasswordProvider(this.pp).certAlias("druid").requireClientCertificate(false).requestClientCertificate(false).validateHostnames(false).reloadSslContext(true).reloadSslContextSeconds(1).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final int ephemeralPort = ThreadLocalRandom.current().nextInt(49152, 65535);
        this.latchedRequestState = new BaseJettyTest.LatchedRequestStateHolder();
        this.injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test", "localhost", false, Integer.valueOf(ephemeralPort), Integer.valueOf(ephemeralPort + 1), true, true));
                binder.bind(TLSServerConfig.class).toInstance((Object)tlsConfig);
                binder.bind(JettyServerInitializer.class).to(BaseJettyTest.JettyServerInit.class).in(LazySingleton.class);
                binder.bind(BaseJettyTest.LatchedRequestStateHolder.class).toInstance((Object)JettyCertRenewTest.this.latchedRequestState);
                Multibinder multibinder = Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class);
                multibinder.addBinding().toInstance((Object)new ServletFilterHolder(){

                    public String getPath() {
                        return "/*";
                    }

                    public Map<String, String> getInitParameters() {
                        return null;
                    }

                    public Class<? extends Filter> getFilterClass() {
                        return BaseJettyTest.DummyAuthFilter.class;
                    }

                    public Filter getFilter() {
                        return null;
                    }

                    public EnumSet<DispatcherType> getDispatcherType() {
                        return null;
                    }
                });
                Jerseys.addResource((Binder)binder, BaseJettyTest.SlowResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.LatchedResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.ExceptionResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DefaultResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DirectlyReturnResource.class);
                binder.bind(AuthorizerMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
                LifecycleModule.register((Binder)binder, Server.class);
            }
        }));
        return this.injector;
    }

    @Test
    public void testCertificateEndDateInvalid() throws Exception {
        Certificate[] certificatesAfter;
        Certificate[] certificatesBefore;
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
        for (Certificate certificate : certificatesBefore = this.getCertificates()) {
            X509Certificate real = (X509Certificate)certificate;
            Assert.assertEquals((Object)dateFormat.parse("Fri Mar 29 11:00:40 UTC 2030").toInstant(), (Object)real.getNotAfter().toInstant());
        }
        Assert.assertEquals((Object)"hello", (Object)this.getResponseWithProperTrustStore());
        File keyStore = new File(JettyCertRenewTest.class.getClassLoader().getResource("server-new.jks").getFile());
        Files.copy(keyStore.toPath(), this.tmpKeyStore, StandardCopyOption.REPLACE_EXISTING);
        File trustStore = new File(JettyCertRenewTest.class.getClassLoader().getResource("truststore-new.jks").getFile());
        Files.copy(trustStore.toPath(), this.tmpTrustStore, StandardCopyOption.REPLACE_EXISTING);
        Thread.sleep(3000L);
        for (Certificate certificate : certificatesAfter = this.getCertificates()) {
            X509Certificate real = (X509Certificate)certificate;
            Assert.assertEquals((Object)dateFormat.parse("Thu Aug 19 13:38:51 UTC 2032").toInstant(), (Object)real.getNotAfter().toInstant());
        }
        Assert.assertEquals((Object)"hello", (Object)this.getResponseWithProperTrustStore());
    }

    private Certificate[] getCertificates() throws Exception {
        URL url = new URL("https://localhost:" + this.tlsPort + "/default/");
        SSLContext sslCtx = SSLContext.getInstance("TLS");
        sslCtx.init(null, new TrustManager[]{new AcceptAllForTestX509TrustManager()}, null);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setHostnameVerifier(new AcceptAllForTestHostnameVerifier());
        connection.setSSLSocketFactory(sslCtx.getSocketFactory());
        connection.getResponseCode();
        Certificate[] certificates = connection.getServerCertificates();
        connection.disconnect();
        return certificates;
    }

    private HttpClientConfig getSslConfig() {
        return HttpClientConfig.builder().withSslContext(HttpClientInit.sslContextWithTrustedKeyStore((String)this.tmpTrustStore.toString(), (String)this.pp.getPassword())).withWorkerCount(1).withReadTimeout(Duration.ZERO).build();
    }

    private String getResponseWithProperTrustStore() throws Exception {
        HttpClient client;
        String text = "hello";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(out);){
            gzipOutputStream.write(text.getBytes(Charset.defaultCharset()));
        }
        Request request = new Request(HttpMethod.GET, new URL("https://localhost:" + this.tlsPort + "/default/"));
        request.setHeader("Content-Encoding", "gzip");
        request.setContent("text/plain", out.toByteArray());
        try {
            client = HttpClientInit.createClient((HttpClientConfig)this.getSslConfig(), (Lifecycle)this.lifecycle);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ListenableFuture go = client.go(request, (HttpResponseHandler)new InputStreamResponseHandler());
        return IOUtils.toString((InputStream)((InputStream)go.get()), (Charset)StandardCharsets.UTF_8);
    }

    private static class AcceptAllForTestX509TrustManager
    implements X509TrustManager {
        private X509Certificate[] accepted;

        private AcceptAllForTestX509TrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] xcs, String string) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] xcs, String string) {
            this.accepted = xcs;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.accepted;
        }
    }

    private static class AcceptAllForTestHostnameVerifier
    implements HostnameVerifier {
        private AcceptAllForTestHostnameVerifier() {
        }

        @Override
        public boolean verify(String string, SSLSession ssls) {
            return true;
        }
    }
}

