/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.apache.commons.io.IOUtils;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.HttpClientConfig;
import org.apache.druid.java.util.http.client.HttpClientInit;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.InputStreamResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.BaseJettyTest;
import org.apache.druid.server.initialization.TLSServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.apache.druid.server.initialization.jetty.ServletFilterHolder;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.CustomCheckX509TrustManager;
import org.apache.druid.server.security.TLSCertificateChecker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class JettyTest
extends BaseJettyTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private HttpClientConfig sslConfig;
    private Injector injector;
    private BaseJettyTest.LatchedRequestStateHolder latchedRequestState;

    @Override
    public void setProperties() {
        super.setProperties();
        System.setProperty("druid.server.http.showDetailedJettyErrors", "true");
    }

    @Override
    protected Injector setupInjector() {
        TLSServerConfig tlsConfig;
        try {
            File keyStore = new File(JettyTest.class.getClassLoader().getResource("server.jks").getFile());
            Path tmpKeyStore = Files.copy(keyStore.toPath(), new File(this.folder.newFolder(), "server.jks").toPath(), new CopyOption[0]);
            File trustStore = new File(JettyTest.class.getClassLoader().getResource("truststore.jks").getFile());
            Path tmpTrustStore = Files.copy(trustStore.toPath(), new File(this.folder.newFolder(), "truststore.jks").toPath(), new CopyOption[0]);
            PasswordProvider pp = () -> "druid123";
            tlsConfig = TLSServerConfig.builder().keyStorePath(tmpKeyStore.toString()).keyStoreType("jks").keyStorePasswordProvider(pp).keyManagerPasswordProvider(pp).trustStorePath(tmpTrustStore.toString()).trustStoreAlgorithm("PKIX").trustStorePasswordProvider(pp).certAlias("druid").requireClientCertificate(false).requestClientCertificate(false).validateHostnames(false).build();
            this.sslConfig = HttpClientConfig.builder().withSslContext(HttpClientInit.sslContextWithTrustedKeyStore((String)tmpTrustStore.toString(), (String)pp.getPassword())).withWorkerCount(1).withReadTimeout(Duration.ZERO).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final int ephemeralPort = ThreadLocalRandom.current().nextInt(49152, 65535);
        this.latchedRequestState = new BaseJettyTest.LatchedRequestStateHolder();
        this.injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test", "localhost", false, Integer.valueOf(ephemeralPort), Integer.valueOf(ephemeralPort + 1), true, true));
                binder.bind(TLSServerConfig.class).toInstance((Object)tlsConfig);
                binder.bind(JettyServerInitializer.class).to(BaseJettyTest.JettyServerInit.class).in(LazySingleton.class);
                binder.bind(BaseJettyTest.LatchedRequestStateHolder.class).toInstance((Object)JettyTest.this.latchedRequestState);
                Multibinder multibinder = Multibinder.newSetBinder((Binder)binder, ServletFilterHolder.class);
                multibinder.addBinding().toInstance((Object)new ServletFilterHolder(){

                    public String getPath() {
                        return "/*";
                    }

                    public Map<String, String> getInitParameters() {
                        return null;
                    }

                    public Class<? extends Filter> getFilterClass() {
                        return BaseJettyTest.DummyAuthFilter.class;
                    }

                    public Filter getFilter() {
                        return null;
                    }

                    public EnumSet<DispatcherType> getDispatcherType() {
                        return null;
                    }
                });
                Jerseys.addResource((Binder)binder, BaseJettyTest.SlowResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.LatchedResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.ExceptionResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DefaultResource.class);
                Jerseys.addResource((Binder)binder, BaseJettyTest.DirectlyReturnResource.class);
                binder.bind(AuthorizerMapper.class).toInstance((Object)AuthTestUtils.TEST_AUTHORIZER_MAPPER);
                LifecycleModule.register((Binder)binder, Server.class);
            }
        }));
        return this.injector;
    }

    @Test
    @Ignore
    public void testTimeouts() throws Exception {
        final ExecutorService executor = Execs.multiThreaded((int)100, (String)"JettyTest-%d");
        final AtomicLong count = new AtomicLong(0L);
        final CountDownLatch latch = new CountDownLatch(1000);
        for (int i = 0; i < 10000; ++i) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    executor.execute(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            long startTime = System.currentTimeMillis();
                            long startTime2 = 0L;
                            try {
                                ListenableFuture go = JettyTest.this.client.go(new Request(HttpMethod.GET, new URL("http://localhost:" + JettyTest.this.port + "/slow/hello")), (HttpResponseHandler)StatusResponseHandler.getInstance());
                                startTime2 = System.currentTimeMillis();
                                go.get();
                            }
                            catch (Exception e) {
                                try {
                                    e.printStackTrace();
                                }
                                catch (Throwable throwable) {
                                    System.out.printf(Locale.ENGLISH, "Response time client%dtime taken for getting future%dCounter %d%n", System.currentTimeMillis() - startTime, System.currentTimeMillis() - startTime2, count.incrementAndGet());
                                    latch.countDown();
                                    throw throwable;
                                }
                                System.out.printf(Locale.ENGLISH, "Response time client%dtime taken for getting future%dCounter %d%n", System.currentTimeMillis() - startTime, System.currentTimeMillis() - startTime2, count.incrementAndGet());
                                latch.countDown();
                            }
                            System.out.printf(Locale.ENGLISH, "Response time client%dtime taken for getting future%dCounter %d%n", System.currentTimeMillis() - startTime, System.currentTimeMillis() - startTime2, count.incrementAndGet());
                            latch.countDown();
                        }
                    });
                }
            });
        }
        latch.await();
    }

    @Test
    public void testGzipResponseCompression() throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/default");
        HttpURLConnection get = (HttpURLConnection)url.openConnection();
        get.setRequestProperty("Accept-Encoding", "gzip");
        Assert.assertEquals((Object)"gzip", (Object)get.getContentEncoding());
        Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)new GZIPInputStream(get.getInputStream()), (Charset)StandardCharsets.UTF_8));
        HttpURLConnection post = (HttpURLConnection)url.openConnection();
        post.setRequestProperty("Accept-Encoding", "gzip");
        post.setRequestMethod("POST");
        Assert.assertEquals((Object)"gzip", (Object)post.getContentEncoding());
        Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)new GZIPInputStream(post.getInputStream()), (Charset)StandardCharsets.UTF_8));
        HttpURLConnection getNoGzip = (HttpURLConnection)url.openConnection();
        Assert.assertNotEquals((Object)"gzip", (Object)getNoGzip.getContentEncoding());
        Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)getNoGzip.getInputStream(), (Charset)StandardCharsets.UTF_8));
        HttpURLConnection postNoGzip = (HttpURLConnection)url.openConnection();
        postNoGzip.setRequestMethod("POST");
        Assert.assertNotEquals((Object)"gzip", (Object)postNoGzip.getContentEncoding());
        Assert.assertEquals((Object)"hello", (Object)IOUtils.toString((InputStream)postNoGzip.getInputStream(), (Charset)StandardCharsets.UTF_8));
    }

    @Test
    @Ignore
    public void testChunkNotFinalized() throws Exception {
        ListenableFuture go = this.client.go(new Request(HttpMethod.GET, new URL("http://localhost:" + this.port + "/exception/exception")), (HttpResponseHandler)new InputStreamResponseHandler());
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)((InputStream)go.get()), (Writer)writer, (String)"utf-8");
            Assert.fail((String)"Should have thrown Exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testThreadNotStuckOnException() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ListenableFuture go = JettyTest.this.client.go(new Request(HttpMethod.GET, new URL("http://localhost:" + JettyTest.this.port + "/exception/exception")), (HttpResponseHandler)new InputStreamResponseHandler());
                    StringWriter writer = new StringWriter();
                    IOUtils.copy((InputStream)((InputStream)go.get()), (Writer)writer, (String)"utf-8");
                }
                catch (IOException go) {
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                latch.countDown();
            }
        });
        latch.await(5L, TimeUnit.SECONDS);
    }

    @Test
    public void testExtensionAuthFilter() throws Exception {
        URL url = new URL("http://localhost:" + this.port + "/default");
        HttpURLConnection get = (HttpURLConnection)url.openConnection();
        get.setRequestProperty("secretUser", "bob");
        Assert.assertEquals((long)200L, (long)get.getResponseCode());
        get = (HttpURLConnection)url.openConnection();
        get.setRequestProperty("secretUser", "hacker");
        Assert.assertEquals((long)401L, (long)get.getResponseCode());
    }

    @Test
    public void testGzipRequestDecompression() throws Exception {
        String text = "hello";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(out);){
            gzipOutputStream.write(text.getBytes(Charset.defaultCharset()));
        }
        Request request = new Request(HttpMethod.POST, new URL("http://localhost:" + this.port + "/return"));
        request.setHeader("Content-Encoding", "gzip");
        request.setContent("text/plain", out.toByteArray());
        Assert.assertEquals((Object)text, (Object)new String(IOUtils.toByteArray((InputStream)((InputStream)this.client.go(request, (HttpResponseHandler)new InputStreamResponseHandler()).get())), Charset.defaultCharset()));
    }

    @Test
    public void testNumConnectionsMetricHttp() throws Exception {
        String text = "hello";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(out);){
            gzipOutputStream.write(text.getBytes(Charset.defaultCharset()));
        }
        Request request = new Request(HttpMethod.GET, new URL("http://localhost:" + this.port + "/latched/hello"));
        request.setHeader("Content-Encoding", "gzip");
        request.setContent("text/plain", out.toByteArray());
        JettyServerModule jsm = (JettyServerModule)this.injector.getInstance(JettyServerModule.class);
        this.latchedRequestState.reset();
        this.waitForJettyServerModuleActiveConnectionsZero(jsm);
        Assert.assertEquals((long)0L, (long)jsm.getActiveConnections());
        ListenableFuture go = this.client.go(request, (HttpResponseHandler)new InputStreamResponseHandler());
        this.latchedRequestState.clientWaitForServerToStartRequest();
        Assert.assertEquals((long)1L, (long)jsm.getActiveConnections());
        this.latchedRequestState.clientReadyToFinishRequest();
        go.get();
        this.waitForJettyServerModuleActiveConnectionsZero(jsm);
        Assert.assertEquals((long)0L, (long)jsm.getActiveConnections());
    }

    @Test
    public void testNumConnectionsMetricHttps() throws Exception {
        HttpClient client;
        String text = "hello";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(out);){
            gzipOutputStream.write(text.getBytes(Charset.defaultCharset()));
        }
        Request request = new Request(HttpMethod.GET, new URL("https://localhost:" + this.tlsPort + "/latched/hello"));
        request.setHeader("Content-Encoding", "gzip");
        request.setContent("text/plain", out.toByteArray());
        try {
            client = HttpClientInit.createClient((HttpClientConfig)this.sslConfig, (Lifecycle)this.lifecycle);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        JettyServerModule jsm = (JettyServerModule)this.injector.getInstance(JettyServerModule.class);
        this.latchedRequestState.reset();
        this.waitForJettyServerModuleActiveConnectionsZero(jsm);
        Assert.assertEquals((long)0L, (long)jsm.getActiveConnections());
        ListenableFuture go = client.go(request, (HttpResponseHandler)new InputStreamResponseHandler());
        this.latchedRequestState.clientWaitForServerToStartRequest();
        Assert.assertEquals((long)1L, (long)jsm.getActiveConnections());
        this.latchedRequestState.clientReadyToFinishRequest();
        go.get();
        this.waitForJettyServerModuleActiveConnectionsZero(jsm);
        Assert.assertEquals((long)0L, (long)jsm.getActiveConnections());
    }

    @Test
    public void testCustomCheckX509TrustManagerSetEndpointIdentificationAlgorithmToNullWithValidateServerHostnamesSetToFalse() throws Exception {
        SslContextFactory.Server server = (SslContextFactory.Server)this.injector.getInstance(SslContextFactory.Server.class);
        server.setEndpointIdentificationAlgorithm("HTTPS");
        server.start();
        SSLEngine sslEngine = server.newSSLEngine();
        X509ExtendedTrustManager mockX509ExtendedTrustManager = (X509ExtendedTrustManager)Mockito.mock(X509ExtendedTrustManager.class);
        TLSCertificateChecker mockTLSCertificateChecker = (TLSCertificateChecker)Mockito.mock(TLSCertificateChecker.class);
        X509Certificate mockX509Certificate = (X509Certificate)Mockito.mock(X509Certificate.class);
        String authType = "testAuthType";
        X509Certificate[] chain = new X509Certificate[]{mockX509Certificate};
        Assert.assertNotNull((Object)sslEngine.getSSLParameters().getEndpointIdentificationAlgorithm());
        CustomCheckX509TrustManager customCheckX509TrustManager = new CustomCheckX509TrustManager(mockX509ExtendedTrustManager, mockTLSCertificateChecker, false);
        customCheckX509TrustManager.checkServerTrusted(chain, authType, sslEngine);
        ArgumentCaptor captor = ArgumentCaptor.forClass(SSLEngine.class);
        ((TLSCertificateChecker)Mockito.verify((Object)mockTLSCertificateChecker)).checkServer((X509Certificate[])ArgumentMatchers.eq((Object)chain), (String)ArgumentMatchers.eq((Object)authType), (SSLEngine)captor.capture(), (X509ExtendedTrustManager)ArgumentMatchers.eq((Object)mockX509ExtendedTrustManager));
        SSLEngine transformedSSLEngine = (SSLEngine)captor.getValue();
        String endpointIdentificationAlgorithm = transformedSSLEngine.getSSLParameters().getEndpointIdentificationAlgorithm();
        Assert.assertTrue((endpointIdentificationAlgorithm == null || endpointIdentificationAlgorithm.isEmpty() ? 1 : 0) != 0);
    }

    private void waitForJettyServerModuleActiveConnectionsZero(JettyServerModule jsm) throws InterruptedException {
        int sleepTimeMills = 10;
        int totalSleeps = 1500;
        int count = 0;
        while (jsm.getActiveConnections() > 0 && count++ < 1500) {
            Thread.sleep(10L);
        }
        if (jsm.getActiveConnections() > 0) {
            throw new RuntimeException("Connections greater than 0. activeConnections=" + jsm.getActiveConnections() + " port=" + this.port);
        }
    }
}

