/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.Arrays;
import java.util.List;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.TLSServerConfig;
import org.apache.druid.server.initialization.jetty.JettyServerInitializer;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.apache.druid.server.security.TLSCertificateChecker;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class JettyServerModuleTest {
    @Test
    public void testJettyServerModule() {
        QueuedThreadPool jettyServerThreadPool = (QueuedThreadPool)Mockito.mock(QueuedThreadPool.class);
        JettyServerModule.setJettyServerThreadPool((QueuedThreadPool)jettyServerThreadPool);
        Mockito.when((Object)jettyServerThreadPool.getThreads()).thenReturn((Object)100);
        Mockito.when((Object)jettyServerThreadPool.getIdleThreads()).thenReturn((Object)40);
        Mockito.when((Object)jettyServerThreadPool.isLowOnThreads()).thenReturn((Object)true);
        Mockito.when((Object)jettyServerThreadPool.getMinThreads()).thenReturn((Object)30);
        Mockito.when((Object)jettyServerThreadPool.getMaxThreads()).thenReturn((Object)100);
        Mockito.when((Object)jettyServerThreadPool.getQueueSize()).thenReturn((Object)50);
        Mockito.when((Object)jettyServerThreadPool.getBusyThreads()).thenReturn((Object)60);
        JettyServerModule.JettyMonitor jettyMonitor = new JettyServerModule.JettyMonitor("ds", "t0");
        StubServiceEmitter serviceEmitter = new StubServiceEmitter("service", "host");
        jettyMonitor.doMonitor((ServiceEmitter)serviceEmitter);
        serviceEmitter.verifyValue("jetty/numOpenConnections", (Number)0);
        serviceEmitter.verifyValue("jetty/threadPool/total", (Number)100);
        serviceEmitter.verifyValue("jetty/threadPool/idle", (Number)40);
        serviceEmitter.verifyValue("jetty/threadPool/isLowOnThreads", (Number)1);
        serviceEmitter.verifyValue("jetty/threadPool/min", (Number)30);
        serviceEmitter.verifyValue("jetty/threadPool/max", (Number)100);
        serviceEmitter.verifyValue("jetty/threadPool/queueSize", (Number)50);
        serviceEmitter.verifyValue("jetty/threadPool/busy", (Number)60);
    }

    @Test
    public void test_isEnableTlsPort_withoutBinding() {
        String keystorePath = JettyServerModuleTest.class.getClassLoader().getResource("server.jks").getFile();
        PasswordProvider pp = (PasswordProvider)Mockito.mock(PasswordProvider.class);
        Mockito.when((Object)pp.getPassword()).thenReturn((Object)"druid123");
        TLSServerConfig tlsServerConfig = TLSServerConfig.builder().keyStorePath(keystorePath).keyStoreType("jks").keyStorePasswordProvider(pp).certAlias("druid").includeCipherSuites(List.of("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256")).includeProtocols(Arrays.asList("TLSv1.2", "TLSv1.3")).requireClientCertificate(false).requestClientCertificate(false).build();
        DruidNode node = new DruidNode("test", "localhost", false, Integer.valueOf(8080), Integer.valueOf(8443), true, true);
        ServerConfig serverConfig = new ServerConfig();
        Lifecycle lifecycle = new Lifecycle();
        Injector injector = (Injector)Mockito.mock(Injector.class);
        TLSCertificateChecker certificateChecker = (TLSCertificateChecker)Mockito.mock(TLSCertificateChecker.class);
        JettyServerInitializer initializer = (JettyServerInitializer)Mockito.mock(JettyServerInitializer.class);
        Mockito.when((Object)((JettyServerInitializer)injector.getInstance(JettyServerInitializer.class))).thenReturn((Object)initializer);
        Server server = JettyServerModule.makeAndInitializeServer((Injector)injector, (Lifecycle)lifecycle, (DruidNode)node, (ServerConfig)serverConfig, (TLSServerConfig)tlsServerConfig, null, (TLSCertificateChecker)certificateChecker);
        Assert.assertNotNull((Object)server);
    }

    @Test
    public void test_isEnableTlsPort_withBinding_forceApplyConfig_isTrue() {
        String keystorePath = JettyServerModuleTest.class.getClassLoader().getResource("server.jks").getFile();
        PasswordProvider pp = (PasswordProvider)Mockito.mock(PasswordProvider.class);
        Mockito.when((Object)pp.getPassword()).thenReturn((Object)"druid123");
        TLSServerConfig tlsServerConfig = TLSServerConfig.builder().keyStorePath(keystorePath).keyStoreType("jks").keyStorePasswordProvider(pp).certAlias("druid").excludeCipherSuites(List.of("TLS_RSA_WITH_NULL_SHA256")).excludeProtocols(Arrays.asList("TLSv1", "TLSv1.1")).requireClientCertificate(false).requestClientCertificate(false).forceApplyConfig(true).build();
        DruidNode node = new DruidNode("test", "localhost", false, Integer.valueOf(8080), Integer.valueOf(8443), true, true);
        ServerConfig serverConfig = new ServerConfig();
        Lifecycle lifecycle = new Lifecycle();
        Injector injector = (Injector)Mockito.mock(Injector.class);
        TLSCertificateChecker certificateChecker = (TLSCertificateChecker)Mockito.mock(TLSCertificateChecker.class);
        JettyServerInitializer initializer = (JettyServerInitializer)Mockito.mock(JettyServerInitializer.class);
        Mockito.when((Object)((JettyServerInitializer)injector.getInstance(JettyServerInitializer.class))).thenReturn((Object)initializer);
        SslContextFactory.Server customSslContextFactory = (SslContextFactory.Server)Mockito.mock(SslContextFactory.Server.class);
        Binding sslContextFactoryBinding = (Binding)Mockito.mock(Binding.class);
        Provider provider = (Provider)Mockito.mock(Provider.class);
        Mockito.when((Object)sslContextFactoryBinding.getProvider()).thenReturn((Object)provider);
        Mockito.when((Object)((SslContextFactory.Server)provider.get())).thenReturn((Object)customSslContextFactory);
        Server server = JettyServerModule.makeAndInitializeServer((Injector)injector, (Lifecycle)lifecycle, (DruidNode)node, (ServerConfig)serverConfig, (TLSServerConfig)tlsServerConfig, (Binding)sslContextFactoryBinding, (TLSCertificateChecker)certificateChecker);
        Assert.assertNotNull((Object)server);
        ((Provider)Mockito.verify((Object)provider)).get();
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory)).setKeyStorePath(keystorePath);
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory)).setKeyStoreType("jks");
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory)).setKeyStorePassword("druid123");
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory)).setCertAlias("druid");
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory)).setExcludeCipherSuites(new String[]{"TLS_RSA_WITH_NULL_SHA256"});
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory)).setExcludeProtocols(new String[]{"TLSv1", "TLSv1.1"});
    }

    @Test
    public void test_isEnableTlsPort_withBinding_forceApplyConfig_isFalse() {
        String keystorePath = JettyServerModuleTest.class.getClassLoader().getResource("server.jks").getFile();
        PasswordProvider pp = (PasswordProvider)Mockito.mock(PasswordProvider.class);
        Mockito.when((Object)pp.getPassword()).thenReturn((Object)"druid123");
        TLSServerConfig tlsServerConfig = TLSServerConfig.builder().keyStorePath(keystorePath).keyStoreType("jks").keyStorePasswordProvider(pp).certAlias("druid").excludeCipherSuites(List.of("TLS_RSA_WITH_NULL_SHA256")).excludeProtocols(Arrays.asList("TLSv1", "TLSv1.1")).requireClientCertificate(false).requestClientCertificate(false).forceApplyConfig(false).build();
        DruidNode node = new DruidNode("test", "localhost", false, Integer.valueOf(8080), Integer.valueOf(8443), true, true);
        ServerConfig serverConfig = new ServerConfig();
        Lifecycle lifecycle = new Lifecycle();
        Injector injector = (Injector)Mockito.mock(Injector.class);
        TLSCertificateChecker certificateChecker = (TLSCertificateChecker)Mockito.mock(TLSCertificateChecker.class);
        JettyServerInitializer initializer = (JettyServerInitializer)Mockito.mock(JettyServerInitializer.class);
        Mockito.when((Object)((JettyServerInitializer)injector.getInstance(JettyServerInitializer.class))).thenReturn((Object)initializer);
        SslContextFactory.Server customSslContextFactory = (SslContextFactory.Server)Mockito.mock(SslContextFactory.Server.class);
        Binding sslContextFactoryBinding = (Binding)Mockito.mock(Binding.class);
        Provider provider = (Provider)Mockito.mock(Provider.class);
        Mockito.when((Object)sslContextFactoryBinding.getProvider()).thenReturn((Object)provider);
        Mockito.when((Object)((SslContextFactory.Server)provider.get())).thenReturn((Object)customSslContextFactory);
        Server server = JettyServerModule.makeAndInitializeServer((Injector)injector, (Lifecycle)lifecycle, (DruidNode)node, (ServerConfig)serverConfig, (TLSServerConfig)tlsServerConfig, (Binding)sslContextFactoryBinding, (TLSCertificateChecker)certificateChecker);
        Assert.assertNotNull((Object)server);
        ((Provider)Mockito.verify((Object)provider)).get();
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory, (VerificationMode)Mockito.never())).setKeyStorePath(keystorePath);
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory, (VerificationMode)Mockito.never())).setKeyStoreType("jks");
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory, (VerificationMode)Mockito.never())).setKeyStorePassword("druid123");
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory, (VerificationMode)Mockito.never())).setCertAlias("druid");
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory, (VerificationMode)Mockito.never())).setExcludeCipherSuites(new String[]{"TLS_RSA_WITH_NULL_SHA256"});
        ((SslContextFactory.Server)Mockito.verify((Object)customSslContextFactory, (VerificationMode)Mockito.never())).setExcludeProtocols(new String[]{"TLSv1", "TLSv1.1"});
    }
}

