/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.initialization.jetty;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.initialization.jetty.StandardResponseHeaderFilterHolder;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;

public class StandardResponseHeaderFilterHolderTest {
    public ServerConfig serverConfig;
    public HttpServletRequest httpRequest;
    public HttpServletResponse httpResponse;
    public FilterChain filterChain;
    public HttpServletResponse proxyResponse;
    public Response clientResponse;

    @Before
    public void setUp() {
        this.serverConfig = (ServerConfig)EasyMock.strictMock(ServerConfig.class);
        this.httpRequest = (HttpServletRequest)EasyMock.strictMock(HttpServletRequest.class);
        this.httpResponse = (HttpServletResponse)EasyMock.strictMock(HttpServletResponse.class);
        this.filterChain = (FilterChain)EasyMock.strictMock(FilterChain.class);
        this.proxyResponse = (HttpServletResponse)EasyMock.strictMock(HttpServletResponse.class);
        this.clientResponse = (Response)EasyMock.strictMock(Response.class);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.serverConfig, this.httpRequest, this.httpResponse, this.filterChain, this.proxyResponse, this.clientResponse});
    }

    @Test
    public void test_get_nullContentSecurityPolicy() throws Exception {
        EasyMock.expect((Object)this.serverConfig.getContentSecurityPolicy()).andReturn((Object)"").once();
        EasyMock.expect((Object)this.httpRequest.getMethod()).andReturn((Object)"GET").anyTimes();
        this.runFilterAndVerifyHeaders((Map<String, String>)ImmutableMap.builder().put((Object)"Cache-Control", (Object)"no-cache, no-store, max-age=0").put((Object)"Content-Security-Policy", (Object)"frame-ancestors 'none'").build());
    }

    @Test
    public void test_post_nullContentSecurityPolicy() throws Exception {
        EasyMock.expect((Object)this.serverConfig.getContentSecurityPolicy()).andReturn((Object)"").once();
        EasyMock.expect((Object)this.httpRequest.getMethod()).andReturn((Object)"POST").anyTimes();
        this.runFilterAndVerifyHeaders(Collections.emptyMap());
    }

    @Test
    public void test_get_emptyContentSecurityPolicy() throws Exception {
        EasyMock.expect((Object)this.serverConfig.getContentSecurityPolicy()).andReturn((Object)"").once();
        EasyMock.expect((Object)this.httpRequest.getMethod()).andReturn((Object)"GET").anyTimes();
        this.runFilterAndVerifyHeaders((Map<String, String>)ImmutableMap.builder().put((Object)"Cache-Control", (Object)"no-cache, no-store, max-age=0").put((Object)"Content-Security-Policy", (Object)"frame-ancestors 'none'").build());
    }

    @Test
    public void test_get_overrideContentSecurityPolicy() throws Exception {
        EasyMock.expect((Object)this.serverConfig.getContentSecurityPolicy()).andReturn((Object)"frame-ancestors 'self'").once();
        EasyMock.expect((Object)this.httpRequest.getMethod()).andReturn((Object)"GET").anyTimes();
        EasyMock.expect((Object)this.httpResponse.getContentType()).andReturn((Object)"text/html").anyTimes();
        this.runFilterAndVerifyHeaders((Map<String, String>)ImmutableMap.builder().put((Object)"Cache-Control", (Object)"no-cache, no-store, max-age=0").put((Object)"Content-Security-Policy", (Object)"frame-ancestors 'self'").build());
    }

    @Test
    public void test_get_invalidContentSecurityPolicy() {
        EasyMock.expect((Object)this.serverConfig.getContentSecurityPolicy()).andReturn((Object)"erron\u00e9").once();
        this.replayAllMocks();
        RuntimeException e = (RuntimeException)Assert.assertThrows(RuntimeException.class, this::makeFilter);
        MatcherAssert.assertThat((Object)e, (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"Content-Security-Policy header value must be fully ASCII")));
    }

    @Test
    public void test_deduplicateHeadersInProxyServlet_withDuplicates() {
        EasyMock.expect((Object)this.proxyResponse.containsHeader("Cache-Control")).andReturn((Object)true).once();
        this.proxyResponse.setHeader("Cache-Control", null);
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.proxyResponse.containsHeader("Strict-Transport-Security")).andReturn((Object)false).once();
        EasyMock.expect((Object)this.clientResponse.getHeaders()).andReturn((Object)HttpFields.from((HttpField[])new HttpField[]{new HttpField("Cache-Control", "true"), new HttpField("Strict-Transport-Security", "true")})).times(3);
        this.replayAllMocks();
        StandardResponseHeaderFilterHolder.deduplicateHeadersInProxyServlet((HttpServletResponse)this.proxyResponse, (Response)this.clientResponse);
    }

    @Test
    public void test_duplicateHeadersInProxyServlet_withNoDuplicates() {
        EasyMock.expect((Object)this.proxyResponse.containsHeader("Cache-Control")).andReturn((Object)false).once();
        EasyMock.expect((Object)this.proxyResponse.containsHeader("Strict-Transport-Security")).andReturn((Object)false).once();
        EasyMock.expect((Object)this.clientResponse.getHeaders()).andReturn((Object)HttpFields.from((HttpField[])new HttpField[]{new HttpField("Cache-Control", "true"), new HttpField("Strict-Transport-Security", "true")})).times(3);
        this.replayAllMocks();
        StandardResponseHeaderFilterHolder.deduplicateHeadersInProxyServlet((HttpServletResponse)this.proxyResponse, (Response)this.clientResponse);
    }

    private StandardResponseHeaderFilterHolder.StandardResponseHeaderFilter makeFilter() {
        return (StandardResponseHeaderFilterHolder.StandardResponseHeaderFilter)new StandardResponseHeaderFilterHolder(this.serverConfig).getFilter();
    }

    private void runFilterAndVerifyHeaders(Map<String, String> expectedHeaders) throws Exception {
        HashMap<String, Capture> captureMap = new HashMap<String, Capture>();
        for (Map.Entry<String, String> entry : expectedHeaders.entrySet()) {
            String headerName = entry.getKey();
            Capture headerValueCapture = Capture.newInstance();
            captureMap.put(headerName, headerValueCapture);
            this.httpResponse.setHeader((String)EasyMock.eq((Object)headerName), (String)EasyMock.capture((Capture)headerValueCapture));
            EasyMock.expectLastCall();
        }
        this.filterChain.doFilter((ServletRequest)this.httpRequest, (ServletResponse)this.httpResponse);
        EasyMock.expectLastCall();
        this.replayAllMocks();
        StandardResponseHeaderFilterHolder.StandardResponseHeaderFilter filter = this.makeFilter();
        filter.doFilter((ServletRequest)this.httpRequest, (ServletResponse)this.httpResponse, this.filterChain);
        for (Map.Entry<String, String> entry : expectedHeaders.entrySet()) {
            Assert.assertEquals((String)entry.getKey(), (Object)entry.getValue(), (Object)((Capture)captureMap.get(entry.getKey())).getValue());
        }
    }

    private void replayAllMocks() {
        EasyMock.replay((Object[])new Object[]{this.serverConfig, this.httpRequest, this.httpResponse, this.filterChain, this.proxyResponse, this.clientResponse});
    }
}

