/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import com.google.common.io.FileWriteMode;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.FileRequestLogger;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class FileRequestLoggerTest {
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final String HOST = "localhost";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testLog() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        DateTime dateTime = DateTimes.nowUtc();
        File logDir = this.temporaryFolder.newFolder();
        String nativeQueryLogString = dateTime + "\tlocalhost\tnative";
        String sqlQueryLogString = dateTime + "\tlocalhost\tsql";
        FileRequestLogger fileRequestLogger = new FileRequestLogger(objectMapper, this.scheduler, logDir, "yyyy-MM-dd'.log'", null, Duration.standardDays((long)1L));
        fileRequestLogger.start();
        RequestLogLine nativeRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)nativeRequestLogLine.getNativeQueryLine((ObjectMapper)EasyMock.anyObject())).andReturn((Object)nativeQueryLogString).anyTimes();
        RequestLogLine sqlRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)sqlRequestLogLine.getSqlQueryLine((ObjectMapper)EasyMock.anyObject())).andReturn((Object)sqlQueryLogString).anyTimes();
        EasyMock.replay((Object[])new Object[]{nativeRequestLogLine, sqlRequestLogLine});
        fileRequestLogger.logNativeQuery(nativeRequestLogLine);
        fileRequestLogger.logSqlQuery(sqlRequestLogLine);
        File logFile = new File(logDir, dateTime.toString("yyyy-MM-dd'.log'"));
        String logString = CharStreams.toString((Readable)Files.newBufferedReader(logFile.toPath(), StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)logString.contains(nativeQueryLogString + "\n" + sqlQueryLogString + "\n"));
        fileRequestLogger.stop();
    }

    @Test
    public void testLogRemove() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        File logDir = this.temporaryFolder.newFolder();
        DateTime dateTime = DateTimes.nowUtc();
        String logString = dateTime + "\tlocalhost\tlogString";
        File oldLogFile = new File(logDir, "2000-01-01.log");
        com.google.common.io.Files.asCharSink((File)oldLogFile, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"testOldLogContent");
        oldLogFile.setLastModified(new Date(0L).getTime());
        FileRequestLogger fileRequestLogger = new FileRequestLogger(objectMapper, this.scheduler, logDir, "yyyy-MM-dd'.log'", Duration.standardDays((long)1L), Duration.standardDays((long)1L));
        fileRequestLogger.start();
        RequestLogLine nativeRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)nativeRequestLogLine.getNativeQueryLine((ObjectMapper)EasyMock.anyObject())).andReturn((Object)logString).anyTimes();
        EasyMock.replay((Object[])new Object[]{nativeRequestLogLine});
        fileRequestLogger.logNativeQuery(nativeRequestLogLine);
        File logFile = new File(logDir, dateTime.toString("yyyy-MM-dd'.log'"));
        Thread.sleep(100L);
        Assert.assertFalse((boolean)oldLogFile.exists());
        Assert.assertTrue((boolean)logFile.exists());
        fileRequestLogger.stop();
    }

    @Test
    public void testLogRemoveWithInvalidDuration() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("request logs retention period must be atleast as long as roll period");
        ObjectMapper objectMapper = new ObjectMapper();
        File logDir = this.temporaryFolder.newFolder();
        FileRequestLogger fileRequestLogger = new FileRequestLogger(objectMapper, this.scheduler, logDir, "yyyy-MM-dd'.log'", Duration.standardMinutes((long)30L), Duration.standardDays((long)1L));
    }

    @Test
    public void testRollPeriodForLog() throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        DateTime dateTime = DateTimes.nowUtc();
        File logDir = this.temporaryFolder.newFolder();
        String sqlQueryLogString = dateTime + "\tlocalhost\tsql";
        FileRequestLogger hourlyLogger = new FileRequestLogger(objectMapper, this.scheduler, logDir, "yyyy-MM-dd-HH'.log'", null, Duration.standardHours((long)1L));
        FileRequestLogger dailyLoggerWithHourPattern = new FileRequestLogger(objectMapper, this.scheduler, logDir, "yyyy-MM-dd-HH'.log'", null, Duration.standardHours((long)26L));
        hourlyLogger.start();
        dailyLoggerWithHourPattern.start();
        RequestLogLine sqlRequestLogLine = (RequestLogLine)EasyMock.createMock(RequestLogLine.class);
        EasyMock.expect((Object)sqlRequestLogLine.getSqlQueryLine((ObjectMapper)EasyMock.anyObject())).andReturn((Object)sqlQueryLogString).anyTimes();
        EasyMock.replay((Object[])new Object[]{sqlRequestLogLine});
        hourlyLogger.logSqlQuery(sqlRequestLogLine);
        dailyLoggerWithHourPattern.logSqlQuery(sqlRequestLogLine);
        File hourlyLogFile = new File(logDir, dateTime.toString("yyyy-MM-dd-HH'.log'"));
        File dailyLogFile = new File(logDir, dateTime.toString("yyyy-MM-dd-00'.log'"));
        String hourlyLogString = CharStreams.toString((Readable)Files.newBufferedReader(hourlyLogFile.toPath(), StandardCharsets.UTF_8));
        String dailyLogString = CharStreams.toString((Readable)Files.newBufferedReader(dailyLogFile.toPath(), StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)hourlyLogString.contains(sqlQueryLogString + "\n"));
        Assert.assertTrue((boolean)dailyLogString.contains(sqlQueryLogString + "\n"));
        hourlyLogger.stop();
        dailyLoggerWithHourPattern.stop();
    }
}

