/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.client.DruidServerConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.metrics.HistoricalMetricsMonitor;
import org.apache.druid.timeline.DataSegment;
import org.easymock.EasyMock;
import org.easymock.EasyMockSupport;
import org.junit.Before;
import org.junit.Test;

public class HistoricalMetricsMonitorTest
extends EasyMockSupport {
    private DruidServerConfig druidServerConfig;
    private SegmentManager segmentManager;
    private SegmentLoadDropHandler segmentLoadDropMgr;
    private StubServiceEmitter serviceEmitter;

    @Before
    public void setUp() {
        this.druidServerConfig = (DruidServerConfig)EasyMock.createStrictMock(DruidServerConfig.class);
        this.segmentManager = (SegmentManager)EasyMock.createStrictMock(SegmentManager.class);
        this.segmentLoadDropMgr = (SegmentLoadDropHandler)EasyMock.createStrictMock(SegmentLoadDropHandler.class);
        this.serviceEmitter = new StubServiceEmitter("test", "localhost");
    }

    @Test
    public void testSimple() {
        long size = 5L;
        String dataSource = "dataSource";
        DataSegment dataSegment = new DataSegment("dataSource", Intervals.of((String)"2014/2015"), "version", (Map)ImmutableMap.of(), (List)ImmutableList.of(), (List)ImmutableList.of(), null, Integer.valueOf(1), 5L);
        long maxSize = 10L;
        int priority = 111;
        String tier = "tier";
        EasyMock.expect((Object)this.druidServerConfig.getMaxSize()).andReturn((Object)10L).once();
        EasyMock.expect((Object)this.segmentLoadDropMgr.getSegmentsToDelete()).andReturn((Object)ImmutableList.of((Object)dataSegment)).once();
        EasyMock.expect((Object)this.druidServerConfig.getTier()).andReturn((Object)"tier").once();
        EasyMock.expect((Object)this.druidServerConfig.getPriority()).andReturn((Object)111).once();
        EasyMock.expect((Object)this.segmentManager.getDataSourceSizes()).andReturn((Object)ImmutableMap.of((Object)"dataSource", (Object)5L));
        EasyMock.expect((Object)this.druidServerConfig.getTier()).andReturn((Object)"tier").once();
        EasyMock.expect((Object)this.druidServerConfig.getPriority()).andReturn((Object)111).once();
        EasyMock.expect((Object)this.druidServerConfig.getMaxSize()).andReturn((Object)10L).times(2);
        EasyMock.expect((Object)this.segmentManager.getDataSourceCounts()).andReturn((Object)ImmutableMap.of((Object)"dataSource", (Object)1L));
        EasyMock.expect((Object)this.druidServerConfig.getTier()).andReturn((Object)"tier").once();
        EasyMock.expect((Object)this.druidServerConfig.getPriority()).andReturn((Object)111).once();
        HistoricalMetricsMonitor monitor = new HistoricalMetricsMonitor(this.druidServerConfig, this.segmentManager, this.segmentLoadDropMgr);
        EasyMock.replay((Object[])new Object[]{this.druidServerConfig, this.segmentManager, this.segmentLoadDropMgr});
        monitor.doMonitor((ServiceEmitter)this.serviceEmitter);
        EasyMock.verify((Object[])new Object[]{this.druidServerConfig, this.segmentManager, this.segmentLoadDropMgr});
        this.serviceEmitter.verifyValue("segment/max", (Number)10L);
        this.serviceEmitter.verifyValue("segment/pendingDelete", Map.of("tier", "tier", "dataSource", "dataSource", "priority", String.valueOf(111)), (Number)dataSegment.getSize());
        this.serviceEmitter.verifyValue("segment/used", Map.of("tier", "tier", "priority", String.valueOf(111), "dataSource", "dataSource"), (Number)dataSegment.getSize());
        this.serviceEmitter.verifyValue("segment/usedPercent", Map.of("tier", "tier", "priority", String.valueOf(111), "dataSource", "dataSource"), (Number)((double)dataSegment.getSize() * 1.0 / 10.0));
        this.serviceEmitter.verifyValue("segment/count", Map.of("tier", "tier", "priority", String.valueOf(111), "dataSource", "dataSource"), (Number)1L);
    }
}

