/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.LatchableEmitterConfig;

public class LatchableEmitter
extends StubServiceEmitter {
    private static final Logger log = new Logger(LatchableEmitter.class);
    public static final String TYPE = "latching";
    private final Set<WaitCondition> waitConditions = new HashSet<WaitCondition>();
    private final ReentrantLock eventProcessingLock = new ReentrantLock();
    private final List<Event> processedEvents = new ArrayList<Event>();
    private final long defaultWaitTimeoutMillis;

    public LatchableEmitter(String service, String host, LatchableEmitterConfig config) {
        super(service, host);
        this.defaultWaitTimeoutMillis = config.getDefaultWaitTimeoutMillis();
    }

    public void emit(Event event) {
        super.emit(event);
        this.evaluateWaitConditions(event);
    }

    public void flush() {
        this.eventProcessingLock.lock();
        try {
            super.flush();
            this.processedEvents.clear();
        }
        finally {
            this.eventProcessingLock.unlock();
        }
    }

    public void close() {
        this.eventProcessingLock.lock();
        try {
            super.close();
            this.processedEvents.clear();
        }
        finally {
            this.eventProcessingLock.unlock();
        }
    }

    public void waitForEvent(Predicate<Event> condition, long timeoutMillis) {
        WaitCondition waitCondition = new WaitCondition(condition);
        this.registerWaitCondition(waitCondition);
        try {
            long awaitTime;
            long l = awaitTime = timeoutMillis >= 0L ? timeoutMillis : Long.MAX_VALUE;
            if (!waitCondition.countDownLatch.await(awaitTime, TimeUnit.MILLISECONDS)) {
                throw new ISE("Timed out waiting for event", new Object[0]);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.waitConditions.remove(waitCondition);
        }
    }

    public ServiceMetricEvent waitForEvent(UnaryOperator<EventMatcher> condition) {
        EventMatcher matcher = (EventMatcher)condition.apply(new EventMatcher());
        this.waitForEvent(event -> event instanceof ServiceMetricEvent && matcher.test((ServiceMetricEvent)event), this.defaultWaitTimeoutMillis);
        return matcher.matchingEvent.get();
    }

    public void waitForEventAggregate(UnaryOperator<EventMatcher> condition, UnaryOperator<AggregateMatcher> aggregateCondition) {
        EventMatcher eventMatcher = (EventMatcher)condition.apply(new EventMatcher());
        AggregateMatcher aggregateMatcher = (AggregateMatcher)aggregateCondition.apply(new AggregateMatcher());
        this.waitForEvent(event -> event instanceof ServiceMetricEvent && eventMatcher.test((ServiceMetricEvent)event) && aggregateMatcher.test((ServiceMetricEvent)event), this.defaultWaitTimeoutMillis);
    }

    private void evaluateWaitConditions(Event event) {
        this.eventProcessingLock.lock();
        try {
            List<WaitCondition> conditionsToEvaluate = List.copyOf(this.waitConditions);
            if (conditionsToEvaluate.isEmpty()) {
                return;
            }
            for (WaitCondition condition : conditionsToEvaluate) {
                if (!condition.predicate.test(event)) continue;
                condition.countDownLatch.countDown();
            }
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error while evaluating wait conditions for event[%s]", new Object[]{event.toMap()});
            throw new ISE((Throwable)e, "Error while evaluating wait conditions for event[%s]", new Object[]{event.toMap()});
        }
        finally {
            this.processedEvents.add(event);
            this.eventProcessingLock.unlock();
        }
    }

    private void registerWaitCondition(WaitCondition condition) {
        this.eventProcessingLock.lock();
        try {
            for (Event event : this.processedEvents) {
                if (!condition.predicate.test(event)) continue;
                condition.countDownLatch.countDown();
                break;
            }
            if (condition.countDownLatch.getCount() > 0L) {
                this.waitConditions.add(condition);
            }
        }
        catch (Exception e) {
            throw new ISE((Throwable)e, "Error while evaluating condition", new Object[0]);
        }
        finally {
            this.eventProcessingLock.unlock();
        }
    }

    private static class WaitCondition {
        private final Predicate<Event> predicate;
        private final CountDownLatch countDownLatch;

        private WaitCondition(Predicate<Event> predicate) {
            this.predicate = predicate;
            this.countDownLatch = new CountDownLatch(1);
        }
    }

    public static class EventMatcher
    implements Predicate<ServiceMetricEvent> {
        private String host;
        private String service;
        private String metricName;
        private Long metricValue;
        private final Map<String, Object> dimensions = new HashMap<String, Object>();
        private final AtomicReference<ServiceMetricEvent> matchingEvent = new AtomicReference();

        public EventMatcher hasMetricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public EventMatcher hasValueAtLeast(long metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public EventMatcher hasDimension(String dimension, Object value) {
            this.dimensions.put(dimension, value);
            return this;
        }

        public EventMatcher hasService(String service) {
            this.service = service;
            return this;
        }

        public EventMatcher hasHost(String host) {
            this.host = host;
            return this;
        }

        @Override
        public boolean test(ServiceMetricEvent event) {
            if (this.metricName != null && !event.getMetric().equals(this.metricName)) {
                return false;
            }
            if (this.metricValue != null && event.getValue().longValue() < this.metricValue) {
                return false;
            }
            if (this.service != null && !this.service.equals(event.getService())) {
                return false;
            }
            if (this.host != null && !this.host.equals(event.getHost())) {
                return false;
            }
            boolean matches = this.dimensions.entrySet().stream().allMatch(dimValue -> event.getUserDims().getOrDefault(dimValue.getKey(), "").equals(dimValue.getValue()));
            if (matches) {
                this.matchingEvent.set(event);
                return true;
            }
            return false;
        }
    }

    public static class AggregateMatcher
    implements Predicate<ServiceMetricEvent> {
        private final List<ServiceMetricEvent> matchingEvents = new ArrayList<ServiceMetricEvent>();
        private long sumSoFar;
        private Long targetSum;
        private Long targetCount;

        public AggregateMatcher hasSumAtLeast(long sum) {
            this.targetSum = sum;
            return this;
        }

        public AggregateMatcher hasCountAtLeast(long count) {
            this.targetCount = count;
            return this;
        }

        @Override
        public boolean test(ServiceMetricEvent latestMatchingEvent) {
            this.matchingEvents.add(latestMatchingEvent);
            this.sumSoFar += latestMatchingEvent.getValue().longValue();
            if (this.targetSum != null && this.sumSoFar < this.targetSum) {
                return false;
            }
            return this.targetCount == null || (long)this.matchingEvents.size() >= this.targetCount;
        }
    }
}

