/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.druid.collections.BlockingPool;
import org.apache.druid.collections.DefaultBlockingPool;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.GroupByStatsMonitor;
import org.apache.druid.server.metrics.MonitorsConfig;
import org.apache.druid.server.metrics.QueryCountStatsMonitor;
import org.apache.druid.server.metrics.QueryCountStatsProvider;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryCountStatsMonitorTest {
    private QueryCountStatsProvider queryCountStatsProvider;
    private BlockingPool<ByteBuffer> mergeBufferPool;
    private MonitorsConfig monitorsConfig;
    private ExecutorService executorService;

    @Before
    public void setUp() {
        this.monitorsConfig = new MonitorsConfig(new ArrayList<String>(Arrays.asList(GroupByStatsMonitor.class.getName(), QueryCountStatsMonitor.class.getName())));
        this.queryCountStatsProvider = new QueryCountStatsProvider(){
            private long successEmitCount = 0L;
            private long failedEmitCount = 0L;
            private long interruptedEmitCount = 0L;
            private long timedOutEmitCount = 0L;

            public long getSuccessfulQueryCount() {
                ++this.successEmitCount;
                return this.successEmitCount;
            }

            public long getFailedQueryCount() {
                this.failedEmitCount += 2L;
                return this.failedEmitCount;
            }

            public long getInterruptedQueryCount() {
                this.interruptedEmitCount += 3L;
                return this.interruptedEmitCount;
            }

            public long getTimedOutQueryCount() {
                this.timedOutEmitCount += 4L;
                return this.timedOutEmitCount;
            }
        };
        this.mergeBufferPool = new DefaultBlockingPool(() -> ByteBuffer.allocate(1024), 5);
        this.executorService = Executors.newSingleThreadExecutor();
    }

    @After
    public void tearDown() {
        this.executorService.shutdown();
    }

    @Test
    public void testMonitor() {
        QueryCountStatsMonitor monitor = new QueryCountStatsMonitor(this.queryCountStatsProvider, this.monitorsConfig, this.mergeBufferPool);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        emitter.flush();
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)5L, (long)emitter.getNumEmittedEvents());
        emitter.verifyValue("query/success/count", (Number)1L);
        emitter.verifyValue("query/failed/count", (Number)2L);
        emitter.verifyValue("query/interrupted/count", (Number)3L);
        emitter.verifyValue("query/timeout/count", (Number)4L);
        emitter.verifyValue("query/count", (Number)10L);
    }

    @Test
    public void testMonitor_emitPendingRequests() {
        this.monitorsConfig = new MonitorsConfig(Collections.singletonList(QueryCountStatsMonitor.class.getName()));
        QueryCountStatsMonitor monitor = new QueryCountStatsMonitor(this.queryCountStatsProvider, this.monitorsConfig, this.mergeBufferPool);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        emitter.flush();
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)6L, (long)emitter.getNumEmittedEvents());
        emitter.verifyValue("mergeBuffer/pendingRequests", (Number)0L);
        emitter.verifyValue("query/success/count", (Number)1L);
        emitter.verifyValue("query/failed/count", (Number)2L);
        emitter.verifyValue("query/interrupted/count", (Number)3L);
        emitter.verifyValue("query/timeout/count", (Number)4L);
        emitter.verifyValue("query/count", (Number)10L);
    }
}

