/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.ServiceStatusMonitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ServiceStatusMonitorTest {
    private ServiceStatusMonitor monitor;
    private StubServiceEmitter emitter;
    private Map<String, Object> heartbeatTags;
    private final Supplier<Map<String, Object>> heartbeatTagsSupplier = () -> this.heartbeatTags;
    private static final String HEARTBEAT_METRIC_KEY = "service/heartbeat";

    @Before
    public void setUp() {
        this.emitter = new StubServiceEmitter();
        this.monitor = new ServiceStatusMonitor();
        this.heartbeatTags = new HashMap<String, Object>();
        this.monitor.heartbeatTagsSupplier = this.heartbeatTagsSupplier;
    }

    @Test
    public void testDefaultHeartbeatReported() {
        this.monitor.doMonitor((ServiceEmitter)this.emitter);
        Assert.assertEquals((long)1L, (long)this.emitter.getNumEmittedEvents());
        this.emitter.verifyValue(HEARTBEAT_METRIC_KEY, (Number)1);
    }

    @Test
    public void testLeaderTag() {
        this.heartbeatTags.put("leader", 1);
        this.monitor.doMonitor((ServiceEmitter)this.emitter);
        Assert.assertEquals((long)1L, (long)this.emitter.getNumEmittedEvents());
        this.emitter.verifyValue(HEARTBEAT_METRIC_KEY, Map.of("leader", 1), (Number)1);
    }

    @Test
    public void testMoreThanOneTag() {
        this.heartbeatTags.put("leader", 1);
        this.heartbeatTags.put("taskRunner", "http");
        this.monitor.doMonitor((ServiceEmitter)this.emitter);
        Assert.assertEquals((long)1L, (long)this.emitter.getNumEmittedEvents());
        this.emitter.verifyValue(HEARTBEAT_METRIC_KEY, Map.of("leader", 1, "taskRunner", "http"), (Number)1);
    }
}

