/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.TaskSlotCountStatsMonitor;
import org.apache.druid.server.metrics.TaskSlotCountStatsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskSlotCountStatsMonitorTest {
    private TaskSlotCountStatsProvider statsProvider;

    @Before
    public void setUp() {
        this.statsProvider = new TaskSlotCountStatsProvider(){

            public Map<String, Long> getTotalTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }

            public Map<String, Long> getIdleTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }

            public Map<String, Long> getUsedTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }

            public Map<String, Long> getLazyTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }

            public Map<String, Long> getBlacklistedTaskSlotCount() {
                return ImmutableMap.of((Object)"c1", (Object)1L);
            }
        };
    }

    @Test
    public void testMonitor() {
        TaskSlotCountStatsMonitor monitor = new TaskSlotCountStatsMonitor(this.statsProvider);
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)5L, (long)emitter.getNumEmittedEvents());
        emitter.verifyValue("taskSlot/total/count", (Number)1L);
        emitter.verifyValue("taskSlot/idle/count", (Number)1L);
        emitter.verifyValue("taskSlot/used/count", (Number)1L);
        emitter.verifyValue("taskSlot/lazy/count", (Number)1L);
        emitter.verifyValue("taskSlot/blacklisted/count", (Number)1L);
    }
}

