/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.druid.server.metrics.IndexerTaskCountStatsProvider;
import org.apache.druid.server.metrics.WorkerTaskCountStatsMonitor;
import org.apache.druid.server.metrics.WorkerTaskCountStatsProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WorkerTaskCountStatsMonitorTest {
    private Injector injectorForMiddleManager;
    private Injector injectorForMiddleManagerNullStats;
    private Injector injectorForPeon;
    private Injector injectorForIndexer;
    private WorkerTaskCountStatsProvider statsProvider;
    private IndexerTaskCountStatsProvider indexerTaskStatsProvider;
    private WorkerTaskCountStatsProvider nullStatsProvider;

    @Before
    public void setUp() {
        this.statsProvider = new WorkerTaskCountStatsProvider(){

            public Long getWorkerTotalTaskSlotCount() {
                return 5L;
            }

            public Long getWorkerFailedTaskCount() {
                return 4L;
            }

            public Long getWorkerIdleTaskSlotCount() {
                return 3L;
            }

            public Long getWorkerSuccessfulTaskCount() {
                return 2L;
            }

            public Long getWorkerUsedTaskSlotCount() {
                return 1L;
            }

            public String getWorkerCategory() {
                return "workerCategory";
            }

            public String getWorkerVersion() {
                return "workerVersion";
            }
        };
        this.indexerTaskStatsProvider = new IndexerTaskCountStatsProvider(){

            public Map<String, Long> getWorkerRunningTasks() {
                return ImmutableMap.of((Object)"wikipedia", (Object)2L, (Object)"animals", (Object)3L);
            }

            public Map<String, Long> getWorkerAssignedTasks() {
                return ImmutableMap.of((Object)"products", (Object)3L, (Object)"orders", (Object)7L);
            }

            public Map<String, Long> getWorkerCompletedTasks() {
                return ImmutableMap.of((Object)"inventory", (Object)8L, (Object)"metrics", (Object)9L);
            }

            public Map<String, Long> getWorkerFailedTasks() {
                return ImmutableMap.of((Object)"movies", (Object)4L, (Object)"games", (Object)6L);
            }

            public Map<String, Long> getWorkerSuccessfulTasks() {
                return ImmutableMap.of((Object)"games", (Object)23L, (Object)"inventory", (Object)89L);
            }
        };
        this.nullStatsProvider = new WorkerTaskCountStatsProvider(){

            @Nullable
            public Long getWorkerTotalTaskSlotCount() {
                return null;
            }

            @Nullable
            public Long getWorkerFailedTaskCount() {
                return null;
            }

            @Nullable
            public Long getWorkerIdleTaskSlotCount() {
                return null;
            }

            @Nullable
            public Long getWorkerSuccessfulTaskCount() {
                return null;
            }

            @Nullable
            public Long getWorkerUsedTaskSlotCount() {
                return null;
            }

            @Nullable
            public String getWorkerCategory() {
                return null;
            }

            @Nullable
            public String getWorkerVersion() {
                return null;
            }
        };
        this.injectorForMiddleManager = Guice.createInjector((Iterable)ImmutableList.of(binder -> binder.bind(WorkerTaskCountStatsProvider.class).toInstance((Object)this.statsProvider)));
        this.injectorForMiddleManagerNullStats = Guice.createInjector((Iterable)ImmutableList.of(binder -> binder.bind(WorkerTaskCountStatsProvider.class).toInstance((Object)this.nullStatsProvider)));
        this.injectorForPeon = Guice.createInjector((Iterable)ImmutableList.of(binder -> {}));
        this.injectorForIndexer = Guice.createInjector((Iterable)ImmutableList.of(binder -> binder.bind(IndexerTaskCountStatsProvider.class).toInstance((Object)this.indexerTaskStatsProvider)));
    }

    @Test
    public void testMonitor() {
        WorkerTaskCountStatsMonitor monitor = new WorkerTaskCountStatsMonitor(this.injectorForMiddleManager, (Set)ImmutableSet.of((Object)NodeRole.MIDDLE_MANAGER));
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)5L, (long)emitter.getNumEmittedEvents());
        emitter.verifyValue("worker/task/failed/count", (Map)ImmutableMap.of((Object)"category", (Object)"workerCategory", (Object)"workerVersion", (Object)"workerVersion"), (Number)4L);
        emitter.verifyValue("worker/task/success/count", (Map)ImmutableMap.of((Object)"category", (Object)"workerCategory", (Object)"workerVersion", (Object)"workerVersion"), (Number)2L);
        emitter.verifyValue("worker/taskSlot/idle/count", (Map)ImmutableMap.of((Object)"category", (Object)"workerCategory", (Object)"workerVersion", (Object)"workerVersion"), (Number)3L);
        emitter.verifyValue("worker/taskSlot/total/count", (Map)ImmutableMap.of((Object)"category", (Object)"workerCategory", (Object)"workerVersion", (Object)"workerVersion"), (Number)5L);
        emitter.verifyValue("worker/taskSlot/used/count", (Map)ImmutableMap.of((Object)"category", (Object)"workerCategory", (Object)"workerVersion", (Object)"workerVersion"), (Number)1L);
    }

    @Test
    public void testMonitorIndexer() {
        WorkerTaskCountStatsMonitor monitor = new WorkerTaskCountStatsMonitor(this.injectorForIndexer, (Set)ImmutableSet.of((Object)NodeRole.INDEXER));
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)10L, (long)emitter.getNumEmittedEvents());
        emitter.verifyValue("worker/task/running/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"wikipedia"), (Number)2L);
        emitter.verifyValue("worker/task/running/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"animals"), (Number)3L);
        emitter.verifyValue("worker/task/assigned/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"products"), (Number)3L);
        emitter.verifyValue("worker/task/assigned/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"orders"), (Number)7L);
        emitter.verifyValue("worker/task/completed/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"inventory"), (Number)8L);
        emitter.verifyValue("worker/task/completed/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"metrics"), (Number)9L);
        emitter.verifyValue("worker/task/failed/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"movies"), (Number)4L);
        emitter.verifyValue("worker/task/failed/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"games"), (Number)6L);
        emitter.verifyValue("worker/task/success/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"games"), (Number)23L);
        emitter.verifyValue("worker/task/success/count", (Map)ImmutableMap.of((Object)"dataSource", (Object)"inventory"), (Number)89L);
    }

    @Test
    public void testMonitorWithNulls() {
        WorkerTaskCountStatsMonitor monitor = new WorkerTaskCountStatsMonitor(this.injectorForMiddleManagerNullStats, (Set)ImmutableSet.of((Object)NodeRole.MIDDLE_MANAGER));
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)0L, (long)emitter.getNumEmittedEvents());
    }

    @Test
    public void testMonitorWithPeon() {
        WorkerTaskCountStatsMonitor monitor = new WorkerTaskCountStatsMonitor(this.injectorForPeon, (Set)ImmutableSet.of((Object)NodeRole.PEON));
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        monitor.doMonitor((ServiceEmitter)emitter);
        Assert.assertEquals((long)0L, (long)emitter.getNumEmittedEvents());
    }
}

